/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.nc;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class MigrateUserguideNCFormPlugin
extends ImbdDymicTplEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"savelink", "modifylink", "dblinktest", "configguide"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject linkDynObj = this.loadDatabaseLink();
        boolean isDataNull = CommonUtils.isNull(linkDynObj);
        this.getView().setEnable(Boolean.valueOf(!isDataNull), new String[]{"modifylink", "dblinktest"});
        this.getView().setEnable(Boolean.valueOf(isDataNull), new String[]{"savelink"});
        DynamicObject linkDataDynObj = (DynamicObject)this.getModel().getValue("dblink");
        String linkNumber = DynamicObjectUtils.getString(linkDataDynObj, "number");
        if (!(linkDataDynObj == null || "IMSC_NC_MIGRATE_ORACLE".equals(linkNumber) || "IMSC_NC_MIGRATE_SQLSERVER".equals(linkNumber) || "IMSC_NC_MIGRATE_DB2".equals(linkNumber))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"savelink", "modifylink", "dblinktest"});
            isDataNull = false;
            linkDynObj = linkDataDynObj;
        }
        if (linkDynObj != null) {
            this.loadDataByIscDatabaseLink(linkDynObj);
        }
        this.setLinkFieldEnable(isDataNull);
        this.setFieldVisibleByDatabaseType();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "savelink": {
                DynamicObject linkDynObj;
                OperationResult optResult;
                String databaseType = (String)this.getModel().getValue("databasetype");
                Object linkNumber = this.getModel().getValue("linknumber");
                Object linkName = this.getModel().getValue("linkname");
                if (StringUtil.isEmpty(databaseType) || StringUtil.isEmpty(linkNumber) || StringUtil.isEmpty(linkName) || StringUtil.isEmpty(this.getModel().getValue("server_ip")) || (Integer)this.getModel().getValue("server_port") <= 0 || StringUtil.isEmpty(this.getModel().getValue("user")) || StringUtil.isEmpty(this.getModel().getValue("newpwd")) || "oracle".equals(databaseType) && StringUtil.isEmpty(this.getModel().getValue("oracle_service")) || !"oracle".equals(databaseType) && StringUtil.isEmpty(this.getModel().getValue("sql_database"))) {
                    if ("oracle".equals(databaseType)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u65b9\u5f0f\u3001\u8fde\u63a5\u7f16\u7801\u3001\u8fde\u63a5\u540d\u79f0\u3001\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001Oracle\u670d\u52a1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MigrateUserguideNCFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u65b9\u5f0f\u3001\u8fde\u63a5\u7f16\u7801\u3001\u8fde\u63a5\u540d\u79f0\u3001\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MigrateUserguideNCFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    }
                    return;
                }
                DynamicObject dblinkDynObj = (DynamicObject)this.getModel().getValue("dblink");
                if (dblinkDynObj != null) {
                    QFilter filter = new QFilter("dblink", "=", (Object)dblinkDynObj.getLong("id"));
                    filter.and(new QFilter("projectstatus", "=", (Object)"E"));
                    String selectors = String.join((CharSequence)",", "number", "executetype", "migratestatus");
                    DynamicObject[] projectDynObjs = BusinessDataServiceHelper.load((String)"dmw_migrateproject_nc", (String)selectors, (QFilter[])filter.toArray());
                    StringBuilder numberBuilder = new StringBuilder();
                    for (DynamicObject projectDynObj : projectDynObjs) {
                        long count = projectDynObj.getDynamicObjectCollection("treeentryentity").stream().filter(o -> "2".equals(o.getString("executetype")) && "B".equals(o.getString("migratestatus"))).count();
                        if (count > 0L) continue;
                        numberBuilder.append(projectDynObj.getString("number")).append("\uff0c");
                    }
                    if (numberBuilder.length() > 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8fde\u63a5\u914d\u7f6e\u7684\u8fc1\u79fb\u4e2d\u9879\u76ee\uff1a%s\u8bf7\u8fc1\u79fb\u5b8c\u6210\u540e\uff0c\u518d\u4fee\u6539\u8fde\u63a5\u914d\u7f6e\u3002", (String)"MigrateUserguideNCFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), numberBuilder.toString());
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                }
                if (!(optResult = SaveServiceHelper.saveOperate((String)"isc_database_link", (DynamicObject[])new DynamicObject[]{linkDynObj = this.createIscDatabaseLinkByGuide()}, (OperateOption)OperateOption.create())).isSuccess()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u5931\u8d25\uff0c%s", (String)"MigrateUserguideNCFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), CommonUtils.getErrDetail(optResult));
                    this.getView().showMessage(msg);
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MigrateUserguideNCFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.setLinkFieldEnable(false);
                this.getModel().setValue("dblink", linkDynObj.getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"savelink"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"modifylink", "dblinktest"});
                this.getPageCache().put("modifylink", "savelink");
                break;
            }
            case "modifylink": {
                if (this.getModel().getValue("dblink") != null) {
                    String msg = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u8fde\u63a5\u914d\u7f6e\u4f1a\u5f71\u54cd\u5176\u4ed6NC\u6570\u636e\u8fc1\u79fb\u9879\u76ee\u5173\u8054\u7684\u8fde\u63a5\u914d\u7f6e\uff0c\u8bf7\u8c28\u614e\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"MigrateUserguideNCFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("modifylink"));
                    return;
                }
                this.modifyLink();
                break;
            }
            case "configguide": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("dmw_nc_config");
                parameter.getOpenStyle().setPlaceholder(false);
                parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
                parameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals("databasetype")) {
            String databaseType;
            switch (databaseType = (String)this.getModel().getValue("databasetype")) {
                case "sqlserver": {
                    this.getView().getModel().setValue("linknumber", (Object)"IMSC_NC_MIGRATE_SQLSERVER");
                    this.getView().getModel().setValue("linkname", (Object)ResManager.loadKDString((String)"\u5b9e\u65bd\u670d\u52a1\u4e91NC\u6570\u636e\u8fc1\u79fb\u4e13\u7528-SQLServer", (String)"MigrateUserguideNCFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                case "DB2": {
                    this.getView().getModel().setValue("linknumber", (Object)"IMSC_NC_MIGRATE_DB2");
                    this.getView().getModel().setValue("linkname", (Object)ResManager.loadKDString((String)"\u5b9e\u65bd\u670d\u52a1\u4e91NC\u6570\u636e\u8fc1\u79fb\u4e13\u7528-DB2", (String)"MigrateUserguideNCFormPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                default: {
                    this.getView().getModel().setValue("linknumber", (Object)"IMSC_NC_MIGRATE_ORACLE");
                    this.getView().getModel().setValue("linkname", (Object)ResManager.loadKDString((String)"\u5b9e\u65bd\u670d\u52a1\u4e91NC\u6570\u636e\u8fc1\u79fb\u4e13\u7528-Oracle", (String)"MigrateUserguideNCFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
            }
            this.getView().getModel().setValue("dblink", null);
            DynamicObject linkDynObj = this.loadDatabaseLink();
            if (linkDynObj != null) {
                this.loadDataByIscDatabaseLink(linkDynObj);
            } else {
                this.getModel().setValue("server_ip", null);
                this.getModel().setValue("server_port", null);
                this.getModel().setValue("user", null);
                this.getModel().setValue("newpwd", null);
                this.getModel().setValue("max_tps", null);
            }
            this.setFieldVisibleByDatabaseType();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("modifylink".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.modifyLink();
        }
    }

    private void loadDataByIscDatabaseLink(DynamicObject linkDynObj) {
        this.getModel().setValue("linknumber", (Object)linkDynObj.getString("number"));
        this.getModel().setValue("linkname", (Object)linkDynObj.getString("name"));
        this.getModel().setValue("dblink", linkDynObj.getPkValue());
        this.getModel().setValue("databasetype", linkDynObj.get("database_type"));
        String dumLinkId = DynamicObjectUtils.getStrPkValue(linkDynObj, "dum_link");
        if ("0COI9MP6A9=I".equals(dumLinkId)) {
            this.getModel().setValue("oracle_service", linkDynObj.get("oracle_service"));
            this.getModel().setValue("readtimeout", linkDynObj.get("attr1"));
            this.getModel().setValue("linktimeout", linkDynObj.get("attr2"));
            this.getModel().setValue("modelname", linkDynObj.get("attr3"));
        } else if ("0COIGTUZ7LW1".equals(dumLinkId)) {
            this.getModel().setValue("sql_database", linkDynObj.get("sql_database"));
            this.getModel().setValue("sqlserverssl", linkDynObj.get("attr1"));
            this.getModel().setValue("sqlserversocket", linkDynObj.get("attr2"));
        } else if ("2NXJFJD56QJB".equals(dumLinkId)) {
            this.getModel().setValue("sql_database", linkDynObj.get("sql_database"));
            this.getModel().setValue("db2schema", linkDynObj.get("attr1"));
        }
        this.getModel().setValue("server_ip", linkDynObj.get("server_ip"));
        this.getModel().setValue("server_port", linkDynObj.get("server_port"));
        this.getModel().setValue("user", linkDynObj.get("user"));
        this.getModel().setValue("newpwd", linkDynObj.get("newpwd"));
        this.getModel().setValue("max_tps", linkDynObj.get("max_tps"));
    }

    private DynamicObject createIscDatabaseLinkByGuide() {
        DynamicObject linkDynObj = this.loadDatabaseLink();
        if (linkDynObj == null) {
            linkDynObj = BusinessDataServiceHelper.newDynamicObject((String)"isc_database_link");
            long pkId = DB.genLongId((String)linkDynObj.getDynamicObjectType().getAlias());
            linkDynObj.set("id", (Object)pkId);
        }
        String databaseType = (String)this.getModel().getValue("databasetype");
        linkDynObj.set("database_type", (Object)databaseType);
        linkDynObj.set("number", this.getModel().getValue("linknumber"));
        linkDynObj.set("name", this.getModel().getValue("linkname"));
        linkDynObj.set("isv", (Object)"kingdee.imsc");
        linkDynObj.set("server_ip", this.getModel().getValue("server_ip"));
        linkDynObj.set("server_port", this.getModel().getValue("server_port"));
        linkDynObj.set("user", this.getModel().getValue("user"));
        linkDynObj.set("newpwd", this.getModel().getValue("newpwd"));
        linkDynObj.set("max_tps", this.getModel().getValue("max_tps"));
        linkDynObj.set("enable", (Object)"1");
        linkDynObj.set("status", (Object)"C");
        linkDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        if ("oracle".equals(databaseType)) {
            linkDynObj.set("dum_link", (Object)"0COI9MP6A9=I");
            linkDynObj.set("oracle_service", this.getModel().getValue("oracle_service"));
            linkDynObj.set("attr1", this.getModel().getValue("readtimeout"));
            linkDynObj.set("attr2", this.getModel().getValue("linktimeout"));
            linkDynObj.set("attr3", this.getModel().getValue("modelname"));
        } else if ("sqlserver".equals(databaseType)) {
            linkDynObj.set("dum_link", (Object)"0COIGTUZ7LW1");
            linkDynObj.set("sql_database", this.getModel().getValue("sql_database"));
            linkDynObj.set("attr1", this.getModel().getValue("sqlserverssl"));
            linkDynObj.set("attr2", this.getModel().getValue("sqlserversocket"));
        } else if ("DB2".equals(databaseType)) {
            linkDynObj.set("dum_link", (Object)"2NXJFJD56QJB");
            linkDynObj.set("sql_database", this.getModel().getValue("sql_database"));
            linkDynObj.set("attr1", this.getModel().getValue("db2schema"));
        }
        return linkDynObj;
    }

    private void setLinkFieldEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"databasetype", "server_ip", "server_port", "user", "newpwd", "oracle_service", "readtimeout", "max_tps", "linktimeout", "modelname", "sql_database", "db2schema", "sqlserverssl", "sqlserversocket"});
    }

    private DynamicObject loadDatabaseLink() {
        DynamicObject dbLinkDynObj = (DynamicObject)this.getModel().getValue("dblink");
        String dumLinkId = DynamicObjectUtils.getStrPkValue(dbLinkDynObj, "dum_link");
        String nubmer = "IMSC_NC_MIGRATE_ORACLE";
        String databaseType = (String)this.getModel().getValue("databasetype");
        if ("0COIGTUZ7LW1".equals(dumLinkId) || "sqlserver".equals(databaseType)) {
            nubmer = "IMSC_NC_MIGRATE_SQLSERVER";
        } else if ("2NXJFJD56QJB".equals(dumLinkId) || "DB2".equals(databaseType)) {
            nubmer = "IMSC_NC_MIGRATE_DB2";
        }
        return BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter("number", "=", (Object)nubmer).toArray());
    }

    private void modifyLink() {
        this.setLinkFieldEnable(true);
        this.getView().setEnable(Boolean.TRUE, new String[]{"savelink"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"modifylink", "dblinktest"});
        this.getPageCache().put("modifylink", "modifylink");
    }

    private void setFieldVisibleByDatabaseType() {
        Object databaseType = this.getModel().getValue("databasetype");
        boolean isOracleVisible = "oracle".equals(databaseType);
        this.getView().setVisible(Boolean.valueOf(isOracleVisible), new String[]{"oracle_service", "readtimeout", "linktimeout", "modelname"});
        this.getView().setVisible(Boolean.valueOf(!isOracleVisible), new String[]{"sql_database"});
        boolean isSqlserverVisible = "sqlserver".equals(databaseType);
        this.getView().setVisible(Boolean.valueOf(isSqlserverVisible), new String[]{"sqlserverssl", "sqlserversocket"});
        boolean isDb2Visible = "DB2".equals(databaseType);
        this.getView().setVisible(Boolean.valueOf(isDb2Visible), new String[]{"db2schema"});
    }
}

