/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.reportpush;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.imsc.dmw.engine.multiimport.helper.ImportServiceManagerHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import kd.imsc.dmw.utils.FormUtil;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.AbstractImbdBdEditPlugin;

public class ReportPushRecordEditPlugin
extends AbstractImbdBdEditPlugin
implements HyperLinkClickListener {
    public void initialize() {
        super.initialize();
        this.hideOperateItemsByPushSubStatus();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isMergeRecord = "2".equals(this.getView().getModel().getValue("reporttype"));
        if (isMergeRecord) {
            TextEdit txEdit = (TextEdit)this.getView().getControl("orgname");
            txEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u5355\u5143", (String)"ReportPushRecordEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0])));
        }
        this.getView().setVisible(Boolean.valueOf(isMergeRecord), new String[]{"orgtreename"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        long pushRecordId;
        String pushStatus;
        boolean isCance;
        super.beforeDoOperation(event);
        FormOperate op = (FormOperate)event.getSource();
        String opKey = op.getOperateKey();
        if ("refresh".equals(opKey) && !(isCance = this.isCanceUpdateStatus(pushStatus = EasReportHelper.getPushStatusByEntryStatus(pushRecordId = this.getView().getModel().getDataEntity().getLong("id"))))) {
            EasReportHelper.updatePushRecordBillStatus(pushRecordId, pushStatus);
            if ("2".equals(pushStatus)) {
                EasReportHelper.repairEntryStatusByIn(pushRecordId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey;
        super.afterDoOperation(event);
        FormOperate op = (FormOperate)event.getSource();
        switch (opKey = op.getOperateKey()) {
            case "retrypush": {
                this.allRetryPush();
                break;
            }
            case "signretrypush": {
                this.signRetryPush();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("reportnumber".equals(fieldName)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            this.showRptBillForm(rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("retrypush".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void signRetryPush() {
        int selectRowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        this.retryPush(new int[]{selectRowIndex});
    }

    private void allRetryPush() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        this.retryPush(selectRows);
    }

    private void retryPush(int[] selectRows) {
        DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("entryentity");
        ArrayList<Long> pushEntryIdList = new ArrayList<Long>(entryColl.size());
        if (!"2".equals(this.getView().getModel().getValue("pushstatus"))) {
            block0: for (DynamicObject entryDynObj : entryColl) {
                if (selectRows != null && selectRows.length > 0) {
                    int rowIndex = entryDynObj.getInt("seq") - 1;
                    for (int selectRowIndex : selectRows) {
                        if (selectRowIndex != rowIndex) continue;
                        if (!"4".equals(entryDynObj.getString("pushsubstatus")) && !"1".equals(entryDynObj.getString("pushsubstatus"))) continue block0;
                        pushEntryIdList.add(entryDynObj.getLong("id"));
                        continue block0;
                    }
                    continue;
                }
                if (!"4".equals(entryDynObj.getString("pushsubstatus")) && !"1".equals(entryDynObj.getString("pushsubstatus"))) continue;
                pushEntryIdList.add(entryDynObj.getLong("id"));
            }
        }
        if (pushEntryIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u63a8\u9001\u72b6\u6001\u4e3a\u8ba1\u5212\u548c\u63a8\u9001\u5931\u8d25\u7684\u6570\u636e\u53ef\u91cd\u65b0\u63a8\u9001\u3002", (String)"ReportPushRecordEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("retryPushRecordId", this.getView().getModel().getDataEntity().getPkValue());
        customParams.put("retryPushRecordEntryIdList", pushEntryIdList);
        customParams.put("bcmmodelid", this.getView().getModel().getValue("bcmmodelid"));
        customParams.put("bcmmodelnumber", this.getView().getModel().getValue("bcmmodelnumber"));
        customParams.put("bcmmodelname", this.getView().getModel().getValue("bcmmodelname"));
        customParams.put("reporttype", this.getView().getModel().getDataEntity().getString("reporttype"));
        FormShowParameter formShowParameter = FormUtil.formShowParameter("dmw_reportconfirm", ShowType.Modal, customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "retrypush"));
        this.getView().showForm(formShowParameter);
    }

    private boolean isCanceUpdateStatus(String taskStatus) {
        String oldTaskStatus = (String)this.getView().getModel().getValue("pushstatus");
        boolean isCance = true;
        boolean isExcuting = "2".equals(taskStatus);
        if (!taskStatus.equals(oldTaskStatus) || isExcuting) {
            String serviceId = (String)this.getView().getModel().getValue("serviceid");
            if (StringUtil.isNotEmpty(serviceId)) {
                TaskInfo taskInfo = ImportServiceManagerHelper.getTaskInfoById(serviceId);
                String serviceStatus = taskInfo.getStatus();
                if (!StringUtils.equalsIgnoreCase((CharSequence)"RUNNING", (CharSequence)serviceStatus) && !StringUtils.equalsIgnoreCase((CharSequence)"BEGIN", (CharSequence)serviceStatus)) {
                    isCance = false;
                }
            } else if (!isExcuting) {
                isCance = false;
            }
        }
        return isCance;
    }

    private void showRptBillForm(int rowIndex) {
        Object reportId = this.getView().getModel().getValue("reportid", rowIndex);
        BillShowParameter fsp = new BillShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setPkId(reportId);
        String formId = "1".equals(this.getView().getModel().getValue("reporttype")) ? "dmw_fi_report_eas" : "dmw_fi_mergereport_eas";
        fsp.setFormId(formId);
        fsp.setPageId(this.getView().getPageId() + reportId);
        fsp.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void hideOperateItemsByPushSubStatus() {
        ArrayList<String> operateIdList = new ArrayList<String>(1);
        operateIdList.add("signretrypush");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkgEvent -> {
            Object source = pkgEvent.getSource();
            if (source instanceof OperationColumn) {
                String operateColumnKey = ((OperationColumn)source).getKey();
                DynamicObject entryDynObj = pkgEvent.getRowData();
                List operationColItems = (List)pkgEvent.getFormatValue();
                if ("operationcolumnap".equalsIgnoreCase(operateColumnKey)) {
                    boolean isVisible = "1".equals(entryDynObj.getString("pushsubstatus")) || "4".equals(entryDynObj.getString("pushsubstatus"));
                    for (OperationColItem operationColItem : operationColItems) {
                        if (!operateIdList.contains(operationColItem.getOperationKey())) continue;
                        operationColItem.setVisible(isVisible);
                    }
                }
            }
        });
    }
}

