/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.schedule.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.MathUtils;
import kd.imsc.dmw.utils.StringUtils;

public class IscDataDeployTask
extends AbstractTask {
    private static final String READY = "READY";
    private static final String FAILED = "FAILED";
    private static final int MAX_QUERY_TIMES = 5000;
    private static final long QUERY_INTERVAL = 100L;
    private static final Log logger = LogFactory.getLog(IscDataDeployTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("percent", 0);
        List packageFilteredIdList = (List)map.get("packageIdList");
        Map packSourceMap = (Map)map.get("schemeIdMap");
        int sum = (Integer)map.get("sum_cache");
        this.onlineSubscribe(packageFilteredIdList, resultMap);
        this.onlineDeployment(sum, packSourceMap, resultMap);
    }

    public void onlineSubscribe(List<Object> packageFilteredIdList, Map<String, Object> resultMap) {
        for (Object tempId : packageFilteredIdList) {
            Long id = Long.valueOf(tempId.toString());
            List errIdList = (List)resultMap.computeIfAbsent("packageIdList", k -> new ArrayList());
            try {
                Map subResult = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscSolutionService", (String)"subscribe", (Object[])new Object[]{id});
                boolean success = (Boolean)subResult.get("success");
                if (!success) {
                    logger.error((String)subResult.get("msg"));
                    errIdList.add(id);
                    resultMap.put("packageIdList", errIdList);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                StringBuilder errMsg = new StringBuilder(e.getMessage());
                if (resultMap.containsKey("errMsg")) {
                    errMsg.append('\n').append(resultMap.get("errMsg"));
                }
                resultMap.put("errMsg", errMsg);
                errIdList.add(id);
                resultMap.put("packageIdList", errIdList);
            }
            this.feedbackCustomdata(resultMap);
        }
    }

    public void onlineDeployment(int sum, Map<String, List<String>> packSourceMap, Map<String, Object> resultMap) {
        if (sum == 0) {
            resultMap.put("percent", 100);
            this.feedbackCustomdata(resultMap);
            return;
        }
        int successNum = 0;
        int percent = 0;
        if (CommonUtils.isNull(packSourceMap)) {
            resultMap.put("errMsg", ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u5305\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8c61\u662f\u5426\u7ed1\u5b9a\u65b9\u6848\u5305\u3002", (String)"IscDataDeployTask_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.feedbackProgress(0);
            this.feedbackCustomdata(resultMap);
            return;
        }
        for (Map.Entry<String, List<String>> entry : packSourceMap.entrySet()) {
            List<String> sourceIdList = entry.getValue();
            for (String sourceId : sourceIdList) {
                List<String> tempIdList = Collections.singletonList(sourceId);
                try {
                    Long packageId = Long.parseLong(entry.getKey());
                    long taskId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscSolutionService", (String)"selectDeploy", (Object[])new Object[]{packageId, tempIdList});
                    DynamicObject jobInst = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"isc_job_inst");
                    String errMsg = this.queryTask(jobInst);
                    if (StringUtils.isEmpty(errMsg)) {
                        percent = MathUtils.calculatePercentage(++successNum, sum);
                    } else {
                        this.buildErrMsg(resultMap, errMsg, sourceId, sum, successNum);
                    }
                    resultMap.put("percent", percent);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    String eMsg = StringUtils.isBlank(e.getMessage()) ? e.toString() : e.getMessage();
                    this.buildErrMsg(resultMap, eMsg, sourceId, sum, successNum);
                }
                this.feedbackProgress(percent);
                this.feedbackCustomdata(resultMap);
            }
            resultMap.put("isEnd", true);
        }
    }

    private void buildErrMsg(Map<String, Object> resultMap, String msg, String sourceId, int sum, int successNum) {
        StringBuilder errMsg = new StringBuilder(msg);
        if (resultMap.containsKey("errMsg")) {
            errMsg.append('\n').append(resultMap.get("errMsg"));
        }
        List<Long> errIdList = new ArrayList<Long>(8);
        if (resultMap.containsKey("schemeIdList")) {
            errIdList = (List)resultMap.get("schemeIdList");
        }
        errIdList.add(Long.valueOf(sourceId));
        int percent = MathUtils.calculatePercentage(successNum, sum);
        resultMap.put("schemeIdList", errIdList);
        resultMap.put("errMsg", errMsg);
        resultMap.put("percent", percent);
    }

    private String queryTask(DynamicObject jobInst) throws InterruptedException {
        int queryTimes;
        QFilter deployFilter = new QFilter("id", "=", (Object)jobInst.getLong("job_owner"));
        boolean isReady = true;
        String state = "";
        String billno = "";
        for (queryTimes = 0; isReady && queryTimes < 5000; ++queryTimes) {
            DynamicObject deploy = QueryServiceHelper.queryOne((String)"isc_dts_solution_deploy", (String)"billno,main_resources.main_state,main_resources.main_res_number,main_resources.main_res_name", (QFilter[])new QFilter[]{deployFilter});
            state = deploy != null ? deploy.getString("main_resources.main_state") : null;
            billno = deploy != null ? deploy.getString("billno") : null;
            isReady = READY.equals(state);
            if (!isReady) continue;
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (queryTimes >= 5000) {
            return ResManager.loadKDString((String)"\u90e8\u7f72\u8d85\u65f6\uff0c\u8be6\u7ec6\u5806\u6808\u8bf7\u67e5\u65b9\u6848\u90e8\u7f72\uff08isc_dts_solution_deploy\uff09\uff0c\u4efb\u52a1\u7f16\u53f7\uff1a%s\u3002", (String)"IscDataDeployTask_1", (String)"imsc-dmw-platform", (Object[])new Object[]{billno});
        }
        if (FAILED.equals(state)) {
            return ResManager.loadKDString((String)"\u90e8\u7f72\u5931\u8d25\uff0c\u8be6\u7ec6\u5806\u6808\u8bf7\u67e5\u65b9\u6848\u90e8\u7f72\uff08isc_dts_solution_deploy\uff09\uff0c\u4efb\u52a1\u7f16\u53f7\uff1a%s\u3002", (String)"IscDataDeployTask_2", (String)"imsc-dmw-platform", (Object[])new Object[]{billno});
        }
        return "";
    }
}

