/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.tpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.helper.tpl.MigrateCheckItemHelper;
import kd.imsc.imbd.formplugin.tpl.ImbdBdTplListPlugin;

public class MigrateCheckItemListPlugin
extends ImbdBdTplListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("migrationmodule.sortnum,migrationobject.sortnum,number");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("checkpair".equals(operateKey)) {
            ListShowParameter parameter;
            ListSelectedRowCollection selectRowColl = this.getSelectedRows();
            Set<Object> pkIdSet = new HashSet(16);
            if (!selectRowColl.isEmpty()) {
                pkIdSet = selectRowColl.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toSet());
            }
            String repairLogFormId = MigrateCheckItemHelper.getRepairLogFormId(this.getListView().getBillFormId());
            List logIdList = new ArrayList(pkIdSet.size());
            if (!pkIdSet.isEmpty()) {
                QFilter logFilter = new QFilter("checkitem", "in", pkIdSet);
                logIdList = QueryServiceHelper.queryPrimaryKeys((String)repairLogFormId, (QFilter[])new QFilter[]{logFilter}, (String)"id", (int)-1);
            }
            if (logIdList.size() > 1 || pkIdSet.isEmpty()) {
                parameter = new ListShowParameter();
                parameter.setBillFormId(repairLogFormId);
                parameter.setFormId("bos_list");
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                if (logIdList.size() > 1) {
                    listFilterParameter.setFilter(new QFilter("checkitem", "in", pkIdSet));
                }
                parameter.setListFilterParameter(listFilterParameter);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else if (logIdList.size() == 1) {
                parameter = new BillShowParameter();
                parameter.setFormId(repairLogFormId);
                parameter.setPkId(logIdList.get(0));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4fee\u590d\u65e5\u5fd7\u3002", (String)"MigrateCheckItemListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
    }
}

