/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.tpl.MigrateSchemeHelper;
import kd.imsc.dmw.helper.tpl.MigrateSortNumExecHelper;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.QFilterUtils;
import kd.imsc.imbd.formplugin.AbstractImbdBillPlugin;

public class MigrateSchemeEditPlugin
extends AbstractImbdBillPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final String TREE_VIEWAP = "treeviewap";
    private static final String SEARCHAP = "searchap";
    private static final String CALLBACK_MODEL = "callback_model";
    private static final String CALLBACK_EXECNUM = "callback_execnum";
    private static final String CALLBACK_RELY = "callback_rely";
    private static final String CALLBACK_UPDATENUM = "callback_updatenum";
    private static final String CHECK_NODE = "check_node";
    private static final String CALLBACK_RELY_CANCEL = "callback_rely_cancel";
    private static final String CALLBACK_SCHEME_VALIDATE = "callback_scheme_validate";
    private static final String FOCUS_NODE = "focusNode";
    private static final String CALLBACK_UNCHECK = "callback_uncheck";
    private static final String DEF_NUM_CACHE = "defNumCache";
    private static final String ADD_NEW = "ADDNEW";
    private MigrateSchemeHelper migrateSchemeHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MigrateSchemeHelper helper = this.getSchemeTreeHelper();
        helper.initTree();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        Set<String> checkNodes = this.getCheckNodes(entryEntity);
        String status = (String)this.getModel().getValue("status");
        if ("B".equals(status) || "C".equals(status)) {
            helper.checkNodeByDmwObject(checkNodes, helper.getNodeIds(), null);
        } else {
            helper.checkNodeByDmwObject(checkNodes, Collections.emptyList(), null);
        }
        this.checkShcemeObj(this.getView());
        this.checkSortNum();
        this.pageStyleDeal();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        MigrateSchemeHelper helper = this.getSchemeTreeHelper();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        Set<String> checkNodes = this.getCheckNodes(entryEntity);
        boolean isSysPreset = (Boolean)this.getModel().getValue("issyspreset");
        switch (operateKey) {
            case "submit": 
            case "audit": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                helper.initTree();
                helper.lockAllNode();
                helper.checkNodeByDmwObject(checkNodes, Collections.emptyList(), null);
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                if (isSysPreset) break;
                helper.initTree();
                helper.checkNodeByDmwObject(checkNodes, Collections.emptyList(), null);
                break;
            }
            case "sortbydefault": {
                this.verifyHaveExecNum(entryEntity);
                break;
            }
            case "sortbysequence": {
                new MigrateSortNumExecHelper(this.getView()).sortByExecNum(entryEntity, "dmw_migratescheme");
                break;
            }
            case "updatesequence": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u3002", (String)"MigrateSchemeEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    return;
                }
                int selectRow = selectRows[0];
                int sortNumExec = ((DynamicObject)entryEntity.get(selectRow)).getInt("sortnumexec");
                new MigrateSortNumExecHelper(this.getView()).updateSequence(entryEntity, selectRow, sortNumExec, "dmw_migratescheme");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object oldValue = changeSet.getOldValue();
        String key = e.getProperty().getName();
        if ("migrationmodel".equals(key)) {
            this.modelChanged(oldValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        switch (callBackId = e.getCallBackId()) {
            case "callback_model": {
                this.modelCallBack(result);
                break;
            }
            case "callback_rely": {
                this.relyCallback(result);
                break;
            }
            case "callback_rely_cancel": {
                this.relyCancelCallback(result);
                break;
            }
            case "callback_execnum": {
                MigrateSortNumExecHelper lTreeHelper = new MigrateSortNumExecHelper(this.getView());
                lTreeHelper.sortByDefault(this.getModel().getEntryEntity("treeentryentity"), "dmw_migratescheme");
                break;
            }
            case "callback_updatenum": {
                this.updateDefNum(result);
                break;
            }
            default: {
                this.schemeValidateCallback(result);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
        helper.serch(searchText);
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        String billFormId;
        this.getPageCache().put(CHECK_NODE, (String)treeNodeCheckEvent.getNodeId());
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getCheckedNodeIds();
        if (selectNodeIds.isEmpty()) {
            this.getModel().deleteEntryData("treeentryentity");
            return;
        }
        switch (billFormId = this.getModel().getDataEntity().getDataEntityType().getName()) {
            case "dmw_migratescheme_eas": 
            case "dmw_migratescheme_nc": 
            case "dmw_migratescheme_ecc": {
                String objectFormId;
                boolean checked = treeNodeCheckEvent.getChecked();
                String string = objectFormId = "dmw_migratescheme_eas".equals(billFormId) ? "dmw_migrateobject_eas" : "dmw_migrateobject_nc";
                if ("dmw_migratescheme_ecc".equals(billFormId)) {
                    objectFormId = "dmw_migrateobject_ecc";
                }
                if (checked) {
                    boolean isRely = this.checkRelyDatas(selectNodeIds, objectFormId);
                    if (isRely) break;
                    MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
                    helper.buildTreeEntityByNode(selectNodeIds);
                    break;
                }
                boolean isRely = this.cancelCheckRelyDatas(selectNodeIds, objectFormId);
                if (isRely) break;
                MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
                helper.buildTreeEntityByNode(selectNodeIds);
                break;
            }
        }
    }

    private Set<String> getCheckNodes(DynamicObjectCollection entryEntity) {
        HashSet<String> checkNodes = new HashSet<String>(16);
        for (DynamicObject entry : entryEntity) {
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj == null) continue;
            checkNodes.add(migObj.getString("id"));
        }
        return checkNodes;
    }

    private void checkShcemeObj(IFormView view) {
        String model = (String)this.getModel().getValue("migrationmodel");
        Set<String> migrateModel = DynamicObjectUtils.getMulcomboSet(model);
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyobj : entryEntity) {
            boolean result;
            DynamicObject migobj = dyobj.getDynamicObject("migrateobject");
            if (migobj == null || !(result = migrateModel.contains("A") && !migobj.getBoolean("issupportinit") || migrateModel.contains("B") && !migobj.getBoolean("issupportall"))) continue;
            list.add(dyobj);
        }
        if (!list.isEmpty()) {
            String msg;
            List names = list.stream().map(n -> n.getDynamicObject("migrateobject").getString("name")).collect(Collectors.toList());
            Set id = list.stream().map(n -> (Long)n.getPkValue()).collect(Collectors.toSet());
            this.getPageCache().put(CALLBACK_SCHEME_VALIDATE, JSONObject.toJSONString(id));
            if (migrateModel.contains("A")) {
                msg = String.format(ResManager.loadKDString((String)"%s\u8fc1\u79fb\u5bf9\u8c61\u5df2\u4e0d\u652f\u6301\u521d\u59cb\u5316\u6a21\u578b\u3002\u5f53\u524d\u8fc1\u79fb\u65b9\u6848\u5df2\u51fa\u73b0\u5f02\u5e38\uff0c\u5c06\u65e0\u6cd5\u4fee\u6539\u548c\u6267\u884c\u8fc1\u79fb\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u79fb\u9664\u5f02\u5e38\u8fc1\u79fb\u5bf9\u8c61\uff1f", (String)"MigrateSchemeEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), String.join((CharSequence)",", names));
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SCHEME_VALIDATE, (IFormPlugin)this));
            } else {
                msg = String.format(ResManager.loadKDString((String)"%s\u8fc1\u79fb\u5bf9\u8c61\u5df2\u4e0d\u652f\u6301\u5168\u91cf\u8fc1\u79fb\u6a21\u578b\u3002\u5f53\u524d\u8fc1\u79fb\u65b9\u6848\u5df2\u51fa\u73b0\u5f02\u5e38\uff0c\u5c06\u65e0\u6cd5\u4fee\u6539\u548c\u6267\u884c\u8fc1\u79fb\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u79fb\u9664\u5f02\u5e38\u8fc1\u79fb\u5bf9\u8c61\uff1f", (String)"MigrateSchemeEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), String.join((CharSequence)",", names));
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SCHEME_VALIDATE, (IFormPlugin)this));
            }
        }
    }

    private void checkSortNum() {
        String status = String.valueOf(this.getView().getFormShowParameter().getStatus());
        MigrateSchemeHelper schemeHelper = this.getSchemeTreeHelper();
        if (!ADD_NEW.equals(status)) {
            String billFormId;
            HashMap<Long, String> moduleSortNumMap = new HashMap<Long, String>(16);
            DynamicObjectCollection migObjEntryColl = this.getModel().getEntryEntity("treeentryentity");
            switch (billFormId = this.getModel().getDataEntity().getDataEntityType().getName()) {
                case "dmw_migratescheme_eas": {
                    moduleSortNumMap.putAll(this.getModuleSortNumMap("dmw_migratemodule_eas", migObjEntryColl));
                    break;
                }
                case "dmw_migratescheme_nc": {
                    moduleSortNumMap.putAll(this.getModuleSortNumMap("dmw_migratemodule_nc", migObjEntryColl));
                    break;
                }
                case "dmw_migratescheme_ecc": {
                    moduleSortNumMap.putAll(this.getModuleSortNumMap("dmw_migratemodule_ecc", migObjEntryColl));
                    break;
                }
            }
            HashMap<Object, String> difNumMap = new HashMap<Object, String>(8);
            for (DynamicObject entry : migObjEntryColl) {
                long moduleId = DynamicObjectUtils.getPkValue(entry.getDynamicObject("migrateobject"), "group");
                String moduleSortNumber = (String)moduleSortNumMap.get(moduleId);
                String objectSortNumber = DynamicObjectUtils.getString(entry.getDynamicObject("migrateobject"), "sortnum");
                String objNewNum = schemeHelper.getThreeDigit(new StringBuilder(objectSortNumber));
                String objNewDefNum = moduleSortNumber + "." + objNewNum;
                String objOldDefNum = entry.getString("sortnumdefault");
                if (objOldDefNum.equals(objNewDefNum)) continue;
                difNumMap.put(entry.getPkValue(), objNewDefNum);
            }
            if (!difNumMap.isEmpty()) {
                this.getView().getPageCache().put(DEF_NUM_CACHE, JSON.toJSONString(difNumMap));
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9ed8\u8ba4\u987a\u5e8f\u53f7\u6709\u53d8\uff0c\u662f\u5426\u66f4\u65b0\u73b0\u6709\u9ed8\u8ba4\u987a\u5e8f\u53f7\uff1f", (String)"MigrateSchemeEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_UPDATENUM, (IFormPlugin)this));
            }
        }
    }

    private Map<Long, String> getModuleSortNumMap(String formId, DynamicObjectCollection migObjEntryColl) {
        DynamicObject[] moduleDynObjs;
        HashMap<Long, String> moduleSortNumMap = new HashMap<Long, String>(16);
        Set moduleIdSet = migObjEntryColl.stream().map(n -> n.getDynamicObject("migrateobject").getDynamicObject("group").getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", moduleIdSet);
        for (DynamicObject module : moduleDynObjs = BusinessDataServiceHelper.load((String)formId, (String)String.join((CharSequence)",", "id", "sortnum"), (QFilter[])new QFilter[]{qFilter})) {
            moduleSortNumMap.put(module.getLong("id"), module.getString("sortnum"));
        }
        return moduleSortNumMap;
    }

    private void modelChanged(Object oldValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            this.getPageCache().put(CALLBACK_MODEL, (String)oldValue);
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u8fc1\u79fb\u6a21\u5f0f\u5c06\u6e05\u7a7a\u8fc1\u79fb\u5bf9\u8c61\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MigrateSchemeEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_MODEL, (IFormPlugin)this));
            return;
        }
        this.modelTreeDeal();
        this.pageStyleDeal();
    }

    private void updateDefNum(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            PermissionHelper.checkPermission(null, "dmw_migratescheme_eas", "4715a0df000000ac");
            String numCache = this.getView().getPageCache().get(DEF_NUM_CACHE);
            Map defNumMap = (Map)JSON.parseObject((String)numCache, Map.class);
            DynamicObjectCollection migObjEntries = this.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject entry : migObjEntries) {
                String defNum = (String)defNumMap.get(entry.getPkValue());
                if (defNum == null) continue;
                entry.set("sortnumdefault", (Object)defNum);
            }
            this.getView().updateView("treeentryentity");
            this.getView().invokeOperation("save");
        }
    }

    private void relyCancelCallback(MessageBoxResult result) {
        MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
        if (MessageBoxResult.Yes.equals((Object)result)) {
            String unCheck = this.getPageCache().get(CALLBACK_UNCHECK);
            List list = (List)JSONObject.parseObject((String)unCheck, List.class);
            String focusNode = this.getPageCache().get(FOCUS_NODE);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            treeView.uncheckNodes(list);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            if (selectedNodeId.isEmpty()) {
                this.getModel().deleteEntryData("treeentryentity");
            }
            helper.buildTreeEntityByNode(selectedNodeId);
            helper.checkNodeByDmwObject(selectedNodeId, Collections.emptyList(), focusNode);
        } else if (MessageBoxResult.Cancel.equals((Object)result)) {
            String checkNode = this.getPageCache().get(CHECK_NODE);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            selectedNodeId.add(checkNode);
            helper.checkNodeByDmwObject(selectedNodeId, Collections.emptyList(), checkNode);
        } else {
            String relyString = this.getPageCache().get(CALLBACK_RELY);
            String focusNode = this.getPageCache().get(FOCUS_NODE);
            Set rely = (Set)JSONObject.parseObject((String)relyString, Set.class);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            selectedNodeId.addAll(new ArrayList(rely));
            helper.buildTreeEntityByNode(selectedNodeId);
            helper.checkNodeByDmwObject(selectedNodeId, Collections.emptyList(), focusNode);
        }
    }

    private void schemeValidateCallback(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            String ids = this.getPageCache().get(CALLBACK_SCHEME_VALIDATE);
            Set idSet = (Set)JSONObject.parseObject((String)ids, Set.class);
            ArrayList<Integer> list = new ArrayList<Integer>(16);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (!idSet.contains(entry.getPkValue())) continue;
                list.add(i);
            }
            int[] ints = new int[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                ints[j] = (Integer)list.get(j);
            }
            this.getModel().deleteEntryRows("treeentryentity", ints);
            this.getView().invokeOperation("save");
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel", "bar_new", "bar_copy", "bar_save", "bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit"});
            TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
            TreeNode rootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(TREE_VIEWAP), TreeNode.class);
            MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
            helper.setTreeEnable(rootNode);
            treeView.updateNode(rootNode);
            treeView.expand(rootNode.getId());
        }
    }

    private void relyCallback(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            String relyString = this.getPageCache().get(CALLBACK_RELY);
            String focusNode = this.getPageCache().get(FOCUS_NODE);
            Set rely = (Set)JSONObject.parseObject((String)relyString, Set.class);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            selectedNodeId.addAll(new ArrayList(rely));
            MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
            helper.buildTreeEntityByNode(selectedNodeId);
            helper.checkNodeByDmwObject(selectedNodeId, Collections.emptyList(), focusNode);
        } else if (MessageBoxResult.Cancel.equals((Object)result)) {
            String unCheck = this.getPageCache().get(CALLBACK_UNCHECK);
            List list = (List)JSONObject.parseObject((String)unCheck, List.class);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            treeView.uncheckNodes(list);
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEWAP);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
            helper.buildTreeEntityByNode(selectedNodeId);
        }
    }

    private void modelCallBack(MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.modelTreeDeal();
            this.pageStyleDeal();
            return;
        }
        String oldValue = this.getPageCache().get(CALLBACK_MODEL);
        this.getModel().beginInit();
        this.getModel().setValue("migrationmodel", (Object)oldValue);
        this.getModel().endInit();
        this.getView().updateView("migrationmodel");
    }

    private void pageStyleDeal() {
        String model = (String)this.getModel().getValue("migrationmodel");
        Set<String> mulcomboSet = DynamicObjectUtils.getMulcomboSet(model);
        if (mulcomboSet.contains("A") && mulcomboSet.contains("B")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"initscheme", "initintegrattype", "allscheme", "allintegrattype"});
        } else if (mulcomboSet.contains("A")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"initscheme", "initintegrattype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"allscheme", "allintegrattype"});
        } else if (mulcomboSet.contains("B")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"allscheme", "allintegrattype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"initscheme", "initintegrattype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"initscheme", "initintegrattype", "allscheme", "allintegrattype"});
        }
    }

    private void modelTreeDeal() {
        this.getModel().deleteEntryData("treeentryentity");
        MigrateSchemeHelper helper = new MigrateSchemeHelper(this.getView());
        helper.initTree();
        helper.checkNodeByDmwObject(Collections.emptyList(), Collections.emptyList(), null);
    }

    private boolean checkRelyDatas(List<String> nodeIds, String objectFormId) {
        HashSet idList = new HashSet(nodeIds.size());
        nodeIds.stream().forEach(n -> idList.add(Long.valueOf(n)));
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] migrationObjs = BusinessDataServiceHelper.load((String)objectFormId, (String)"id,easobjectrelys,number,name", (QFilter[])qFilter.toArray());
        HashSet<String> relyDatas = new HashSet<String>(16);
        HashSet<String> unCheckTree = new HashSet<String>(16);
        StringBuilder builder = new StringBuilder();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
        HashSet<Long> selectNodes = new HashSet<Long>(16);
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        selectedNodeIds.forEach(n -> selectNodes.add(Long.valueOf(n)));
        this.doMigRelyDeal(selectNodes, migrationObjs, relyDatas, unCheckTree, builder, objectFormId);
        builder.append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4e00\u8d77\u6dfb\u52a0\u5230\u65b9\u6848\u3002", (String)"MigrateSchemeEditPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (relyDatas.isEmpty()) {
            return false;
        }
        this.getPageCache().put(CALLBACK_RELY, JSONObject.toJSONString(relyDatas));
        this.getPageCache().put(CALLBACK_UNCHECK, JSONObject.toJSONString(unCheckTree));
        this.getPageCache().put(FOCUS_NODE, nodeIds.get(0));
        MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
        btnNameMaps.put(6, ResManager.loadKDString((String)"\u786e\u5b9a", (String)"MigrateSchemeEditPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(7, ResManager.loadKDString((String)"\u5ffd\u7565", (String)"MigrateSchemeEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MigrateSchemeEditPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getView().showConfirm(builder.toString(), "", options, null, new ConfirmCallBackListener(CALLBACK_RELY, (IFormPlugin)this), btnNameMaps);
        return true;
    }

    private boolean cancelCheckRelyDatas(List<String> nodeIds, String objectFormId) {
        HashSet idList = new HashSet(nodeIds.size());
        nodeIds.stream().forEach(n -> idList.add(Long.valueOf(n)));
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] migrationObjs = BusinessDataServiceHelper.load((String)objectFormId, (String)"id,easobjectrelys,number,name", (QFilter[])qFilter.toArray());
        HashSet<String> relyDatas = new HashSet<String>(16);
        StringBuilder builder = new StringBuilder();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
        HashSet selectNodes = new HashSet(16);
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        selectedNodeIds.forEach(n -> selectNodes.add(Long.valueOf(n)));
        HashSet<String> unCheckTree = new HashSet<String>(16);
        this.cancelMigRelyDeal(selectedNodeIds, migrationObjs, relyDatas, unCheckTree, builder);
        builder.append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4e00\u8d77\u53d6\u6d88\u52fe\u9009\u3002", (String)"MigrateSchemeEditPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (unCheckTree.isEmpty()) {
            return false;
        }
        this.getPageCache().put(CALLBACK_RELY, JSONObject.toJSONString(relyDatas));
        this.getPageCache().put(CALLBACK_UNCHECK, JSONObject.toJSONString(unCheckTree));
        this.getPageCache().put(FOCUS_NODE, nodeIds.get(0));
        MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
        btnNameMaps.put(6, ResManager.loadKDString((String)"\u786e\u5b9a", (String)"MigrateSchemeEditPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(7, ResManager.loadKDString((String)"\u5ffd\u7565", (String)"MigrateSchemeEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MigrateSchemeEditPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getView().showConfirm(builder.toString(), "", options, null, new ConfirmCallBackListener(CALLBACK_RELY_CANCEL, (IFormPlugin)this), btnNameMaps);
        return true;
    }

    private void doMigRelyDeal(Set<Long> idList, DynamicObject[] migrationObjs, Set<String> relyDatas, Set<String> unCheckTree, StringBuilder builder, String objectFormId) {
        for (DynamicObject mig : migrationObjs) {
            DynamicObjectCollection easObjectRelies = mig.getDynamicObjectCollection("easobjectrelys");
            if (easObjectRelies == null || easObjectRelies.isEmpty()) continue;
            StringBuilder relyName = new StringBuilder();
            for (DynamicObject rely : easObjectRelies) {
                DynamicObject baseData = rely.getDynamicObject("fbasedataid");
                if (baseData == null || idList.contains((Long)baseData.getPkValue())) continue;
                unCheckTree.add(mig.getString("id"));
                this.relyNestDeal(idList, relyDatas, relyName, baseData, objectFormId);
            }
            if (relyName.length() <= 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9%1$s\u5bf9\u8c61\u4f9d\u8d56%2$s\u5bf9\u8c61\uff0c%3$s", (String)"MigrateSchemeEditPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]), mig.getString("name"), relyName.substring(0, relyName.length() - 1), "\n");
            builder.append(msg);
        }
    }

    private void cancelMigRelyDeal(List<String> selectIds, DynamicObject[] migrationObjs, Set<String> relyDatas, Set<String> unCheckTree, StringBuilder builder) {
        ArrayList<DynamicObject> migrationObj = new ArrayList<DynamicObject>(Arrays.asList(migrationObjs));
        int size = migrationObj.size();
        boolean juge = true;
        int i = 0;
        while (juge && i <= size) {
            ++i;
            juge = false;
            Iterator iterator = migrationObj.iterator();
            block1: while (iterator.hasNext()) {
                DynamicObject mig = (DynamicObject)iterator.next();
                DynamicObjectCollection easobjectrelys = mig.getDynamicObjectCollection("easobjectrelys");
                if (easobjectrelys == null || easobjectrelys.isEmpty()) continue;
                for (DynamicObject rely : easobjectrelys) {
                    DynamicObject basedata = rely.getDynamicObject("fbasedataid");
                    if (selectIds.contains(String.valueOf(basedata.getPkValue()))) continue;
                    juge = true;
                    selectIds.remove(mig.getString("id"));
                    iterator.remove();
                    unCheckTree.add(mig.getString("id"));
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u8c61\u4f9d\u8d56%2$s\u5bf9\u8c61\uff0c%3$s", (String)"MigrateSchemeEditPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]), mig.getString("name"), basedata.getString("name"), "\n");
                    builder.append(msg);
                    continue block1;
                }
            }
        }
    }

    private void relyNestDeal(Set<Long> selectNodeIds, Set<String> relyDatas, StringBuilder relyName, DynamicObject basedata, String objectFormId) {
        QFilter qFilter = QFilterUtils.getEnableQFilter().and(QFilterUtils.getAuditedQfilter()).and("id", "=", basedata.getPkValue());
        DynamicObject relyObj = BusinessDataServiceHelper.loadSingle((String)objectFormId, (String)"id,easobjectrelys,number,name", (QFilter[])qFilter.toArray());
        if (relyObj != null) {
            relyName.append(basedata.getString("name")).append('\uff0c');
            relyDatas.add(basedata.getString("id"));
            DynamicObjectCollection easObjectRelys = relyObj.getDynamicObjectCollection("easobjectrelys");
            if (easObjectRelys == null || easObjectRelys.isEmpty()) {
                return;
            }
            for (DynamicObject rely : easObjectRelys) {
                DynamicObject base = rely.getDynamicObject("fbasedataid");
                if (selectNodeIds.contains((Long)base.getPkValue())) continue;
                this.relyNestDeal(selectNodeIds, relyDatas, relyName, base, objectFormId);
            }
        }
    }

    private MigrateSchemeHelper getSchemeTreeHelper() {
        if (this.migrateSchemeHelper == null) {
            this.migrateSchemeHelper = new MigrateSchemeHelper(this.getView());
        }
        return this.migrateSchemeHelper;
    }

    private void verifyHaveExecNum(DynamicObjectCollection entryEntity) {
        boolean haveNum = false;
        for (DynamicObject item : entryEntity) {
            int sortNumExec = item.getInt("sortnumexec");
            if (sortNumExec == 0) continue;
            haveNum = true;
            String msg = ResManager.loadKDString((String)"\u5df2\u6709\u6267\u884c\u987a\u5e8f\u53f7\u5c06\u88ab\u5237\u65b0\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"MigrateSchemeEditPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_EXECNUM));
            break;
        }
        if (!haveNum) {
            new MigrateSortNumExecHelper(this.getView()).sortByDefault(entryEntity, "dmw_migratescheme");
        }
    }
}

