/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.datacollect;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.common.pagemodel.DmwProjectdetail;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class ProjectRpeportOpValidator
extends AbstractImbdValidator {
    public void otherOP(String opKey, ExtendedDataEntity[] datas) {
        switch (opKey) {
            case "taskfinish": {
                List<Long> collectEntryIdList = this.verifyProjectStatus(datas, "1", "", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u65f6\uff0c\u624d\u5141\u8bb8\u6807\u8bb0\u5b8c\u6210\u3002", (String)"ProjectRpeportOpValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.verifyTaskFinish(datas, collectEntryIdList);
                break;
            }
            case "canceltaskfinish": {
                this.verifyProjectStatus(datas, "2", "", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5df2\u63d0\u62a5\u65f6\uff0c\u624d\u5141\u8bb8\u53d6\u6d88\u5b8c\u6210\u3002", (String)"ProjectRpeportOpValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "dataconfirm": {
                this.verifyProjectStatus(datas, "1", "1", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u4e14%s\u6570\u636e\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u65f6\uff0c\u624d\u5141\u8bb8\u6570\u636e\u786e\u8ba4\u3002", (String)"ProjectRpeportOpValidator_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "dataunconfirm": {
                this.verifyProjectStatus(datas, "1", "2", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u4e14%s\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u65f6\uff0c\u624d\u5141\u8bb8\u53d6\u6d88\u786e\u8ba4\u3002", (String)"ProjectRpeportOpValidator_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "datacanel": {
                this.verifyProjectStatus(datas, "1", "1", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u4e14%s\u6570\u636e\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u65f6\uff0c\u624d\u5141\u8bb8\u5e9f\u5f03\u6570\u636e\u3002", (String)"ProjectRpeportOpValidator_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "dataenable": {
                this.verifyProjectStatus(datas, "1", "6", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u4e14\u63d0\u62a5\u72b6\u6001\u4e3a\u5f85\u63d0\u62a5\u4e14%s\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5e9f\u5f03\u65f6\uff0c\u624d\u5141\u8bb8\u91cd\u65b0\u751f\u6548\u3002", (String)"ProjectRpeportOpValidator_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
    }

    private List<Long> verifyProjectStatus(ExtendedDataEntity[] datas, String reportStatus, String dataStatus, String msg) {
        List<Long> collectEntryIdList = this.getCollectResultEntryId();
        List<Long> importEntryIdList = this.getImportResultEntryId();
        DynamicObjectCollection projectDetailColl = this.getProjectDetailByResultEntryId(collectEntryIdList);
        long curUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> successCollectEntryIdList = new ArrayList<Long>(collectEntryIdList.size());
        ArrayList<Long> successImportEntryIdList = new ArrayList<Long>(importEntryIdList.size());
        for (ExtendedDataEntity data : datas) {
            for (DynamicObject detail : projectDetailColl) {
                long reporterId = detail.getLong(DmwProjectdetail.EF_reportorid_Q);
                if (curUserId == reporterId) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6570\u636e\u63d0\u62a5\u4eba\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"ProjectRpeportOpValidator_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return successCollectEntryIdList;
            }
            DynamicObjectCollection entryColl = data.getDataEntity().getDynamicObjectCollection("reporttasks");
            List reportTaskList = entryColl.stream().filter(o -> collectEntryIdList.contains(o.getLong("collectresultentryid"))).collect(Collectors.toList());
            if (CommonUtils.isNull(reportTaskList)) continue;
            List selectEntryList = reportTaskList.stream().map(o -> o.getLong("collectresultentryid")).collect(Collectors.toList());
            Set detailSet = projectDetailColl.stream().filter(o -> selectEntryList.contains(o.getLong(DmwProjectdetail.E_collectresultentry_id)) && reportStatus.equals(o.getString(DmwProjectdetail.EF_reportstatus_Q))).map(o -> o.getLong(DmwProjectdetail.E_collectresultentry_id)).collect(Collectors.toSet());
            if (CommonUtils.isNull(detailSet)) {
                msg = StringUtil.isNotEmpty(dataStatus) ? String.format(msg, "") : msg;
                this.addErrorMessage(data, msg);
                continue;
            }
            if (StringUtil.isNotEmpty(dataStatus)) {
                StringBuilder seqStr = new StringBuilder();
                for (DynamicObject reportTaskEntry : reportTaskList) {
                    DynamicObjectCollection importEntryColl = reportTaskEntry.getDynamicObjectCollection("importresultentry");
                    List importEntryList = importEntryColl.stream().filter(o -> importEntryIdList.contains(o.getLong("importresultentryid"))).collect(Collectors.toList());
                    if (CommonUtils.isNull(importEntryList)) continue;
                    for (DynamicObject importEntryObj : importEntryList) {
                        List list = projectDetailColl.stream().filter(o -> importEntryObj.getLong("importresultentryid") == o.getLong(DmwProjectdetail.E_importresultentry_id) && dataStatus.equals(o.getString(DmwProjectdetail.EF_datastatus_Q))).collect(Collectors.toList());
                        if (CommonUtils.isNull(list)) {
                            seqStr.append(importEntryObj.get("seq")).append(',');
                            continue;
                        }
                        successCollectEntryIdList.add(reportTaskEntry.getLong("collectresultentryid"));
                        successImportEntryIdList.add(importEntryObj.getLong("importresultentryid"));
                    }
                }
                if (seqStr.length() <= 0) continue;
                seqStr.deleteCharAt(seqStr.length() - 1);
                this.addErrorMessage(data, String.format(msg, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u7684", (String)"ProjectRpeportOpValidator_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), seqStr)));
                continue;
            }
            successCollectEntryIdList.addAll(detailSet);
        }
        this.getOption().setVariableValue("collectresultentryid", SerializationUtils.toJsonString(successCollectEntryIdList));
        this.getOption().setVariableValue("importresultentryid", SerializationUtils.toJsonString(successImportEntryIdList));
        return successCollectEntryIdList;
    }

    private void verifyTaskFinish(ExtendedDataEntity[] datas, List<Long> collectEntryIdList) {
        if (collectEntryIdList.isEmpty()) {
            return;
        }
        DynamicObjectCollection detailFinishColl = this.getReportProjectDetailColl(collectEntryIdList);
        if (detailFinishColl != null && !detailFinishColl.isEmpty()) {
            StringBuilder seqStr = new StringBuilder();
            String msg = ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u6807\u8bb0\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5b58\u5728\u5f85\u786e\u8ba4\u63d0\u62a5\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6807\u5fd7\u5b8c\u6210\u3002", (String)"ProjectRpeportOpValidator_7", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (ExtendedDataEntity data : datas) {
                DynamicObject dynObj = data.getDataEntity();
                DynamicObjectCollection entryColl = dynObj.getDynamicObjectCollection("reporttasks");
                List selectEntryList = entryColl.stream().filter(o -> collectEntryIdList.contains(o.getLong("collectresultentryid"))).collect(Collectors.toList());
                for (DynamicObject newEntryObj : selectEntryList) {
                    List list = detailFinishColl.stream().filter(o -> newEntryObj.getLong("collectresultentryid") == o.getLong(DmwProjectdetail.E_collectresultentry_id)).collect(Collectors.toList());
                    Set dataStatusSet = list.stream().map(o -> o.getString(DmwProjectdetail.EF_datastatus_Q)).collect(Collectors.toSet());
                    if (!dataStatusSet.contains("1")) continue;
                    seqStr.append(newEntryObj.get("seq")).append(',');
                    detailFinishColl.removeAll(list);
                }
                if (seqStr.length() <= 0) continue;
                seqStr.deleteCharAt(seqStr.length() - 1);
                this.addErrorMessage(data, String.format(msg, seqStr));
            }
        }
    }

    private DynamicObjectCollection getProjectDetailByResultEntryId(List<Long> collectEntryIdList) {
        QFilter qFilter = new QFilter(DmwProjectdetail.E_collectresultentry_id, "in", collectEntryIdList);
        qFilter.and(new QFilter(DmwProjectdetail.F_projectid_projectstatus, "=", (Object)"B"));
        String selectors = String.join((CharSequence)",", DmwProjectdetail.E_collectresultentry_id, DmwProjectdetail.EF_reportstatus_Q, DmwProjectdetail.EF_reportorid_Q, DmwProjectdetail.E_importresultentry_id, DmwProjectdetail.EF_datastatus_Q);
        return QueryServiceHelper.query((String)"dmw_projectdetail", (String)selectors, (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection getReportProjectDetailColl(List<Long> entryIdList) {
        if (!CommonUtils.isNull(entryIdList)) {
            return ProjectAllBaseUtil.queryProjectDetailColl(entryIdList);
        }
        return null;
    }

    private List<Long> getCollectResultEntryId() {
        if (this.getOption().containsVariable("collectresultentryid")) {
            return (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("collectresultentryid"), List.class);
        }
        return new ArrayList<Long>(0);
    }

    private List<Long> getImportResultEntryId() {
        if (this.getOption().containsVariable("importresultentryid")) {
            return (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("importresultentryid"), List.class);
        }
        return new ArrayList<Long>(0);
    }
}

