/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.multiimport.scheme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.utils.DynamicObjectUtils;

public class SchemeSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SchemeSaveOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        log.info("SchemeSaveOp.beginOperationTransaction, record num:" + (dataEntities == null ? "null" : Integer.valueOf(dataEntities.length)));
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        boolean containsVariable = this.getOption().containsVariable("operateType");
        if (containsVariable) {
            String operateType = this.getOption().getVariableValue("operateType");
            boolean flag = "new".equals(operateType);
            if (!flag) {
                return;
            }
            Map<String, Boolean> numberExistsMap = this.numberExists(dataEntities);
            for (DynamicObject dataEntity : dataEntities) {
                String number = dataEntity.getString("number");
                if (numberExistsMap.get(number).booleanValue()) {
                    String newNumber = DynamicObjectUtils.autoNumber(dataEntity, "dmw_impscheme", null);
                    dataEntity.set("number", (Object)newNumber);
                }
                dataEntity.set("enable", (Object)"0");
                dataEntity.set("disabler", (Object)dataEntity.getDynamicObject("creator"));
                dataEntity.set("disabledate", (Object)dataEntity.getDate("createtime"));
            }
        }
    }

    private Map<String, Boolean> numberExists(DynamicObject[] dataEntities) {
        List<String> numbers = this.getNumbers(dataEntities);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(dataEntities.length);
        QFilter[] filters = new QFilter[1];
        for (String number : numbers) {
            filters[0] = new QFilter("number", "=", (Object)number);
            boolean exists = QueryServiceHelper.exists((String)"dmw_impscheme", (QFilter[])filters);
            result.put(number, exists);
        }
        return result;
    }

    private List<String> getNumbers(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String number = dataEntity.getString("number");
            if (StringUtils.isEmpty((CharSequence)number)) continue;
            result.add(number);
        }
        return result;
    }
}

