/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.multiimport.scheme;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.plugin.validator.SchemeShareValidator;

public class SchemeShareOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SchemeShareOp.class);
    private final SchemeShareValidator validator = new SchemeShareValidator();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("shared");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)this.validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        log.info("SchemeShareOp.beginOperationTransaction, record num:" + (dataEntities == null ? "null" : Integer.valueOf(dataEntities.length)));
        try {
            super.beginOperationTransaction(e);
            this.updateDynamic(dataEntities);
        }
        catch (Exception exception) {
            throw new KDBizException("DB Excute Exception");
        }
    }

    private void updateDynamic(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operationKey = this.validator.operateKey();
        for (DynamicObject dynamicObject : dataEntities) {
            String value = "share".equals(operationKey) ? "1" : "0";
            dynamicObject.set("shared", (Object)value);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

