/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.tpl.migratescheme;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.imsc.dmw.helper.tpl.MigrateSortNumExecHelper;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class MigrateSchemeSubmitValidator
extends AbstractImbdValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("migrateobject");
        fields.add("sortnumdefault");
        fields.add("sortnumexec");
        fields.add(String.join((CharSequence)".", "treeentryentity", "seq"));
        return fields;
    }

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            this.sortByExecNum(rowDataEntity);
            this.vertifyErrorSequence(rowDataEntity);
        }
    }

    private void sortByExecNum(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("treeentryentity");
        List entryList = entryEntity.stream().sorted(Comparator.comparing(n -> n.getInt("sortnumexec"))).collect(Collectors.toList());
        entryEntity.clear();
        entryEntity.addAll(entryList);
        for (int i = 0; i < entryEntity.size(); ++i) {
            ((DynamicObject)entryEntity.get(i)).set("seq", (Object)i);
        }
    }

    private void vertifyErrorSequence(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject item : entryEntity) {
            int sortNumExec = item.getInt("sortnumexec");
            if (sortNumExec != 0) continue;
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8d4b\u503c\u3002", (String)"MigrateSchemeSubmitValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
            return;
        }
        Map<String, List<String>> errorSequenceMap = MigrateSortNumExecHelper.getErrorSequenceMap(entryEntity, "dmw_migratescheme");
        if (!errorSequenceMap.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff01\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u6267\u884c\u987a\u5e8f\u5728\u540e\uff0c\u53ef\u80fd\u5bfc\u81f4\u8fc1\u79fb\u5931\u8d25\u3002", (String)"MigrateSchemeSubmitValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            StringBuilder detail = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : errorSequenceMap.entrySet()) {
                String migObjName = entry.getKey();
                List<String> relyObjNameList = entry.getValue();
                for (String relyObjName : relyObjNameList) {
                    String tempMsg = String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u3010%1$s\u3011\u7684\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u3010%2$s\u3011\u6267\u884c\u8fc1\u79fb\u6392\u5e8f\u5728\u540e\u3002", (String)"MigrateSchemeSubmitValidator_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), migObjName, relyObjName);
                    detail.append(tempMsg).append('\n');
                }
            }
            this.addMessage(dataEntity, title, detail.toString(), ErrorLevel.Warning);
        }
    }
}

