/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.helper.eas.OpValidatorHelper;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class ConvCashSaveValidator
extends AbstractImbdValidator {
    private final String opType;

    public ConvCashSaveValidator() {
        this.opType = "save";
    }

    public ConvCashSaveValidator(String opType) {
        this.opType = opType;
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("id");
        fields.add("number");
        fields.add("org");
        fields.add("srccashnum");
        fields.add("entryentity");
        fields.add("entryentity.srcasst");
        fields.add("entryentity.tarasst");
        return fields;
    }

    public void validate() {
        ArrayList<Object> idList = new ArrayList<Object>(8);
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            String enable;
            ExtendedDataEntity rowDataEntity = this.getDataEntities()[i];
            DynamicObject bill = rowDataEntity.getDataEntity();
            if ("save".equals(this.opType) && "0".equals(enable = bill.getString("enable"))) {
                return;
            }
            idList.add(bill.getPkValue());
            this.judgeIfEqual(rowDataEntity, new QFilter("enable", "=", (Object)"1"));
            this.judgeIfEqual(rowDataEntity, new QFilter("id", "in", idList));
            this.judgeSrcDimension(rowDataEntity);
            this.judgeTarDimension(rowDataEntity);
        }
    }

    private void judgeIfEqual(ExtendedDataEntity rowDataEntity, QFilter qFilter) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection easOrges = (DynamicObjectCollection)bill.get("org");
        Object srcId = bill.get("id");
        String srcCashNum = (String)bill.get("srccashnum");
        HashMap<Object, String> map = new HashMap<Object, String>(8);
        StringBuilder errMsg = new StringBuilder();
        for (DynamicObject item : easOrges) {
            DynamicObject easOrg = item.getDynamicObject("fbasedataid");
            if (easOrg == null) continue;
            map.put(easOrg.getPkValue(), easOrg.getString("name"));
        }
        Map entryEntries = BusinessDataServiceHelper.loadFromCache((String)"dmw_cash_convert", (String)"id,number,org,srccashnum", (QFilter[])new QFilter[]{qFilter}, (String)"");
        for (DynamicObject entry : entryEntries.values()) {
            String tempDocNum = entry.getString("number");
            DynamicObjectCollection tempEasOrges = entry.getDynamicObjectCollection("org");
            Object tempSrcId = entry.get("id");
            String tempSrcCashNum = entry.getString("srccashnum");
            if (!srcCashNum.equals(tempSrcCashNum) || tempSrcId.equals(srcId)) continue;
            if (tempEasOrges.isEmpty() && map.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801%1$s\u4e0e%2$s\u5355\u636e\u4e2d\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvCashMapPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[]{srcCashNum, tempDocNum});
                errMsg.append(msg).append('\n');
                continue;
            }
            if (tempEasOrges.isEmpty() || map.isEmpty()) continue;
            for (DynamicObject item : tempEasOrges) {
                Object tempEasOrgId;
                DynamicObject easOrg = item.getDynamicObject("fbasedataid");
                if (easOrg == null || !map.containsKey(tempEasOrgId = easOrg.getPkValue())) continue;
                String msg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d%1$s+\u6e90\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801%2$s\u4e0e%3$s\u5355\u636e\u4e2d\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvCashMapPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[]{map.get(tempEasOrgId), srcCashNum, tempDocNum});
                errMsg.append(msg).append('\n');
            }
        }
        if (errMsg.length() > 0) {
            errMsg.deleteCharAt(errMsg.length() - 1);
            this.addErrorMessage(rowDataEntity, errMsg.toString());
        }
    }

    private void judgeSrcDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        String errMsg = OpValidatorHelper.judgeEntryDymDup(entryEntries, "srcasst", "ConvAccountMapPlugin_3", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u6838\u7b97\u7ef4\u5ea6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (errMsg.length() > 0) {
            this.addErrorMessage(rowDataEntity, errMsg);
        }
    }

    private void judgeTarDimension(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        String errMsg = OpValidatorHelper.judgeEntryDymDup(entryEntries, "tarasst", "ConvAccountMapPlugin_4", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvAccountMapPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (errMsg.length() > 0) {
            this.addErrorMessage(rowDataEntity, errMsg);
        }
    }
}

