/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.mservice.CommonMappingtUpgradeServiceImpl;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class ConvGeneralSaveValidator
extends AbstractImbdValidator {
    private final String opType;

    public ConvGeneralSaveValidator() {
        this.opType = "save";
    }

    public ConvGeneralSaveValidator(String opType) {
        this.opType = opType;
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("entryentity");
        fields.add("org");
        fields.add("entryentity.srcnum");
        return fields;
    }

    public void validate() {
        CommonMappingtUpgradeServiceImpl i = new CommonMappingtUpgradeServiceImpl();
        i.beforeExecuteSqlWithResult(null, null, null, null);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String enable;
            DynamicObject bill = rowDataEntity.getDataEntity();
            if ("save".equals(this.opType) && "0".equals(enable = bill.getString("enable"))) continue;
            this.judgeEntryRowDup(rowDataEntity);
        }
    }

    private void judgeEntryRowDup(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        DynamicObjectCollection entryEntries = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, Integer> numRowMap = new HashMap<String, Integer>(8);
        HashMap<String, Map> orgMap = new HashMap<String, Map>(8);
        for (int i = 0; i < entryEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntries.get(i);
            String number = entry.getString("srcnum");
            String tarNumber = entry.getString("tarnum");
            String key = number + "&&" + tarNumber;
            orgMap.putIfAbsent(number, new HashMap(8));
            Map easOrgs = (Map)orgMap.get(number);
            DynamicObjectCollection orgEntrys = entry.getDynamicObjectCollection("orgentry");
            if (CollectionUtils.isEmpty((Collection)orgEntrys)) {
                this.emptryDeal(rowDataEntity, i, easOrgs);
            }
            for (DynamicObject orgEntry : orgEntrys) {
                DynamicObject fbasedataid = orgEntry.getDynamicObject("fbasedataid");
                if (fbasedataid == null) {
                    if (orgEntrys.size() != 1) continue;
                    this.emptryDeal(rowDataEntity, i, easOrgs);
                    continue;
                }
                Long orgid = (Long)fbasedataid.getPkValue();
                String orgName = fbasedataid.getLocaleString("name").getLocaleValue();
                Integer integer = (Integer)easOrgs.get(orgid);
                if (integer != null) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u540c\u6e90\u5bf9\u8c61\u7f16\u7801\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884cEAS\u7ec4\u7ec7(%3$s)\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvGeneralMapPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[]{integer + 1, String.valueOf(i + 1), orgName}));
                }
                easOrgs.put(orgid, i);
            }
            orgMap.put(number, easOrgs);
            if (numRowMap.containsKey(key)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u6e90\u5bf9\u8c61\u7f16\u7801\u548c\u76ee\u6807\u5bf9\u8c61\u7f16\u7801\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvGeneralMapPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[]{(Integer)numRowMap.get(key) + 1, String.valueOf(i + 1)}));
                continue;
            }
            numRowMap.put(key, i);
        }
    }

    private void emptryDeal(ExtendedDataEntity rowDataEntity, int i, Map<Long, Integer> easOrgs) {
        Long emptykey = 99999999L;
        Integer integer = easOrgs.get(emptykey);
        if (integer != null) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e2d\u540c\u6e90\u5bf9\u8c61\u7f16\u7801\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884cEAS\u7ec4\u7ec7\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff0c\u8bf7\u590d\u6838\u6570\u636e\u3002", (String)"ConvGeneralMapPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[]{integer + 1, String.valueOf(i + 1)}));
        }
        easOrgs.put(emptykey, i);
    }
}

