/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SchemeShareValidator
extends AbstractValidator {
    private static final String SHARE = "share";
    private static final String PRIVATE = "private";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String SHARED = "shared";
    private static final String CREATOR = "creator";

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add(SHARE);
        set.add(PRIVATE);
        set.add(ENABLE);
        set.add(STATUS);
        set.add(SHARED);
        set.add(CREATOR);
        return set;
    }

    public void validate() {
        String operateKey = this.getOperateKey();
        if (SHARE.equals(operateKey) || PRIVATE.equals(operateKey)) {
            this.check();
        }
    }

    private void check() {
        long currUserId = RequestContext.get().getCurrUserId();
        if (currUserId == 0L) {
            return;
        }
        if (ObjectUtils.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkLoginUser(dataEntity, currUserId);
            this.checkShareStatus(dataEntity);
        }
    }

    private void checkLoginUser(ExtendedDataEntity dataEntity, long currentUserId) {
        DynamicObject data = dataEntity.getDataEntity();
        long creatorId = data.getLong("creator.id");
        if (creatorId == 0L || creatorId != currentUserId) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u8d26\u6237\u65e0\u6743\u64cd\u4f5c\u6b64\u6570\u636e\u3002", (String)"SchemeShareValidator_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    private void checkShareStatus(ExtendedDataEntity dataEntity) {
        String operateKey = this.getOperateKey();
        DynamicObject data = dataEntity.getDataEntity();
        String shared = data.getString(SHARED);
        if (SHARE.equals(operateKey) && "1".equals(shared)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u662f\u5171\u4eab\u72b6\u6001\u3002", (String)"SchemeShareValidator_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (PRIVATE.equals(operateKey) && "0".equals(shared)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u662f\u79c1\u6709\u72b6\u6001\u3002", (String)"SchemeShareValidator_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public String operateKey() {
        return this.getOperateKey();
    }
}

