/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.imsc.dmw.utils.StringUtils;

public class FilterGridUtil {
    private static final Log log = LogFactory.getLog(FilterGridUtil.class);

    private FilterGridUtil() {
    }

    public static void setFilterControl(String entityNumber, FilterGrid filterGrid) {
        if (StringUtils.isBlank(entityNumber)) {
            filterGrid.setFilterColumns(new ArrayList());
            return;
        }
        MainEntityType entityType = FilterGridUtil.getEntityTypeByFormId(entityNumber);
        if (entityType == null) {
            filterGrid.setFilterColumns(new ArrayList());
            return;
        }
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
        FilterGridUtil.removeInvalidFilterColumns(entityType, cols);
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(entityType.getName());
    }

    public static MainEntityType getEntityTypeByFormId(String formId) {
        MainEntityType entityType = null;
        String realEntityId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)realEntityId);
        }
        catch (Exception e) {
            log.error(String.format("not find %s", formId), (Throwable)e);
        }
        return entityType;
    }

    private static void removeInvalidFilterColumns(MainEntityType entityType, List<Map<String, Object>> cols) {
        Map fields = entityType.getAllFields();
        cols.removeIf(col -> col == null || col.get("fieldName") == null || fields.get(col.get("fieldName")) instanceof PictureProp);
    }
}

