/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.imsc.dmw.errorcode.DmwBizException;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);

    public static String postJson(String url, Map<String, String> header, String json) throws IOException {
        logger.info("HttpUtils.doPost: url = " + url);
        String responseStr = HttpClientUtils.postjson((String)url, header, (String)json);
        logger.info("HttpUtils.doPost: url = " + url + ",resultObj = " + HttpUtils.validLog(responseStr));
        return responseStr;
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        logger.info("HttpUtils.get: url = " + url);
        String responseStr = HttpClientUtils.get((String)url, header, body);
        logger.info("HttpUtils.get: url = " + url + ",resultObj = " + HttpUtils.validLog(responseStr == null ? "null" : responseStr));
        return responseStr;
    }

    public static String postJsonWithRetry(String url, Map<String, String> header, String json) {
        String responseStr = null;
        logger.info("HttpUtils.doPost: url = " + url);
        for (int count = 0; count < 3; ++count) {
            try {
                responseStr = HttpClientUtils.postjson((String)url, header, (String)json, (int)60000, (int)60000);
                break;
            }
            catch (Exception var6) {
                logger.info("HttpUtils.doPost:error, retry " + count, (Object)var6);
                continue;
            }
        }
        if (responseStr != null && !responseStr.contains("\"app_token\":") && !responseStr.contains("\"access_token\":")) {
            logger.info("HttpUtils.doPost: url = " + url + ",resultObj = " + HttpUtils.validLog(responseStr));
        }
        return responseStr;
    }

    public static String validLog(String logs) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("%0a");
        list.add("%0b");
        list.add("%0c");
        list.add("%0d");
        list.add("%7f");
        list.add("%08");
        list.add("%0A");
        list.add("%0D");
        list.add("\r");
        list.add("\n");
        String normalize = Normalizer.normalize(logs, Normalizer.Form.NFKC);
        for (String str : list) {
            normalize = normalize.replace(str, "");
        }
        return normalize;
    }

    public static String xFormEncode(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof CharSequence) {
            return data.toString();
        }
        if (data instanceof Map) {
            StringBuilder s = new StringBuilder();
            Map params = (Map)data;
            for (Map.Entry param : params.entrySet()) {
                if (s.length() > 0) {
                    s.append('&');
                }
                String key = (String)param.getKey();
                s.append(HttpUtils.encode(key));
                s.append('=');
                Object v = param.getValue();
                String value = v == null ? "" : v.toString();
                s.append(HttpUtils.encode(value));
            }
            return s.toString();
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u8981\u6c42\u662f\u5b57\u7b26\u4e32\uff0c\u4f46\u5b9e\u9645\u4e0a\u662f%s\uff01", (String)"HttpUtil_1", (String)"isc-iscb-util", (Object[])new Object[0]), data.getClass().getName()));
    }

    private static String encode(String key) {
        try {
            return URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("change encode UTF-8 error", (Throwable)e);
            throw new DmwBizException("change encode UTF-8 error");
        }
    }

    public static String mergeToURL(String url, String data) {
        if (data != null && data.length() != 0) {
            return url + '?' + data;
        }
        return url;
    }
}

