/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imsc.dmw.errorcode.DmwBizException;

public class OperationUtils {
    public static OperationResult OperateSingleDynamic(String operationKey, String entityNumber, DynamicObject dataEntities) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(false));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])new DynamicObject[]{dataEntities}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errMsg = OperationUtils.getErrDetail(operationResult);
            throw new DmwBizException("OperationUtils.OperateSingleDynamic do operat error," + errMsg);
        }
        return operationResult;
    }

    public static OperationResult OperatebyId(String operationKey, String entityNumber, Set<Object> idSet) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(false));
        Object[] ids = idSet.toArray();
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
    }

    public static OperationResult OperateSingleDynamic(String operationKey, String entityNumber, Collection<DynamicObject> dataEntities) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(false));
        DynamicObject[] objects = dataEntities.toArray(new DynamicObject[dataEntities.size()]);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])objects, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errMsg = OperationUtils.getErrDetail(operationResult);
            throw new DmwBizException("OperationUtils.OperateSingleDynamic do operat error," + errMsg);
        }
        return operationResult;
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }
}

