/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.net.URLEncoder;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mservice.svc.expt.ExportServiceImpl;
import kd.bos.web.actions.export.ExportActionResult;
import kd.imsc.dmw.errorcode.DmwBizException;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class StdTemplateHelper {
    private static final Log logger = LogFactory.getLog(StdTemplateHelper.class);

    private StdTemplateHelper() {
    }

    public static SXSSFWorkbook getStdImportTemplateStream(String formId, String targetName) throws DmwBizException {
        try {
            LocalDate now = LocalDate.now();
            ExportServiceImpl exportService = new ExportServiceImpl();
            String type = "dmw";
            String exportId = "";
            String temId = "0";
            boolean fillParent = false;
            String fileName = URLEncoder.encode(targetName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8");
            long startTime = System.currentTimeMillis();
            String routeAppId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
            ExportActionResult exportActionResult = exportService.doExportAction(type, exportId, temId, fillParent, routeAppId, formId, fileName, null, null);
            logger.info("\u83b7\u53d6\u5168\u91cf\u6a21\u677f \u8017\u65f6 {}ms", (Object)(System.currentTimeMillis() - startTime));
            if (exportActionResult == null || !exportActionResult.isSuccess()) {
                throw new DmwBizException(String.format(ResManager.loadKDString((String)"\u5168\u91cf[%s]\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25", (String)"StdTemplateHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId));
            }
            return exportActionResult.getWorkbook();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new DmwBizException(String.format(ResManager.loadKDString((String)"\u5168\u91cf[%1$s]\u6807\u51c6\u6a21\u677f\u83b7\u53d6\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a %2$s", (String)"StdTemplateHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId, e.getMessage()), (Throwable)e);
        }
    }
}

