/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.HashMap;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.imsc.dmw.utils.StringUtils;

public class StyleUtils {
    private StyleUtils() {
    }

    public static void setContainerStyle(IFormView view, String name, String borderStyle, String backColor, String foreColor) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(2);
        if (StringUtils.isNotBlank(foreColor)) {
            styleMap.put("fc", foreColor);
        }
        if (StringUtils.isNotBlank(backColor)) {
            styleMap.put("bc", backColor);
        }
        if (StringUtils.isNotBlank(borderStyle)) {
            HashMap s = new HashMap(2);
            HashMap<String, String> border = new HashMap<String, String>(4);
            border.put("r", borderStyle);
            border.put("l", borderStyle);
            border.put("t", borderStyle);
            border.put("b", borderStyle);
            s.put("b", border);
            styleMap.put("s", s);
        }
        view.updateControlMetadata(name, styleMap);
    }

    public static void setContainerStyle(IFormView view, String name, String rborderStyle, String lborderStyle, String tborderStyle, String bborderStyle, String backColor, String foreColor) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(2);
        if (StringUtils.isNotBlank(foreColor)) {
            styleMap.put("fc", foreColor);
        }
        if (StringUtils.isNotBlank(backColor)) {
            styleMap.put("bc", backColor);
        }
        if (StringUtils.isNotBlank(rborderStyle) || StringUtils.isNotBlank(lborderStyle) || StringUtils.isNotBlank(tborderStyle) || StringUtils.isNotBlank(bborderStyle)) {
            HashMap s = new HashMap(2);
            HashMap<String, String> border = new HashMap<String, String>(4);
            border.put("r", rborderStyle);
            border.put("l", lborderStyle);
            border.put("t", tborderStyle);
            border.put("b", bborderStyle);
            s.put("b", border);
            styleMap.put("s", s);
        }
        view.updateControlMetadata(name, styleMap);
    }

    public static void setCardRowStyle(IFormView view, String name, int row, String columnName, String backColor, String foreColor) {
        CardEntry cardEntry = (CardEntry)view.getControl(name);
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        HashMap<String, HashMap<String, String>> columnMap = new HashMap<String, HashMap<String, String>>(2);
        if (StringUtils.isNotBlank(backColor)) {
            styleMap.put("bc", backColor);
        }
        if (StringUtils.isNotBlank(foreColor)) {
            styleMap.put("fc", foreColor);
        }
        columnMap.put(columnName, styleMap);
        cardEntry.setCustomProperties(columnName, row, columnMap);
    }
}

