/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.taskcheckresult;

import java.util.ArrayList;
import java.util.List;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;

public class TaskCheckResultBusiness {
    public static void saveTaskCheckResult(List<Long> taskIds, Object schemeId, Object orgId, String checkResult) {
        try (TXHandle h1 = TX.requiresNew();){
            ArrayList<DynamicObject> resultRecords = new ArrayList<DynamicObject>(16);
            for (Long taskId : taskIds) {
                DynamicObject resultRecord = BusinessDataServiceHelper.newDynamicObject((String)"imic_checkresultrecord");
                resultRecord.set("initscheme", schemeId);
                resultRecord.set("inittask", (Object)taskId);
                resultRecord.set("dispatchorg", orgId);
                resultRecord.set("checkresult", (Object)checkResult);
                resultRecords.add(resultRecord);
            }
            try {
                QFilter delFilter = new QFilter(TaskDispatchConst.INITTASK_ID, "in", taskIds).and("dispatchorg", "=", orgId);
                DeleteServiceHelper.delete((String)"imic_checkresultrecord", (QFilter[])delFilter.toArray());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"imic_checkresultrecord");
                BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])resultRecords.toArray());
            }
            catch (Exception e) {
                h1.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"TaskCheckResultPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }
}

