/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.taskdispatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imsc.imic.common.taskdispatch.DispatchStepModel;
import kd.imsc.imic.common.taskdispatch.DispatchTaskModel;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;

public class TaskDispatchBusiness {
    public static void saveDispatchTask(String groupStepModelStr, DynamicCollectionProperty checkerUserProperty, Map<Long, DynamicObject> userMap, DynamicCollectionProperty dispatchOrgProperty, Map<Long, DynamicObject> orgMap, boolean useDimension, DynamicObject bizApp, DynamicObject scheme, long schemeId, MainEntityType dataEntityType) {
        try (TXHandle h1 = TX.requiresNew();){
            Map stepModelMap = (Map)SerializationUtils.fromJsonString((String)groupStepModelStr, Map.class);
            ArrayList<DynamicObject> dispatchRecords = new ArrayList<DynamicObject>(16);
            for (Map.Entry stepModelEntry : stepModelMap.entrySet()) {
                String stepId = (String)stepModelEntry.getKey();
                String stepModelStr = SerializationUtils.toJsonString(stepModelMap.get(stepId));
                DispatchStepModel stepModel = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepModelStr, DispatchStepModel.class);
                List<DispatchTaskModel> tasks = stepModel.getTasks();
                HashMap unDispatchOrgMap = new HashMap(16);
                for (DispatchTaskModel taskModel : tasks) {
                    Long taskId = taskModel.getTaskId();
                    List<Long> unDispatchOrgIds = taskModel.getUnDispatchOrgIds();
                    unDispatchOrgMap.putIfAbsent(taskId, new ArrayList(16));
                    ((List)unDispatchOrgMap.get(taskId)).addAll(unDispatchOrgIds);
                }
                for (DispatchTaskModel task : tasks) {
                    DynamicObject dispatchRecord = BusinessDataServiceHelper.newDynamicObject((String)"imic_taskdispatchrecord");
                    String stepName = task.getStepName();
                    Long taskId = task.getTaskId();
                    Long chargeUserId = task.getChargeUserId();
                    List<Long> checkerUserIds = task.getCheckerUserIds();
                    DynamicObjectCollection checkerUserDyms = TaskDispatchBusiness.buildDynamicCollection(checkerUserProperty, checkerUserIds, userMap);
                    List<Long> dispatchOrgIds = task.getDispatchOrgIds();
                    DynamicObjectCollection dispatchOrgDyms = TaskDispatchBusiness.buildDynamicCollection(dispatchOrgProperty, dispatchOrgIds, orgMap);
                    String dispatchStatus = "0";
                    if (useDimension) {
                        List unDispatchOrgIds = (List)unDispatchOrgMap.get(taskId);
                        if (chargeUserId != 0L && unDispatchOrgIds.isEmpty()) {
                            dispatchStatus = "1";
                        }
                    } else if (chargeUserId != 0L) {
                        dispatchStatus = "1";
                    }
                    dispatchRecord.set("bizapp", (Object)bizApp);
                    dispatchRecord.set("initscheme", (Object)scheme);
                    dispatchRecord.set("stepid", (Object)Long.valueOf(stepId));
                    dispatchRecord.set("stepname", (Object)stepName);
                    dispatchRecord.set("inittask", (Object)taskId);
                    dispatchRecord.set("chargeuser", (Object)chargeUserId);
                    dispatchRecord.set("checkuser", (Object)checkerUserDyms);
                    dispatchRecord.set("dispatchorg", (Object)dispatchOrgDyms);
                    dispatchRecord.set("dispatchstatus", (Object)dispatchStatus);
                    dispatchRecords.add(dispatchRecord);
                }
            }
            try {
                QFilter filter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", (Object)schemeId);
                DeleteServiceHelper.delete((String)"imic_taskdispatchrecord", (QFilter[])filter.toArray());
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("savetype", "manual");
                BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])dispatchRecords.toArray());
            }
            catch (Exception e) {
                h1.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"TaskDispatchPlugin_7", (String)"imsc-imic-platform", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private static DynamicObjectCollection buildDynamicCollection(DynamicCollectionProperty dynamicCollectionProperty, List<Long> ids, Map<Long, DynamicObject> dymMap) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dynamicCollectionProperty.getDynamicCollectionItemPropertyType(), null);
        long[] pkIds = DB.genLongIds((String)"imic_taskdispatchrecord", (int)ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            Long id = ids.get(i);
            long pkId = pkIds[i];
            DynamicObject dynamicObject = new DynamicObject(dynamicCollectionProperty.getDynamicCollectionItemPropertyType());
            dynamicObject.set("pkid", (Object)pkId);
            dynamicObject.set("fbasedataid", (Object)dymMap.get(id));
            dynamicObject.set("fbasedataid_id", (Object)id);
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        return dynamicObjectCollection;
    }
}

