/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.taskdispatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.business.ShowFormHelper;
import kd.imsc.imic.business.taskdispatch.TaskDispatchBusiness;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.LockUtils;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.deliveryinitial.ImicProgressunitConstant;
import kd.imsc.imic.common.taskdispatch.DispatchStepModel;
import kd.imsc.imic.common.taskdispatch.DispatchTaskModel;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;

public class TaskDispatchPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String STEP_LABEL_KEYS_CACHE = "steplabelkeys";
    private static final String STEP_LINE_LABEL_KEYS = "steplinelabelkeys";
    private static final String TASK_PANEL_AP = "taskpanelap";
    private static final String STEP_PANEL_AP = "steppanelap";
    private static final String TASK_ENTRY = "taskentry";
    private static final String STEP_MODEL_MAP = "stepmodelmap";
    private static final String CUR_STEP_LABEL = "cursteplabel";
    private static final String CUR_TASK_LABEL = "curtasklabel";
    private static final String UNDERLINE = "underline";
    private List<String> taskLabelKeys = Arrays.asList("alltasksize", "undispatchtasksize", "dispatchtasksize");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String stepLabelKeysStr = this.getPageCache().get(STEP_LABEL_KEYS_CACHE);
        if (StringUtils.isNotEmpty(stepLabelKeysStr)) {
            List stepLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLabelKeysStr, List.class);
            this.addClickListeners(stepLabelKeys.toArray(new String[0]));
        }
        this.addClickListeners(new String[]{"alltasksize", "undispatchtasksize", "dispatchtasksize", "tbmain"});
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit chargeUser = (BasedataEdit)this.getControl("chargeuser");
        chargeUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit checkUser = (BasedataEdit)this.getControl("checkuser");
        checkUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("dispatchorg");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeid");
        this.getModel().setValue("initscheme", schemeId);
        DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("initscheme");
        if (scheme == null) {
            return;
        }
        boolean useDimension = scheme.getBoolean("usedimension");
        String schemeName = scheme.getString("name");
        DynamicObject bizApp = scheme.getDynamicObject("bizapp");
        DynamicObjectCollection groups = scheme.getDynamicObjectCollection("itemgroup");
        this.getModel().setValue("name", (Object)schemeName);
        this.getModel().setValue("bizapp", (Object)bizApp);
        QFilter recordFilter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "=", schemeId);
        String selectRecordFields = String.join((CharSequence)",", "initscheme", "stepname", "inittask", "dispatchstatus", "chargeuser", "checkuser", "dispatchorg");
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectRecordFields, (QFilter[])recordFilter.toArray());
        Map<Long, List<DynamicObject>> taskRecordMap = Arrays.stream(records).collect(Collectors.groupingBy(record -> record.getDynamicObject("inittask").getLong("id")));
        List<DispatchStepModel> stepModels = this.getStepModel(groups, taskRecordMap, useDimension);
        Map stepModelMap = stepModels.stream().collect(Collectors.toMap(DispatchStepModel::getStepId, dispatchStepModel -> dispatchStepModel, (k1, k2) -> k2, LinkedHashMap::new));
        this.getPageCache().put(STEP_MODEL_MAP, SerializationUtils.toJsonString((Object)stepModelMap));
        this.createStepLabels(stepModels);
        String stepLineLabelKeysStr = this.getPageCache().get(STEP_LINE_LABEL_KEYS);
        if (StringUtils.isNotEmpty(stepLineLabelKeysStr)) {
            List stepLineLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLineLabelKeysStr, List.class);
            String labelLineLabelKey = (String)stepLineLabelKeys.get(0);
            stepLineLabelKeys.remove(labelLineLabelKey);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{labelLineLabelKey});
            this.getView().setVisible(Boolean.valueOf(false), stepLineLabelKeys.toArray(new String[0]));
        }
        this.getPageCache().put(CUR_STEP_LABEL, "all");
        ArrayList<DispatchTaskModel> tasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> dispatchTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> unDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        for (DispatchStepModel stepModel : stepModels) {
            tasks.addAll(stepModel.getTasks());
            dispatchTasks.addAll(stepModel.getDispatchTasks());
            unDispatchTasks.addAll(stepModel.getUnDispatchTasks());
        }
        this.createTaskEntry(tasks);
        this.getView().setVisible(Boolean.valueOf(!useDimension), new String[]{TASK_PANEL_AP});
        this.getView().setVisible(Boolean.valueOf(useDimension), new String[]{"dispatchorg", "orgdistribution"});
        if (!useDimension) {
            TaskDispatchHelper.setLabelForceColor(this.getView(), "alltasksize", "themeColor");
            this.getPageCache().put(CUR_TASK_LABEL, "alltasksize");
            this.setTaskSizeLabelVal(tasks.size(), dispatchTasks.size(), unDispatchTasks.size());
        } else {
            DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
            this.packageEntryData(scheme, taskEntrys);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("initscheme");
        if (scheme == null) {
            return;
        }
        boolean useDimension = scheme.getBoolean("usedimension");
        if (useDimension) {
            String stepLabelKeysStr = this.getPageCache().get(STEP_LABEL_KEYS_CACHE);
            String stepLabel = this.getPageCache().get(CUR_STEP_LABEL);
            if (StringUtils.isNotEmpty(stepLabelKeysStr) && "all".equals(stepLabel)) {
                List stepLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLabelKeysStr, List.class);
                stepLabelKeys.remove("all");
                this.cacheStepModelDimen(stepLabelKeys);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject scheme;
        DataMutexImpl dataMutex;
        Map lockInfo;
        if (StringUtils.equals(evt.getItemKey(), "barsave") && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(String.valueOf((scheme = this.getModel().getDataEntity().getDynamicObject("initscheme")).getPkValue()), "default_netctrl", "imic_initialscheme")) != null && !StringUtils.equals((String)lockInfo.get("opkey"), "todispatch")) {
            String userId = (String)lockInfo.get("userid");
            Map<String, Object> userInfo = CommonUtil.getUserInfoById(Long.parseLong(userId));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TaskDispatchPlugin_13", (String)"imsc-imic-platform", (Object[])new Object[0]), userInfo.getOrDefault("name", "")));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barclose": {
                this.getView().close();
                break;
            }
            case "barrefresh": {
                this.getView().updateView();
                DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("initscheme");
                if (scheme == null) {
                    return;
                }
                boolean useDimension = scheme.getBoolean("usedimension");
                if (!useDimension) {
                    return;
                }
                DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
                this.packageEntryData(scheme, taskEntrys);
                this.getView().updateView(TASK_ENTRY);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            String opKey;
            AbstractOperate operate = (AbstractOperate)args.getSource();
            switch (opKey = operate.getOperateKey()) {
                case "batchsetcharge": 
                case "batchsetcheck": {
                    EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
                    int[] selectRows = entryGrid.getSelectRows();
                    if (selectRows.length != 0) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u3002", (String)"TaskDispatchPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "orgdispatch": {
                    int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
                    Object chargeUser = this.getModel().getValue("chargeuser", entryCurrentRowIndex);
                    DynamicObjectCollection dispatchOrg = (DynamicObjectCollection)this.getModel().getValue("dispatchorg", entryCurrentRowIndex);
                    if (chargeUser != null && !dispatchOrg.isEmpty()) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8d23\u4efb\u4eba\u548c\u7ec4\u7ec7\u3002", (String)"TaskDispatchPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "save": {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
                    ArrayList<Integer> rowList = new ArrayList<Integer>();
                    DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("initscheme");
                    if (scheme == null) {
                        return;
                    }
                    boolean useDimension = scheme.getBoolean("usedimension");
                    for (DynamicObject entryRowData : entryEntity) {
                        Integer seq;
                        Object chargeUserRow;
                        MulBasedataDynamicObjectCollection checkUser = (MulBasedataDynamicObjectCollection)entryRowData.get("checkuser");
                        MulBasedataDynamicObjectCollection disPatchOrg = (MulBasedataDynamicObjectCollection)entryRowData.get("dispatchorg");
                        if (useDimension) {
                            if (checkUser.isEmpty() && disPatchOrg.isEmpty() || !Objects.isNull(chargeUserRow = entryRowData.get("chargeuser"))) continue;
                            seq = entryRowData.getInt("seq");
                            rowList.add(seq);
                            continue;
                        }
                        if (checkUser.isEmpty() || !Objects.isNull(chargeUserRow = entryRowData.get("chargeuser"))) continue;
                        seq = entryRowData.getInt("seq");
                        rowList.add(seq);
                    }
                    if (rowList.isEmpty()) break;
                    String tip = useDimension ? ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5206\u914d\u68c0\u67e5\u4eba\u6216\u7ec4\u7ec7\uff0c\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"TaskDispatchPlugin_11", (String)"imsc-imic-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c%s\u884c\u5df2\u5206\u914d\u68c0\u67e5\u4eba\uff0c\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"TaskDispatchPlugin_12", (String)"imsc-imic-platform", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(tip, Arrays.toString((Object[])rowList.toArray(new Integer[0]))));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        int currentRowIndex = this.getView().getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        switch (actionId) {
            case "batchsetcharge": {
                this.batchFillChargeUserOrChecker("chargeuser", closedCallBackEvent);
                break;
            }
            case "batchsetcheck": {
                this.batchFillChargeUserOrChecker("checkuser", closedCallBackEvent);
                break;
            }
            case "orgdispatch": {
                this.orgDisPatchBack(closedCallBackEvent, currentRowIndex);
                break;
            }
        }
    }

    private void orgDisPatchBack(ClosedCallBackEvent closedCallBackEvent, int currentRowIndex) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (selectedRows == null) {
                return;
            }
            List selectOrgIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection dispatchOrgs = (DynamicObjectCollection)this.getModel().getValue("dispatchorg", currentRowIndex);
            List dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.get("fbasedataid_id")).collect(Collectors.toList());
            dispatchOrgIds.addAll(selectOrgIds);
            this.getModel().setValue("dispatchorg", (Object)dispatchOrgIds.toArray(), currentRowIndex);
        } else if (returnData instanceof Map) {
            DynamicObject task = (DynamicObject)this.getModel().getValue("inittask", currentRowIndex);
            if (task == null) {
                return;
            }
            long taskId = task.getLong("id");
            Map returnDataMap = (Map)returnData;
            long returnChargeUserId = (Long)returnDataMap.get("chargeuserid");
            List returnOrgIds = (List)returnDataMap.get("dispatchorg");
            int rowIndex = -1;
            DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
            for (int i = 0; i < taskEntrys.size(); ++i) {
                DynamicObject taskEntry = (DynamicObject)taskEntrys.get(i);
                DynamicObject entryTask = taskEntry.getDynamicObject("inittask");
                DynamicObject chargeUser = taskEntry.getDynamicObject("chargeuser");
                if (entryTask == null || chargeUser == null) continue;
                long entryTaskId = entryTask.getLong("id");
                long entryChargeUserId = chargeUser.getLong("id");
                if (entryTaskId != taskId || entryChargeUserId != returnChargeUserId) continue;
                DynamicObjectCollection dispatchOrgs = taskEntry.getDynamicObjectCollection("dispatchorg");
                List dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.get("fbasedataid_id")).collect(Collectors.toList());
                returnOrgIds.addAll(dispatchOrgIds);
                rowIndex = i;
                break;
            }
            if (rowIndex != -1) {
                this.getModel().setValue("dispatchorg", (Object)returnOrgIds.toArray(), rowIndex);
            } else {
                int insertRow = this.getModel().insertEntryRow(TASK_ENTRY, currentRowIndex + 1);
                Object stepId = this.getModel().getValue("stepid", currentRowIndex);
                Object stepName = this.getModel().getValue("stepname", currentRowIndex);
                this.getModel().setValue("stepid", stepId, insertRow);
                this.getModel().setValue("stepname", stepName, insertRow);
                this.getModel().setValue("inittask", (Object)task, insertRow);
                this.getModel().setValue("chargeuser", (Object)returnChargeUserId, insertRow);
                this.getModel().setValue("dispatchorg", (Object)returnOrgIds.toArray(), insertRow);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, opKey);
            StyleCss styleCss = new StyleCss();
            switch (opKey) {
                case "batchsetcharge": 
                case "batchsetcheck": {
                    boolean multiSelect = StringUtils.equals("batchsetcheck", opKey);
                    styleCss.setHeight("580px");
                    styleCss.setWidth("960px");
                    ListShowParameter listShowParameter = ShowFormHelper.showListForm("bos_user", "bos_usertreelistf7", closeCallBack, ShowType.Modal, true, multiSelect, null, null, styleCss, null);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                case "orgdispatch": {
                    int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
                    String unDispatchOrgStr = (String)this.getModel().getValue("undispatchorg_tag", entryCurrentRowIndex);
                    if (StringUtils.isEmpty(unDispatchOrgStr)) {
                        return;
                    }
                    List orgIds = (List)SerializationUtils.fromJsonString((String)unDispatchOrgStr, List.class);
                    QFilter filter = new QFilter("id", "in", (Object)orgIds);
                    DynamicObject chargeUser = (DynamicObject)this.getModel().getValue("chargeuser", entryCurrentRowIndex);
                    long chargeUserId = chargeUser.getLong("id");
                    HashMap<String, Object> params = new HashMap<String, Object>(1);
                    params.put("chargeuserid", chargeUserId);
                    String caption = ResManager.loadKDString((String)"\u672a\u5206\u914d\u7ec4\u7ec7", (String)"TaskDispatchPlugin_9", (String)"imsc-imic-platform", (Object[])new Object[0]);
                    styleCss.setHeight("650px");
                    styleCss.setWidth("700px");
                    ListShowParameter showParameter = ShowFormHelper.showListForm("imic_undispatchorg_new", "imic_undispatchlistf7", closeCallBack, ShowType.Modal, true, true, params, filter, styleCss, caption);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                case "save": {
                    if (!args.getOperationResult().isSuccess()) break;
                    this.saveDispatchTask();
                    break;
                }
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        List stepLabelKeys;
        super.onGetControl(e);
        String key = e.getKey();
        String stepLabelKeysStr = this.getPageCache().get(STEP_LABEL_KEYS_CACHE);
        if (StringUtils.isNotEmpty(stepLabelKeysStr) && (stepLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLabelKeysStr, List.class)).contains(key)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject scheme = dataEntity.getDynamicObject("initscheme");
        if (scheme == null) {
            return;
        }
        boolean useDimension = scheme.getBoolean("usedimension");
        String stepLabelKeysStr = this.getPageCache().get(STEP_LABEL_KEYS_CACHE);
        ArrayList<String> stepLabelKeys = new ArrayList(16);
        if (StringUtils.isNotEmpty(stepLabelKeysStr)) {
            stepLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLabelKeysStr, List.class);
        }
        if (stepLabelKeys.contains(key)) {
            this.clickStepLabel(scheme, stepLabelKeys, key, useDimension);
        } else if (this.taskLabelKeys.contains(key)) {
            this.clickTaskLabel(key, useDimension);
        }
    }

    private void clickStepLabel(DynamicObject scheme, List<String> stepLabelKeys, String key, boolean useDimension) {
        this.getPageCache().put(CUR_STEP_LABEL, key);
        for (String labelKey : stepLabelKeys) {
            if (!key.equals(labelKey)) {
                TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "#212121");
                continue;
            }
            TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "themeColor");
        }
        String labelLineLabelKey = key + UNDERLINE;
        String stepLineLabelKeysStr = this.getPageCache().get(STEP_LINE_LABEL_KEYS);
        if (StringUtils.isNotEmpty(stepLineLabelKeysStr)) {
            List stepLineLabelKeys = (List)SerializationUtils.fromJsonString((String)stepLineLabelKeysStr, List.class);
            stepLineLabelKeys.remove(labelLineLabelKey);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{labelLineLabelKey});
            this.getView().setVisible(Boolean.valueOf(false), stepLineLabelKeys.toArray(new String[0]));
        }
        String taskLabelKey = useDimension ? "alltasksize" : this.getPageCache().get(CUR_TASK_LABEL);
        ArrayList<DispatchTaskModel> tasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> dispatchTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> unDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        this.reCreateEntryLabelClick(key, taskLabelKey, tasks, dispatchTasks, unDispatchTasks);
        if (useDimension) {
            DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
            this.packageEntryData(scheme, taskEntrys);
            this.getView().updateView(TASK_ENTRY);
        } else {
            this.setTaskSizeLabelVal(tasks.size(), dispatchTasks.size(), unDispatchTasks.size());
        }
    }

    private void clickTaskLabel(String key, boolean useDimension) {
        if (useDimension) {
            return;
        }
        this.getPageCache().put(CUR_TASK_LABEL, key);
        for (String labelKey : this.taskLabelKeys) {
            if (!key.equals(labelKey)) {
                TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "#212121");
                continue;
            }
            TaskDispatchHelper.setLabelForceColor(this.getView(), labelKey, "themeColor");
        }
        String stepLabelKey = this.getPageCache().get(CUR_STEP_LABEL);
        ArrayList<DispatchTaskModel> tasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> dispatchTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> unDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        this.reCreateEntryLabelClick(stepLabelKey, key, tasks, dispatchTasks, unDispatchTasks);
    }

    private void reCreateEntryLabelClick(String stepLabelKey, String taskLabelKey, List<DispatchTaskModel> tasks, List<DispatchTaskModel> dispatchTasks, List<DispatchTaskModel> unDispatchTasks) {
        String groupStepModelStr = this.getPageCache().get(STEP_MODEL_MAP);
        if (StringUtils.isEmpty(groupStepModelStr)) {
            return;
        }
        Map stepModelMap = (Map)SerializationUtils.fromJsonString((String)groupStepModelStr, Map.class);
        if ("all".equals(stepLabelKey)) {
            for (Map.Entry stepModelEntry : stepModelMap.entrySet()) {
                String stepModelStr = SerializationUtils.toJsonString(stepModelEntry.getValue());
                DispatchStepModel stepModel = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepModelStr, DispatchStepModel.class);
                tasks.addAll(stepModel.getTasks());
                dispatchTasks.addAll(stepModel.getDispatchTasks());
                unDispatchTasks.addAll(stepModel.getUnDispatchTasks());
            }
        } else {
            String stepModelStr = SerializationUtils.toJsonString(stepModelMap.get(stepLabelKey));
            DispatchStepModel stepModel = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepModelStr, DispatchStepModel.class);
            tasks.addAll(stepModel.getTasks());
            dispatchTasks.addAll(stepModel.getDispatchTasks());
            unDispatchTasks.addAll(stepModel.getUnDispatchTasks());
        }
        List<Object> taskModels = new ArrayList(16);
        if ("alltasksize".equals(taskLabelKey)) {
            taskModels = tasks;
        } else if ("dispatchtasksize".equals(taskLabelKey)) {
            taskModels = dispatchTasks;
        } else if ("undispatchtasksize".equals(taskLabelKey)) {
            taskModels = unDispatchTasks;
        }
        this.createTaskEntry(taskModels);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("initscheme");
        boolean useDimension = scheme.getBoolean("usedimension");
        DynamicObjectCollection taskEntrys = dataEntity.getDynamicObjectCollection(TASK_ENTRY);
        Long stepIdLong = (Long)this.getModel().getValue("stepid", rowIndex);
        String stepId = String.valueOf(stepIdLong);
        switch (propertyName) {
            case "dispatchorg": {
                if (!useDimension) {
                    return;
                }
                this.packageEntryData(scheme, taskEntrys);
                this.getView().updateView(TASK_ENTRY);
                ArrayList<Integer> deleteRows = new ArrayList<Integer>(16);
                for (int i = 0; i < taskEntrys.size(); ++i) {
                    DynamicObject taskEntry = (DynamicObject)taskEntrys.get(i);
                    boolean isDisAllOrg = taskEntry.getBoolean("isdispatchallorg");
                    DynamicObjectCollection dispatchOrgs = taskEntry.getDynamicObjectCollection("dispatchorg");
                    if (!isDisAllOrg || !dispatchOrgs.isEmpty()) continue;
                    deleteRows.add(i);
                }
                if (!deleteRows.isEmpty()) {
                    this.getModel().deleteEntryRows(TASK_ENTRY, deleteRows.stream().mapToInt(deleteRow -> deleteRow).toArray());
                }
                this.cacheStepModelDimen(Collections.singletonList(stepId));
                break;
            }
            case "chargeuser": 
            case "checkuser": {
                DynamicObject task = (DynamicObject)this.getModel().getValue("inittask", rowIndex);
                if (task == null) {
                    return;
                }
                long taskId = task.getLong("id");
                if (useDimension) {
                    this.cacheStepModelDimen(Collections.singletonList(stepId));
                    break;
                }
                this.cacheStepModelNoDimen(newValue, propertyName, stepId, taskId);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        int row = evt.getRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("initscheme");
        if (scheme == null) {
            return;
        }
        boolean useDimension = scheme.getBoolean("usedimension");
        DynamicObject task = (DynamicObject)this.getModel().getValue("inittask", row);
        if (task == null) {
            return;
        }
        long taskId = task.getLong("id");
        DynamicObjectCollection taskEntrys = dataEntity.getDynamicObjectCollection(TASK_ENTRY);
        switch (key) {
            case "dispatchorg": {
                this.dispatchOrgF7(scheme, taskEntrys, row, taskId, formShowParameter);
                break;
            }
            case "chargeuser": {
                if (!useDimension) {
                    return;
                }
                this.chargeUserF7(taskEntrys, row, taskId, formShowParameter);
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeid");
        LockUtils.releaseLock(String.valueOf(schemeId), "default_netctrl", "imic_initialscheme", "todispatch");
    }

    private void dispatchOrgF7(DynamicObject scheme, DynamicObjectCollection taskEntrys, int row, long taskId, ListShowParameter formShowParameter) {
        ArrayList allDispatchOrgIds = new ArrayList(16);
        for (int i = 0; i < taskEntrys.size(); ++i) {
            long entryTaskId;
            DynamicObject taskEntry;
            DynamicObject entryTask;
            if (row == i || (entryTask = (taskEntry = (DynamicObject)taskEntrys.get(i)).getDynamicObject("inittask")) == null || taskId != (entryTaskId = entryTask.getLong("id"))) continue;
            DynamicObjectCollection dispatchOrgs = taskEntry.getDynamicObjectCollection("dispatchorg");
            List dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
            allDispatchOrgIds.addAll(dispatchOrgIds);
        }
        HashSet<DynamicObject> schemes = new HashSet<DynamicObject>(1);
        schemes.add(scheme);
        Map<Long, List<Long>> taskApplyOrgMap = TaskDispatchHelper.getTaskApplyOrgMap(schemes);
        List<Long> taskApplyOrgList = taskApplyOrgMap.get(taskId);
        taskApplyOrgList.removeAll(allDispatchOrgIds);
        QFilter orgIdFilter = new QFilter("id", "in", taskApplyOrgList);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdFilter);
        formShowParameter.setMustInput(true);
    }

    private void chargeUserF7(DynamicObjectCollection taskEntrys, int row, long taskId, ListShowParameter formShowParameter) {
        ArrayList<Long> chargeUserIds = new ArrayList<Long>(16);
        for (int i = 0; i < taskEntrys.size(); ++i) {
            DynamicObject chargeUser;
            long entryTaskId;
            DynamicObject taskEntry;
            DynamicObject entryTask;
            if (row == i || (entryTask = (taskEntry = (DynamicObject)taskEntrys.get(i)).getDynamicObject("inittask")) == null || taskId != (entryTaskId = entryTask.getLong("id")) || (chargeUser = taskEntry.getDynamicObject("chargeuser")) == null) continue;
            chargeUserIds.add(chargeUser.getLong("id"));
        }
        if (!chargeUserIds.isEmpty()) {
            QFilter chargerUserFilter = new QFilter("id", "not in", chargeUserIds);
            formShowParameter.getListFilterParameter().getQFilters().add(chargerUserFilter);
        }
    }

    private void createStepLabels(List<DispatchStepModel> stepModels) {
        Container stepPanelAp = (Container)this.getControl(STEP_PANEL_AP);
        ArrayList<Map> items = new ArrayList<Map>(16);
        ArrayList<String> stepLabelKeys = new ArrayList<String>(16);
        ArrayList<String> stepLineLabelKeys = new ArrayList<String>(16);
        String allStepName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskDispatchPlugin_10", (String)"imsc-imic-platform", (Object[])new Object[0]);
        stepLabelKeys.add("all");
        FlexPanelAp allFlexPanelAp = this.createFlexPanelAp("all", allStepName, stepLineLabelKeys);
        items.add(allFlexPanelAp.createControl());
        for (DispatchStepModel stepModel : stepModels) {
            String stepId = stepModel.getStepId();
            stepLabelKeys.add(stepId);
            String stepName = stepModel.getStepName();
            FlexPanelAp flexPanelAp = this.createFlexPanelAp(stepId, stepName, stepLineLabelKeys);
            items.add(flexPanelAp.createControl());
        }
        stepPanelAp.addControls(items);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(STEP_LABEL_KEYS_CACHE, SerializationUtils.toJsonString(stepLabelKeys));
        pageCache.put(STEP_LINE_LABEL_KEYS, SerializationUtils.toJsonString(stepLineLabelKeys));
    }

    private FlexPanelAp createFlexPanelAp(String stepId, String stepName, List<String> stepLineLabelKeys) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setHeight(new LocaleString("32px"));
        flexPanelAp.setWidth(new LocaleString("144px"));
        flexPanelAp.setDirection("column");
        flexPanelAp.setKey(stepId + "flex");
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        LabelAp stepLabel = new LabelAp();
        stepLabel.setKey(stepId);
        stepLabel.setName(new LocaleString(stepName));
        stepLabel.setWidth(new LocaleString("144px"));
        stepLabel.setHeight(new LocaleString("30px"));
        stepLabel.setGrow(0);
        stepLabel.setShrink(1);
        stepLabel.setFontSize(14);
        stepLabel.setClickable(true);
        stepLabel.setLabelStyle("1");
        stepLabel.setTextAlign("center");
        if ("all".equals(stepId)) {
            stepLabel.setForeColor("themeColor");
        }
        Padding padding = new Padding();
        padding.setTop("5px");
        Style style = new Style();
        style.setPadding(padding);
        stepLabel.setStyle(style);
        flexPanelAp.getItems().add(stepLabel);
        LabelAp underLineLabel = new LabelAp();
        String lineLabelKey = stepId + UNDERLINE;
        stepLineLabelKeys.add(lineLabelKey);
        underLineLabel.setKey(lineLabelKey);
        underLineLabel.setHeight(new LocaleString("2px"));
        underLineLabel.setWidth(new LocaleString("144px"));
        underLineLabel.setBackColor("#5582F3");
        flexPanelAp.getItems().add(underLineLabel);
        return flexPanelAp;
    }

    private void setTaskSizeLabelVal(int allTaskSize, int dispatchTaskSize, int unDispatchTaskSize) {
        String allTaskLabel = ResManager.loadKDString((String)"\u5168\u90e8\u4efb\u52a1\uff08%s\uff09", (String)"TaskDispatchPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[]{allTaskSize});
        String dispatchTaskLabel = ResManager.loadKDString((String)"\u5df2\u4e0b\u8fbe\u4efb\u52a1\uff08%s\uff09", (String)"TaskDispatchPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[]{dispatchTaskSize});
        String unDispatchTaskLabel = ResManager.loadKDString((String)"\u672a\u4e0b\u8fbe\u4efb\u52a1\uff08%s\uff09", (String)"TaskDispatchPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[]{unDispatchTaskSize});
        TaskDispatchHelper.setLabelVal(this.getView(), "alltasksize", allTaskLabel);
        TaskDispatchHelper.setLabelVal(this.getView(), "dispatchtasksize", dispatchTaskLabel);
        TaskDispatchHelper.setLabelVal(this.getView(), "undispatchtasksize", unDispatchTaskLabel);
    }

    private void createTaskEntry(List<DispatchTaskModel> tasks) {
        this.getModel().deleteEntryData(TASK_ENTRY);
        int taskEntrySize = tasks.size();
        if (taskEntrySize == 0) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(TASK_ENTRY, taskEntrySize);
        for (int i = 0; i < tasks.size(); ++i) {
            DispatchTaskModel taskModel = tasks.get(i);
            String stepId = taskModel.getStepId();
            String stepName = taskModel.getStepName();
            Long taskId = taskModel.getTaskId();
            Long chargeUserId = taskModel.getChargeUserId();
            List<Long> checkerUserIds = taskModel.getCheckerUserIds();
            List<Long> orgIds = taskModel.getDispatchOrgIds();
            this.getModel().setValue("stepid", (Object)stepId, i);
            this.getModel().setValue("stepname", (Object)stepName, i);
            this.getModel().setValue("inittask", (Object)taskId, i);
            this.getModel().setValue("chargeuser", (Object)chargeUserId, i);
            this.getModel().setValue("checkuser", (Object)checkerUserIds.toArray(), i);
            this.getModel().setValue("dispatchorg", (Object)orgIds.toArray(), i);
        }
        this.getModel().endInit();
        this.getView().updateView(TASK_ENTRY);
    }

    private void batchFillChargeUserOrChecker(String filPropName, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection data = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        List<Long> userIdList = data.stream().map(e -> Long.valueOf(String.valueOf(e.getPrimaryKeyValue()))).collect(Collectors.toList());
        EntryGrid eg = (EntryGrid)this.getControl(TASK_ENTRY);
        int[] rows = eg.getSelectRows();
        Long[] userIdArr = userIdList.toArray(new Long[0]);
        Long userId = (Long)userIdList.get(0);
        for (int rowIndex : rows) {
            if (StringUtils.equals("chargeuser", filPropName)) {
                this.getModel().setValue(filPropName, (Object)userId, rowIndex);
                continue;
            }
            if (!StringUtils.equals("checkuser", filPropName)) continue;
            this.getModel().setValue(filPropName, (Object)userIdArr, rowIndex);
        }
    }

    private void cacheStepModelDimen(List<String> stepIds) {
        String groupStepModelStr = this.getPageCache().get(STEP_MODEL_MAP);
        if (StringUtils.isNotEmpty(groupStepModelStr)) {
            Map stepModelMap = (Map)SerializationUtils.fromJsonString((String)groupStepModelStr, Map.class);
            DynamicObjectCollection taskEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(TASK_ENTRY);
            Map groupTaskMap = taskEntrys.stream().collect(Collectors.groupingBy(taskEntry -> taskEntry.getString("stepid"), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
            for (String stepId : stepIds) {
                if (!groupTaskMap.containsKey(stepId) || groupTaskMap.get(stepId) == null) continue;
                List groupTaskEntrys = (List)groupTaskMap.get(stepId);
                ArrayList<DispatchTaskModel> tasks = new ArrayList<DispatchTaskModel>(16);
                for (DynamicObject taskEntry2 : groupTaskEntrys) {
                    String stepName = taskEntry2.getString("stepname");
                    DynamicObject task = taskEntry2.getDynamicObject("inittask");
                    long taskId = task.getLong("id");
                    DynamicObject chargeUser = taskEntry2.getDynamicObject("chargeuser");
                    long chargeUserId = 0L;
                    if (chargeUser != null) {
                        chargeUserId = chargeUser.getLong("id");
                    }
                    DynamicObjectCollection checkers = taskEntry2.getDynamicObjectCollection("checkuser");
                    List<Long> checkerIds = checkers.stream().map(checker -> checker.getLong("fbasedataid_id")).collect(Collectors.toList());
                    DynamicObjectCollection dispatchOrgs = taskEntry2.getDynamicObjectCollection("dispatchorg");
                    List<Long> dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
                    List unDispatchOrgIds = new ArrayList(16);
                    String unDispatchOrgStr = taskEntry2.getString("undispatchorg_tag");
                    if (StringUtils.isNotEmpty(unDispatchOrgStr)) {
                        unDispatchOrgIds = (List)SerializationUtils.fromJsonString((String)unDispatchOrgStr, List.class);
                    }
                    List<Long> unDispatchOrgLongIds = unDispatchOrgIds.stream().map(orgId -> Long.valueOf(String.valueOf(orgId))).collect(Collectors.toList());
                    DispatchTaskModel taskModel = this.createTaskModel(stepId, stepName, taskId, chargeUserId, checkerIds, dispatchOrgIds, unDispatchOrgLongIds);
                    tasks.add(taskModel);
                }
                String stepModelStr = SerializationUtils.toJsonString(stepModelMap.get(stepId));
                DispatchStepModel stepModel = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepModelStr, DispatchStepModel.class);
                stepModel.setTasks(tasks);
                stepModelMap.put(stepId, stepModel);
            }
            this.getPageCache().put(STEP_MODEL_MAP, SerializationUtils.toJsonString((Object)stepModelMap));
        }
    }

    private void cacheStepModelNoDimen(Object newValue, String propertyName, String stepId, long taskId) {
        String stepLabelKey = this.getPageCache().get(CUR_STEP_LABEL);
        String groupStepModelStr = this.getPageCache().get(STEP_MODEL_MAP);
        if (StringUtils.isEmpty(groupStepModelStr)) {
            return;
        }
        Map stepModelMap = (Map)SerializationUtils.fromJsonString((String)groupStepModelStr, Map.class);
        String stepModelStr = SerializationUtils.toJsonString(stepModelMap.get(stepId));
        DispatchStepModel stepModel = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepModelStr, DispatchStepModel.class);
        List<DispatchTaskModel> tasks = stepModel.getTasks();
        ArrayList<DispatchTaskModel> dispatchTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> unDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        Long chargeUserId = 0L;
        ArrayList<Long> checkerUserIds = new ArrayList(16);
        if (newValue != null) {
            if ("chargeuser".equals(propertyName)) {
                DynamicObject chargeUser = (DynamicObject)newValue;
                chargeUserId = chargeUser.getLong("id");
            } else {
                DynamicObjectCollection checkUsers = (DynamicObjectCollection)newValue;
                checkerUserIds = checkUsers.stream().map(checker -> checker.getLong("fbasedataid_id")).collect(Collectors.toList());
            }
        }
        for (DispatchTaskModel taskModel : tasks) {
            if (taskId == taskModel.getTaskId()) {
                if ("chargeuser".equals(propertyName)) {
                    taskModel.setChargeUserId(chargeUserId);
                } else {
                    taskModel.setCheckerUserIds(checkerUserIds);
                }
            }
            if (taskModel.getChargeUserId() != 0L) {
                dispatchTasks.add(taskModel);
                continue;
            }
            unDispatchTasks.add(taskModel);
        }
        stepModel.setDispatchTasks(dispatchTasks);
        stepModel.setUnDispatchTasks(unDispatchTasks);
        stepModelMap.put(stepId, stepModel);
        ArrayList<DispatchTaskModel> allTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> allDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        ArrayList<DispatchTaskModel> allUnDispatchTasks = new ArrayList<DispatchTaskModel>(16);
        if ("chargeuser".equals(propertyName)) {
            if ("all".equals(stepLabelKey)) {
                for (Map.Entry stepModelEntry : stepModelMap.entrySet()) {
                    String stepDataStr = SerializationUtils.toJsonString(stepModelEntry.getValue());
                    DispatchStepModel stepData = (DispatchStepModel)SerializationUtils.fromJsonString((String)stepDataStr, DispatchStepModel.class);
                    allTasks.addAll(stepData.getTasks());
                    allDispatchTasks.addAll(stepData.getDispatchTasks());
                    allUnDispatchTasks.addAll(stepData.getUnDispatchTasks());
                }
                this.setTaskSizeLabelVal(allTasks.size(), allDispatchTasks.size(), allUnDispatchTasks.size());
            } else {
                this.setTaskSizeLabelVal(tasks.size(), dispatchTasks.size(), unDispatchTasks.size());
            }
        }
        this.getPageCache().put(STEP_MODEL_MAP, SerializationUtils.toJsonString((Object)stepModelMap));
    }

    private void packageEntryData(DynamicObject scheme, DynamicObjectCollection taskEntrys) {
        HashSet<DynamicObject> schemes = new HashSet<DynamicObject>(1);
        schemes.add(scheme);
        Map<Long, List<Long>> taskApplyOrgMap = TaskDispatchHelper.getTaskApplyOrgMap(schemes);
        HashMap taskOrgMap = new HashMap(16);
        List taskIdList = taskEntrys.stream().filter(m -> m.getDynamicObject("inittask") != null).map(m -> m.getDynamicObject("inittask").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection progressUnit = QueryServiceHelper.query((String)"imic_progressunit", (String)"id,initialschemeentryid as taskid,initialschemeentryid.itemname as itemname,dimension as orgid", (QFilter[])new QFilter[]{new QFilter(ImicProgressunitConstant.schemeEntryDetailId, "in", taskIdList)});
        Map taskIdMap = progressUnit.stream().collect(Collectors.toMap(m -> m.getLong("taskid"), Function.identity(), (existing, replacement) -> existing, HashMap::new));
        int rowIndex = 0;
        for (Object taskEntry : taskEntrys) {
            DynamicObject dynamicObject = taskEntry.getDynamicObject("inittask");
            if (dynamicObject != null) {
                long taskId = dynamicObject.getLong("id");
                DynamicObjectCollection dispatchOrgs = taskEntry.getDynamicObjectCollection("dispatchorg");
                List dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
                taskOrgMap.putIfAbsent(taskId, new ArrayList(16));
                ((List)taskOrgMap.get(taskId)).addAll(dispatchOrgIds);
                if (taskIdMap.containsKey(taskId)) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"chargeuser", "checkuser", "dispatchorg"});
                }
            }
            ++rowIndex;
        }
        final HashMap<Long, List<Long>> newTaskOrgMap = new HashMap<Long, List<Long>>(16);
        for (Map.Entry entry : taskOrgMap.entrySet()) {
            Long taskId = (Long)entry.getKey();
            List dispatchOrgList = (List)entry.getValue();
            List<Long> applyOrgList = taskApplyOrgMap.get(taskId);
            if (dispatchOrgList.isEmpty()) {
                newTaskOrgMap.put(taskId, applyOrgList);
                continue;
            }
            applyOrgList.removeAll(dispatchOrgList);
            newTaskOrgMap.put(taskId, applyOrgList);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
        entryGrid.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent e) {
                DynamicObject rowData = e.getRowData();
                DynamicObject task = rowData.getDynamicObject("inittask");
                if (task == null) {
                    return;
                }
                long taskId = task.getLong("id");
                List unDispatchOrgs = (List)newTaskOrgMap.get(taskId);
                if (e.getSource() instanceof OperationColumn && "orgdistribution".equals(((OperationColumn)e.getSource()).getKey())) {
                    List operationColItems = (List)e.getFormatValue();
                    OperationColItem operationColItem = (OperationColItem)operationColItems.get(0);
                    if (unDispatchOrgs.isEmpty()) {
                        operationColItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5168\u90e8\u5206\u914d", (String)"TaskDispatchPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[0])));
                        operationColItem.setLocked(true);
                    } else {
                        String operationName = ResManager.loadKDString((String)"\u672a\u5206\u914d\u7ec4\u7ec7\uff08%s\uff09", (String)"TaskDispatchPlugin_6", (String)"imsc-imic-platform", (Object[])new Object[]{unDispatchOrgs.size()});
                        operationColItem.setOperationName(new LocaleString(operationName));
                        operationColItem.setLocked(false);
                    }
                } else if (e.getSource() instanceof LargeTextEdit && "undispatchorg".equals(((LargeTextEdit)e.getSource()).getKey())) {
                    rowData.set("undispatchorg_tag", (Object)SerializationUtils.toJsonString((Object)unDispatchOrgs));
                } else if (e.getSource() instanceof FieldEdit && "isdispatchallorg".equals(((FieldEdit)e.getSource()).getKey())) {
                    rowData.set("isdispatchallorg", (Object)unDispatchOrgs.isEmpty());
                }
            }
        });
    }

    private List<DispatchStepModel> getStepModel(DynamicObjectCollection groups, Map<Long, List<DynamicObject>> taskRecordMap, boolean useDimension) {
        ArrayList<DispatchStepModel> stepModels = new ArrayList<DispatchStepModel>(16);
        for (DynamicObject group : groups) {
            String stepId = group.getString("id");
            String stepName = group.getString("stepname");
            DynamicObjectCollection entryItems = group.getDynamicObjectCollection("imic_initentry_items");
            List enableItems = entryItems.stream().filter(item -> item.getBoolean("itemenabled")).collect(Collectors.toList());
            if (enableItems.isEmpty()) continue;
            DispatchStepModel stepModel = new DispatchStepModel();
            stepModel.setStepName(stepName);
            stepModel.setStepId(stepId);
            ArrayList<DispatchTaskModel> tasks = new ArrayList<DispatchTaskModel>(16);
            ArrayList<DispatchTaskModel> unDisPatchTasks = new ArrayList<DispatchTaskModel>(16);
            ArrayList<DispatchTaskModel> dispatchTasks = new ArrayList<DispatchTaskModel>(16);
            for (DynamicObject entryItem : entryItems) {
                boolean enable = entryItem.getBoolean("itemenabled");
                if (!enable) continue;
                long taskId = entryItem.getLong("id");
                List<DynamicObject> recordList = taskRecordMap.get(taskId);
                long chargeUserId = 0L;
                List<Long> checkerIds = new ArrayList<Long>(16);
                List<Long> dispatchOrgIds = new ArrayList<Long>(16);
                ArrayList<Long> unDispatchOrgIds = new ArrayList<Long>(16);
                if (recordList != null && !recordList.isEmpty()) {
                    for (DynamicObject record : recordList) {
                        DynamicObject chargeUser = record.getDynamicObject("chargeuser");
                        String dispatchStatus = record.getString("dispatchstatus");
                        if (chargeUser != null) {
                            chargeUserId = chargeUser.getLong("id");
                        }
                        DynamicObjectCollection checkers = record.getDynamicObjectCollection("checkuser");
                        checkerIds = checkers.stream().map(checker -> checker.getLong("fbasedataid_id")).collect(Collectors.toList());
                        if (useDimension) {
                            DynamicObjectCollection dispatchOrgs = record.getDynamicObjectCollection("dispatchorg");
                            dispatchOrgIds = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
                        }
                        DispatchTaskModel taskModel = this.createTaskModel(stepId, stepName, taskId, chargeUserId, checkerIds, dispatchOrgIds, unDispatchOrgIds);
                        tasks.add(taskModel);
                        if (useDimension) continue;
                        if ("1".equals(dispatchStatus)) {
                            dispatchTasks.add(taskModel);
                            continue;
                        }
                        if (!StringUtils.isEmpty(dispatchStatus) && !"0".equals(dispatchStatus)) continue;
                        unDisPatchTasks.add(taskModel);
                    }
                    continue;
                }
                DispatchTaskModel taskModel = this.createTaskModel(stepId, stepName, taskId, chargeUserId, checkerIds, dispatchOrgIds, unDispatchOrgIds);
                tasks.add(taskModel);
                if (useDimension) continue;
                unDisPatchTasks.add(taskModel);
            }
            stepModel.setTasks(tasks);
            stepModel.setDispatchTasks(dispatchTasks);
            stepModel.setUnDispatchTasks(unDisPatchTasks);
            stepModels.add(stepModel);
        }
        return stepModels;
    }

    private DispatchTaskModel createTaskModel(String stepId, String stepName, long taskId, long chargeUserId, List<Long> checkerIds, List<Long> dispatchOrgIds, List<Long> unDispatchOrgIds) {
        DispatchTaskModel taskModel = new DispatchTaskModel();
        taskModel.setStepId(stepId);
        taskModel.setStepName(stepName);
        taskModel.setTaskId(taskId);
        taskModel.setChargeUserId(chargeUserId);
        taskModel.setCheckerUserIds(checkerIds);
        taskModel.setDispatchOrgIds(dispatchOrgIds);
        taskModel.setUnDispatchOrgIds(unDispatchOrgIds);
        return taskModel;
    }

    private void saveDispatchTask() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject bizApp = dataEntity.getDynamicObject("bizapp");
        DynamicObject scheme = dataEntity.getDynamicObject("initscheme");
        if (scheme == null) {
            return;
        }
        long schemeId = scheme.getLong("id");
        boolean useDimension = scheme.getBoolean("usedimension");
        String selectProperties = String.join((CharSequence)",", "id", "number");
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)selectProperties, null);
        Map<Long, DynamicObject> userMap = users.stream().collect(Collectors.toMap(user -> user.getLong("id"), user -> user));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_user", (String)selectProperties, null);
        Map<Long, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(org -> org.getLong("id"), org -> org));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"imic_taskdispatchrecord");
        DynamicCollectionProperty checkerUserProperty = (DynamicCollectionProperty)dataEntityType.getProperty("checkuser");
        DynamicCollectionProperty dispatchOrgProperty = (DynamicCollectionProperty)dataEntityType.getProperty("dispatchorg");
        String groupStepModelStr = this.getPageCache().get(STEP_MODEL_MAP);
        if (StringUtils.isEmpty(groupStepModelStr)) {
            return;
        }
        try {
            TaskDispatchBusiness.saveDispatchTask(groupStepModelStr, checkerUserProperty, userMap, dispatchOrgProperty, orgMap, useDimension, bizApp, scheme, schemeId, dataEntityType);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"TaskDispatchPlugin_7", (String)"imsc-imic-platform", (Object[])new Object[]{e.getMessage()}));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskDispatchPlugin_8", (String)"imsc-imic-platform", (Object[])new Object[0]));
    }
}

