/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.workbench;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.business.ShowFormHelper;
import kd.imsc.imic.business.workbench.ImicWorkBenchCache;
import kd.imsc.imic.business.workbench.ImicWorkBenchHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.DynamicObjectUtils;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.pagemodel.ImicInitialscheme;

public class ImicWorkBenchDetailPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntryGrid = (CardEntry)this.getView().getControl("homecardentry");
        cardEntryGrid.addRowClickListener((RowClickEventListener)this);
        Label allLabel = (Label)this.getControl("all_label");
        allLabel.addClickListener((ClickListener)this);
        Label unfinishLabel = (Label)this.getControl("unfinish_label");
        unfinishLabel.addClickListener((ClickListener)this);
        Label finishLabel = (Label)this.getControl("finish_label");
        finishLabel.addClickListener((ClickListener)this);
        Label initGuideLabel = (Label)this.getControl("initguide_label");
        initGuideLabel.addClickListener((ClickListener)this);
        Vector closeVector = (Vector)this.getControl("close_vectorap");
        closeVector.addClickListener((ClickListener)this);
        Vector openVector = (Vector)this.getControl("open_vectorap");
        openVector.addClickListener((ClickListener)this);
        BasedataEdit orgBaseData = (BasedataEdit)this.getControl("orgid");
        orgBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = CommonUtil.getLongCustomParamValue(this.getView(), "orgId");
        this.getModel().setValue("orgid", (Object)orgId);
        if (orgId == 0L) {
            return;
        }
        List<String> schemeNumList = ImicWorkBenchHelper.getSchemeNumList(orgId, RequestContext.get().getCurrUserId(), this.getView());
        if (schemeNumList.isEmpty()) {
            return;
        }
        this.createHomeCardEntryByOrg(schemeNumList, orgId);
    }

    public void afterBindData(EventObject e) {
        String completebtn;
        super.afterBindData(e);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("homecardentry");
        if (!CommonUtil.isNull(entryColl)) {
            int rowIndex = 0;
            long schemeId = CommonUtil.getLongCustomParamValue(this.getView(), "schemeId");
            List schemeList = entryColl.stream().filter(o -> o.getLong("schemeid") == schemeId).collect(Collectors.toList());
            if (!CommonUtil.isNull(schemeList)) {
                rowIndex = ((DynamicObject)schemeList.get(0)).getInt("seq") - 1;
            }
            CardEntry cardEntryGrid = (CardEntry)this.getView().getControl("homecardentry");
            cardEntryGrid.selectRows(rowIndex, true);
        }
        if (StringUtils.isEmpty(completebtn = ImicWorkBenchCache.queryRecord("completebtn", RequestContext.get().getCurrUserId()))) {
            completebtn = "all_label";
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("bc", "#5582F3");
        map.put("fc", "#FFFFFF");
        this.getView().updateControlMetadata(completebtn, map);
        this.getView().getPageCache().put("param_clicklabel", completebtn);
        String isHideNavigation = ImicWorkBenchCache.queryRecord("ishidenavigation", RequestContext.get().getCurrUserId());
        if ("close_vectorap".equals(isHideNavigation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"open_flexpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"open_vectorap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"open_flexpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"open_vectorap"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        if ("homecardentry".equals(cardEntry.getKey())) {
            DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("homecardentry");
            int rowIndex = 0;
            for (DynamicObject entryDynObj : entryColl) {
                if (entryDynObj.getBoolean("select")) {
                    this.getView().getModel().setValue("select", (Object)Boolean.FALSE, rowIndex);
                }
                ++rowIndex;
            }
            this.getView().getModel().setValue("select", (Object)Boolean.TRUE, evt.getRow());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("homecardentry");
        switch (key) {
            case "all_label": 
            case "finish_label": 
            case "unfinish_label": {
                String clikcLabel = this.getView().getPageCache().get("param_clicklabel");
                if (StringUtils.isNotEmpty(clikcLabel) || !key.equals(clikcLabel)) {
                    if (StringUtils.isEmpty(clikcLabel) && !key.equals(clikcLabel)) {
                        clikcLabel = "all_label";
                    }
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put("bc", "");
                    map.put("fc", "#212121");
                    this.getView().updateControlMetadata(clikcLabel, map);
                    this.getView().getPageCache().put("param_clicklabel", "");
                }
                String labelKey = "all_label";
                if (!key.equals(clikcLabel)) {
                    labelKey = key;
                    this.getView().getPageCache().put("param_clicklabel", key);
                }
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("bc", "#5582F3");
                map.put("fc", "#FFFFFF");
                this.getView().updateControlMetadata(labelKey, map);
                ImicWorkBenchCache.updateRecord("completebtn", labelKey, RequestContext.get().getCurrUserId());
                if (CommonUtil.isNull(entryColl)) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("homecardentry");
                long schemeId = (Long)this.getModel().getValue("schemeid", rowIndex);
                DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue("orgid");
                this.loadSchemeTaskItemPage(schemeId, DynamicObjectUtils.getPkValue(orgDynObj), labelKey, rowIndex);
                break;
            }
            case "close_vectorap": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"open_flexpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"open_vectorap"});
                ImicWorkBenchCache.updateRecord("ishidenavigation", "close_vectorap", RequestContext.get().getCurrUserId());
                break;
            }
            case "open_vectorap": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"open_flexpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"open_vectorap"});
                ImicWorkBenchCache.updateRecord("ishidenavigation", "open_vectorap", RequestContext.get().getCurrUserId());
                break;
            }
            case "initguide_label": {
                this.jumpToInitGuide();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        if ("childrefresh".equals(opKey)) {
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("homecardentry");
            List entryList = entryColl.stream().filter(o -> o.getBoolean("select")).collect(Collectors.toList());
            int rowIndex = 0;
            if (!CommonUtil.isNull(entryList)) {
                rowIndex = ((DynamicObject)entryList.get(0)).getInt("seq") - 1;
            }
            this.updateHomeCardEntryByOrg(rowIndex, op);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "orgid": {
                DynamicObject newOrg = (DynamicObject)newValue;
                String mark = this.getPageCache().get("mark");
                if (String.valueOf(true).equals(mark)) {
                    this.getPageCache().put("mark", String.valueOf(false));
                    return;
                }
                if (newValue == null) {
                    this.getPageCache().put("mark", String.valueOf(true));
                    this.getModel().setValue("orgid", oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImicWorkBenchDetailPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
                    return;
                }
                long orgId = ((DynamicObject)newValue).getLong("id");
                ImicWorkBenchCache.updateRecord("org", orgId, RequestContext.get().getCurrUserId());
                List<String> schemeNumList = ImicWorkBenchHelper.getSchemeNumList(orgId, RequestContext.get().getCurrUserId(), null);
                if (schemeNumList.isEmpty()) {
                    return;
                }
                this.createHomeCardEntryByOrg(schemeNumList, DynamicObjectUtils.getPkValue(newOrg));
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("homecardentry");
                if (CommonUtil.isNull(entryColl)) break;
                int defaultRowIndex = 0;
                String schemeIdStr = this.getView().getPageCache().get("schemeid");
                if (StringUtils.isNotEmpty(schemeIdStr)) {
                    long schemeId = Long.parseLong(schemeIdStr);
                    List schemeList = entryColl.stream().filter(o -> o.getLong("schemeid") == schemeId).collect(Collectors.toList());
                    if (!CommonUtil.isNull(schemeList)) {
                        defaultRowIndex = ((DynamicObject)schemeList.get(0)).getInt("seq") - 1;
                    }
                }
                CardEntry cardEntryGrid = (CardEntry)this.getView().getControl("homecardentry");
                cardEntryGrid.selectRows(defaultRowIndex, true);
                break;
            }
            case "select": {
                boolean select = (Boolean)newValue;
                if (!select) break;
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                long schemeId = (Long)this.getModel().getValue("schemeid", rowIndex);
                DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue("orgid");
                String clikcLabel = this.getView().getPageCache().get("param_clicklabel");
                if (StringUtils.isEmpty(clikcLabel)) {
                    clikcLabel = "all_label";
                }
                this.loadSchemeTaskItemPage(schemeId, DynamicObjectUtils.getPkValue(orgDynObj), clikcLabel, rowIndex);
                this.getView().getPageCache().put("schemeid", String.valueOf(schemeId));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (StringUtils.equals(key, "orgid")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setBillFormId("imic_workbenchorg");
        }
    }

    private List<DynamicObject> getSchemeDynObjColl(List<String> schemeNumList, long orgId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        enableFilter.and(new QFilter(ImicInitialscheme.EF_initentry_itemenabled, "=", (Object)Boolean.TRUE));
        enableFilter.and(new QFilter("number", "in", schemeNumList));
        QFilter qFilter = new QFilter("usedimension", "=", (Object)Boolean.FALSE);
        qFilter.and(enableFilter);
        QFilter allUseFilter = new QFilter("isalluse", "=", (Object)Boolean.TRUE);
        allUseFilter.and(new QFilter("usedimension", "=", (Object)Boolean.TRUE));
        allUseFilter.and(enableFilter);
        QFilter orgFilter = new QFilter("isalluse", "=", (Object)Boolean.FALSE);
        orgFilter.and(new QFilter("usedimension", "=", (Object)Boolean.TRUE));
        orgFilter.and(enableFilter);
        orgFilter.and(QFilter.join((String)"id", (String)String.join((CharSequence)".", "imic_assignrecord", "initialscheme"), (QFilter)new QFilter(String.join((CharSequence)".", "imic_assignrecord", "org"), "=", (Object)orgId)));
        qFilter.or(allUseFilter);
        String selectFields = String.join((CharSequence)",", "id", "number", "name", "usedimension", "bizapp", ImicInitialscheme.F_bizapp_name, ImicInitialscheme.F_bizcloud_name, "defaultcaliber", ImicInitialscheme.EF_initentry_items_id, ImicInitialscheme.EF_initentry_itemname, ImicInitialscheme.EF_initentry_initconfigmustset);
        DynamicObjectCollection schemeColl = QueryServiceHelper.query((String)"imic_initialscheme", (String)selectFields, (QFilter[])qFilter.toArray());
        DynamicObjectCollection orgSchemeColl = QueryServiceHelper.query((String)"imic_initialscheme", (String)selectFields, (QFilter[])orgFilter.toArray());
        ArrayList schemeList = new ArrayList(16);
        if (!CommonUtil.isNull(schemeColl)) {
            schemeList.addAll(schemeColl);
        }
        if (!CommonUtil.isNull(orgSchemeColl)) {
            schemeList.addAll(orgSchemeColl);
        }
        return schemeList.stream().sorted((o1, o2) -> {
            String schemeNum1 = o1.getString("number");
            String schemeNum2 = o2.getString("number");
            int i1 = schemeNumList.indexOf(schemeNum1);
            int i2 = schemeNumList.indexOf(schemeNum2);
            return i1 - i2;
        }).collect(Collectors.toList());
    }

    private void jumpToInitGuide() {
        String initGuide = this.getView().getPageCache().get("initguide");
        initGuide = StringUtils.isNotBlank(initGuide) ? initGuide : "imic_initguide";
        String appNum = this.getView().getPageCache().get("bizapp");
        String appName = this.getView().getPageCache().get("appnamelabel");
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5411\u5bfc_%s", (String)"ImicWorkBenchDetailPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[]{appName}));
        formShowParameter.setCustomParam("initAppId", (Object)appNum);
        if ("pbd".equals(appNum)) {
            formShowParameter.setFormId("srm_init");
            formShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
            formShowParameter.setCustomParam("isFrom", (Object)"imic");
        } else {
            formShowParameter.setFormId(initGuide);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("defaultOrgId", org.getPkValue());
        }
        this.getView().showForm(formShowParameter);
    }

    private Map<Long, List<DynamicObject>> getSchemeProgressUnit(List<DynamicObject> schemeList, long orgId) {
        Set bizAppIdSet = schemeList.stream().map(o -> o.getString("bizapp")).collect(Collectors.toSet());
        Set initSchemeIdSet = schemeList.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter schemeFilter = new QFilter("initialscheme", "in", initSchemeIdSet);
        QFilter filter = new QFilter("dimension", "in", bizAppIdSet);
        filter.and(schemeFilter);
        QFilter assignOrgFilter = new QFilter("org", "=", (Object)orgId);
        assignOrgFilter.and(schemeFilter);
        filter.or(assignOrgFilter);
        String fields = String.join((CharSequence)",", "initialschemeentryid", "initialscheme");
        DynamicObjectCollection progressColl = QueryServiceHelper.query((String)"imic_progressunit", (String)fields, (QFilter[])filter.toArray());
        return progressColl.stream().collect(Collectors.groupingBy(o -> o.getLong("initialscheme")));
    }

    private void createHomeCardEntryByOrg(List<String> schemeNumList, long orgId) {
        this.getModel().deleteEntryData("homecardentry");
        Container progressCardEntryFlex = (Container)this.getControl("progresscardentryflex");
        String entryPanelKeyStr = this.getPageCache().get("progresscardentryflex");
        if (StringUtils.isNotEmpty(entryPanelKeyStr)) {
            List cacheEntryFlexPanelKeys = (List)SerializationUtils.fromJsonString((String)entryPanelKeyStr, List.class);
            progressCardEntryFlex.deleteControls(cacheEntryFlexPanelKeys.toArray(new String[cacheEntryFlexPanelKeys.size()]));
        }
        if (CommonUtil.isNull(schemeNumList)) {
            return;
        }
        List<DynamicObject> schemeList = this.getSchemeDynObjColl(schemeNumList, orgId);
        if (!CommonUtil.isNull(schemeList)) {
            Map<Long, List<DynamicObject>> progressMap = this.getSchemeProgressUnit(schemeList, orgId);
            ArrayList<String> entryFlexPanelKeys = new ArrayList<String>(16);
            ArrayList<Map> entryItems = new ArrayList<Map>(16);
            Style entryPanelStyle = new Style();
            Margin entryPanelMargin = new Margin();
            entryPanelMargin.setTop("10px");
            entryPanelStyle.setMargin(entryPanelMargin);
            Style stepPanelStyle = new Style();
            Margin stepPanelMargin = new Margin();
            stepPanelMargin.setBottom("2px");
            stepPanelStyle.setMargin(stepPanelMargin);
            Map bizAppEntryMap = schemeList.stream().collect(Collectors.groupingBy(o -> o.getString("bizapp"), LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry bziAppMapEntry : bizAppEntryMap.entrySet()) {
                Map<Long, List<DynamicObject>> initSchemeIdMap = ((List)bziAppMapEntry.getValue()).stream().collect(Collectors.groupingBy(o -> o.getLong("id")));
                for (Map.Entry<Long, List<DynamicObject>> mapEntry : initSchemeIdMap.entrySet()) {
                    BigDecimal completeProgress;
                    BigDecimal complete;
                    BigDecimal total;
                    List<DynamicObject> schemeEntryList = mapEntry.getValue();
                    int subEntryRow = this.getModel().createNewEntryRow("homecardentry");
                    DynamicObject initEntryDynObj = schemeEntryList.get(0);
                    String appName = "181/2AWNX/C6".equals(initEntryDynObj.getString("bizapp")) ? initEntryDynObj.getString(ImicInitialscheme.F_bizcloud_name) : initEntryDynObj.getString(ImicInitialscheme.F_bizapp_name);
                    this.getModel().setValue("appname", (Object)appName, subEntryRow);
                    long schemeId = mapEntry.getKey();
                    this.getModel().setValue("schemeid", (Object)schemeId, subEntryRow);
                    List<DynamicObject> progressList = progressMap.get(schemeId);
                    HashSet<Long> completeMustIdSet = new HashSet<Long>(16);
                    HashSet<Long> completeIdSet = new HashSet<Long>(16);
                    if (!CommonUtil.isNull(progressList)) {
                        Set finishInitEntryIdSet = progressList.stream().map(o -> o.getLong("initialschemeentryid")).collect(Collectors.toSet());
                        for (DynamicObject schemeEntryDynObj : schemeEntryList) {
                            long itemEntryId = schemeEntryDynObj.getLong(ImicInitialscheme.EF_initentry_items_id);
                            if (!finishInitEntryIdSet.contains(itemEntryId)) continue;
                            if (schemeEntryDynObj.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)) {
                                completeMustIdSet.add(itemEntryId);
                            }
                            completeIdSet.add(itemEntryId);
                        }
                    }
                    if ("B".equals(initEntryDynObj.getString("defaultcaliber"))) {
                        long mustSize = schemeEntryList.stream().filter(o -> o.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)).map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).distinct().count();
                        total = new BigDecimal(mustSize);
                        complete = new BigDecimal(completeMustIdSet.size());
                        completeProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(100L) : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                    } else {
                        Set entryItemIdSet = schemeEntryList.stream().map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
                        int allSize = entryItemIdSet.size();
                        total = new BigDecimal(allSize);
                        complete = new BigDecimal(completeIdSet.size());
                        completeProgress = complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                    }
                    String finishprogress = completeProgress.intValue() + "%";
                    String finishtext = "";
                    if (BigDecimal.valueOf(100L).compareTo(completeProgress) <= 0) {
                        finishtext = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ImicWorkBenchDetailPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
                        finishprogress = "";
                    }
                    this.getModel().setValue("finishprogress", (Object)finishprogress, subEntryRow);
                    this.getModel().setValue("finishtext", (Object)finishtext, subEntryRow);
                    CardEntryFlexPanelAp cardEntryFlexPanelAp = this.createCardEntryFlexPanelAp(subEntryRow, entryPanelStyle);
                    String cardEntryFlexPanelApKey = cardEntryFlexPanelAp.getKey();
                    entryFlexPanelKeys.add(cardEntryFlexPanelApKey);
                    FlexPanelAp stepFlexPanelAp = this.createStepFlexPanelAp(subEntryRow, cardEntryFlexPanelApKey, stepPanelStyle);
                    cardEntryFlexPanelAp.getItems().add(stepFlexPanelAp);
                    entryItems.add(cardEntryFlexPanelAp.createControl());
                    HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                    customParams.put("finishprogress", completeProgress.intValue());
                    FormShowParameter showParameter = ShowFormHelper.showFrom("imic_schemeprogress", stepFlexPanelAp.getKey(), null, ShowType.InContainer, null, customParams);
                    this.getView().showForm(showParameter);
                }
            }
            progressCardEntryFlex.addControls(entryItems);
            this.getPageCache().put("progresscardentryflex", SerializationUtils.toJsonString(entryFlexPanelKeys));
            CardEntry cardEntryGrid = (CardEntry)this.getView().getControl("homecardentry");
            for (int i = 0; i < entryFlexPanelKeys.size(); ++i) {
                String entryFlexPanelKey = (String)entryFlexPanelKeys.get(i);
                ArrayList newEntryFlexPanelKeys = new ArrayList(entryFlexPanelKeys);
                newEntryFlexPanelKeys.remove(entryFlexPanelKey);
                cardEntryGrid.setChildVisible(false, i, newEntryFlexPanelKeys.toArray(new String[0]));
            }
        }
    }

    private void updateHomeCardEntryByOrg(int rowIndex, FormOperate op) {
        BigDecimal completeProgress;
        BigDecimal complete;
        BigDecimal total;
        int allNum = Integer.parseInt((String)op.getOption().getVariables().get("allTaskNum"));
        int finishNum = Integer.parseInt((String)op.getOption().getVariables().get("finishTaskNum"));
        DynamicObjectCollection homeCardEntry = this.getModel().getEntryEntity("homecardentry");
        if ("B".equals(op.getOption().getVariables().get("defaultcaliber"))) {
            total = new BigDecimal(Integer.parseInt((String)op.getOption().getVariables().get("allMustTaskNum")));
            complete = new BigDecimal(Integer.parseInt((String)op.getOption().getVariables().get("finishMustTaskNum")));
            completeProgress = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.valueOf(100L) : complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        } else {
            total = new BigDecimal(allNum);
            complete = new BigDecimal(finishNum);
            completeProgress = complete.divide(total, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        }
        String finishprogress = completeProgress.intValue() + "%";
        String finishtext = "";
        if (BigDecimal.valueOf(100L).compareTo(completeProgress) <= 0) {
            finishtext = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ImicWorkBenchDetailPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
            finishprogress = "";
        }
        ((DynamicObject)homeCardEntry.get(rowIndex)).set("finishprogress", (Object)finishprogress);
        ((DynamicObject)homeCardEntry.get(rowIndex)).set("finishtext", (Object)finishtext);
        Label finishLabel = (Label)this.getView().getControl("finish_label");
        finishLabel.setText(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210 %s", (String)"ImicWorkBenchDetailPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[]{finishNum}));
        Label unFinishLabel = (Label)this.getView().getControl("unfinish_label");
        unFinishLabel.setText(ResManager.loadKDString((String)"\u672a\u5b8c\u6210 %s", (String)"ImicWorkBenchDetailPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[]{allNum - finishNum}));
        this.getView().updateView("finishprogress", rowIndex);
        this.getView().updateView("finishtext", rowIndex);
        Container progressCardEntryFlex = (Container)this.getControl("progresscardentryflex");
        String entryPanelKey = "entryflexpanel" + rowIndex;
        Style entryPanelStyle = new Style();
        Margin entryPanelMargin = new Margin();
        entryPanelMargin.setTop("10px");
        entryPanelStyle.setMargin(entryPanelMargin);
        Style stepPanelStyle = new Style();
        Margin stepPanelMargin = new Margin();
        stepPanelMargin.setBottom("2px");
        stepPanelStyle.setMargin(stepPanelMargin);
        progressCardEntryFlex.deleteControls(new String[]{entryPanelKey});
        CardEntryFlexPanelAp cardEntryFlexPanelAp = this.createCardEntryFlexPanelAp(rowIndex, entryPanelStyle);
        FlexPanelAp stepFlexPanelAp = this.createStepFlexPanelAp(rowIndex, cardEntryFlexPanelAp.getKey(), stepPanelStyle);
        cardEntryFlexPanelAp.getItems().add(stepFlexPanelAp);
        ArrayList<Map> maps = new ArrayList<Map>(1);
        maps.add(cardEntryFlexPanelAp.createControl());
        progressCardEntryFlex.addControls(maps);
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("finishprogress", completeProgress.intValue());
        FormShowParameter showParameter = ShowFormHelper.showFrom("imic_schemeprogress", stepFlexPanelAp.getKey(), null, ShowType.InContainer, null, customParams);
        this.getView().showForm(showParameter);
    }

    private void loadSchemeTaskItemPage(long schemeId, long orgId, String labelType, int sidebarCardIndex) {
        this.clearFlexInitScheme();
        this.getView().getPageCache().put("bizapp", null);
        this.getView().getPageCache().put("initguide", null);
        this.getView().getPageCache().put("appnamelabel", null);
        if (schemeId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        qFilter.and(new QFilter(ImicInitialscheme.EF_initentry_itemenabled, "=", (Object)Boolean.TRUE));
        String selectFields = String.join((CharSequence)",", "id", "number", "modifytime", "name", ImicInitialscheme.F_bizapp_number, "initguide", "bizapp", ImicInitialscheme.F_bizapp_name, ImicInitialscheme.F_bizcloud_name, "usedimension", "defaultcaliber", ImicInitialscheme.EF_itemgroup_id, ImicInitialscheme.EF_itemgroup_seq, ImicInitialscheme.EF_itemgroup_stepname, ImicInitialscheme.EF_initentry_items_id, ImicInitialscheme.EF_initentry_itemname, ImicInitialscheme.EF_initentry_initconfigmustset, ImicInitialscheme.EF_inititem_modeltype, ImicInitialscheme.EF_inititem_number, ImicInitialscheme.EF_initentry_datajudgebasisdesc_tag, ImicInitialscheme.EF_initentry_url, ImicInitialscheme.EF_initentry_initconfigdescription, ImicInitialscheme.EF_initentry_pageparam);
        String orderbys = String.join((CharSequence)",", "id", ImicInitialscheme.EF_itemgroup_seq, ImicInitialscheme.EF_initentry_items_seq);
        DynamicObjectCollection initSchemeEntryColl = QueryServiceHelper.query((String)"imic_initialscheme", (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderbys);
        if (CommonUtil.isNull(initSchemeEntryColl)) {
            return;
        }
        QFilter schemeFilter = new QFilter("initialscheme", "=", (Object)schemeId);
        DynamicObject initEntryDynObj = (DynamicObject)initSchemeEntryColl.get(0);
        if (initEntryDynObj.getBoolean("usedimension")) {
            QFilter assignOrgFilter = new QFilter("org", "=", (Object)orgId);
            schemeFilter.and(assignOrgFilter);
        }
        DynamicObjectCollection progressColl = QueryServiceHelper.query((String)"imic_progressunit", (String)"initialschemeentryid", (QFilter[])schemeFilter.toArray());
        Set progressEntryIdSet = progressColl.stream().map(o -> o.getLong("initialschemeentryid")).collect(Collectors.toSet());
        ArrayList<AnchorItems> anchorItemsList = new ArrayList<AnchorItems>(10);
        Container schemeContainer = (Container)this.getView().getControl("flexinitscheme");
        Map allStepEntryMap = initSchemeEntryColl.stream().collect(Collectors.groupingBy(o -> o.getLong(ImicInitialscheme.EF_itemgroup_id), LinkedHashMap::new, Collectors.toList()));
        Set allItemEntryIdSet = initSchemeEntryColl.stream().map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
        Set allFinishItemEntryIdSet = progressEntryIdSet.stream().filter(allItemEntryIdSet::contains).collect(Collectors.toSet());
        Set allMustItemEntryIdSet = initSchemeEntryColl.stream().filter(o -> o.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)).map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
        Set allMustFinishItemEntryIdSet = progressEntryIdSet.stream().filter(allMustItemEntryIdSet::contains).collect(Collectors.toSet());
        Label unfinishLabel = (Label)this.getControl("unfinish_label");
        unfinishLabel.setText(ResManager.loadKDString((String)"\u672a\u5b8c\u6210 %s", (String)"ImicWorkBenchDetailPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[]{allItemEntryIdSet.size() - allFinishItemEntryIdSet.size()}));
        Label finishLabel = (Label)this.getControl("finish_label");
        finishLabel.setText(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210 %s", (String)"ImicWorkBenchDetailPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[]{allFinishItemEntryIdSet.size()}));
        int count = 1;
        ArrayList<String> targetKeyList = new ArrayList<String>(16);
        boolean isCreateDefault = true;
        for (Map.Entry mapEntry : allStepEntryMap.entrySet()) {
            List stepInitEntryList = (List)mapEntry.getValue();
            if ("unfinish_label".equals(labelType)) {
                Set unFinishItemEntryIdSet = initSchemeEntryColl.stream().filter(o -> !progressEntryIdSet.contains(o.getLong(ImicInitialscheme.EF_initentry_items_id))).map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
                stepInitEntryList = ((List)mapEntry.getValue()).stream().filter(o -> unFinishItemEntryIdSet.contains(o.getLong(ImicInitialscheme.EF_initentry_items_id))).collect(Collectors.toList());
            } else if ("finish_label".equals(labelType)) {
                Set finishItemEntryIdSet = initSchemeEntryColl.stream().filter(o -> progressEntryIdSet.contains(o.getLong(ImicInitialscheme.EF_initentry_items_id))).map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
                stepInitEntryList = ((List)mapEntry.getValue()).stream().filter(o -> finishItemEntryIdSet.contains(o.getLong(ImicInitialscheme.EF_initentry_items_id))).collect(Collectors.toList());
            }
            if (CommonUtil.isNull(stepInitEntryList)) continue;
            isCreateDefault = false;
            DynamicObject firstInitEntryDynObj = (DynamicObject)stepInitEntryList.get(0);
            String stepName = firstInitEntryDynObj.getString(ImicInitialscheme.EF_itemgroup_stepname);
            String stepLabel = firstInitEntryDynObj.getInt(ImicInitialscheme.EF_itemgroup_seq) + "." + stepName;
            Set itemEntryIdSet = stepInitEntryList.stream().map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
            long finishCount = progressEntryIdSet.stream().filter(o -> itemEntryIdSet.contains(o)).count();
            boolean isFinish = finishCount == (long)itemEntryIdSet.size();
            int itemSize = itemEntryIdSet.size();
            if ("B".equals(firstInitEntryDynObj.getString("defaultcaliber"))) {
                Set mustItemEntryIdSet = stepInitEntryList.stream().filter(o -> o.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset)).map(o -> o.getLong(ImicInitialscheme.EF_initentry_items_id)).collect(Collectors.toSet());
                finishCount = progressEntryIdSet.stream().filter(o -> mustItemEntryIdSet.contains(o)).count();
                itemSize = mustItemEntryIdSet.size();
            }
            String itemqtyLabel = "(" + finishCount + "/" + itemSize + ")";
            String targetKey = "imic_schemetaskitem" + count;
            FlexPanelAp panelAp = this.createFlexPanelAp(targetKey);
            ArrayList<Map> maps = new ArrayList<Map>(1);
            maps.add(panelAp.createControl());
            schemeContainer.addControls(maps);
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("initialscheme", schemeId);
            customParams.put("step_label", stepLabel);
            customParams.put("itemqty_label", itemqtyLabel);
            customParams.put("isFinish", isFinish);
            customParams.put("inititementry_card", stepInitEntryList);
            customParams.put("orgid", orgId);
            customParams.put("progressEntryIdSet", progressEntryIdSet);
            customParams.put("sidebarCardIndex", sidebarCardIndex);
            customParams.put("number", firstInitEntryDynObj.getString("number"));
            customParams.put("firstmodifytime", firstInitEntryDynObj.getString("modifytime"));
            customParams.put("usedimension", firstInitEntryDynObj.getBoolean("usedimension"));
            customParams.put("defaultcaliber", firstInitEntryDynObj.getString("defaultcaliber"));
            customParams.put("bizapp", firstInitEntryDynObj.getString("bizapp"));
            customParams.put(ImicInitialscheme.F_bizapp_number, ((DynamicObject)initSchemeEntryColl.get(0)).getString(ImicInitialscheme.F_bizapp_number));
            customParams.put("initguide", ((DynamicObject)initSchemeEntryColl.get(0)).getString("initguide").trim());
            customParams.put(ImicInitialscheme.EF_inititem_number, firstInitEntryDynObj.getString(ImicInitialscheme.EF_inititem_number));
            customParams.put("pageparam", firstInitEntryDynObj.getString(ImicInitialscheme.EF_initentry_pageparam));
            customParams.put("allMustTaskNum", allMustItemEntryIdSet.size());
            customParams.put("finishMustTaskNum", allMustFinishItemEntryIdSet.size());
            customParams.put("allTaskNum", allItemEntryIdSet.size());
            customParams.put("finishTaskNum", allFinishItemEntryIdSet.size());
            customParams.put("param_clicklabel", this.getView().getPageCache().get("param_clicklabel"));
            FormShowParameter showParameter = ShowFormHelper.showFrom("imic_schemetaskitem", targetKey, null, ShowType.InContainer, null, customParams);
            this.getView().showForm(showParameter);
            AnchorItems item = new AnchorItems(targetKey, stepName, null);
            anchorItemsList.add(item);
            ++count;
            targetKeyList.add(targetKey);
        }
        if (isCreateDefault) {
            FormShowParameter showParameter = ShowFormHelper.showFrom("imic_schemetaskitem", "flexinitscheme", null, ShowType.InContainer, null, null);
            this.getView().showForm(showParameter);
        }
        this.getView().getPageCache().put("param_steptargetkey", SerializationUtils.toJsonString(targetKeyList));
        Label appnamelabel = (Label)this.getControl("appnamelabel");
        String appName = "181/2AWNX/C6".equals(initEntryDynObj.getString("bizapp")) ? initEntryDynObj.getString(ImicInitialscheme.F_bizcloud_name) : initEntryDynObj.getString(ImicInitialscheme.F_bizapp_name);
        appnamelabel.setText(appName);
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        anchorCtl.setHighlight(true);
        anchorCtl.addItems(anchorItemsList);
        this.getView().setVisible(Boolean.valueOf(!anchorItemsList.isEmpty()), new String[]{"anchorcontrolap"});
        this.getView().getPageCache().put("bizapp", ((DynamicObject)initSchemeEntryColl.get(0)).getString(ImicInitialscheme.F_bizapp_number));
        this.getView().getPageCache().put("initguide", ((DynamicObject)initSchemeEntryColl.get(0)).getString("initguide").trim());
        this.getView().getPageCache().put("appnamelabel", appName);
    }

    private FlexPanelAp createFlexPanelAp(String key) {
        FlexPanelAp flexPanel = new FlexPanelAp();
        flexPanel.setCollapsible(false);
        flexPanel.setShrink(0);
        flexPanel.setGrow(0);
        flexPanel.setKey(key);
        Style style = flexPanel.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin margin = new Margin();
        margin.setBottom("12px");
        style.setMargin(margin);
        flexPanel.setStyle(style);
        flexPanel.setRadius("5px");
        return flexPanel;
    }

    private void clearFlexInitScheme() {
        Container schemeContainer = (Container)this.getView().getControl("flexinitscheme");
        String controlKeyStr = this.getPageCache().get("param_steptargetkey");
        if (StringUtils.isNotEmpty(controlKeyStr)) {
            List targetKeyList = JSON.parseArray((String)controlKeyStr, String.class);
            if (CommonUtil.isNull(targetKeyList)) {
                return;
            }
            schemeContainer.deleteControls(targetKeyList.toArray(new String[targetKeyList.size()]));
            this.getPageCache().remove("param_steptargetkey");
        }
    }

    private CardEntryFlexPanelAp createCardEntryFlexPanelAp(int i, Style entryPanelStyle) {
        String entryFlexPanelKey = "entryflexpanel" + i;
        CardEntryFlexPanelAp cardEntryFlexPanel = new CardEntryFlexPanelAp();
        cardEntryFlexPanel.setCollapsible(false);
        cardEntryFlexPanel.setShrink(0);
        cardEntryFlexPanel.setGrow(0);
        cardEntryFlexPanel.setKey(entryFlexPanelKey);
        cardEntryFlexPanel.setStyle(entryPanelStyle);
        cardEntryFlexPanel.setDirection("row");
        cardEntryFlexPanel.setWrap(true);
        cardEntryFlexPanel.setOverflow("visible");
        cardEntryFlexPanel.setWidth(new LocaleString("100px"));
        return cardEntryFlexPanel;
    }

    private FlexPanelAp createStepFlexPanelAp(int j, String cardEntryFlexPanelApKey, Style stepPanelStyle) {
        String stepPanelApKey = cardEntryFlexPanelApKey + "steppanel" + j;
        FlexPanelAp stepPanelAp = new FlexPanelAp();
        stepPanelAp.setCollapsible(false);
        stepPanelAp.setShrink(0);
        stepPanelAp.setGrow(0);
        stepPanelAp.setWidth(new LocaleString("100px"));
        stepPanelAp.setKey(stepPanelApKey);
        stepPanelAp.setStyle(stepPanelStyle);
        return stepPanelAp;
    }
}

