/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.opplugin.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.common.StringUtils;

public class InitialSchemeEnableValidator
extends AbstractValidator {
    private static final String BIZ_APP = "bizapp";
    private static final String USE_DIMENSION = "usedimension";
    private static final String ENABLE = "enable";
    private static final String ISSHARE = "isalluse";

    public void validate() {
        ExtendedDataEntity[] entities;
        String opName = this.validateContext.getOperateName();
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            DynamicObject currScheme = entity.getDataEntity();
            Object pkValue = currScheme.getPkValue();
            boolean isCurrUseDmsn = currScheme.getBoolean(USE_DIMENSION);
            boolean isCurrShare = currScheme.getBoolean(ISSHARE);
            boolean isCurrEnable = currScheme.getBoolean(ENABLE);
            if (!isCurrEnable && isCurrShare && StringUtils.equals(operateKey, "save")) continue;
            DynamicObject bizApp = currScheme.getDynamicObject(BIZ_APP);
            DynamicObject curDimension = currScheme.getDynamicObject("dimensiontype");
            Object currDimensionType = curDimension == null ? "" : curDimension.getPkValue();
            DynamicObjectCollection currCard = QueryServiceHelper.query((String)"imic_assignrecord", (String)"id,dimension", (QFilter[])new QFilter("initialscheme", "=", pkValue).toArray());
            String appName = bizApp.getString("name");
            QFilter allSchemeFilter = new QFilter(BIZ_APP, "=", bizApp.getPkValue()).and("id", "!=", pkValue).and(ENABLE, "=", (Object)"1");
            DynamicObjectCollection allSchemes = QueryServiceHelper.query((String)"imic_initialscheme", (String)"id,number,usedimension,enable,isalluse,dimensiontype,name", (QFilter[])allSchemeFilter.toArray());
            for (DynamicObject scheme : allSchemes) {
                boolean isDbUseDmsn = scheme.getBoolean(USE_DIMENSION);
                boolean isDbEnable = scheme.getBoolean(ENABLE);
                boolean isDbShare = scheme.getBoolean(ISSHARE);
                String dbSchemeName = scheme.getString("name");
                String dbDimensionType = scheme.getString("dimensiontype");
                String tip = null;
                if (!isCurrUseDmsn) {
                    if (isDbUseDmsn && "save".equals(operateKey)) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u65b9\u6848[%2$s]\uff0c\u6682\u4e0d\u652f\u6301%3$s\u65e0\u7ef4\u5ea6\u7ba1\u7406\u7684\u65b9\u6848", (String)"InitialSchemeEnableValidator_0", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName, opName);
                    }
                } else if (isCurrShare) {
                    if (!isDbUseDmsn) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u672a\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u65b9\u6848[%2$s]\uff0c\u6682\u4e0d\u652f\u6301%3$s\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u7684\u65b9\u6848", (String)"InitialSchemeEnableValidator_1", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName, opName);
                    } else if (isDbEnable && !isDbShare) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u7684\u65b9\u6848[%2$s]\uff0c\u4e0d\u5141\u8bb8%3$s\u5168\u5c40\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u8c03\u6574\u540e\u518d%4$s", (String)"InitialSchemeEnableValidator_2", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName, opName, opName);
                    }
                } else if (!isDbUseDmsn) {
                    tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u672a\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u65b9\u6848[%2$s]\uff0c\u6682\u4e0d\u652f\u6301%3$s\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u7684\u65b9\u6848", (String)"InitialSchemeEnableValidator_1", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName, opName);
                } else if (isDbShare) {
                    if (isDbEnable) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5df2\u5b58\u5728\u5168\u5c40\u5171\u4eab[%2$s]\uff0c\u6682\u4e0d\u652f\u6301%3$s\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u7684\u65b9\u6848", (String)"InitialSchemeEnableValidator_3", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName, opName);
                    }
                    if (StringUtils.isBlank(tip) && !currDimensionType.equals(dbDimensionType)) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5b58\u5728\u65b9\u6848[%2$s]\u7ef4\u5ea6\u7c7b\u578b\u4e0e\u5f53\u524d\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u6682\u4e0d\u652f\u6301\u540c\u4e00\u5e94\u7528\u4e0b\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\u7684\u521d\u59cb\u5316\u65b9\u6848", (String)"InitialSchemeEnableValidator_4", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName);
                    }
                } else {
                    if (!currDimensionType.equals(dbDimensionType)) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5b58\u5728\u65b9\u6848[%2$s]\u7ef4\u5ea6\u7c7b\u578b\u4e0e\u5f53\u524d\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u6682\u4e0d\u652f\u6301\u540c\u4e00\u5e94\u7528\u4e0b\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\u7684\u521d\u59cb\u5316\u65b9\u6848", (String)"InitialSchemeEnableValidator_4", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName);
                    }
                    if (StringUtils.isBlank(tip) && isDbEnable) {
                        DynamicObjectCollection dbCard = QueryServiceHelper.query((String)"imic_assignrecord", (String)"id,dimension", (QFilter[])new QFilter("initialscheme", "=", scheme.get("id")).toArray());
                        if (currCard.size() > 0 && dbCard.size() > 0) {
                            ArrayList currDime = new ArrayList(10);
                            currCard.forEach(l -> currDime.add(l.getString("dimension")));
                            ArrayList dbDime = new ArrayList(10);
                            dbCard.forEach(l -> dbDime.add(l.getString("dimension")));
                            List resultList = currDime.stream().filter(dbDime::contains).collect(Collectors.toList());
                            if (resultList.size() > 0) {
                                tip = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u4e0b\u5b58\u5728\u542f\u7528\u72b6\u6001\u4e14\u5206\u914d\u8303\u56f4\u51b2\u7a81\u7684\u65b9\u6848%2$s\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u542f\u7528", (String)"InitialSchemeEnableValidator_5", (String)"imsc-imic-platform", (Object[])new Object[0]), appName, dbSchemeName);
                            }
                        }
                    }
                }
                if (!StringUtils.isNotBlank(tip)) continue;
                this.addErrorMessage(entity, tip);
            }
        }
    }
}

