/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.opplugin.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.imic.business.taskdispatch.TaskDispatchHelper;
import kd.imsc.imic.common.taskdispatch.TaskDispatchConst;

public class TaskDispatchRecordSaveValidator
extends AbstractValidator {
    private List<Long> noUseDimenTaskIds = new ArrayList<Long>(16);
    private List<Long> recordIdList = new ArrayList<Long>(16);
    private Map<Long, List<Long>> taskApplyOrgMap = new HashMap<Long, List<Long>>(16);
    private Map<Long, List<Long>> duplicateOrgMap = new HashMap<Long, List<Long>>(16);
    private Map<Long, List<Long>> duplicateUserMap = new HashMap<Long, List<Long>>(16);

    public void validate() {
        DynamicObject[] records;
        OperateOption option = this.getOption();
        if (option.containsVariable("savetype")) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap<Long, List<Long>> taskAllOrgMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, List<Long>> taskUserMap = new HashMap<Long, List<Long>>(16);
        HashSet<DynamicObject> initSchemes = new HashSet<DynamicObject>(16);
        ArrayList<Long> importDataIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            importDataIds.add(dataEntity.getLong("id"));
            DynamicObject initScheme2 = dataEntity.getDynamicObject("initscheme");
            DynamicObject initTask = dataEntity.getDynamicObject("inittask");
            if (initScheme2 == null || initTask == null) continue;
            initSchemes.add(initScheme2);
            long taskId = initTask.getLong("id");
            boolean useDimension = initScheme2.getBoolean("usedimension");
            if (!useDimension) continue;
            this.prepareTaskMap(dataEntity, taskId, taskUserMap, taskAllOrgMap);
        }
        this.taskApplyOrgMap = TaskDispatchHelper.getTaskApplyOrgMap(initSchemes);
        List schemeIds = initSchemes.stream().map(initScheme -> initScheme.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter(TaskDispatchConst.INITSCHEME_ID, "in", schemeIds);
        String selectRecordProperties = String.join((CharSequence)",", "initscheme", "inittask", "chargeuser", "dispatchorg");
        for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"imic_taskdispatchrecord", (String)selectRecordProperties, (QFilter[])filter.toArray())) {
            long recordId = record.getLong("id");
            this.recordIdList.add(recordId);
            DynamicObject scheme = record.getDynamicObject("initscheme");
            DynamicObject initTask = record.getDynamicObject("inittask");
            if (scheme == null || initTask == null) continue;
            long taskId = initTask.getLong("id");
            boolean useDimension = scheme.getBoolean("usedimension");
            if (!useDimension) {
                this.noUseDimenTaskIds.add(taskId);
                continue;
            }
            if (importDataIds.contains(recordId)) continue;
            this.prepareTaskMap(record, taskId, taskUserMap, taskAllOrgMap);
        }
        this.duplicateOrgMap = this.getDuplicateMap(taskAllOrgMap);
        this.duplicateUserMap = this.getDuplicateMap(taskUserMap);
        this.doValidate(extendedDataEntities);
    }

    private void doValidate(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long recordId = dataEntity.getLong("id");
            DynamicObject initScheme = dataEntity.getDynamicObject("initscheme");
            DynamicObject initTask = dataEntity.getDynamicObject("inittask");
            if (initScheme == null || initTask == null) continue;
            long stepId = dataEntity.getLong("stepid");
            String stepName = dataEntity.getString("stepname");
            String schemeNum = initScheme.getString("number");
            DynamicObjectCollection itemGroups = initScheme.getDynamicObjectCollection("itemgroup");
            List stepIdList = itemGroups.stream().map(step -> step.getLong("id")).collect(Collectors.toList());
            if (!stepIdList.contains(stepId)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u65b9\u6848\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a%2$s\u7684\u6b65\u9aa4\u3002", (String)"TaskDispatchRecordSaveValidator_0", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum, stepName}));
                continue;
            }
            List<Object> entryItemIds = new ArrayList(16);
            for (DynamicObject itemGroup : itemGroups) {
                long groupId = itemGroup.getLong("id");
                if (stepId != groupId) continue;
                DynamicObjectCollection items = itemGroup.getDynamicObjectCollection("imic_initentry_items");
                entryItemIds = items.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            long taskId = initTask.getLong("id");
            String taskName = initTask.getString("itemname");
            if (!entryItemIds.contains(taskId)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u65b9\u6848\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a%2$s\u7684\u521d\u59cb\u5316\u4efb\u52a1\u3002", (String)"TaskDispatchRecordSaveValidator_1", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum, taskId, taskName}));
                continue;
            }
            boolean useDimension = initScheme.getBoolean("usedimension");
            DynamicObjectCollection dispatchOrgs = dataEntity.getDynamicObjectCollection("dispatchorg");
            if (useDimension) {
                List<Long> duplicateUserIds;
                DynamicObject chargeUser = dataEntity.getDynamicObject("chargeuser");
                String chargeUserNum = "";
                long chargeUserId = 0L;
                if (chargeUser != null) {
                    chargeUserNum = chargeUser.getString("number");
                    chargeUserId = chargeUser.getLong("id");
                }
                if ((duplicateUserIds = this.duplicateUserMap.get(taskId)) != null && duplicateUserIds.contains(chargeUserId)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u65b9\u6848\u4e0b\u540d\u79f0\u4e3a%2$s\u7684\u4efb\u52a1\u9879\u5df2\u7ecf\u5206\u914d\u5de5\u53f7\u4e3a%3$s\u7684\u8d23\u4efb\u4eba\uff0c\u65e0\u9700\u91cd\u590d\u5206\u914d\u3002", (String)"TaskDispatchRecordSaveValidator_3", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum, taskName, chargeUserNum}));
                    continue;
                }
                List newOrgIds = dispatchOrgs.stream().filter(dispatchOrg -> dispatchOrg.getDynamicObject("fbasedataid") != null).map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
                Map<Long, String> orgNumMap = dispatchOrgs.stream().filter(dispatchOrg -> dispatchOrg.getDynamicObject("fbasedataid") != null).collect(Collectors.toMap(dispatchOrg -> dispatchOrg.getDynamicObject("fbasedataid").getLong("id"), dispatchOrg -> dispatchOrg.getDynamicObject("fbasedataid").getString("number")));
                ArrayList tempOrgIds = new ArrayList(newOrgIds);
                List<Long> taskApplyOrgList = this.taskApplyOrgMap.get(taskId);
                tempOrgIds.removeAll(taskApplyOrgList);
                if (!tempOrgIds.isEmpty()) {
                    ArrayList<String> orgNumList = new ArrayList<String>(16);
                    for (Long tempOrgId : tempOrgIds) {
                        orgNumList.add(orgNumMap.get(tempOrgId));
                    }
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7%1$s\u4e0d\u5728\u65b9\u6848%2$s\u53ef\u5206\u914d\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"TaskDispatchRecordSaveValidator_2", (String)"imsc-imic-platform", (Object[])new Object[]{String.join((CharSequence)",", orgNumList), schemeNum}));
                    continue;
                }
                List<Long> duplicateOrgIds = this.duplicateOrgMap.get(taskId);
                if (duplicateOrgIds == null) continue;
                List sameOrgIds = newOrgIds.stream().filter(duplicateOrgIds::contains).collect(Collectors.toList());
                if (sameOrgIds.isEmpty()) continue;
                ArrayList<String> orgNumList = new ArrayList<String>(16);
                for (Long sameOrgId : sameOrgIds) {
                    orgNumList.add(orgNumMap.get(sameOrgId));
                }
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u65b9\u6848\u4e0b\u540d\u79f0\u4e3a%2$s\u4efb\u52a1\u9879\u5df2\u7ecf\u4e0b\u8fbe\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\uff0c\u65e0\u9700\u91cd\u590d\u4e0b\u8fbe\u3002", (String)"TaskDispatchRecordSaveValidator_4", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum, taskName, String.join((CharSequence)",", orgNumList)}));
                continue;
            }
            if (!this.recordIdList.contains(recordId) && this.noUseDimenTaskIds.contains(taskId)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u65b9\u6848\u5df2\u5b58\u5728\u540d\u79f0\u4e3a%2$s\u7684\u4efb\u52a1\u9879\u7684\u4e0b\u8fbe\u8bb0\u5f55\u3002", (String)"TaskDispatchRecordSaveValidator_5", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum, taskName}));
                continue;
            }
            if (dispatchOrgs.isEmpty()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u65b9\u6848\u672a\u5f00\u542f\u7ef4\u5ea6\u7ba1\u7406\uff0c\u8bf7\u4e0d\u8981\u5f55\u5165\u4e0b\u8fbe\u7ec4\u7ec7\u3002", (String)"TaskDispatchRecordSaveValidator_6", (String)"imsc-imic-platform", (Object[])new Object[]{schemeNum}));
        }
    }

    private Map<Long, List<Long>> getDuplicateMap(Map<Long, List<Long>> map) {
        HashMap<Long, List<Long>> duplicateMap = new HashMap<Long, List<Long>>(16);
        for (Map.Entry<Long, List<Long>> mapEntry : map.entrySet()) {
            Long taskId = mapEntry.getKey();
            List<Long> ids = mapEntry.getValue();
            List duplicateIds = ids.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
            if (duplicateIds.isEmpty()) continue;
            duplicateMap.put(taskId, duplicateIds);
        }
        return duplicateMap;
    }

    private void prepareTaskMap(DynamicObject dynamicObject, Long taskId, Map<Long, List<Long>> taskUserMap, Map<Long, List<Long>> taskAllOrgMap) {
        DynamicObject chargeUser = dynamicObject.getDynamicObject("chargeuser");
        if (chargeUser != null) {
            long chargeUserId = chargeUser.getLong("id");
            taskUserMap.putIfAbsent(taskId, new ArrayList(16));
            taskUserMap.get(taskId).add(chargeUserId);
        }
        DynamicObjectCollection dispatchOrgs = dynamicObject.getDynamicObjectCollection("dispatchorg");
        List dipatchOrgIdList = dispatchOrgs.stream().map(dispatchOrg -> dispatchOrg.getLong("fbasedataid_id")).collect(Collectors.toList());
        taskAllOrgMap.putIfAbsent(taskId, new ArrayList(16));
        taskAllOrgMap.get(taskId).addAll(dipatchOrgIdList);
    }
}

