/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ssc.hstc.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.sdk.ssc.hstc.util.ObjectUtils;

public class ArtiCheckPointService {
    private static final Log LOGGER = LogFactory.getLog(ArtiCheckPointService.class);

    public static ArtiCheckPointService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Map<Long, DynamicObjectCollection> getArtiCheckPointByBillTypeId(Long billTypeId, Long taskTypeId, Collection<Long> billIds) {
        HashMap<Long, DynamicObjectCollection> resultMap = new HashMap<Long, DynamicObjectCollection>(billIds.size());
        String entityName = "task_taskbill";
        String selectFields = "id,entryentity.childpkid as childpkid,bindbill.number as bindbillnumber";
        QFilter billTypeFilter = new QFilter("id", "=", (Object)billTypeId);
        QFilter taskTypeFilter = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        DynamicObject taskBillDy = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{billTypeFilter, taskTypeFilter});
        if (taskBillDy == null) {
            return resultMap;
        }
        Long childpkid = taskBillDy.getLong("childpkid");
        QFilter filter = new QFilter("id", "=", (Object)childpkid);
        try {
            QFilter filter1 = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
            DynamicObjectCollection articheckpointCollection = QueryServiceHelper.query((String)"task_taskbill_child", (String)"entryentityarticheck.articheck.id as articheckpointid,entryentityarticheck.articheck.name as articheckpointname,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", (QFilter[])new QFilter[]{filter, filter1});
            if (articheckpointCollection == null || articheckpointCollection.size() == 0) {
                return resultMap;
            }
            for (DynamicObject dyo : articheckpointCollection) {
                List<Long> matchBillIds = new ArrayList<Long>(billIds.size());
                if (StringUtils.isBlank((CharSequence)dyo.getString("checkcondition"))) {
                    matchBillIds.addAll(billIds);
                } else {
                    matchBillIds = this.meetCondition(taskBillDy.getString("bindbillnumber"), dyo.getString("checkconditionjson"), billIds);
                }
                for (Long billId : matchBillIds) {
                    DynamicObjectCollection collection = (DynamicObjectCollection)resultMap.get(billId);
                    if (collection == null) {
                        collection = new DynamicObjectCollection();
                    }
                    collection.add((Object)dyo);
                    resultMap.put(billId, collection);
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
            QFilter filter1 = QFilter.isNotNull((String)"articheckpointconfig.FBasedataId");
            DynamicObjectCollection articheckpointCollection = QueryServiceHelper.query((String)"task_taskbill_child", (String)"articheckpointconfig.FBasedataId as articheckpointid,articheckpointconfig.FBasedataId.name as articheckpointname,articheckpointconfig.FBasedataId.isselected as articheckpointselected", (QFilter[])new QFilter[]{filter, filter1});
            if (articheckpointCollection == null || articheckpointCollection.size() == 0) {
                return resultMap;
            }
            for (Long billId : billIds) {
                resultMap.put(billId, articheckpointCollection);
            }
        }
        return resultMap;
    }

    private List<Long> meetCondition(String bindEntityNumber, String conditionJson, Collection<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(this.analysisFilter(bindEntityNumber, conditionJson));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)bindEntityNumber, (String)"id", (QFilter[])qFilter.toArray());
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<Long>();
        }
        return collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private QFilter analysisFilter(String entityNumber, String conditionJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public List<DynamicObject> genArtiCheckPointWithTaskInfos(Long billTypeId, Long taskTypeId, List<DynamicObject> taskHistoryDys, String operationResultType) {
        ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
        List<Long> billlongIds = taskHistoryDys.stream().map(dy -> dy.getLong("billlongid")).collect(Collectors.toList());
        Map<Long, DynamicObjectCollection> artiCheckPointMap = this.getArtiCheckPointByBillTypeId(billTypeId, taskTypeId, billlongIds);
        if (artiCheckPointMap == null || artiCheckPointMap.isEmpty()) {
            return articheckpointlist;
        }
        Date nowDate = new Date();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
        for (DynamicObject taskHistoryDy : taskHistoryDys) {
            long billlongId = taskHistoryDy.getLong("billlongid");
            DynamicObjectCollection artiCheckPoints = artiCheckPointMap.get(billlongId);
            for (DynamicObject artiCheckPoint : artiCheckPoints) {
                DynamicObject articheckpointitem = new DynamicObject((DynamicObjectType)dt);
                articheckpointitem.set("taskid", (Object)taskHistoryDy.getString("id"));
                articheckpointitem.set("articheckpoint", (Object)artiCheckPoint.getString("articheckpointid"));
                articheckpointitem.set("createtime", (Object)nowDate);
                if (OperationResultType.PROCESSED.getValue().equals(operationResultType)) {
                    articheckpointitem.set("iscontented", (Object)Boolean.TRUE);
                } else {
                    articheckpointitem.set("iscontented", (Object)artiCheckPoint.getBoolean("articheckpointselected"));
                }
                articheckpointlist.add(articheckpointitem);
            }
        }
        return articheckpointlist;
    }

    public void saveArtiCheckPoint(IDataModel model, DynamicObject[] taskHistoryDys, boolean isFromList, String operationResultType) {
        Map<Long, DynamicObject> sourceTaskIdMap = Stream.of(taskHistoryDys).collect(Collectors.toMap(dy -> dy.getLong("sourcetaskid"), dy -> dy));
        List taskids = sourceTaskIdMap.keySet().stream().map(String::valueOf).collect(Collectors.toList());
        Date nowDate = new Date();
        if (isFromList) {
            QFilter filter = new QFilter("taskid", "in", taskids);
            DynamicObject[] articheckpointrecords = BusinessDataServiceHelper.load((String)"task_articheckpointrecord", (String)"id,taskid,createtime", (QFilter[])new QFilter[]{filter});
            if (articheckpointrecords != null && articheckpointrecords.length > 0) {
                for (DynamicObject articheckpointrecord : articheckpointrecords) {
                    long taskId = ObjectUtils.getLongValOfObject((Object)articheckpointrecord.get("taskid"));
                    articheckpointrecord.set("taskid", sourceTaskIdMap.get(taskId).get("id"));
                    articheckpointrecord.set("createtime", (Object)nowDate);
                }
                SaveServiceHelper.save((DynamicObject[])articheckpointrecords);
                return;
            }
            ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
            Map<Long, List<DynamicObject>> billtypeMap = Stream.of(taskHistoryDys).collect(Collectors.groupingBy(dy -> dy.getLong("billtype.id")));
            for (Map.Entry<Long, List<DynamicObject>> billtypeEntry : billtypeMap.entrySet()) {
                Long billTypeId = billtypeEntry.getKey();
                Map<Long, List<DynamicObject>> tasktypeidMap = billtypeEntry.getValue().stream().collect(Collectors.groupingBy(dy -> dy.getLong("tasktypeid.id")));
                for (Map.Entry<Long, List<DynamicObject>> tasktypeEntry : tasktypeidMap.entrySet()) {
                    Long taskTypeId = tasktypeEntry.getKey();
                    articheckpointlist.addAll(this.genArtiCheckPointWithTaskInfos(billTypeId, taskTypeId, tasktypeEntry.getValue(), operationResultType));
                }
            }
            SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
        } else {
            if (model == null) {
                return;
            }
            QFilter filter = new QFilter("taskid", "in", taskids);
            DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"id as articheckpointid,articheckpoint as articheckpointname,iscontented as articheckpointselected", (QFilter[])new QFilter[]{filter});
            if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
                DeleteServiceHelper.delete((String)"task_articheckpointrecord", (QFilter[])new QFilter[]{filter});
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
            ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            if (entryentity == null || entryentity.size() == 0) {
                return;
            }
            for (DynamicObject taskHistoryDy : taskHistoryDys) {
                for (DynamicObject entry : entryentity) {
                    DynamicObject articheckpointitem = new DynamicObject((DynamicObjectType)dt);
                    articheckpointitem.set("taskid", (Object)taskHistoryDy.getString("id"));
                    articheckpointitem.set("articheckpoint", (Object)entry.getString("articheckpointid"));
                    articheckpointitem.set("createtime", (Object)nowDate);
                    articheckpointitem.set("iscontented", entry.get("checkboxfield"));
                    articheckpointlist.add(articheckpointitem);
                }
            }
            SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
        }
    }

    public Map<Long, List<String>> checkArtiCheckPointSelectedOfList(Collection<Long> taskIdListIn) {
        LOGGER.info("--ArtiCheckPointService.checkArtiCheckPointSelectedOfList--taskIdListIn = {}", taskIdListIn);
        HashMap<Long, List<String>> resultMap = new HashMap<Long, List<String>>(16);
        List taskIds = taskIdListIn.stream().map(id -> id + "").collect(Collectors.toList());
        HashSet<Long> taskIdList = new HashSet<Long>(taskIdListIn);
        QFilter taskFilter = new QFilter("taskid", "in", taskIds);
        QFilter taskbillchildFilter = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"iscontented,taskid", (QFilter[])new QFilter[]{taskFilter});
        if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
            for (DynamicObject articheckpointrecord : articheckpointrecords) {
                taskIdList.remove(articheckpointrecord.getLong("taskid"));
                if (articheckpointrecord.getBoolean("iscontented")) continue;
                String subject = this.getSubjectFromTask(articheckpointrecord.getLong("taskid"));
                String resultMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), subject);
                resultMap.put(articheckpointrecord.getLong("taskid"), Collections.singletonList(resultMsg));
            }
            LOGGER.info("--ArtiCheckPointService.checkArtiCheckPointSelectedOfList-- after check record taskIdList = {}", taskIdList);
            if (taskIdList.size() == 0) {
                return resultMap;
            }
        }
        ORM orm = ORM.create();
        try (DataSet taskRows = orm.queryDataSet("task_task", "task_task", "id as taskid,billtype,tasktypeid,subject,billlongid", new QFilter[]{new QFilter("id", "in", taskIdList)});
             DataSet billtypeRows = orm.queryDataSet("task_taskbill", "task_taskbill", "id as taskbillid,entryentity.tasktype as tasktype,entryentity.childpkid as childid,bindbill_new.id as bindbillnumber", null);
             DataSet childBilltypeRows = orm.queryDataSet("task_taskbill_child", "task_taskbill_child", "id as taskbillchildid,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", taskbillchildFilter.toArray());
             DataSet resultRows = taskRows.join(billtypeRows, JoinType.INNER).on("billtype", "taskbillid").on("tasktypeid", "tasktype").select(new String[]{"taskid", "subject", "childid", "billlongid", "bindbillnumber", "billtype", "tasktypeid"}).finish().join(childBilltypeRows, JoinType.INNER).on("childid", "taskbillchildid").select(new String[]{"taskid", "subject", "billlongid", "bindbillnumber", "articheckpointselected", "checkconditionjson", "checkcondition", "billtype", "tasktypeid"}).finish();){
            Map<String, Object> rowResultMap = this.getRowResultMap(resultRows);
            Map taskIdArtiCheckPointsMap = (Map)rowResultMap.get("taskIdArtiCheckPointsMap");
            block37: for (Long taskId : taskIdList) {
                DynamicObjectCollection artiCheckPointColl = (DynamicObjectCollection)taskIdArtiCheckPointsMap.get(taskId);
                if (artiCheckPointColl == null) continue;
                for (DynamicObject artiCheckPoint : artiCheckPointColl) {
                    if (artiCheckPoint.getBoolean("articheckpointselected")) continue;
                    String resultMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((Map)rowResultMap.get("taskIdSubjectMap")).get(taskId));
                    resultMap.put(taskId, Collections.singletonList(resultMsg));
                    continue block37;
                }
            }
        }
        return resultMap;
    }

    public Map<String, Object> getRowResultMap(DataSet resultRows) {
        HashMap billAndTaskTypeBillIdsMap = new HashMap(16);
        HashMap billAndTaskTypeTaskSetMap = new HashMap(16);
        HashMap<Long, String> taskIdSubjectMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> taskBillIdMap = new HashMap<Long, Long>(16);
        for (Object row : resultRows) {
            HashSet<Long> taskIdSet;
            HashSet<Long> billIdSet;
            Long l = row.getLong("taskid");
            Long billId = row.getLong("billlongid");
            taskBillIdMap.put(l, billId);
            taskIdSubjectMap.put(l, row.getString("subject"));
            Long billTypeId = row.getLong("billtype");
            Long taskTypeId = row.getLong("tasktypeid");
            String key = Long.toString(billTypeId) + "_" + taskTypeId;
            if (billAndTaskTypeBillIdsMap.get(key) != null) {
                billIdSet = (HashSet<Long>)billAndTaskTypeBillIdsMap.get(key);
                billIdSet.add(row.getLong("billlongid"));
            } else {
                billIdSet = new HashSet<Long>(16);
                billIdSet.add(row.getLong("billlongid"));
                billAndTaskTypeBillIdsMap.put(key, billIdSet);
            }
            if (billAndTaskTypeTaskSetMap.get(key) != null) {
                taskIdSet = (HashSet<Long>)billAndTaskTypeTaskSetMap.get(key);
                taskIdSet.add(l);
                continue;
            }
            taskIdSet = new HashSet<Long>(16);
            taskIdSet.add(l);
            billAndTaskTypeTaskSetMap.put(key, taskIdSet);
        }
        HashMap<Long, DynamicObjectCollection> taskIdArtiCheckPointsMap = new HashMap<Long, DynamicObjectCollection>(16);
        for (Map.Entry entry : billAndTaskTypeTaskSetMap.entrySet()) {
            String billAndTaskType = (String)entry.getKey();
            String[] billAndTaskTypes = billAndTaskType.split("_");
            Long billTypeId = Long.parseLong(billAndTaskTypes[0]);
            Long taskTypeId = Long.parseLong(billAndTaskTypes[1]);
            Map<Long, DynamicObjectCollection> billIdArtiCheckPoints = this.getArtiCheckPointByBillTypeId(billTypeId, taskTypeId, (Collection)billAndTaskTypeBillIdsMap.get(billAndTaskType));
            Set taskSet = (Set)entry.getValue();
            for (Long task : taskSet) {
                Long billId = (Long)taskBillIdMap.get(task);
                DynamicObjectCollection artiCheckPointsColl = billIdArtiCheckPoints.get(billId);
                taskIdArtiCheckPointsMap.put(task, artiCheckPointsColl);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("taskIdSubjectMap", taskIdSubjectMap);
        resultMap.put("taskIdArtiCheckPointsMap", taskIdArtiCheckPointsMap);
        return resultMap;
    }

    private String getSubjectFromTask(long taskId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"subject");
        return dynamicObject.getString("subject");
    }

    private static class InstanceHolder {
        private static final ArtiCheckPointService INSTANCE = new ArtiCheckPointService();

        private InstanceHolder() {
        }
    }
}

