/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.orgchange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.event.AbstractOrgChangeEventServicePlugin;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.task.orgchange.BaseDataServiceHelper;

public class OrgRootChangeServicePlugin
extends AbstractOrgChangeEventServicePlugin {
    private static final Log log = LogFactory.getLog(OrgRootChangeServicePlugin.class);

    protected OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent evt) {
        return this.returnCheckReport(evt);
    }

    public OrgChangeCheckReport returnCheckReport(KDBizEvent evt) {
        JSONObject operationParams;
        log.info("returnCheckReport start");
        OrgChangeCheckReport orgChangeCheckReport = new OrgChangeCheckReport();
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        if (variables == null) {
            log.info("returnCheckReport end");
            return orgChangeCheckReport;
        }
        log.info("returnCheckReport variables = {}", (Object)variables.toJSONString());
        Object subscriptionId = variables.get((Object)"subscription_id");
        if (Objects.nonNull(subscriptionId)) {
            orgChangeCheckReport.setEventId(Long.valueOf(subscriptionId.toString()));
        }
        if ((operationParams = variables.getJSONObject("base_orgchange_resetroot")) == null) {
            log.info("returnCheckReport end");
            return orgChangeCheckReport;
        }
        String changeRecordId = operationParams.getString("changerecordid");
        orgChangeCheckReport.setChangeRecordId(Long.valueOf(changeRecordId));
        JSONArray synViewArray = operationParams.getJSONArray("synviews");
        if (CollectionUtils.isEmpty((Collection)synViewArray)) {
            orgChangeCheckReport.setCheckStatus("P");
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OrgRootChangeServicePlugin_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        } else {
            try {
                this.doReturnCheckReport(orgChangeCheckReport, synViewArray);
            }
            catch (Exception e) {
                log.error("\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\u3002", (Throwable)e);
                String result = ResManager.loadKDString((String)"\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"OrgRootChangeServicePlugin_2", (String)"ssc-task-upgradeservice", (Object[])new Object[]{e.getMessage()});
                orgChangeCheckReport.setCheckStatus("W");
                orgChangeCheckReport.setCheckResult(result);
            }
        }
        log.info("returnCheckReport end");
        return orgChangeCheckReport;
    }

    private void doReturnCheckReport(OrgChangeCheckReport orgChangeCheckReport, JSONArray synViewArray) {
        long oldRootId = 0L;
        long newRootId = 0L;
        for (int i = 0; i < synViewArray.size(); ++i) {
            JSONObject jsonObject = synViewArray.getJSONObject(i);
            String viewId = jsonObject.getString("viewid");
            if (!"01".equals(viewId) && !"15".equals(viewId)) continue;
            oldRootId = jsonObject.getLong("oldrootid");
            newRootId = jsonObject.getLong("newrootid");
            break;
        }
        if (oldRootId != 0L && newRootId != 0L) {
            BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
            List checkDetails = baseDataServiceHelper.changeRootOrgBdUp(oldRootId, newRootId);
            if (CollectionUtils.isEmpty((Collection)checkDetails)) {
                orgChangeCheckReport.setCheckStatus("P");
                orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OrgRootChangeServicePlugin_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
            } else {
                orgChangeCheckReport.setCheckStatus("W");
                orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u5b58\u5728\u6839\u7ec4\u7ec7\u7ef4\u62a4\u7684\u975e\u79c1\u6709\u57fa\u7840\u8d44\u6599\u3002", (String)"OrgRootChangeServicePlugin_3", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                orgChangeCheckReport.setDetails(checkDetails);
            }
        }
    }
}

