/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaskBillNewBindBillUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_SQL = "SELECT fid, fbindbill FROM t_tk_taskmainbill WHERE (fbindbill_new = '' OR fbindbill_new = ' ')";
    private static final String UPDATE_SQL = "UPDATE t_tk_taskmainbill SET fbindbill_new = ? WHERE fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String algoKey = "upgradeNewBindBillField";
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        HashMap entityTBillMap = new HashMap(64);
        try (DataSet ds = DB.queryDataSet((String)"upgradeNewBindBillField_0", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL);){
            ds.forEach(d -> entityTBillMap.computeIfAbsent(d.getString("fbindbill"), k -> new HashSet(8)).add(d.getLong("fid")));
        }
        if (entityTBillMap.size() > 0) {
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(entityTBillMap.size());
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("SELECT fid,fnumber FROM t_meta_formdesign WHERE", new Object[0]).appendIn("fid", entityTBillMap.keySet().toArray());
            try (DataSet ds = DB.queryDataSet((String)"upgradeNewBindBillField_1", (DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder);){
                for (Row row : ds) {
                    String entityId = row.getString("fid");
                    String entityNumber = row.getString("fnumber");
                    for (Long taskBillId : (Set)entityTBillMap.get(entityId)) {
                        Object[] param = new Object[]{entityNumber, taskBillId};
                        updateParams.add(param);
                    }
                }
            }
            if (updateParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL, updateParams);
                upgradeResult.setLog("upgrade t_tk_taskmainbill of fbindbill_new is success.upgrade data size:" + updateParams.size());
            } else {
                upgradeResult.setLog("no data need upgrade.");
            }
        } else {
            upgradeResult.setLog("no data need upgrade.");
        }
        return upgradeResult;
    }
}

