/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.factor;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.enums.achieve.CalFactorFieldConfigEnum;
import kd.ssc.enums.achieve.FactorAggTypeEnum;
import kd.ssc.task.business.achieve.factor.IFactorComputeEngine;

public class EntityFactorCompute
implements IFactorComputeEngine {
    private static final Log LOGGER = LogFactory.getLog(EntityFactorCompute.class);
    private static final String LOG_PREFIX = "-- ssc achieve EntityFactorCompute --";
    private static final String ALGO_KEY = "fi.ssc.achieve.computeFactorValue";
    private static final String DATA_ERROR = "fi.ssc.factorDataError";
    private static final String COMPUTE_ERROR = "fi.ssc.factorComputeError";

    private EntityFactorCompute() {
    }

    public static IFactorComputeEngine getInstance() {
        return EntityFactorComputeInstance.INSTANCE;
    }

    public Object computeFactorValue(Long mainOrgId, Long factorId, String assessType, Long assessObjectId, Date startDate, Date endDate) {
        Map<Long, Object> values = this.computeFactorValues(mainOrgId, factorId, assessType, Collections.singleton(assessObjectId), startDate, endDate);
        if (values == null) {
            return null;
        }
        return values.get(assessObjectId);
    }

    public Map<Long, Object> batchComputeFactor(Long mainOrgId, Long factorId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        return this.computeFactorValues(mainOrgId, factorId, assessType, assessObjectIds, startDate, endDate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Object> computeFactorValues(Long mainOrgId, Long factorId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        Iterator iterator;
        HashMap<Long, Object> result;
        String assessObjField;
        block36: {
            String selectFields;
            AssessTypeEnum assessTypeEnum = AssessTypeEnum.getAssessTypeByValue((String)assessType);
            if (assessTypeEnum == null) {
                return null;
            }
            String factorSelectFields = "id,number,entityobject,conditionjson,aggmode,aggfieldnumber,fieldmapping";
            DynamicObject factorDetailInfo = BusinessDataServiceHelper.loadSingle((Object)factorId, (String)"ssc_calculationfactor", (String)factorSelectFields);
            this.checkData(factorDetailInfo);
            String entityNumber = factorDetailInfo.getString("entityobject.number");
            QFilter[] dataFiler = this.buildQFilter(mainOrgId, factorDetailInfo, assessTypeEnum, assessObjectIds, startDate, endDate);
            String aggField = factorDetailInfo.getString("aggfieldnumber");
            FactorAggTypeEnum aggModel = this.getAggType(factorDetailInfo.getString("aggmode"));
            assessObjField = this.getAssessObjMappingField(assessTypeEnum, factorDetailInfo.getString("fieldmapping"));
            boolean aggSameAssess = aggField.equals(assessObjField);
            boolean aggSameAssessAndCount = false;
            if (aggSameAssess) {
                if (FactorAggTypeEnum.COUNT != aggModel) {
                    ErrorCode code = new ErrorCode(COMPUTE_ERROR, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u914d\u7f6e\u9519\u8bef\uff1a\u805a\u5408\u5b57\u6bb5\u548c\u8bc4\u4ef7\u5bf9\u8c61\u5b57\u6bb5\u76f8\u540c\u4f46\u805a\u5408\u65b9\u5f0f\u4e0d\u4e3a\u8ba1\u6570\u3002", (String)"EntityFactorCompute_8", (String)"ssc-task-business", (Object[])new Object[0]));
                    throw new KDException(code, new Object[0]);
                }
                selectFields = aggField;
                aggSameAssessAndCount = true;
            } else {
                selectFields = aggField + "," + assessObjField;
            }
            String[] groupField = new String[]{assessObjField};
            result = new HashMap<Long, Object>();
            this.handleNoDataCase(aggModel, assessObjectIds, result);
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)entityNumber, (String)selectFields, (QFilter[])dataFiler, null);){
                DataSet groupDataSet;
                if (!dSet.hasNext()) {
                    HashMap<Long, Object> hashMap = result;
                    return hashMap;
                }
                if (aggSameAssessAndCount) {
                    iterator = dSet.iterator();
                    break block36;
                }
                switch (aggModel) {
                    case SUM: {
                        groupDataSet = dSet.groupBy(groupField).sum(aggField).finish();
                        break;
                    }
                    case COUNT: {
                        groupDataSet = dSet.groupBy(groupField).count(aggField).finish();
                        break;
                    }
                    case AVG: {
                        groupDataSet = dSet.groupBy(groupField).avg(aggField).finish();
                        break;
                    }
                    case MAX: {
                        groupDataSet = dSet.groupBy(groupField).max(aggField).finish();
                        break;
                    }
                    case MIN: {
                        groupDataSet = dSet.groupBy(groupField).min(aggField).finish();
                        break;
                    }
                    default: {
                        Map<Long, Object> row = null;
                        return row;
                    }
                }
                while (groupDataSet.hasNext()) {
                    Row row = groupDataSet.next();
                    result.put(row.getLong(assessObjField), row.get(aggField));
                }
                return result;
            }
            catch (Exception e) {
                LOGGER.error("-- ssc achieve EntityFactorCompute --compute achieve factor value error.", (Throwable)e);
                ErrorCode code = new ErrorCode(COMPUTE_ERROR, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u8ba1\u7b97\u51fa\u9519\uff1a%s", (String)"EntityFactorCompute_7", (String)"ssc-task-business", (Object[])new Object[0]), e.getMessage()));
                throw new KDException(code, new Object[0]);
            }
        }
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long assessObjId = row.getLong(assessObjField);
            Integer count = (Integer)result.get(assessObjId);
            if (count == null) {
                result.put(assessObjId, 1);
                continue;
            }
            count = count + 1;
            result.put(assessObjId, count);
        }
        return result;
    }

    private void checkData(DynamicObject factorData) {
        if (factorData == null) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u4e0d\u5b58\u5728\u3002", (String)"EntityFactorCompute_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String entityNumber = factorData.getString("entityobject.number");
        if (entityNumber == null) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u672a\u914d\u7f6e\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"EntityFactorCompute_1", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String fieldMapping = factorData.getString("fieldmapping");
        if (StringUtils.isEmpty((String)fieldMapping)) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u4e0d\u5b58\u5728\u5b57\u6bb5\u6620\u5c04\u3002", (String)"EntityFactorCompute_2", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String aggFieldNumber = factorData.getString("aggfieldnumber");
        if (StringUtils.isEmpty((String)aggFieldNumber)) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u201c\u805a\u5408\u5bf9\u8c61\u201d\u3002", (String)"EntityFactorCompute_4", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String aggModel = factorData.getString("aggmode");
        if (StringUtils.isEmpty((String)aggModel)) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u201c\u805a\u5408\u65b9\u5f0f\u201d\u3002", (String)"EntityFactorCompute_5", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    private QFilter[] buildQFilter(Long mainOrgId, DynamicObject factorData, AssessTypeEnum assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        String sscOrgField;
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        String conditionJson = factorData.getString("conditionjson");
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            String entityNumber = factorData.getString("entityobject.number");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
            filterBuilder.buildFilter(false);
            filter.addAll(filterBuilder.getQFilters());
        }
        String fieldMapping = factorData.getString("fieldmapping");
        JSONObject jsonObject = JSONObject.parseObject((String)fieldMapping);
        String dateField = this.getMappingField(jsonObject, CalFactorFieldConfigEnum.ACHIEVE_ACCESS_TIME, true);
        QFilter dateFilter = new QFilter(dateField, ">=", (Object)startDate);
        dateFilter.and(new QFilter(dateField, "<=", (Object)endDate));
        filter.add(dateFilter);
        CalFactorFieldConfigEnum fieldConfigEnum = assessType.getFactorFieldConfigEnum();
        String assessObjField = this.getMappingField(jsonObject, fieldConfigEnum, true);
        QFilter assessObjFilter = new QFilter(assessObjField, "in", assessObjectIds);
        filter.add(assessObjFilter);
        if (AssessTypeEnum.SSC_ORG != assessType && mainOrgId != null && StringUtils.isNotEmpty((String)(sscOrgField = this.getMappingField(jsonObject, CalFactorFieldConfigEnum.ACHIEVE_SSC, false)))) {
            QFilter sscFilter = new QFilter(sscOrgField, "=", (Object)mainOrgId);
            filter.add(sscFilter);
        }
        return filter.toArray(new QFilter[0]);
    }

    private String getMappingField(JSONObject mappingJson, CalFactorFieldConfigEnum fieldType, boolean mustNeed) {
        String fieldNumber;
        JSONObject fieldMap = mappingJson.getJSONObject(fieldType.getFieldKey());
        String string = fieldNumber = fieldMap == null ? null : fieldMap.getString("fieldNumber");
        if (mustNeed && (fieldNumber == null || StringUtils.isEmpty((String)fieldNumber))) {
            ErrorCode code = new ErrorCode(DATA_ERROR, String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u7684\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"EntityFactorCompute_3", (String)"ssc-task-business", (Object[])new Object[0]), fieldType.getFieldName()));
            throw new KDException(code, new Object[0]);
        }
        return fieldNumber;
    }

    private String getAssessObjMappingField(AssessTypeEnum assessType, String allFieldMapping) {
        JSONObject jsonObject = JSONObject.parseObject((String)allFieldMapping);
        CalFactorFieldConfigEnum fieldConfigEnum = assessType.getFactorFieldConfigEnum();
        return this.getMappingField(jsonObject, fieldConfigEnum, true);
    }

    private FactorAggTypeEnum getAggType(String aggTypeValue) {
        FactorAggTypeEnum aggType = FactorAggTypeEnum.getFactorAggTypeByValue((String)aggTypeValue);
        if (aggType == null) {
            ErrorCode code = new ErrorCode(DATA_ERROR, String.format(ResManager.loadKDString((String)"%s\u7684\u805a\u5408\u65b9\u5f0f\u4e0d\u5b58\u5728\u3002", (String)"EntityFactorCompute_6", (String)"ssc-task-business", (Object[])new Object[0]), aggTypeValue));
            throw new KDException(code, new Object[0]);
        }
        return aggType;
    }

    private void handleNoDataCase(FactorAggTypeEnum aggModel, Set<Long> assessObjectIds, Map<Long, Object> returnValues) {
        if (FactorAggTypeEnum.COUNT == aggModel || FactorAggTypeEnum.SUM == aggModel) {
            for (Long assessObj : assessObjectIds) {
                returnValues.computeIfAbsent(assessObj, key -> 0);
            }
        }
    }

    private static class EntityFactorComputeInstance {
        private static final IFactorComputeEngine INSTANCE = new EntityFactorCompute();

        private EntityFactorComputeInstance() {
        }
    }
}

