/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.indicator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.enums.achieve.FactorTypeEnum;
import kd.ssc.task.business.achieve.factor.IFactorComputeEngine;
import kd.ssc.task.business.achieve.factory.FactorComputeFactory;

public class CompIndicatorActualCompute {
    private static final Log LOGGER = LogFactory.getLog(CompIndicatorActualCompute.class);
    private static final String LOG_PREFIX = "-- ssc achieve CompIndicatorActualCompute --";
    private static final String ERROR_CODE = "fi.ssc.computeIndicatorActualError";
    private final Long mainOrgId;
    private final Long indicatorId;
    private final Date startDate;
    private final Date endDate;
    private String formulaExpression;
    private Set<String> vars;
    private Map<String, DynamicObject> factorsData;
    private Map<Long, Map<String, Object>> compedFactors;

    public CompIndicatorActualCompute(Long mainOrgId, Long indicatorId, Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.mainOrgId = mainOrgId;
        if (indicatorId == null || indicatorId.equals(0L)) {
            ErrorCode code = new ErrorCode(ERROR_CODE, ResManager.loadKDString((String)"\u6784\u9020\u8ba1\u7b97\u6307\u6807\u5b9e\u9645\u503c\u8ba1\u7b97\u5bf9\u8c61\u5931\u8d25\uff0c\u4f20\u5165\u7a7a\u6307\u6807\u3002", (String)"CompIndicatorActualCompute_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        this.indicatorId = indicatorId;
        String ruleJson = this.queryIndicatorRuleJson(indicatorId);
        this.prepareFormulaData(ruleJson);
        this.prepareFactorData();
    }

    public CompIndicatorActualCompute(Long mainOrgId, DynamicObject indicator, Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.mainOrgId = mainOrgId;
        if (indicator == null) {
            ErrorCode code = new ErrorCode(ERROR_CODE, ResManager.loadKDString((String)"\u6784\u9020\u8ba1\u7b97\u6307\u6807\u5b9e\u9645\u503c\u8ba1\u7b97\u5bf9\u8c61\u5931\u8d25\uff0c\u4f20\u5165\u7a7a\u6307\u6807\u3002", (String)"CompIndicatorActualCompute_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        this.indicatorId = indicator.getLong("id");
        String ruleJson = indicator.getString("ruleexpjson_tag");
        this.prepareFormulaData(ruleJson);
        this.prepareFactorData();
    }

    public BigDecimal computeIndicatorActualValue(String assessType, Long assessObjId) {
        if (this.compedFactors == null) {
            this.compedFactors = new HashMap<Long, Map<String, Object>>();
        }
        this.checkAssessType(assessType);
        Map thisCompedFactors = this.compedFactors.computeIfAbsent(assessObjId, a -> new HashMap());
        HashMap<String, Object> paramCtx = new HashMap<String, Object>(16);
        for (String var : this.vars) {
            Object compedFactorValue = thisCompedFactors.get(var);
            if (compedFactorValue == null) {
                try {
                    IFactorComputeEngine factorCompute = this.getFactorComputeEngine(var);
                    long factorId = this.factorsData.get(var).getLong("id");
                    Object factorValue = factorCompute.computeFactorValue(this.mainOrgId, Long.valueOf(factorId), assessType, assessObjId, this.startDate, this.endDate);
                    this.checkParamIsNull(var, factorValue);
                    thisCompedFactors.put(var, factorValue);
                    paramCtx.put(var, factorValue);
                    continue;
                }
                catch (Exception e) {
                    ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50%1s\u8ba1\u7b97\u9519\u8bef\uff1a%2s\u3002", (String)"CompIndicatorActualCompute_6", (String)"ssc-task-business", (Object[])new Object[0]), this.factorsData.get(var).getString("number"), e.getMessage()));
                    throw new KDException(code, new Object[0]);
                }
            }
            paramCtx.put(var, compedFactorValue);
        }
        return this.runFormula(paramCtx, assessType, assessObjId);
    }

    public Map<Long, BigDecimal> batchComputeIndicatorActualValue(String assessType, Set<Long> assessObjIds) {
        if (this.compedFactors == null) {
            this.compedFactors = new HashMap<Long, Map<String, Object>>();
        }
        this.checkAssessType(assessType);
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(16);
        for (Long assessObj : assessObjIds) {
            Map thisCompedFactors = this.compedFactors.computeIfAbsent(assessObj, a -> new HashMap());
            HashMap<String, Object> paramCtx = new HashMap<String, Object>(16);
            for (String var : this.vars) {
                Object compedFactorValue = thisCompedFactors.get(var);
                if (compedFactorValue == null) {
                    IFactorComputeEngine factorCompute = this.getFactorComputeEngine(var);
                    long factorId = this.factorsData.get(var).getLong("id");
                    try {
                        Map batchFactorValue = factorCompute.batchComputeFactor(this.mainOrgId, Long.valueOf(factorId), assessType, assessObjIds, this.startDate, this.endDate);
                        Object factorValue = batchFactorValue.get(assessObj);
                        this.checkParamIsNull(var, factorValue);
                        paramCtx.put(var, factorValue);
                        for (Map.Entry ele : batchFactorValue.entrySet()) {
                            this.compedFactors.computeIfAbsent((Long)ele.getKey(), (Function<Long, Map<String, Object>>)((Function<Long, Map>)a -> new HashMap())).put(var, ele.getValue());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error(LOG_PREFIX + String.format("compute the actual value of %s factor occur error:", this.factorsData.get(var).getString("number")), (Throwable)e);
                        ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50%1s\u8ba1\u7b97\u9519\u8bef\uff1a%2s\u3002", (String)"CompIndicatorActualCompute_6", (String)"ssc-task-business", (Object[])new Object[0]), var, e.getMessage()));
                        throw new KDException(code, new Object[0]);
                    }
                }
                paramCtx.put(var, compedFactorValue);
            }
            result.put(assessObj, this.runFormula(paramCtx, assessType, assessObj));
        }
        return result;
    }

    private void prepareFormulaData(String ruleExpJson) {
        if (ruleExpJson == null) {
            ErrorCode code = new ErrorCode(ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u8ba1\u7b97\u7c7b\u578b\u7ee9\u6548\u6307\u6807\u4e0d\u5b58\u5728\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CompIndicatorActualCompute_1", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)ruleExpJson, CRFormula.class);
        this.formulaExpression = crFormula.getExpression();
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        this.vars = bosExpression.getVars();
    }

    private void prepareFactorData() {
        QFilter numberFilter = new QFilter("number", "in", this.vars);
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter useOrgFilter = baseDataService.getBaseDataFilter("ssc_calculationfactor", this.mainOrgId);
        String selectFields = "id,number,datasource";
        DynamicObjectCollection factors = QueryServiceHelper.query((String)"ssc_calculationfactor", (String)selectFields, (QFilter[])new QFilter[]{numberFilter, useOrgFilter});
        if (factors == null) {
            ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6307\u6807\u516c\u5f0f\u4e2d\u7684\u8ba1\u7b97\u56e0\u5b50%s\u4e0d\u5b58\u5728\uff0c\u6216\u5f53\u524d\u7ec4\u7ec7\u65e0\u4f7f\u7528\u6743\u3002", (String)"CompIndicatorActualCompute_2", (String)"ssc-task-business", (Object[])new Object[0]), this.vars));
            throw new KDException(code, new Object[0]);
        }
        Map<String, DynamicObject> factorsMap = factors.stream().collect(Collectors.toMap(f -> f.getString("number"), f -> f, (f1, f2) -> f1));
        if (!factorsMap.keySet().containsAll(this.vars)) {
            this.vars.removeAll(factorsMap.keySet());
            ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6307\u6807\u516c\u5f0f\u4e2d\u7684\u8ba1\u7b97\u56e0\u5b50%s\u4e0d\u5b58\u5728\uff0c\u6216\u5f53\u524d\u7ec4\u7ec7\u65e0\u4f7f\u7528\u6743\u3002", (String)"CompIndicatorActualCompute_2", (String)"ssc-task-business", (Object[])new Object[0]), this.vars));
            throw new KDException(code, new Object[0]);
        }
        this.factorsData = factorsMap;
    }

    private String queryIndicatorRuleJson(Long indicatorId) {
        QFilter idFilter = new QFilter("id", "=", (Object)indicatorId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"ssc_achievetarget", (String)"ruleexpjson_tag", (QFilter[])idFilter.toArray());
        return dyn == null ? null : dyn.getString("ruleexpjson_tag");
    }

    private IFactorComputeEngine getFactorComputeEngine(String factorNumber) {
        DynamicObject factor = this.factorsData.get(factorNumber);
        FactorTypeEnum type = FactorTypeEnum.getFactorTypeByValue((String)factor.getString("datasource"));
        if (type == null) {
            ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6307\u6807\u516c\u5f0f\u4e2d\u7684\u8ba1\u7b97\u56e0\u5b50%s\u7c7b\u578b\u9519\u8bef\u3002", (String)"CompIndicatorActualCompute_3", (String)"ssc-task-business", (Object[])new Object[0]), factor.getString("number")));
            throw new KDException(code, new Object[0]);
        }
        return FactorComputeFactory.getFactorComputeInstance((FactorTypeEnum)type);
    }

    protected BigDecimal runFormula(Map<String, Object> paramCtx, String assessType, Long assessObj) {
        LOGGER.info("-- ssc achieve CompIndicatorActualCompute --paramCtx is :" + paramCtx);
        try {
            Object actualValue = FormulaEngine.runFormula((String)this.formulaExpression, paramCtx);
            return this.getBigDecimal(actualValue);
        }
        catch (RunFormulaException e) {
            LOGGER.error(LOG_PREFIX + String.format("compute the actual value of %s indicator occur error.assObjId:%s,errorInfo:", this.indicatorId, assessObj), (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    private void checkAssessType(String assessTypeStr) {
        AssessTypeEnum assessTypeEnum = AssessTypeEnum.getAssessTypeByValue((String)assessTypeStr);
        if (assessTypeEnum == null) {
            ErrorCode code = new ErrorCode("fi.ssc.indicatorDataError", ResManager.loadKDString((String)"\u201c\u8003\u6838\u5bf9\u8c61\u7c7b\u578b\u201d\u9519\u8bef\uff1a\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u3002", (String)"CompIndicatorActualCompute_10", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    protected String buildAssessObjInfo(String assessType, Long AssessObj) {
        String info = "";
        if ("2".equals(assessType)) {
            info = ResManager.loadKDString((String)"\u4eba\u5458", (String)"CompIndicatorActualCompute_7", (String)"ssc-task-business", (Object[])new Object[0]);
            QFilter idFilter = new QFilter("id", "=", (Object)AssessObj);
            DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"name", (QFilter[])idFilter.toArray());
            if (user != null) {
                info = info + user.getString("name");
            }
        } else if ("1".equals(assessType)) {
            info = ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"CompIndicatorActualCompute_8", (String)"ssc-task-business", (Object[])new Object[0]);
            QFilter idFilter = new QFilter("id", "=", (Object)AssessObj);
            DynamicObject group = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"name", (QFilter[])idFilter.toArray());
            if (group != null) {
                info = info + group.getString("name");
            }
        }
        return info;
    }

    private void checkParamIsNull(String factorNumber, Object factorValue) {
        if (factorValue == null) {
            ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50%s\u7684\u503c\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u56e0\u5b50\u7684\u914d\u7f6e\u6216\u5b9e\u73b0\u903b\u8f91\u3002", (String)"CompIndicatorActualCompute_9", (String)"ssc-task-business", (Object[])new Object[0]), factorNumber));
            throw new KDException(code, new Object[0]);
        }
    }

    protected BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(value.toString());
            } else {
                LOGGER.info("-- ssc achieve CompIndicatorActualCompute --Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
                ErrorCode code = new ErrorCode(ERROR_CODE, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6307\u6807\u7684\u5b9e\u9645\u503c\u8ba1\u7b97\u7ed3\u679c%s\u8f6c\u5316\u4e3a\u6570\u5b57\u5f62\u5f0f\u5931\u8d25\u3002", (String)"CompIndicatorActualCompute_5", (String)"ssc-task-business", (Object[])new Object[0]), value));
                throw new KDException(code, new Object[0]);
            }
        }
        return ret;
    }

    public Map<Long, Map<String, Object>> getCompedFactors() {
        return this.compedFactors;
    }

    public void setCompedFactors(Map<Long, Map<String, Object>> compedFactor) {
        this.compedFactors = compedFactor;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public Long getIndicatorId() {
        return this.indicatorId;
    }
}

