/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.enums.achieve.IndicatorTypeEnum;
import kd.ssc.task.business.achieve.indicator.CompIndicatorActualCompute;

public class AchieveSchemeConverter {
    private static final Log LOGGER = LogFactory.getLog(AchieveSchemeConverter.class);
    private static final String LOG_PREFIX = "-- ssc AchieveSchemeConverter --";
    private final DynamicObject scheme;
    private final Date startDate;
    private final Date endDate;
    private String assessType;
    private String assessObjFiledKey;
    private DynamicObjectCollection assessObjects;

    public AchieveSchemeConverter(DynamicObject scheme, Date startDate, Date endDate) {
        if (scheme == null) {
            ErrorCode code = new ErrorCode("fi.ssc.schemeDataError", ResManager.loadKDString((String)"\u7ee9\u6548\u65b9\u6848\u8bc4\u4ef7\u5bf9\u8c61\u7c7b\u578b\u9519\u8bef\uff1a\u7ee9\u6548\u8bc4\u4ef7\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"AchieveSchemeConverter_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        this.scheme = scheme;
        this.startDate = startDate;
        this.endDate = endDate;
        this.prepareData();
    }

    public List<DynamicObject> buildEvaluationData() {
        if (this.assessObjects == null || this.assessObjects.size() < 1) {
            return null;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        long currUserId = RequestContext.get().getCurrUserId();
        Object ssc = this.scheme.get("sscid");
        String sscId = this.scheme.getString("sscid.id");
        Object assessPlanId = this.scheme.get("id");
        Object assessPeriod = this.scheme.get("assessperiod");
        boolean isSSCType = AssessTypeEnum.SSC_ORG.getValue().equals(this.assessType);
        DynamicObjectCollection schemeIndicEntry = this.scheme.getDynamicObjectCollection("entryentity_po");
        Map<Long, Map<Long, BigDecimal>> indicatorActualValues = this.computeIndicatorActualValue();
        for (DynamicObject assessObject : this.assessObjects) {
            Long assessObjId;
            DynamicObject newAchEva = BusinessDataServiceHelper.newDynamicObject((String)"ssc_achieveevalute");
            newAchEva.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"ssc_achieveevalute", (DynamicObject)newAchEva, (String)sscId));
            newAchEva.set("sscid", ssc);
            newAchEva.set("assessplanid", assessPlanId);
            newAchEva.set("assessperiod", assessPeriod);
            newAchEva.set("assessdimension", (Object)this.assessType);
            newAchEva.set("applicant", (Object)currUserId);
            if (isSSCType) {
                assessObjId = assessObject.getLong("id");
                newAchEva.set("assessname", assessObject.get("name"));
            } else {
                assessObjId = assessObject.getLong("fbasedataid.id");
                newAchEva.set(this.assessObjFiledKey, (Object)assessObjId);
                newAchEva.set("assessname", assessObject.get("fbasedataid.name"));
                if ("2".equals(this.assessType)) {
                    newAchEva.set("applicant", (Object)assessObjId);
                    long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)assessObjId);
                    newAchEva.set("dept", (Object)userMainOrgId);
                }
            }
            newAchEva.set("periodstart", (Object)this.startDate);
            newAchEva.set("periodend", (Object)this.endDate);
            newAchEva.set("createtime", (Object)new Date());
            newAchEva.set("creator", (Object)currUserId);
            newAchEva.set("enable", (Object)"1");
            newAchEva.set("status", (Object)"A");
            DynamicObjectCollection evaluationEntry = newAchEva.getDynamicObjectCollection("entryentity_po");
            for (DynamicObject row : schemeIndicEntry) {
                DynamicObject addNew = evaluationEntry.addNew();
                addNew.set("poachieveid", row.get("poachieveid"));
                addNew.set("potargettype", row.get("potargettype"));
                addNew.set("pounitid", row.get("pounitid"));
                addNew.set("postandard", row.get("postandard"));
                addNew.set("potarget", row.get("potarget"));
                addNew.set("poweight", row.get("poweight"));
                addNew.set("scoringstandard", row.get("podescription"));
                Long indicatorId = row.getLong("poachieveid.id");
                BigDecimal actualValue = indicatorActualValues.get(indicatorId) == null ? null : indicatorActualValues.get(indicatorId).get(assessObjId);
                addNew.set("poactual", actualValue);
            }
            result.add(newAchEva);
        }
        return result;
    }

    public Map<Long, Map<Long, BigDecimal>> computeIndicatorActualValue() {
        HashMap<Long, Map<Long, BigDecimal>> indicatorActualValues = new HashMap<Long, Map<Long, BigDecimal>>();
        DynamicObjectCollection schemeIndicEntry = this.scheme.getDynamicObjectCollection("entryentity_po");
        Set indicatorIds = schemeIndicEntry.stream().map(i -> i.getLong("poachieveid.id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", indicatorIds);
        String selectFields = "id,number,targettype,ruleexpjson_tag,maxscore,minscore,setup,setdown";
        DynamicObjectCollection indicators = QueryServiceHelper.query((String)"ssc_achievetarget", (String)selectFields, (QFilter[])idFilter.toArray());
        Set<Long> assessObjIds = AssessTypeEnum.SSC_ORG.getValue().equals(this.assessType) ? this.assessObjects.stream().map(a -> a.getLong("id")).collect(Collectors.toSet()) : this.assessObjects.stream().map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toSet());
        Map<Long, Map<String, Object>> compedFactor = null;
        for (DynamicObject indicator : indicators) {
            long id = indicator.getLong("id");
            if (indicatorActualValues.containsKey(id)) continue;
            IndicatorTypeEnum targetType = IndicatorTypeEnum.getIndicatorTypeByValue((String)indicator.getString("targettype"));
            if (targetType == null) {
                ErrorCode code = new ErrorCode("fi.ssc.indicatorDataError", String.format(ResManager.loadKDString((String)"\u7ee9\u6548\u6307\u6807%s\u7c7b\u578b\u9519\u8bef\uff1a\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u7ee9\u6548\u6307\u6807\u3002", (String)"AchieveSchemeConverter_2", (String)"ssc-task-business", (Object[])new Object[0]), indicator.getPkValue()));
                throw new KDException(code, new Object[0]);
            }
            switch (targetType) {
                case COMPUTABILITY_INDICATOR: {
                    try {
                        CompIndicatorActualCompute actualCompute = new CompIndicatorActualCompute((Long)this.scheme.getLong("sscid.id"), indicator, this.startDate, this.endDate);
                        actualCompute.setCompedFactors(compedFactor);
                        Map<Long, BigDecimal> elementActualValue = actualCompute.batchComputeIndicatorActualValue(this.assessType, assessObjIds);
                        compedFactor = actualCompute.getCompedFactors();
                        indicatorActualValues.put(id, elementActualValue);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("-- ssc AchieveSchemeConverter --compute indicator actual value error:", (Throwable)e);
                        ErrorCode code = new ErrorCode("fi.ssc.computeIndicatorActualError", String.format(ResManager.loadKDString((String)"\u7ee9\u6548\u6307\u6807%1s\u5b9e\u9645\u503c\u8ba1\u7b97\u9519\u8bef\uff1a%2s", (String)"AchieveSchemeConverter_3", (String)"ssc-task-business", (Object[])new Object[0]), indicator.getString("number"), e.getMessage()));
                        throw new KDException(code, new Object[0]);
                    }
                }
                case SUBJECTIVITY_INDICATOR: {
                    indicatorActualValues.put(id, null);
                }
            }
        }
        return indicatorActualValues;
    }

    private void prepareData() {
        this.assessType = this.scheme.getString("assessobject");
        AssessTypeEnum assessTypeEnum = AssessTypeEnum.getAssessTypeByValue((String)this.assessType);
        if (assessTypeEnum == null) {
            ErrorCode code = new ErrorCode("fi.ssc.schemeDataError", String.format(ResManager.loadKDString((String)"\u7ee9\u6548\u65b9\u6848\u8bc4\u4ef7\u5bf9\u8c61\u7c7b\u578b\u9519\u8bef\uff1a\u6ca1\u6709%s\u7c7b\u578b\u7684\u8bc4\u4ef7\u65b9\u6848\u3002", (String)"AchieveSchemeConverter_1", (String)"ssc-task-business", (Object[])new Object[0]), this.assessType));
            throw new KDException(code, new Object[0]);
        }
        switch (assessTypeEnum) {
            case USER: {
                this.assessObjects = this.scheme.getDynamicObjectCollection("userids");
                this.assessObjFiledKey = "assessuserid";
                break;
            }
            case WORK_GROUP: {
                this.assessObjects = this.scheme.getDynamicObjectCollection("workgroups");
                this.assessObjFiledKey = "workgroup";
                break;
            }
            case SSC_ORG: {
                this.assessObjects = new DynamicObjectCollection();
                this.assessObjects.add((Object)this.scheme.getDynamicObject("sscid"));
                this.assessObjFiledKey = "sscid";
            }
        }
    }
}

