/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.business.boardv2.pojo.ChartData;
import kd.ssc.task.business.boardv2.pojo.MulSeriesData;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataHelper {
    public static DynamicObject getSscCurDyo(long sscId, String timeDim) {
        DynamicObject sscCurDyo;
        String selectFilter = "1".equalsIgnoreCase(timeDim) ? sscId + DateHelper.getCurDay() : ("3".equalsIgnoreCase(timeDim) ? sscId + DateHelper.getCurYear() : sscId + DateHelper.getCurMonth());
        QFilter qFilter = new QFilter("selectfilter", "=", (Object)selectFilter);
        if (QueryServiceHelper.exists((String)"som_task_ssc", (QFilter[])qFilter.toArray())) {
            sscCurDyo = BusinessDataServiceHelper.loadSingle((String)"som_task_ssc", (QFilter[])qFilter.toArray());
        } else {
            sscCurDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_task_ssc");
            sscCurDyo.set("sscid_id", (Object)sscId);
            sscCurDyo.set("querydate", (Object)new Date());
            sscCurDyo.set("timedim", (Object)timeDim);
            sscCurDyo.set("selectfilter", (Object)selectFilter);
        }
        return sscCurDyo;
    }

    public static List<DynamicObject> getSscCurDyo(long sscId, Collection<String> dateCol, String timeDim) {
        ArrayList<DynamicObject> sscCurDyoList = new ArrayList<DynamicObject>(dateCol.size());
        ArrayList<String> selectFilters = new ArrayList<String>(dateCol.size());
        for (String date : dateCol) {
            selectFilters.add(sscId + date);
        }
        SimpleDateFormat dateFormat = "1".equalsIgnoreCase(timeDim) ? new SimpleDateFormat("yyyy-MM-dd") : ("3".equalsIgnoreCase(timeDim) ? new SimpleDateFormat("yyyy") : new SimpleDateFormat("yyyy-MM"));
        QFilter qFilter = new QFilter("selectfilter", "in", selectFilters);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"som_task_ssc", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!ids.isEmpty()) {
            DynamicObject[] sscCurDyoArr;
            for (DynamicObject dyo : sscCurDyoArr = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"som_task_ssc"))) {
                dateCol.remove(dateFormat.format(dyo.getDate("querydate")));
            }
            sscCurDyoList.addAll(Arrays.asList(sscCurDyoArr));
        }
        for (String date : dateCol) {
            DynamicObject sscCurDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_task_ssc");
            sscCurDyo.set("sscid_id", (Object)sscId);
            try {
                sscCurDyo.set("querydate", (Object)dateFormat.parse(date));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            sscCurDyo.set("timedim", (Object)timeDim);
            sscCurDyo.set("selectfilter", (Object)(sscId + date));
            sscCurDyoList.add(sscCurDyo);
        }
        return sscCurDyoList;
    }

    public static DynamicObject getSscCurDyoFromCache(long sscId, String timeDim) {
        String selectFilter = "1".equalsIgnoreCase(timeDim) ? sscId + DateHelper.getCurDay() : ("3".equalsIgnoreCase(timeDim) ? sscId + DateHelper.getCurYear() : sscId + DateHelper.getCurMonth());
        QFilter qFilter = new QFilter("selectfilter", "=", (Object)selectFilter);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"som_task_ssc", (QFilter[])qFilter.toArray());
    }

    public static List<DynamicObject> getSscCurDyoFromCache(String selectFilter, String selectFilterNotLike, String selectFields, String orderByColumn, String sc) {
        QFilter qFilter = new QFilter("selectfilter", "like", (Object)selectFilter).and("selectfilter", "not like", (Object)selectFilterNotLike);
        List<Object> resultList = new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"som_task_ssc", (String)selectFields, (QFilter[])qFilter.toArray()).values());
        if (StringUtils.isNotBlank((CharSequence)orderByColumn)) {
            resultList = resultList.stream().sorted(Comparator.comparingDouble(a -> NumberUtils.toDouble((String)a.getString(orderByColumn), (double)0.0))).collect(Collectors.toList());
            if ("desc".equalsIgnoreCase(sc)) {
                Collections.reverse(resultList);
            }
        }
        return resultList;
    }

    public static List<DynamicObject> getSscCurDyoFromCache(String selectFilter, String selectFilterNotLike) {
        QFilter qFilter = new QFilter("selectfilter", "like", (Object)selectFilter).and("selectfilter", "not like", (Object)selectFilterNotLike);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"som_task_ssc", (QFilter[])qFilter.toArray()).values());
    }

    public static List<DynamicObject> getGroupCurDyo(long sscId, Collection<Long> userGroupIds, String timeDim) {
        ArrayList<DynamicObject> groupCurDyoList = new ArrayList<DynamicObject>(userGroupIds.size());
        ArrayList<String> selectFilters = new ArrayList<String>(userGroupIds.size());
        for (Long userGroupId : userGroupIds) {
            if ("1".equalsIgnoreCase(timeDim)) {
                selectFilters.add(sscId + DateHelper.getCurDay() + userGroupId);
                continue;
            }
            if ("3".equalsIgnoreCase(timeDim)) {
                selectFilters.add(sscId + DateHelper.getCurYear() + userGroupId);
                continue;
            }
            selectFilters.add(sscId + DateHelper.getCurMonth() + userGroupId);
        }
        QFilter qFilter = new QFilter("selectfilter", "in", selectFilters);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"som_task_group", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!ids.isEmpty()) {
            DynamicObject[] groupCurDyoArr;
            for (DynamicObject dyo : groupCurDyoArr = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"som_task_group"))) {
                userGroupIds.remove(dyo.getLong("usergroup_id"));
            }
            groupCurDyoList.addAll(Arrays.asList(groupCurDyoArr));
        }
        for (Long userGroupId : userGroupIds) {
            DynamicObject groupCurDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_task_group");
            groupCurDyo.set("sscid_id", (Object)sscId);
            groupCurDyo.set("usergroup_id", (Object)userGroupId);
            groupCurDyo.set("querydate", (Object)new Date());
            groupCurDyo.set("timedim", (Object)timeDim);
            if ("1".equalsIgnoreCase(timeDim)) {
                groupCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurDay() + userGroupId));
            } else if ("3".equalsIgnoreCase(timeDim)) {
                groupCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurYear() + userGroupId));
            } else {
                groupCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurMonth() + userGroupId));
            }
            groupCurDyoList.add(groupCurDyo);
        }
        return groupCurDyoList;
    }

    public static List<DynamicObject> getGroupCurDyoFromCache(long sscId, String timeDim) {
        String selectFilter;
        String selectFilterNotLike = "";
        if ("1".equalsIgnoreCase(timeDim)) {
            selectFilter = sscId + DateHelper.getCurDay();
        } else if ("3".equalsIgnoreCase(timeDim)) {
            selectFilter = sscId + DateHelper.getCurYear();
            selectFilterNotLike = sscId + DateHelper.getCurYear() + "-%";
        } else {
            selectFilter = sscId + DateHelper.getCurMonth();
            selectFilterNotLike = sscId + DateHelper.getCurMonth() + "-%";
        }
        QFilter qFilter = new QFilter("selectfilter", "like", (Object)(selectFilter + '%')).and("selectfilter", "not like", (Object)selectFilterNotLike).and("usergroup_id", "!=", (Object)0L);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"som_task_group", (QFilter[])qFilter.toArray()).values());
    }

    public static List<DynamicObject> getGroupCurDyoFromCache(long sscId, String timeDim, String selectFields, String orderByColumn, String sc) {
        String selectFilter;
        String selectFilterNotLike = "";
        if ("1".equalsIgnoreCase(timeDim)) {
            selectFilter = sscId + DateHelper.getCurDay();
        } else if ("3".equalsIgnoreCase(timeDim)) {
            selectFilter = sscId + DateHelper.getCurYear();
            selectFilterNotLike = sscId + DateHelper.getCurYear() + "-%";
        } else {
            selectFilter = sscId + DateHelper.getCurMonth();
            selectFilterNotLike = sscId + DateHelper.getCurMonth() + "-%";
        }
        QFilter qFilter = new QFilter("selectfilter", "like", (Object)(selectFilter + '%')).and("selectfilter", "not like", (Object)selectFilterNotLike).and("usergroup_id", "!=", (Object)0L);
        List<Object> resultList = new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"som_task_group", (String)selectFields, (QFilter[])qFilter.toArray()).values());
        if (StringUtils.isNotBlank((CharSequence)orderByColumn)) {
            resultList = resultList.stream().sorted(Comparator.comparingDouble(a -> NumberUtils.toDouble((String)a.getString(orderByColumn), (double)0.0))).collect(Collectors.toList());
            if ("desc".equalsIgnoreCase(sc)) {
                Collections.reverse(resultList);
            }
        }
        return resultList;
    }

    public static Map<Object, DynamicObject> getGroupCurDyoMapFromCache(long sscId, String timeDim) {
        List<DynamicObject> groupCurDyoList = DataHelper.getGroupCurDyoFromCache(sscId, timeDim);
        HashMap<Object, DynamicObject> resultMap = new HashMap<Object, DynamicObject>(groupCurDyoList.size());
        for (DynamicObject dyo : groupCurDyoList) {
            resultMap.put(dyo.get("usergroup_id"), dyo);
        }
        return resultMap;
    }

    public static List<DynamicObject> getUserCurDyo(long sscId, Collection<Long> userIds, String timeDim) {
        ArrayList<DynamicObject> userCurDyoList = new ArrayList<DynamicObject>(userIds.size());
        ArrayList<String> selectFilters = new ArrayList<String>(userIds.size());
        for (Long userId : userIds) {
            if ("1".equalsIgnoreCase(timeDim)) {
                selectFilters.add(sscId + DateHelper.getCurDay() + userId);
                continue;
            }
            if ("3".equalsIgnoreCase(timeDim)) {
                selectFilters.add(sscId + DateHelper.getCurYear() + userId);
                continue;
            }
            selectFilters.add(sscId + DateHelper.getCurMonth() + userId);
        }
        QFilter qFilter = new QFilter("selectfilter", "in", selectFilters);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"som_task_user", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!ids.isEmpty()) {
            DynamicObject[] userCurDyoArr;
            for (DynamicObject dyo : userCurDyoArr = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"som_task_user"))) {
                userIds.remove(dyo.getLong("user_id"));
            }
            userCurDyoList.addAll(Arrays.asList(userCurDyoArr));
        }
        for (Long userId : userIds) {
            DynamicObject userCurDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_task_user");
            userCurDyo.set("sscid_id", (Object)sscId);
            userCurDyo.set("user_id", (Object)userId);
            userCurDyo.set("querydate", (Object)new Date());
            userCurDyo.set("timedim", (Object)timeDim);
            if ("1".equalsIgnoreCase(timeDim)) {
                userCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurDay() + userId));
            } else if ("3".equalsIgnoreCase(timeDim)) {
                userCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurYear() + userId));
            } else {
                userCurDyo.set("selectfilter", (Object)(sscId + DateHelper.getCurMonth() + userId));
            }
            userCurDyoList.add(userCurDyo);
        }
        return userCurDyoList;
    }

    public static Map<Long, Integer> calculateGroupDutyTime(DataSet dataSet) {
        HashMap<Long, Integer> groupDutyTimeMap = new HashMap<Long, Integer>(16);
        if (dataSet != null && !dataSet.isEmpty()) {
            for (Row row : dataSet) {
                Long userGroupId = row.getLong("groupid");
                String dutyTimeBitSet = row.getString("dutytimebitset");
                int minute = DataHelper.countOccurrences(dutyTimeBitSet, '1');
                groupDutyTimeMap.put(userGroupId, groupDutyTimeMap.computeIfAbsent(userGroupId, p -> 0) + minute);
            }
        }
        return groupDutyTimeMap;
    }

    public static Map<Object, BigDecimal> calculateGroupTaskLoad(DataSet monthTaskSumDataSet, Map<Object, DynamicObject> workGroupMap) {
        HashMap<Object, BigDecimal> workGroupTaskLoadMap = new HashMap<Object, BigDecimal>(workGroupMap.size());
        if (monthTaskSumDataSet != null && !monthTaskSumDataSet.isEmpty()) {
            HashMap<Object, BigDecimal> userGroupTaskLoadMap = new HashMap<Object, BigDecimal>(16);
            for (Row row : monthTaskSumDataSet) {
                userGroupTaskLoadMap.put(row.get("usergroup"), row.getBigDecimal("coefficient"));
            }
            for (Map.Entry<Object, DynamicObject> workGroupEntry : workGroupMap.entrySet()) {
                DynamicObjectCollection groups = workGroupEntry.getValue().getDynamicObjectCollection("entryentity");
                BigDecimal bigDecimal = new BigDecimal(0);
                for (DynamicObject group : groups) {
                    bigDecimal = bigDecimal.add(userGroupTaskLoadMap.computeIfAbsent(group.get("usergroup_id"), p -> new BigDecimal(0)));
                }
                workGroupTaskLoadMap.put(workGroupEntry.getKey(), bigDecimal);
            }
        }
        return workGroupTaskLoadMap;
    }

    public static Map<Object, Integer> calculateGroupDutyTime(DataSet dataSet, Map<Object, DynamicObject> workGroupMap) {
        HashMap<Object, Integer> workGroupDutyTimeMap = new HashMap<Object, Integer>(workGroupMap.size());
        if (dataSet != null && !dataSet.isEmpty()) {
            HashMap<Object, Map> userGroupDutyTimeMap = new HashMap<Object, Map>(workGroupMap.size());
            for (Row row : dataSet) {
                Object userGroupId = row.get("groupid");
                Object userId = row.get("userid");
                String dateStr = DateUtil.format((Object)row.getDate("daten"), (String)"yyyy-MM-dd");
                String dutyTimeBitSet = row.getString("dutytimebitset");
                Map userDutyTimeMap = userGroupDutyTimeMap.computeIfAbsent(userGroupId, p -> new HashMap(16));
                Map dateDutyTimeMap = userDutyTimeMap.computeIfAbsent(userId, p -> new HashMap(16));
                Object dutyTimeSet = dateDutyTimeMap.computeIfAbsent(dateStr, p -> new LinkedHashSet(360));
                dutyTimeSet.addAll(DataHelper.recordIndex(dutyTimeBitSet, '1'));
            }
            for (Map.Entry<Object, DynamicObject> workGroupEntry : workGroupMap.entrySet()) {
                DynamicObjectCollection groups = workGroupEntry.getValue().getDynamicObjectCollection("entryentity");
                HashMap<Object, Map> workGroupUserDutyTimeMap = new HashMap<Object, Map>(16);
                for (DynamicObject group : groups) {
                    Object userGroupId = group.get("usergroup_id");
                    Map userDutyTimeMap = (Map)userGroupDutyTimeMap.get(userGroupId);
                    if (userDutyTimeMap == null) continue;
                    for (Map.Entry entry : userDutyTimeMap.entrySet()) {
                        Map dateDutyTimeMap = workGroupUserDutyTimeMap.computeIfAbsent(entry.getKey(), p -> new HashMap(16));
                        for (Map.Entry dateDutyTimeEntry : ((Map)entry.getValue()).entrySet()) {
                            Set dutyTimeSet = dateDutyTimeMap.computeIfAbsent(dateDutyTimeEntry.getKey(), p -> new LinkedHashSet(360));
                            dutyTimeSet.addAll((Collection)dateDutyTimeEntry.getValue());
                        }
                    }
                }
                int minute = 0;
                for (Map dateDutyTimeMap : workGroupUserDutyTimeMap.values()) {
                    for (Object dutyTimeSet : dateDutyTimeMap.values()) {
                        minute += dutyTimeSet.size();
                    }
                }
                workGroupDutyTimeMap.put(workGroupEntry.getKey(), minute);
            }
        }
        return workGroupDutyTimeMap;
    }

    public static Set<Integer> recordIndex(String str, char ch) {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(360);
        int index = 0;
        while ((index = str.indexOf(ch, index)) != -1) {
            set.add(index++);
        }
        return set;
    }

    public static int countOccurrences(String str, char ch) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(ch, index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    public static Map<Object, DynamicObject> getWorkGroupFromCache(long sscId) {
        QFilter filter = new QFilter("createorg", "=", (Object)sscId).and("enable", "=", (Object)Character.valueOf('1'));
        return BusinessDataServiceHelper.loadFromCache((String)"task_workgroup", (QFilter[])filter.toArray());
    }

    public static Map<Long, BigDecimal> getOrgAvgScoreRank(Long sscId, ChartData c3008) {
        LinkedHashMap<Long, BigDecimal> resultMap = new LinkedHashMap<Long, BigDecimal>(10);
        HashSet showOrg = new HashSet(OrgRelationQueryHelper.getFromOrgList((long)sscId, (boolean)false));
        if (!showOrg.isEmpty()) {
            QFilter qFilter = new QFilter("company", "in", showOrg);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DataHelper.getOrgAvgScoreRank()", (String)"ssc_creditboardavgscore", (String)"company,company.name companyName,avgscore", (QFilter[])qFilter.toArray(), (String)"avgscore desc", (int)10);){
                int rank = 1;
                for (Row row : dataSet) {
                    resultMap.put(row.getLong("company"), row.getBigDecimal("avgscore").setScale(0, 4));
                    MulSeriesData mulSeriesData = new MulSeriesData();
                    c3008.addSeries(mulSeriesData);
                    mulSeriesData.addData(new Object[]{rank++, row.getString("companyName"), row.getBigDecimal("avgscore").setScale(1, 4).toString()});
                }
            }
        }
        return resultMap;
    }

    public static Long getWorkgroupId(Long userGroupId) {
        QFilter filter = new QFilter("entryentity.usergroup", "=", (Object)userGroupId);
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"task_workgroup", (QFilter[])filter.toArray(), null, (int)1);
        return objects.size() > 0 ? (Long)objects.get(0) : 0L;
    }
}

