/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.business.boardv2.helper.TimingLogger;
import kd.ssc.task.business.boardv2.pojo.RankModel;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.util.SSCBosUtil;
import kd.ssc.task.util.TaskParamControlUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskHistoryDataProcessor {
    private static final String TASK_TASKHISTORY = "task_taskhistory";
    private static final Log logger = LogFactory.getLog(TaskHistoryDataProcessor.class);
    private static final String PARAM_BOARD = "som_board_complete_";
    private final DecimalFormat d1 = new DecimalFormat("0.0");

    public void processData() {
        String cacheKey = PARAM_BOARD;
        String date = SSCBosUtil.getCtrlParam((String)cacheKey);
        List<String> dateList = DateHelper.getMonthsFromLastYearJanToNow(date);
        String completeDate = dateList.get(dateList.size() - 1);
        try (DataSet dataSet = ORM.create().queryDataSet("TaskHistoryDataProcessor#task_usergroup", "task_usergroup", "createorg", null, null, 0, 100000, (Distinctable)WithDistinctable.get());){
            for (Row row : dataSet) {
                TimingLogger timingLogger = new TimingLogger();
                Long sscId = row.getLong("createorg");
                ArrayList<String> list = new ArrayList<String>(dateList);
                logger.info(String.format("\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3%s\uff0c\u5373\u5c06\u5904\u7406\u6b64\u6708\u4efd\u7684\u6570\u636e\uff0c\u6708\u4efd\uff1a%s", sscId, list));
                this.processData(sscId, list);
                timingLogger.info(sscId + " process data", logger);
            }
            boolean somBoardLastYear = TaskParamControlUtil.writeBackParam((String)cacheKey, (String)completeDate);
            if (!somBoardLastYear) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"task_paramcontrol");
                object.set("paramname", (Object)cacheKey);
                object.set("number", (Object)cacheKey);
                object.set("paramvalue", (Object)completeDate);
                object.set("description", (Object)ResManager.loadKDString((String)"\u5171\u4eab\u770b\u677f\u6700\u65b0\u6570\u636e\uff08\u6708\u4efd\uff09", (String)"TaskHistoryDataProcessor_0", (String)"ssc-task-business", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processData(long sscId, List<String> dateList) throws ParseException {
        Object handDataSet22;
        Throwable allCnt22;
        Serializable autoRatio;
        Object autoDataSet22;
        Object querydate;
        Serializable dateFormat;
        Serializable allTaskCntMap22;
        Object allDataSet22;
        Object formatDataSet22;
        Iterator averageAging;
        List<DynamicObject> groupCurMonthDyoList;
        Object taskCount22;
        Serializable userGroupDoubleMap22;
        Object userGroupResultSet;
        TimingLogger timeLog = new TimingLogger();
        logger.info("ssc-task processData sscId : " + sscId);
        Date[] curDayRange = DateHelper.getCurDayRange();
        Date[] curMonthRange = DateHelper.getCurMonthRange();
        Date[] curYearRange = DateHelper.getCurYearRange();
        Date startDate = new SimpleDateFormat("yyyy-MM").parse(dateList.get(0));
        HashMap<Long, DynamicObject> groupCurMonthDyoMap = new HashMap<Long, DynamicObject>(16);
        List<String> lastYearJanToNowList = DateHelper.getMonthsFromLastYearJanToNow();
        List<DynamicObject> sscLastYearToNowMonthsDyo = DataHelper.getSscCurDyo(sscId, lastYearJanToNowList, "2");
        DynamicObject sscCurDayDyo = DataHelper.getSscCurDyo(sscId, "1");
        DynamicObject sscCurYearDyo = DataHelper.getSscCurDyo(sscId, "3");
        DynamicObject sscCurMonthDyo = sscLastYearToNowMonthsDyo.stream().filter(dyo -> DateHelper.getCurMonth().equals(new SimpleDateFormat("yyyy-MM").format(dyo.getDate("querydate")))).findFirst().orElse(null);
        if (sscCurMonthDyo == null || sscCurDayDyo == null || sscCurYearDyo == null) {
            logger.error(String.format("unknown exception sscCurXXXDyo is null[%s,%s,%s] and stop the processor sscId:" + sscId, sscCurMonthDyo == null, sscCurDayDyo == null, sscCurYearDyo == null));
            return;
        }
        QFilter curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,costwaittime,usergroup,coefficient", (QFilter[])curMonthFilter.toArray(), null);
             DataSet sumResultSet = dataSet.copy().groupBy(null).sum("costwaittime").finish();){
            userGroupResultSet = dataSet.copy().groupBy(new String[]{"usergroup"}).sum("costwaittime").sum("coefficient").finish();
            Throwable throwable = null;
            try {
                if (sumResultSet.hasNext()) {
                    Row row = sumResultSet.next();
                    BigDecimal costWaitTime = row.getBigDecimal("costwaittime");
                    int taskCount22 = dataSet.count("id", false);
                    if (taskCount22 > 0) {
                        BigDecimal averageAging2 = costWaitTime.divide(new BigDecimal(taskCount22), 1, 4);
                        sscCurMonthDyo.set("aveaging", (Object)averageAging2.toString());
                    }
                }
                userGroupDoubleMap22 = new HashMap<Long, Double[]>(16);
                HashMap<Long, BigDecimal> userGroupAveAgingMap = new HashMap<Long, BigDecimal>(16);
                taskCount22 = userGroupResultSet.iterator();
                while (taskCount22.hasNext()) {
                    Row row = (Row)taskCount22.next();
                    BigDecimal costWaitTime = row.getBigDecimal("costwaittime");
                    BigDecimal taskLoad = row.getBigDecimal("coefficient");
                    Long userGroupId = row.getLong("usergroup");
                    if (taskLoad == null || taskLoad.compareTo(new BigDecimal(0)) <= 0) continue;
                    Double[] doubles = new Double[]{Double.parseDouble(costWaitTime.toString()), Double.parseDouble(taskLoad.toString())};
                    userGroupDoubleMap22.put(userGroupId, doubles);
                    BigDecimal averageAging3 = costWaitTime.divide(taskLoad, 1, 4);
                    userGroupAveAgingMap.put(userGroupId, averageAging3);
                }
                groupCurMonthDyoList = DataHelper.getGroupCurDyo(sscId, new HashSet<Long>(userGroupAveAgingMap.keySet()), "2");
                for (DynamicObject dyo2 : groupCurMonthDyoList) {
                    long userGroupId = dyo2.getLong("usergroup_id");
                    groupCurMonthDyoMap.put(userGroupId, dyo2);
                    Double[] doubles = (Double[])userGroupDoubleMap22.get(userGroupId);
                    dyo2.set("costwaittime", (Object)(doubles == null ? Double.valueOf("0") : doubles[0]));
                    dyo2.set("taskload", (Object)(doubles == null ? Double.valueOf("0") : doubles[1]));
                    averageAging = (BigDecimal)userGroupAveAgingMap.get(userGroupId);
                    dyo2.set("aveaginggroup", (Object)(averageAging == null ? null : ((BigDecimal)((Object)averageAging)).toString()));
                }
            }
            catch (Throwable userGroupDoubleMap22) {
                throwable = userGroupDoubleMap22;
                throw userGroupDoubleMap22;
            }
            finally {
                if (userGroupResultSet != null) {
                    if (throwable != null) {
                        try {
                            userGroupResultSet.close();
                        }
                        catch (Throwable userGroupDoubleMap22) {
                            throwable.addSuppressed(userGroupDoubleMap22);
                        }
                    } else {
                        userGroupResultSet.close();
                    }
                }
            }
        }
        timeLog.info("current month efficiency", logger);
        QFilter curDayFilter = new QFilter("sscid", "=", (Object)sscId).and("taskcreatetime", ">=", (Object)curDayRange[0]).and("taskcreatetime", "<", (Object)curDayRange[1]).and("qualitysamplelibrary", "=", (Object)0L);
        curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("taskcreatetime", ">=", (Object)curMonthRange[0]).and("taskcreatetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L);
        QFilter curYearFilter = new QFilter("sscid", "=", (Object)sscId).and("taskcreatetime", ">=", (Object)curYearRange[0]).and("taskcreatetime", "<", (Object)curYearRange[1]).and("qualitysamplelibrary", "=", (Object)0L);
        this.countTaskCreate(sscCurDayDyo, curDayFilter);
        this.countTaskCreate(sscCurMonthDyo, curMonthFilter);
        this.countTaskCreate(sscCurYearDyo, curYearFilter);
        timeLog.info("current day/month/year taskcntall", logger);
        curDayFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curDayRange[0]).and("completetime", "<", (Object)curDayRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        curYearFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curYearRange[0]).and("completetime", "<", (Object)curYearRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        this.countTaskDone(sscCurDayDyo, curDayFilter);
        this.countTaskDone(sscCurMonthDyo, curMonthFilter);
        this.countTaskDone(sscCurYearDyo, curYearFilter);
        timeLog.info("current day/month/year taskcntdone", logger);
        this.countUnQuality(sscId, sscCurYearDyo, sscLastYearToNowMonthsDyo, startDate);
        timeLog.info("countUnQuality", logger);
        this.notQualityPointTop5(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("notQualityPointTop5", logger);
        this.notQualityAuditor5(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("notQualityAuditor5", logger);
        QFilter qFilter = new QFilter("sscid", "=", (Object)sscId).and("state", "in", (Object)new String[]{"3", "4"}).and("completetime", ">=", (Object)startDate).and("qualitysamplelibrary", "=", (Object)0L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,completetime,state", (QFilter[])qFilter.toArray(), (String)"completetime");
        userGroupResultSet = null;
        try {
            formatDataSet22 = dataSet.select(new String[]{"id", "TO_CHAR(completetime,'yyyy-MM') completetime", "state"});
            userGroupDoubleMap22 = null;
            try {
                allDataSet22 = formatDataSet22.groupBy(new String[]{"completetime", "state"}).count("id").finish();
                taskCount22 = null;
                try {
                    void var32_87;
                    allTaskCntMap22 = new LinkedHashMap<String, Integer>(24);
                    LinkedHashMap<String, Integer> passTaskCntMap = new LinkedHashMap<String, Integer>(24);
                    LinkedHashMap<String, Integer> unpassTaskCntMap = new LinkedHashMap<String, Integer>(24);
                    LinkedHashMap billQualityMap = new LinkedHashMap(24);
                    averageAging = allDataSet22.iterator();
                    while (averageAging.hasNext()) {
                        Row row = (Row)averageAging.next();
                        allTaskCntMap22.compute(row.getString("completetime"), (key, oldValue) -> {
                            oldValue = oldValue == null ? Integer.valueOf(0) : oldValue;
                            return oldValue + row.getInteger("id");
                        });
                        passTaskCntMap.compute(row.getString("completetime"), (key, oldValue) -> {
                            oldValue = oldValue == null ? Integer.valueOf(0) : oldValue;
                            return oldValue + (TaskStateEnum.AUDIT_PASSED.getValue().equals(row.getString("state")) ? row.getInteger("id") : 0);
                        });
                        unpassTaskCntMap.compute(row.getString("completetime"), (key, oldValue) -> {
                            oldValue = oldValue == null ? Integer.valueOf(0) : oldValue;
                            return oldValue + (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(row.getString("state")) ? row.getInteger("id") : 0);
                        });
                    }
                    for (Map.Entry entry : passTaskCntMap.entrySet()) {
                        if ((Integer)allTaskCntMap22.get(entry.getKey()) <= 0) continue;
                        billQualityMap.put(entry.getKey(), new BigDecimal((Integer)entry.getValue()).multiply(new BigDecimal(100)).divide(new BigDecimal((Integer)allTaskCntMap22.get(entry.getKey())), 1, 4));
                    }
                    LinkedHashMap unpassMap = new LinkedHashMap(24);
                    for (Map.Entry entry : unpassTaskCntMap.entrySet()) {
                        if ((Integer)allTaskCntMap22.get(entry.getKey()) <= 0) continue;
                        unpassMap.put(entry.getKey(), new BigDecimal((Integer)entry.getValue()).multiply(new BigDecimal(100)).divide(new BigDecimal((Integer)allTaskCntMap22.get(entry.getKey())), 1, 4));
                    }
                    dateFormat = new SimpleDateFormat("yyyy-MM");
                    boolean bl = false;
                    for (DynamicObject dyo3 : sscLastYearToNowMonthsDyo) {
                        querydate = ((DateFormat)dateFormat).format(dyo3.getDate("querydate"));
                        BigDecimal billQuality = (BigDecimal)billQualityMap.get(querydate);
                        BigDecimal unpassRate = (BigDecimal)unpassMap.get(querydate);
                        Integer passCnt = (Integer)passTaskCntMap.get(querydate);
                        Integer unpassCnt = (Integer)unpassTaskCntMap.get(querydate);
                        if (billQuality != null) {
                            dyo3.set("billquality", (Object)billQuality.toString());
                        }
                        if (unpassRate != null) {
                            dyo3.set("unpass_rate", (Object)unpassRate.toString());
                        }
                        if (passCnt != null) {
                            dyo3.set("auditpasscnt", (Object)passCnt);
                        }
                        if (unpassCnt != null) {
                            dyo3.set("auditunpasscnt", (Object)unpassCnt);
                        }
                        if (!((String)querydate).startsWith(DateHelper.getCurYear())) continue;
                        var32_87 += dyo3.getInt("auditunpasscnt");
                    }
                    sscCurYearDyo.set("auditunpasscnt", (Object)((int)var32_87));
                    if (sscCurYearDyo.getInt("taskcntdone") != 0) {
                        sscCurYearDyo.set("unpass_rate", (Object)new BigDecimal((int)var32_87).multiply(new BigDecimal(100)).divide(new BigDecimal(sscCurYearDyo.getInt("taskcntdone")), 1, 4).toString());
                    } else {
                        sscCurYearDyo.set("unpass_rate", (Object)"0.0");
                    }
                }
                catch (Throwable allTaskCntMap22) {
                    taskCount22 = allTaskCntMap22;
                    throw allTaskCntMap22;
                }
                finally {
                    if (allDataSet22 != null) {
                        if (taskCount22 != null) {
                            try {
                                allDataSet22.close();
                            }
                            catch (Throwable allTaskCntMap22) {
                                ((Throwable)taskCount22).addSuppressed(allTaskCntMap22);
                            }
                        } else {
                            allDataSet22.close();
                        }
                    }
                }
            }
            catch (Throwable allDataSet22) {
                userGroupDoubleMap22 = allDataSet22;
                throw allDataSet22;
            }
            finally {
                if (formatDataSet22 != null) {
                    if (userGroupDoubleMap22 != null) {
                        try {
                            formatDataSet22.close();
                        }
                        catch (Throwable allDataSet22) {
                            ((Throwable)userGroupDoubleMap22).addSuppressed(allDataSet22);
                        }
                    } else {
                        formatDataSet22.close();
                    }
                }
            }
        }
        catch (Throwable formatDataSet22) {
            userGroupResultSet = formatDataSet22;
            throw formatDataSet22;
        }
        finally {
            if (dataSet != null) {
                if (userGroupResultSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable formatDataSet22) {
                        ((Throwable)userGroupResultSet).addSuppressed(formatDataSet22);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        timeLog.info("billquality, unpass_rate, auditpasscnt, auditunpasscnt", logger);
        List robotUserGroupIds = QueryServiceHelper.queryPrimaryKeys((String)"task_usergroup", (QFilter[])new QFilter("isrobots", "=", (Object)true).and("createorg", "=", (Object)sscId).toArray(), null, (int)-1);
        curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)0L).and("usergroup", "not in", (Object)robotUserGroupIds);
        DataSet monthDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,coefficient,personid", (QFilter[])curMonthFilter.toArray(), null);
        formatDataSet22 = null;
        try {
            DataSet userDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)"bos_user", (String)"id,name", null, null);
            allDataSet22 = null;
            try {
                DataSet resultDataSet = monthDataSet.join(userDataSet).on("personid", "id").select(new String[]{"id", "coefficient", "personid"}, new String[]{"name"}).finish().groupBy(new String[]{"personid", "name"}).sum("coefficient").finish().orderBy(new String[]{"coefficient desc"}).top(3);
                allTaskCntMap22 = null;
                try {
                    if (!resultDataSet.isEmpty()) {
                        LinkedHashMap<Long, Double> map = new LinkedHashMap<Long, Double>(3);
                        for (Object row : resultDataSet) {
                            Double coefficient = row.getDouble("coefficient");
                            map.put(row.getLong("personid"), coefficient);
                        }
                        sscCurMonthDyo.set("taskrankjson", (Object)(map.isEmpty() ? " " : JSON.toJSONString(map)));
                    }
                }
                catch (Throwable map) {
                    allTaskCntMap22 = map;
                    throw map;
                }
                finally {
                    if (resultDataSet != null) {
                        if (allTaskCntMap22 != null) {
                            try {
                                resultDataSet.close();
                            }
                            catch (Throwable map) {
                                ((Throwable)allTaskCntMap22).addSuppressed(map);
                            }
                        } else {
                            resultDataSet.close();
                        }
                    }
                }
            }
            catch (Throwable resultDataSet) {
                allDataSet22 = resultDataSet;
                throw resultDataSet;
            }
            finally {
                if (userDataSet != null) {
                    if (allDataSet22 != null) {
                        try {
                            userDataSet.close();
                        }
                        catch (Throwable resultDataSet) {
                            ((Throwable)allDataSet22).addSuppressed(resultDataSet);
                        }
                    } else {
                        userDataSet.close();
                    }
                }
            }
        }
        catch (Throwable userDataSet) {
            formatDataSet22 = userDataSet;
            throw userDataSet;
        }
        finally {
            if (monthDataSet != null) {
                if (formatDataSet22 != null) {
                    try {
                        monthDataSet.close();
                    }
                    catch (Throwable userDataSet) {
                        ((Throwable)formatDataSet22).addSuppressed(userDataSet);
                    }
                } else {
                    monthDataSet.close();
                }
            }
        }
        timeLog.info("taskrankjson", logger);
        curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        DataSet allDataSet3 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,autoprocess", (QFilter[])curMonthFilter.toArray(), null);
        formatDataSet22 = null;
        try {
            autoDataSet22 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,autoprocess", (QFilter[])curMonthFilter.and("autoprocess", "=", (Object)true).and("usergroup", "in", (Object)robotUserGroupIds).toArray(), null);
            allDataSet22 = null;
            try {
                int allCnt22 = allDataSet3.count("id", true);
                int autoCnt = autoDataSet22.count("id", true);
                if (allCnt22 > 0) {
                    autoRatio = new BigDecimal(autoCnt).multiply(new BigDecimal(100)).divide(new BigDecimal(allCnt22), 1, 4);
                    sscCurMonthDyo.set("autoratio", (Object)((BigDecimal)autoRatio).toString());
                } else {
                    sscCurMonthDyo.set("autoratio", (Object)" ");
                }
            }
            catch (Throwable allCnt22) {
                allDataSet22 = allCnt22;
                throw allCnt22;
            }
            finally {
                if (autoDataSet22 != null) {
                    if (allDataSet22 != null) {
                        try {
                            autoDataSet22.close();
                        }
                        catch (Throwable allCnt22) {
                            ((Throwable)allDataSet22).addSuppressed(allCnt22);
                        }
                    } else {
                        autoDataSet22.close();
                    }
                }
            }
        }
        catch (Throwable autoDataSet22) {
            formatDataSet22 = autoDataSet22;
            throw autoDataSet22;
        }
        finally {
            if (allDataSet3 != null) {
                if (formatDataSet22 != null) {
                    try {
                        allDataSet3.close();
                    }
                    catch (Throwable autoDataSet22) {
                        ((Throwable)formatDataSet22).addSuppressed(autoDataSet22);
                    }
                } else {
                    allDataSet3.close();
                }
            }
        }
        timeLog.info("autoratio", logger);
        this.countCurrentMonthAutoNotPass(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("countCurrentMonthAutoNotPass", logger);
        this.notPassReasonTop5(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("notPassReasonTop5", logger);
        this.notPassBillTypeTop5(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("notPassBillTypeTop5", logger);
        this.notPassOrgTop5(sscId, curMonthRange, sscCurMonthDyo);
        timeLog.info("notPassOrgTop5", logger);
        QFilter unCompleteFilter = new QFilter("sscid", "=", (Object)sscId).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"1");
        curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
        DataSet unCompleteDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,usergroup", (QFilter[])unCompleteFilter.toArray(), null);
        autoDataSet22 = null;
        try {
            allCnt22 = null;
            try (DataSet unCompleteDataSetTask = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)"task_task", (String)"id,usergroup", (QFilter[])unCompleteFilter.toArray(), null);){
                DataSet completeDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,usergroup", (QFilter[])curMonthFilter.toArray(), null);
                autoRatio = null;
                try {
                    Object row;
                    DataSet completeDataSetTask = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)"task_task", (String)"id,usergroup", (QFilter[])curMonthFilter.toArray(), null);
                    row = null;
                    try {
                        DataSet unCompleteCntDataSet = unCompleteDataSet.groupBy(new String[]{"usergroup"}).count("id").finish();
                        dateFormat = null;
                        try {
                            DataSet throwable = unCompleteDataSetTask.groupBy(new String[]{"usergroup"}).count("id").finish();
                            Object object = null;
                            try {
                                DataSet completeCntDataSet = completeDataSet.groupBy(new String[]{"usergroup"}).count("id").finish();
                                querydate = null;
                                try {
                                    DataSet completeCntDataSetTask = completeDataSetTask.groupBy(new String[]{"usergroup"}).count("id").finish();
                                    Object object2 = null;
                                    try {
                                        Object userGroupId;
                                        HashMap<Long, Integer> unCompleteCntMap = new HashMap<Long, Integer>(16);
                                        HashMap<Long, Integer> completeCntMap = new HashMap<Long, Integer>(16);
                                        for (Row row2 : unCompleteCntDataSet) {
                                            userGroupId = row2.getLong("usergroup");
                                            unCompleteCntMap.put((Long)userGroupId, unCompleteCntMap.computeIfAbsent((Long)userGroupId, p -> 0) + row2.getInteger("id"));
                                        }
                                        for (Row row2 : throwable) {
                                            userGroupId = row2.getLong("usergroup");
                                            unCompleteCntMap.put((Long)userGroupId, unCompleteCntMap.computeIfAbsent((Long)userGroupId, p -> 0) + row2.getInteger("id"));
                                        }
                                        for (Row row2 : completeCntDataSet) {
                                            userGroupId = row2.getLong("usergroup");
                                            completeCntMap.put((Long)userGroupId, completeCntMap.computeIfAbsent((Long)userGroupId, p -> 0) + row2.getInteger("id"));
                                        }
                                        for (Row row2 : completeCntDataSetTask) {
                                            userGroupId = row2.getLong("usergroup");
                                            completeCntMap.put((Long)userGroupId, completeCntMap.computeIfAbsent((Long)userGroupId, p -> 0) + row2.getInteger("id"));
                                        }
                                        HashSet userGroupIdSetForEach = new HashSet(unCompleteCntMap.keySet());
                                        userGroupIdSetForEach.addAll(completeCntMap.keySet());
                                        HashSet<Long> userGroupIdSet = new HashSet<Long>(16);
                                        for (Long userGroupId2 : userGroupIdSetForEach) {
                                            if (groupCurMonthDyoMap.containsKey(userGroupId2)) {
                                                DynamicObject dyo4 = (DynamicObject)groupCurMonthDyoMap.get(userGroupId2);
                                                Integer unCompleteCnt = unCompleteCntMap.getOrDefault(userGroupId2, 0);
                                                int allCnt3 = unCompleteCnt + completeCntMap.getOrDefault(userGroupId2, 0);
                                                String ratio = allCnt3 == 0 ? "0.0" : new BigDecimal(unCompleteCnt).multiply(new BigDecimal(100)).divide(new BigDecimal(allCnt3), 1, 4).toString();
                                                dyo4.set("taskcntundone", (Object)unCompleteCnt);
                                                dyo4.set("taskcntall", (Object)allCnt3);
                                                dyo4.set("taskundoneratio", (Object)ratio);
                                                continue;
                                            }
                                            userGroupIdSet.add(userGroupId2);
                                        }
                                        if (!userGroupIdSet.isEmpty()) {
                                            List<DynamicObject> groupCurDyoList = DataHelper.getGroupCurDyo(sscId, userGroupIdSet, "2");
                                            for (DynamicObject dyo2 : groupCurDyoList) {
                                                long userGroupId3 = dyo2.getLong("usergroup_id");
                                                groupCurMonthDyoMap.put(userGroupId3, dyo2);
                                                Integer unCompleteCnt = unCompleteCntMap.getOrDefault(userGroupId3, 0);
                                                int allCnt4 = unCompleteCnt + completeCntMap.getOrDefault(userGroupId3, 0);
                                                String ratio = allCnt4 == 0 ? "0.0" : new BigDecimal(unCompleteCnt).multiply(new BigDecimal(100)).divide(new BigDecimal(allCnt4), 1, 4).toString();
                                                dyo2.set("taskcntundone", (Object)unCompleteCnt);
                                                dyo2.set("taskcntall", (Object)allCnt4);
                                                dyo2.set("taskundoneratio", (Object)ratio);
                                            }
                                            groupCurMonthDyoList.addAll(groupCurDyoList);
                                        }
                                    }
                                    catch (Throwable unCompleteCntMap) {
                                        object2 = unCompleteCntMap;
                                        throw unCompleteCntMap;
                                    }
                                    finally {
                                        if (completeCntDataSetTask != null) {
                                            if (object2 != null) {
                                                try {
                                                    completeCntDataSetTask.close();
                                                }
                                                catch (Throwable unCompleteCntMap) {
                                                    ((Throwable)object2).addSuppressed(unCompleteCntMap);
                                                }
                                            } else {
                                                completeCntDataSetTask.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable completeCntDataSetTask) {
                                    querydate = completeCntDataSetTask;
                                    throw completeCntDataSetTask;
                                }
                                finally {
                                    if (completeCntDataSet != null) {
                                        if (querydate != null) {
                                            try {
                                                completeCntDataSet.close();
                                            }
                                            catch (Throwable completeCntDataSetTask) {
                                                ((Throwable)querydate).addSuppressed(completeCntDataSetTask);
                                            }
                                        } else {
                                            completeCntDataSet.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable completeCntDataSet) {
                                object = completeCntDataSet;
                                throw completeCntDataSet;
                            }
                            finally {
                                if (throwable != null) {
                                    if (object != null) {
                                        try {
                                            throwable.close();
                                        }
                                        catch (Throwable completeCntDataSet) {
                                            ((Throwable)object).addSuppressed(completeCntDataSet);
                                        }
                                    } else {
                                        throwable.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            dateFormat = throwable;
                            throw throwable;
                        }
                        finally {
                            if (unCompleteCntDataSet != null) {
                                if (dateFormat != null) {
                                    try {
                                        unCompleteCntDataSet.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)dateFormat).addSuppressed(throwable);
                                    }
                                } else {
                                    unCompleteCntDataSet.close();
                                }
                            }
                        }
                    }
                    catch (Throwable unCompleteCntDataSet) {
                        row = unCompleteCntDataSet;
                        throw unCompleteCntDataSet;
                    }
                    finally {
                        if (completeDataSetTask != null) {
                            if (row != null) {
                                try {
                                    completeDataSetTask.close();
                                }
                                catch (Throwable unCompleteCntDataSet) {
                                    ((Throwable)row).addSuppressed(unCompleteCntDataSet);
                                }
                            } else {
                                completeDataSetTask.close();
                            }
                        }
                    }
                }
                catch (Throwable completeDataSetTask) {
                    autoRatio = completeDataSetTask;
                    throw completeDataSetTask;
                }
                finally {
                    if (completeDataSet != null) {
                        if (autoRatio != null) {
                            try {
                                completeDataSet.close();
                            }
                            catch (Throwable completeDataSetTask) {
                                ((Throwable)autoRatio).addSuppressed(completeDataSetTask);
                            }
                        } else {
                            completeDataSet.close();
                        }
                    }
                }
            }
            catch (Throwable completeDataSet) {
                allCnt22 = completeDataSet;
                throw completeDataSet;
            }
        }
        catch (Throwable unCompleteDataSetTask) {
            autoDataSet22 = unCompleteDataSetTask;
            throw unCompleteDataSetTask;
        }
        finally {
            if (unCompleteDataSet != null) {
                if (autoDataSet22 != null) {
                    try {
                        unCompleteDataSet.close();
                    }
                    catch (Throwable unCompleteDataSetTask) {
                        ((Throwable)autoDataSet22).addSuppressed(unCompleteDataSetTask);
                    }
                } else {
                    unCompleteDataSet.close();
                }
            }
        }
        timeLog.info("current month group efficiency", logger);
        List orgList = OrgRelationQueryHelper.getFromOrgListFilterDutyScope((long)sscId, (boolean)true);
        List bookTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbookstype", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray(), null, (int)-1);
        curMonthFilter = new QFilter("org", "in", (Object)orgList).and("booktype", "in", (Object)bookTypeIds).and("bookeddate", ">=", (Object)curMonthRange[0]).and("bookeddate", "<", (Object)curMonthRange[1]);
        allCnt22 = null;
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#gl_voucher", (String)"gl_voucher", (String)"id,sourcetype", (QFilter[])curMonthFilter.toArray(), null);){
            handDataSet22 = dataSet2.copy().filter("sourcetype = '0'");
            autoRatio = null;
            try {
                int voucherCntAll = dataSet2.count("id", true);
                int handCntAll = handDataSet22.count("id", true);
                int voucherCntAuto = voucherCntAll - handCntAll;
                if (voucherCntAll > 0) {
                    BigDecimal voucherAuto = new BigDecimal(voucherCntAuto).multiply(new BigDecimal(100)).divide(new BigDecimal(voucherCntAll), 1, 4);
                    sscCurMonthDyo.set("voucherautoratio", (Object)voucherAuto.toString());
                } else {
                    sscCurMonthDyo.set("voucherautoratio", (Object)" ");
                }
            }
            catch (Throwable throwable) {
                autoRatio = throwable;
                throw throwable;
            }
            finally {
                if (handDataSet22 != null) {
                    if (autoRatio != null) {
                        try {
                            handDataSet22.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)autoRatio).addSuppressed(throwable);
                        }
                    } else {
                        handDataSet22.close();
                    }
                }
            }
        }
        catch (Throwable handDataSet22) {
            allCnt22 = handDataSet22;
            throw handDataSet22;
        }
        timeLog.info("voucherautoratio", logger);
        curMonthFilter = new QFilter("org", "in", (Object)orgList).and("booktype", "in", (Object)bookTypeIds).and("bookeddate", ">=", (Object)curMonthRange[0]).and("bookeddate", "<", (Object)curMonthRange[1]).and("billstatus", "in", (Object)new char[]{'A', 'B'});
        QFilter auditedFilter = new QFilter("org", "in", (Object)orgList).and("booktype", "in", (Object)bookTypeIds).and("bookeddate", ">=", (Object)curMonthRange[0]).and("bookeddate", "<", (Object)curMonthRange[1]).and("billstatus", "=", (Object)Character.valueOf('C'));
        DataSet dataSet3 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#gl_voucher", (String)"gl_voucher", (String)"id,billstatus", (QFilter[])curMonthFilter.toArray(), null);
        handDataSet22 = null;
        try (DataSet auditedDataSet22 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#gl_voucher", (String)"gl_voucher", (String)"id,ispost", (QFilter[])auditedFilter.toArray(), null);
             DataSet cntDataSet = dataSet3.groupBy(new String[]{"billstatus"}).count("id").finish();){
            Throwable throwable = null;
            try (DataSet auditedCntDataSet = auditedDataSet22.groupBy(new String[]{"ispost"}).count("id").finish();){
                int saveCnt = 0;
                int submitCnt = 0;
                int auditNoPost = 0;
                int auditPost = 0;
                for (Row row : cntDataSet) {
                    String billStatus = row.getString("billstatus");
                    if ("A".equalsIgnoreCase(billStatus)) {
                        saveCnt = row.getInteger("id");
                        continue;
                    }
                    if (!"B".equalsIgnoreCase(billStatus)) continue;
                    submitCnt = row.getInteger("id");
                }
                for (Row row : auditedCntDataSet) {
                    Boolean isPost = row.getBoolean("ispost");
                    if (isPost.booleanValue()) {
                        auditPost = row.getInteger("id");
                        continue;
                    }
                    auditNoPost = row.getInteger("id");
                }
                sscCurMonthDyo.set("savecnt", (Object)saveCnt);
                sscCurMonthDyo.set("submitcnt", (Object)submitCnt);
                sscCurMonthDyo.set("auditnopost", (Object)auditNoPost);
                sscCurMonthDyo.set("auditpost", (Object)auditPost);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable auditedDataSet22) {
            handDataSet22 = auditedDataSet22;
            throw auditedDataSet22;
        }
        finally {
            if (dataSet3 != null) {
                if (handDataSet22 != null) {
                    try {
                        dataSet3.close();
                    }
                    catch (Throwable auditedDataSet22) {
                        ((Throwable)handDataSet22).addSuppressed(auditedDataSet22);
                    }
                } else {
                    dataSet3.close();
                }
            }
        }
        timeLog.info("auditpost,auditnopost,savecnt,submitcnt", logger);
        sscLastYearToNowMonthsDyo.add(sscCurDayDyo);
        sscLastYearToNowMonthsDyo.add(sscCurYearDyo);
        SaveServiceHelper.save((DynamicObject[])sscLastYearToNowMonthsDyo.toArray(new DynamicObject[0]));
        List<DynamicObject> groupCurDyoFromCache = DataHelper.getGroupCurDyoFromCache(sscId, "2");
        Set groupDyoPk = groupCurMonthDyoList.stream().map(dyo -> NumberUtils.toLong((String)(dyo.getPkValue() + ""), (long)0L)).collect(Collectors.toSet());
        Set removed = groupCurDyoFromCache.stream().filter(g -> !groupDyoPk.contains(g.getLong("id"))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (!removed.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)groupCurMonthDyoList.get(0).getDynamicObjectType(), (Object[])removed.toArray());
        }
        SaveServiceHelper.save((DynamicObject[])groupCurMonthDyoList.toArray(new DynamicObject[0]));
    }

    private void countTaskCreate(DynamicObject dyo, QFilter timeFilter) {
        int taskCount = ORM.create().count("count#task_taskhistory#create", TASK_TASKHISTORY, "id", timeFilter.toArray()) + ORM.create().count("count#task_task#create", "task_task", "id", timeFilter.toArray());
        dyo.set("taskcntall", (Object)taskCount);
    }

    private void countTaskDone(DynamicObject dyo, QFilter timeFilter) {
        int taskCount = ORM.create().count("count#task_taskhistory#done", TASK_TASKHISTORY, "id", timeFilter.toArray());
        dyo.set("taskcntdone", (Object)taskCount);
    }

    private void countUnQuality(long sscId, DynamicObject sscCurYearDyo, List<DynamicObject> sscLastYearToNowMonthsDyo, Date startDate) {
        QFilter monthsFilter = new QFilter("qualitysamplelibrary", ">", (Object)0L).and("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)startDate);
        try (DataSet monthQualityDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id,completetime,qualityresult", (QFilter[])monthsFilter.toArray(), null);
             DataSet formatDataSet = monthQualityDataSet.select(new String[]{"id", "TO_CHAR(completetime,'yyyy-MM') completetime", "qualityresult"});
             DataSet allDataSet = formatDataSet.groupBy(new String[]{"completetime", "qualityresult"}).count("id").finish();){
            String curYear = DateHelper.getCurYear();
            HashMap<String, Object> countMap = new HashMap<String, Object>(sscLastYearToNowMonthsDyo.size());
            while (allDataSet.hasNext()) {
                Row row = allDataSet.next();
                String queryDate = row.getString("completetime");
                if (StringUtils.isBlank((CharSequence)queryDate)) continue;
                Integer count = row.getInteger("id");
                Object ints = countMap.getOrDefault(queryDate, new int[2]);
                int qualityResult = NumberUtils.toInt((String)row.getString("qualityresult"), (int)2);
                if (qualityResult == 0) {
                    ints[0] = count;
                }
                if (qualityResult == 1) {
                    ints[1] = count;
                }
                countMap.putIfAbsent(queryDate, ints);
            }
            int yearQualityTaskCount = 0;
            int yearUnQualityTaskCount = 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
            for (DynamicObject dyo : sscLastYearToNowMonthsDyo) {
                String queryDate = dateFormat.format(dyo.getDate("querydate"));
                int[] ints = (int[])countMap.get(queryDate);
                if (ints != null) {
                    int monthUnQualityTaskCount = ints[0] + ints[1];
                    dyo.set("qualitycnt", (Object)monthUnQualityTaskCount);
                    dyo.set("unqualitycnt", (Object)ints[0]);
                    if (ints[0] > 0) {
                        BigDecimal monthUnQualityRatio = new BigDecimal(ints[0]).multiply(new BigDecimal(100)).divide(new BigDecimal(monthUnQualityTaskCount), 1, 4);
                        dyo.set("unqualityratio", (Object)monthUnQualityRatio.toString());
                    }
                }
                if (!queryDate.startsWith(curYear)) continue;
                yearQualityTaskCount += dyo.getInt("qualitycnt");
                yearUnQualityTaskCount += dyo.getInt("unqualitycnt");
            }
            sscCurYearDyo.set("qualitycnt", (Object)yearQualityTaskCount);
            sscCurYearDyo.set("unqualitycnt", (Object)yearUnQualityTaskCount);
            if (yearQualityTaskCount > 0) {
                BigDecimal yearUnQualityRatio = new BigDecimal(yearUnQualityTaskCount).multiply(new BigDecimal(100)).divide(new BigDecimal(yearQualityTaskCount), 1, 4);
                sscCurYearDyo.set("unqualityratio", (Object)yearUnQualityRatio.toString());
            }
        }
    }

    private void notQualityPointTop5(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        QFilter curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", ">", (Object)0L).and("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()).and("qualityresult", "=", (Object)"0");
        try (DataSet taskSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"id", (QFilter[])curMonthFilter.toArray(), null);
             DataSet msgSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_qualitymessagerecord", (String)"task_qualitymessagerecord", (String)"point as pointid,qualitycheck as taskid, reviewmethod, entryentity.messagetype as messagetype, entryentity.isnewmessage as isnewmessage", null, null).filter("reviewmethod = '1' and messagetype = '0' and isnewmessage = 1");
             DataSet dataSet = taskSet.join(msgSet).on("id", "taskid").select(new String[0], new String[]{"pointid"}).finish().groupBy(new String[]{"pointid"}).count("count").finish().orderBy(new String[]{"count desc"}).top(5);){
            ArrayList<RankModel> rank = new ArrayList<RankModel>();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("pointid");
                Integer count = row.getInteger("count");
                if (id == null) continue;
                rank.add(new RankModel(id.longValue(), (Object)count));
            }
            sscCurMonthDyo.set("notquality_point5", (Object)JSON.toJSONString(rank));
        }
    }

    private void notQualityAuditor5(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        List rank = (List)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT t2.fpersonid as personid, t1.fqualityresult as qualityresult, count(t1.fqualityresult) as count\n  FROM t_tk_taskhistory t1\n  JOIN t_tk_taskhistory t2\n    ON t1.fsourcetaskid = t2.fid and t1.fsscid = ?\n   AND t1.fcompletetime >= ?\n   AND t1.fcompletetime < ?\n   AND t1.fqualitysamplelibraryid > 0\n   AND t1.fpooltype = '2'\n GROUP BY t2.fpersonid, t1.fqualityresult; ", (Object[])new Object[]{sscId, curMonthRange[0], curMonthRange[1]}, rs -> {
            ArrayList<RankModel> result = new ArrayList<RankModel>(5);
            HashMap<Long, int[]> persons = new HashMap<Long, int[]>();
            while (rs.next()) {
                long id = rs.getLong("personid");
                int count = rs.getInt("count");
                String qualityResult = rs.getString("qualityresult");
                int index = NumberUtils.toInt((String)qualityResult, (int)2);
                if (index != 0 && index != 1) continue;
                int[] cnts = persons.computeIfAbsent(id, k -> new int[2]);
                cnts[index] = count;
            }
            List sortedList = persons.entrySet().stream().map(e -> {
                int[] value = (int[])e.getValue();
                int sum = value[0] + value[1];
                if (sum == 0) {
                    return new AbstractMap.SimpleEntry(e.getKey(), 0.0);
                }
                return new AbstractMap.SimpleEntry(e.getKey(), (double)value[0] * 100.0 / (double)sum);
            }).sorted((e1, e2) -> ((Double)e2.getValue()).compareTo((Double)e1.getValue())).collect(Collectors.toList());
            int len = Math.min(5, sortedList.size());
            for (int i = 0; i < len; ++i) {
                result.add(new RankModel(((Long)((AbstractMap.SimpleEntry)sortedList.get(i)).getKey()).longValue(), (Object)this.d1.format(((AbstractMap.SimpleEntry)sortedList.get(i)).getValue())));
            }
            return result;
        });
        sscCurMonthDyo.set("notquality_auditor5", (Object)JSON.toJSONString((Object)rank));
    }

    private void countCurrentMonthRescan(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        String algoKey = "TaskHistoryDataProcessor#countCurrentMonthRescan";
        int count = 0;
        QFilter notCompleteFilter = new QFilter("sscid", "=", (Object)sscId).and("taskcreatetime", ">=", (Object)curMonthRange[0]).and("taskcreatetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("state", "=", (Object)TaskStateEnum.RESCAN.getValue());
        try (DataSet rescanSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_task", (String)"id", (QFilter[])notCompleteFilter.toArray(), null);){
        }
        sscCurMonthDyo.set("rescancnt", (Object)(count += rescanSet.count("id", false)));
    }

    private void countCurrentMonthAutoNotPass(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        QFilter autoNotPassFilter = new QFilter("sscid", "=", (Object)sscId).and("taskcreatetime", ">=", (Object)curMonthRange[0]).and("taskcreatetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("autoprocessresult", "=", (Object)"0");
        QFilter completeFilter = new QFilter("pooltype", "=", (Object)"2");
        String algoKey = "TaskHistoryDataProcessor#countCurrentMonthAutoNotPass";
        int count = 0;
        try (DataSet autoNotPassSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)TASK_TASKHISTORY, (String)"autoprocessresult", (QFilter[])new QFilter[]{autoNotPassFilter, completeFilter}, null);){
            count += autoNotPassSet.count("autoprocessresult", false);
        }
        autoNotPassSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_task", (String)"autoprocessresult", (QFilter[])autoNotPassFilter.toArray(), null);
        var10_9 = null;
        try {
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
        finally {
            if (autoNotPassSet != null) {
                if (var10_9 != null) {
                    try {
                        autoNotPassSet.close();
                    }
                    catch (Throwable throwable) {
                        var10_9.addSuppressed(throwable);
                    }
                } else {
                    autoNotPassSet.close();
                }
            }
        }
        sscCurMonthDyo.set("autounpasscnt", (Object)(count += autoNotPassSet.count("autoprocessresult", false)));
    }

    private void notPassReasonTop5(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        QFilter curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()).and("state", "=", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
        try (DataSet unpassSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"sourcetaskid", (QFilter[])curMonthFilter.toArray(), null);
             DataSet unpassReasonSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_withdrawal_unpass", (String)"task_withdrawal_unpass", (String)"withdrawal.id wid,taskid", null, null);
             DataSet unpassTopSet = unpassSet.join(unpassReasonSet, JoinType.INNER).on("sourcetaskid", "taskid").select(new String[]{"wid"}).finish().groupBy(new String[]{"wid"}).count("count").finish().orderBy(new String[]{"count desc"}).top(5);){
            ArrayList<RankModel> list = new ArrayList<RankModel>(5);
            while (unpassTopSet.hasNext()) {
                Row row = unpassTopSet.next();
                list.add(new RankModel(row.getLong("wid").longValue(), (Object)row.getInteger("count")));
            }
            sscCurMonthDyo.set("unpass_reason5", (Object)JSON.toJSONString(list));
        }
    }

    private void notPassBillTypeTop5(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        QFilter curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        try (DataSet notPassBillT5 = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"billtype,state", (QFilter[])curMonthFilter.toArray(), null).groupBy(new String[]{"billtype", "state"}).count("count").finish();){
            ArrayList<RankModel> rank = new ArrayList<RankModel>(5);
            HashMap<Long, int[]> map = new HashMap<Long, int[]>(5);
            while (notPassBillT5.hasNext()) {
                Row row = notPassBillT5.next();
                Long id = row.getLong("billtype");
                Integer count = row.getInteger("count");
                String state = row.getString("state");
                int index = NumberUtils.toInt((String)state, (int)5) - 3;
                if (id == null || index != 0 && index != 1) continue;
                int[] cnts = map.computeIfAbsent(id, k -> new int[2]);
                cnts[index] = count;
            }
            List sortedList = map.entrySet().stream().map(e -> {
                int[] value = (int[])e.getValue();
                int sum = value[0] + value[1];
                if (sum == 0) {
                    return new AbstractMap.SimpleEntry(e.getKey(), 0.0);
                }
                int notPass = value[1];
                return new AbstractMap.SimpleEntry(e.getKey(), (double)notPass * 100.0 / (double)sum);
            }).sorted((e1, e2) -> ((Double)e2.getValue()).compareTo((Double)e1.getValue())).collect(Collectors.toList());
            int len = Math.min(5, sortedList.size());
            for (int i = 0; i < len; ++i) {
                rank.add(new RankModel(((Long)((AbstractMap.SimpleEntry)sortedList.get(i)).getKey()).longValue(), (Object)this.d1.format(((AbstractMap.SimpleEntry)sortedList.get(i)).getValue())));
            }
            sscCurMonthDyo.set("unpass_billtype5", (Object)JSON.toJSONString(rank));
        }
    }

    private void notPassOrgTop5(long sscId, Date[] curMonthRange, DynamicObject sscCurMonthDyo) {
        QFilter curMonthFilter = new QFilter("sscid", "=", (Object)sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)TASK_TASKHISTORY, (String)"orgid,state", (QFilter[])curMonthFilter.toArray(), null).groupBy(new String[]{"orgid", "state"}).count("count").finish();){
            ArrayList<RankModel> rank = new ArrayList<RankModel>(5);
            HashMap<Long, int[]> map = new HashMap<Long, int[]>(5);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("orgid");
                Integer count = row.getInteger("count");
                String state = row.getString("state");
                int index = NumberUtils.toInt((String)state, (int)5) - 3;
                if (id == null || index != 0 && index != 1) continue;
                int[] cnts = map.computeIfAbsent(id, k -> new int[2]);
                cnts[index] = count;
            }
            List sortedList = map.entrySet().stream().map(e -> {
                int[] value = (int[])e.getValue();
                int sum = value[0] + value[1];
                if (sum == 0) {
                    return new AbstractMap.SimpleEntry(e.getKey(), 0.0);
                }
                int notPass = value[1];
                return new AbstractMap.SimpleEntry(e.getKey(), (double)notPass * 100.0 / (double)sum);
            }).sorted((e1, e2) -> ((Double)e2.getValue()).compareTo((Double)e1.getValue())).collect(Collectors.toList());
            int len = Math.min(5, sortedList.size());
            for (int i = 0; i < len; ++i) {
                rank.add(new RankModel(((Long)((AbstractMap.SimpleEntry)sortedList.get(i)).getKey()).longValue(), (Object)this.d1.format(((AbstractMap.SimpleEntry)sortedList.get(i)).getValue())));
            }
            sscCurMonthDyo.set("unpass_org5", (Object)JSON.toJSONString(rank));
        }
    }
}

