/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fircm.dto.ApproveTaskResult;
import kd.bos.ext.fircm.dto.WorkFlowNodeCreditRecordDto;
import kd.bos.ext.fircm.enums.WorkFlowAuditTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.CreditModifySourceEnum;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.business.helper.WorkFlowCreditHelper;
import kd.ssc.task.workflow.dto.CreditPointDTO;
import org.apache.commons.lang3.StringUtils;

public class TaskCreditHelper {
    private static final Log log = LogFactory.getLog(TaskCreditHelper.class);
    private static final String BAR_PASS = "bar_pass";
    private static final String BAR_NOT_PASS = "bd_nopass";
    private static final String QUERY_SQL_PASS = "SELECT a.fid,a.fsubject,b.fsubscorerule FROM t_tk_taskhistory a,t_tk_crebreakrulerecord b WHERE a.fstate='3' AND a.fid=b.fhistaskid AND a.fassignid='%s'";
    private static final String QUERY_SQL_NOT_PASS = "SELECT a.fid,a.fsubject,c.fsubscorerule FROM t_tk_taskhistory a,t_tk_withdrawal_unpass b,t_tk_withdrawal c WHERE a.fstate='4' AND a.fsourcetaskid=b.ftask AND b.fwithdrawal = c.fid AND a.fassignid='%s'";

    public static void updateWfVariableByTaskId(String key, Map<String, String> map, DynamicObject taskInfo) {
        boolean supportBar;
        boolean bl = supportBar = StringUtils.equals((CharSequence)BAR_PASS, (CharSequence)key) || StringUtils.equals((CharSequence)BAR_NOT_PASS, (CharSequence)key);
        if (!supportBar) {
            return;
        }
        String currentTaskSubject = taskInfo.getString("subject");
        String assignId = taskInfo.getString("assignid");
        long sscTaskId = taskInfo.getLong("id");
        ArrayList<ApproveTaskResult> approveTaskResultList = new ArrayList<ApproveTaskResult>();
        TaskCreditHelper.addCurrentTaskApproveResult(key, map, approveTaskResultList, currentTaskSubject, sscTaskId);
        TaskCreditHelper.loadApproveResultFromHisTask(assignId, approveTaskResultList, key);
        DynamicObject wfHiTaskInst = WorkFlowCreditHelper.getWfHiTaskInst((long)Long.parseLong(assignId));
        Long hisInstId = wfHiTaskInst.getLong("processinstanceid");
        String flowCSSInfoStr = WorkFlowCreditHelper.getWfVariable((Long)hisInstId);
        List<WorkFlowNodeCreditRecordDto> flowCSSInfoList = TaskCreditHelper.buildWfNodeCreditRecordDtoList(approveTaskResultList, wfHiTaskInst.getString("taskdefinitionkey"), wfHiTaskInst.getString("name"), flowCSSInfoStr);
        if (CollectionUtils.isNotEmpty(flowCSSInfoList)) {
            WorkFlowCreditHelper.updateWfVariable((Long)hisInstId, (String)SerializationUtils.toJsonString(flowCSSInfoList));
        } else if (StringUtils.isNotEmpty((CharSequence)flowCSSInfoStr)) {
            WorkFlowCreditHelper.updateWfVariable((Long)hisInstId, (String)"");
        }
    }

    private static void addCurrentTaskApproveResult(String key, Map<String, String> map, List<ApproveTaskResult> approveTaskResultList, String currentTaskSubject, long sscTaskId) {
        switch (key) {
            case "bar_pass": {
                List<Long> subScoreRuleIdList = TaskCreditHelper.getFlawedSubScoreRule(map);
                if (CollectionUtils.isEmpty(subScoreRuleIdList)) {
                    return;
                }
                String passDescription = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u4f46\u6709\u8fdd\u89c4\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s", (String)"TaskCreditHelper_0", (String)"ssc-task-business", (Object[])new Object[0]), currentTaskSubject);
                approveTaskResultList.add(new ApproveTaskResult(subScoreRuleIdList, WorkFlowAuditTypeEnum.APPROVE.getCode(), passDescription, sscTaskId));
                break;
            }
            case "bd_nopass": {
                List<Long> subScoreRuleByWithdrawal = TaskCreditHelper.getSubScoreRuleByWithdrawal(map);
                if (CollectionUtils.isEmpty(subScoreRuleByWithdrawal)) {
                    return;
                }
                String notPassDescription = String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s\u3002", (String)"TaskCreditHelper_1", (String)"ssc-task-business", (Object[])new Object[0]), currentTaskSubject);
                approveTaskResultList.add(new ApproveTaskResult(subScoreRuleByWithdrawal, WorkFlowAuditTypeEnum.REJECT.getCode(), notPassDescription, sscTaskId));
                break;
            }
        }
    }

    private static List<WorkFlowNodeCreditRecordDto> buildWfNodeCreditRecordDtoList(List<ApproveTaskResult> approveTaskResultList, String flowNodeId, String flowNodeName, String flowCSSInfoStr) {
        WorkFlowNodeCreditRecordDto nowNodeCSSInfoDto = null;
        if (CollectionUtils.isNotEmpty(approveTaskResultList)) {
            nowNodeCSSInfoDto = new WorkFlowNodeCreditRecordDto(flowNodeId, flowNodeName, approveTaskResultList);
        }
        List<WorkFlowNodeCreditRecordDto> flowCSSInfoList = StringUtils.isEmpty((CharSequence)flowCSSInfoStr) ? new ArrayList(1) : SerializationUtils.fromJsonStringToList((String)flowCSSInfoStr, WorkFlowNodeCreditRecordDto.class);
        flowCSSInfoList.removeIf(item -> item.getFlowNodeId().equals(flowNodeId));
        if (nowNodeCSSInfoDto != null) {
            flowCSSInfoList.add(nowNodeCSSInfoDto);
        }
        return flowCSSInfoList;
    }

    private static void loadApproveResultFromHisTask(String assignId, List<ApproveTaskResult> approveTaskResultList, String key) {
        TaskCreditHelper.queryPassHisTask(assignId, approveTaskResultList, key);
        TaskCreditHelper.queryNotPassHisTask(assignId, approveTaskResultList, key);
    }

    public static void passedButFlawed(Map<String, String> map, long historyTaskId) {
        List<Long> subScoreRuleIdList = TaskCreditHelper.getFlawedSubScoreRule(map);
        if (CollectionUtils.isEmpty(subScoreRuleIdList)) {
            return;
        }
        String description = ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u4f46\u6709\u8fdd\u89c4", (String)"TaskCreditHelper_2", (String)"ssc-task-business", (Object[])new Object[0]);
        TaskCreditHelper.dispatch2FircmDeductPoint(description, historyTaskId, subScoreRuleIdList);
    }

    private static List<Long> getFlawedSubScoreRule(Map<String, String> map) {
        String subScoreRuleIdsJson = map.get("subscorerule");
        if (StringUtils.isEmpty((CharSequence)subScoreRuleIdsJson)) {
            return new ArrayList<Long>();
        }
        return SerializationUtils.fromJsonStringToList((String)subScoreRuleIdsJson, Long.class);
    }

    public static void approvalFailed(Map<String, String> map, long historyTaskId) {
        List<Long> subScoreRuleIds = TaskCreditHelper.getSubScoreRuleByWithdrawal(map);
        if (CollectionUtils.isEmpty(subScoreRuleIds)) {
            TaskCreditHelper.dispatch2FircmInsert0Log(historyTaskId);
            return;
        }
        String description = ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"TaskCreditHelper_3", (String)"ssc-task-business", (Object[])new Object[0]);
        TaskCreditHelper.dispatch2FircmDeductPoint(description, historyTaskId, subScoreRuleIds);
    }

    private static List<Long> getSubScoreRuleByWithdrawal(Map<String, String> map) {
        String withdrawalIdsJson = map.get("withdrawalids");
        if (StringUtils.isEmpty((CharSequence)withdrawalIdsJson)) {
            return new ArrayList<Long>();
        }
        List withdrawalIds = SerializationUtils.fromJsonStringToList((String)withdrawalIdsJson, Long.class);
        if (CollectionUtils.isEmpty((Collection)withdrawalIds)) {
            return new ArrayList<Long>();
        }
        return TaskCreditHelper.getSubScoreRuleIdsByWithdrawalIds(withdrawalIds);
    }

    public static void dispatch2FircmDeductPoint(String description, long historyTaskId, List<Long> subScoreRuleIds) {
        TaskCreditHelper.dispatch2FircmDeductPoint(description, historyTaskId, subScoreRuleIds, CreditModifySourceEnum.SSCAUDIT.getValue());
    }

    public static void dispatch2FircmDeductPoint(String description, long historyTaskId, List<Long> subScoreRuleIds, String modifySource) {
        DynamicObject hisTaskDyn = TaskCreditHelper.getHisTaskDyn(historyTaskId);
        CreditPointDTO dto = TaskCreditHelper.buildCreditPointDTO(hisTaskDyn);
        try {
            Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{dto.getBillNumber(), dto.getBillId()});
            Optional.ofNullable(userIdByAppObj).ifPresent(id -> dto.setUserId(id.longValue()));
            if (dto.getUserId() == -1L) {
                log.error(String.format("dispatch2FircmDeductPoint error, billType:{%s}, billNo:{%s}", dto.getBillNumber(), dto.getBillNo()));
                return;
            }
            String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
            log.info(String.format("dispatch2FircmDeductPoint, creditPointDTO:%s, subScoreRuleIds:%s, description:%s", dto, subScoreRuleIds, description));
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"deductCreditPoints", (Object[])new Object[]{subScoreRuleIds, modifySource, creditPointDTOStr, description});
        }
        catch (Exception e) {
            log.error(String.format("deductCreditPoints error, msg:%s", ExceptionUtil.getStackTrace((Throwable)e)));
            ExceptionPlatformUtil.saveErrorInfo((String)TaskCreditHelper.class.getName(), (String)"dispatch2FircmDeductPoint", (String)dto.toString(), (Throwable)e);
        }
    }

    private static void dispatch2FircmInsert0Log(long historyTaskId) {
        DynamicObject hisTaskDyn = TaskCreditHelper.getHisTaskDyn(historyTaskId);
        CreditPointDTO dto = TaskCreditHelper.buildCreditPointDTO(hisTaskDyn);
        try {
            Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{dto.getBillNumber(), dto.getBillId()});
            Optional.ofNullable(userIdByAppObj).ifPresent(id -> dto.setUserId(id.longValue()));
            if (dto.getUserId() == -1L) {
                log.error(String.format("dispatch2FircmInsert0Log error, billType:{%s}, billNo:{%s}", dto.getBillNumber(), dto.getBillNo()));
                return;
            }
            String description = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%1$s\u3002", (String)"TaskCreditHelper_4", (String)"ssc-task-business", (Object[])new Object[0]), hisTaskDyn.getString("subject"));
            log.info(String.format("dispatch2FircmInsert0Log, creditPointDTO:%s, description:%s", dto, description));
            String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"insertCreditModLogOfZero", (Object[])new Object[]{creditPointDTOStr, CreditModifySourceEnum.SSCAUDIT.getValue(), description});
        }
        catch (Exception e) {
            log.error("insertCreditModLogOfZero error, msg:%s", (Object)ExceptionUtil.getStackTrace((Throwable)e));
            ExceptionPlatformUtil.saveErrorInfo((String)TaskCreditHelper.class.getName(), (String)"insertCreditModLogOfZero", (Throwable)e);
        }
    }

    public static void saveBreakRuleRecord(Long historyTaskId, Map<String, String> map) {
        List<Long> flawedSubScoreRule = TaskCreditHelper.getFlawedSubScoreRule(map);
        if (CollectionUtils.isEmpty(flawedSubScoreRule)) {
            return;
        }
        ArrayList<DynamicObject> breakRecords = new ArrayList<DynamicObject>(10);
        for (Long subScoreRuleId : flawedSubScoreRule) {
            DynamicObject breakRule = BusinessDataServiceHelper.newDynamicObject((String)"task_crebreakrulerecord");
            breakRule.set("histaskid", (Object)historyTaskId);
            breakRule.set("subscorerule", (Object)subScoreRuleId);
            breakRecords.add(breakRule);
        }
        if (breakRecords.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])breakRecords.toArray(new DynamicObject[0]));
        }
    }

    private static List<Long> getSubScoreRuleIdsByWithdrawalIds(List<Long> ids) {
        ArrayList<Long> subScoreRuleIds = new ArrayList<Long>();
        String algoKey = "kd.ssc.task.common.TaskApprevalUtil#getSubScoreRuleIdsByWithdrawalIds";
        QFilter idFil = new QFilter("id", "in", ids);
        QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        try (DataSet resultDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_withdrawal", (String)"subscorerule.id", (QFilter[])new QFilter[]{idFil, enableFil}, null);){
            for (Row row : resultDS) {
                Long id = row.getLong("subscorerule.id");
                if (id == 0L) continue;
                subScoreRuleIds.add(id);
            }
        }
        return subScoreRuleIds;
    }

    private static CreditPointDTO buildCreditPointDTO(DynamicObject historyTask) {
        CreditPointDTO dto = new CreditPointDTO();
        dto.setBillId(historyTask.getString("billid"));
        dto.setBillNo(historyTask.getString("billnumber"));
        dto.setBillNumber(historyTask.getString("billtype.bindbill.number"));
        dto.setUserId(historyTask.getLong("creator.id"));
        dto.setHisTaskId(historyTask.getLong("id"));
        return dto;
    }

    public static DynamicObject getHisTaskDyn(Long historyTaskId) {
        String entityName = "task_taskhistory";
        String selectFields = "id, sourcetaskid, tasktypeid.id, creator.id, billtype.id, billid, billtype.bindbill.number, billnumber, subject,assignid";
        QFilter idFilter = new QFilter("id", "=", (Object)historyTaskId);
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
    }

    public static DynamicObject getTaskInfo(long taskId) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        return QueryServiceHelper.queryOne((String)"task_task", (String)"id,assignid,subject", (QFilter[])new QFilter[]{idFilter});
    }

    private static void queryNotPassHisTask(String assignId, List<ApproveTaskResult> approveTaskResultList, String key) {
        String algoKey = TaskCreditHelper.class + ".queryNotPassHisTask()";
        String querySql = String.format(QUERY_SQL_NOT_PASS, assignId);
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)querySql);){
            if (dataSet.isEmpty()) {
                return;
            }
            for (Row row : dataSet) {
                String subject = row.getString("fsubject");
                Long subScoreRuleId = row.getLong("fsubscorerule");
                long taskId = row.getLong("fid");
                String description = String.format(StringUtils.equals((CharSequence)BAR_PASS, (CharSequence)key) ? ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u4f46\u6709\u8fdd\u89c4\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s", (String)"TaskCreditHelper_0", (String)"ssc-task-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s\u3002", (String)"TaskCreditHelper_1", (String)"ssc-task-business", (Object[])new Object[0]), subject);
                ApproveTaskResult approveTaskResult = new ApproveTaskResult(Collections.singletonList(subScoreRuleId), WorkFlowAuditTypeEnum.REJECT.getCode(), description, taskId);
                approveTaskResultList.add(approveTaskResult);
            }
        }
    }

    private static void queryPassHisTask(String assignId, List<ApproveTaskResult> approveTaskResultList, String key) {
        String algoKey = TaskCreditHelper.class + ".queryNotPassHisTask()";
        String querySql = String.format(QUERY_SQL_PASS, assignId);
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)querySql);){
            if (dataSet.isEmpty()) {
                return;
            }
            for (Row row : dataSet) {
                String subject = row.getString("fsubject");
                Long subScoreRuleId = row.getLong("fsubscorerule");
                long taskId = row.getLong("fid");
                String description = String.format(StringUtils.equals((CharSequence)BAR_PASS, (CharSequence)key) ? ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u4f46\u6709\u8fdd\u89c4\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s", (String)"TaskCreditHelper_0", (String)"ssc-task-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u4efb\u52a1\u4e3b\u9898\u4e3a\uff1a%s\u3002", (String)"TaskCreditHelper_1", (String)"ssc-task-business", (Object[])new Object[0]), subject);
                ApproveTaskResult approveTaskResult = new ApproveTaskResult(Collections.singletonList(subScoreRuleId), WorkFlowAuditTypeEnum.APPROVE.getCode(), description, taskId);
                approveTaskResultList.add(approveTaskResult);
            }
        }
    }
}

