/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class TaskQueryListPoolHelper {
    private static final Log log = LogFactory.getLog(TaskQueryListPoolHelper.class);

    public static List<Long> getByIncludeAllBindBill(List<String> sourceBillList) {
        ArrayList<Long> pkIdList = new ArrayList<Long>(8);
        if (CollectionUtils.isEmpty(sourceBillList)) {
            return pkIdList;
        }
        QFilter lastFilter = null;
        int size = sourceBillList.size();
        for (int i = 0; i < size; ++i) {
            String sourceBill = sourceBillList.get(i);
            QFilter qFilter = new QFilter("bill_new.FBasedataId", "=", (Object)sourceBill);
            if (lastFilter != null) {
                qFilter.and(lastFilter);
            }
            ArrayList<Long> lastIdList = new ArrayList<Long>(8);
            DynamicObjectCollection poolDos = QueryServiceHelper.query((String)"task_querylistpool", (String)"id,number,bill_new.FBasedataId", (QFilter[])new QFilter[]{qFilter});
            if (CollectionUtils.isEmpty((Collection)poolDos)) break;
            for (DynamicObject poolDo : poolDos) {
                Long pkId = poolDo.getLong("id");
                lastIdList.add(pkId);
            }
            lastFilter = new QFilter("id", "in", lastIdList);
            if (i != size - 1) continue;
            pkIdList.addAll(lastIdList);
        }
        log.info(" TaskQueryListPoolHelper.getByIncludeAllBindBill end: pkIdList = {}", JSON.toJSON(pkIdList));
        return pkIdList;
    }

    public static List<String> getSourceBillListById(Long taskPoolId) {
        ArrayList<String> sourceBillList = new ArrayList<String>();
        QFilter idFilter = new QFilter("id", "=", (Object)taskPoolId);
        DynamicObjectCollection poolDos = QueryServiceHelper.query((String)"task_querylistpool", (String)"id,number,bill_new.FBasedataId", (QFilter[])new QFilter[]{idFilter});
        if (!CollectionUtils.isEmpty((Collection)poolDos)) {
            for (DynamicObject poolDo : poolDos) {
                String sourceBill = poolDo.getString("bill_new.FBasedataId");
                if (!StringUtils.isNotEmpty((String)sourceBill)) continue;
                sourceBillList.add(sourceBill);
            }
        }
        return sourceBillList;
    }
}

