/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class QualityCheckSchemeBatchTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(QualityCheckSchemeBatchTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6279\u91cf\u6267\u884c\u8d28\u68c0\u65b9\u6848", (String)"QualityCheckSchemeBatchTask_0", (String)"ssc-task-business", (Object[])new Object[0]), null);
        List pkIds = (List)params.get("selectedIds");
        DynamicObject[] selectedRows = QualityCheckSchemeBatchTask.queryQualityCheckSchemesByIds(pkIds);
        int totalCount = selectedRows.length;
        int successCount = 0;
        ArrayList<String> schemeExeFailList = new ArrayList<String>(selectedRows.length);
        ArrayList<String> unableSchemeList = new ArrayList<String>(selectedRows.length);
        ArrayList<String> noTaskSchemeList = new ArrayList<String>(selectedRows.length);
        StringBuilder schemeSuccessMessage = new StringBuilder();
        StringBuilder schemeErrorMessage = new StringBuilder();
        int progress = 0;
        int totalAmt = selectedRows.length;
        for (int i = 0; i < totalAmt; ++i) {
            long nextAmt = i + 1;
            String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7b2c%1$s/%2$s\u4e2a\u8d28\u68c0\u65b9\u6848\u3002", (String)"QualityCheckSchemeBatchTask_1", (String)"ssc-task-business", (Object[])new Object[0]), nextAmt, totalAmt);
            progress = 100 * i / totalAmt;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            DynamicObject checkScheme = selectedRows[i];
            String schemeName = checkScheme.getString("name");
            DynamicObject checkSchemeInfo = this.getCheckScheme((Long)checkScheme.getPkValue());
            if (checkSchemeInfo == null) {
                schemeExeFailList.add(schemeName);
                continue;
            }
            Boolean enable = checkSchemeInfo.getBoolean("enable");
            if (!enable.booleanValue()) {
                unableSchemeList.add(schemeName);
                continue;
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"excutedonothing", (String)"task_qualitycheckscheme", (Object[])new Object[]{checkSchemeInfo.getLong("id")}, (OperateOption)OperateOption.create());
            Map result = (Map)SerializationUtils.fromJsonString((String)operationResult.getMessage(), HashMap.class);
            String message = "";
            if (!result.isEmpty()) {
                int num = Integer.parseInt(result.get("num") + "");
                if (num > -1) {
                    if (num > 0) {
                        message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u201c%1$s\u201d\u5df2\u6267\u884c\u7ed3\u675f\uff0c\u5171\u751f\u6210%2$s\u6761\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityCheckSchemeListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, num);
                        schemeSuccessMessage.append(message).append("\r\n");
                        ++successCount;
                    }
                } else {
                    message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u201c%1$s\u201d\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"QualityCheckSchemeListPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, result.get("error"));
                    schemeErrorMessage.append(message).append("\r\n");
                }
            }
            if (!StringUtils.isBlank((CharSequence)message)) continue;
            noTaskSchemeList.add(schemeName);
        }
        StringBuilder showMessage = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)schemeSuccessMessage.toString())) {
            showMessage.append((CharSequence)schemeSuccessMessage);
        }
        if (!schemeExeFailList.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848%s\uff1a\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualityCheckSchemeListPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((Object)schemeExeFailList).toString());
            showMessage.append(message);
            showMessage.append("\r\n");
        }
        if (!unableSchemeList.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u3002", (String)"QualityCheckSchemeListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((Object)unableSchemeList).toString());
            showMessage.append(message);
            showMessage.append("\r\n");
        }
        if (!noTaskSchemeList.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848%s\uff1a\u672a\u62bd\u53d6\u5230\u8d28\u68c0\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u62bd\u68c0\u53c2\u6570\u3002", (String)"QualityCheckSchemeListPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((Object)noTaskSchemeList).toString());
            showMessage.append(message);
            showMessage.append("\r\n");
        }
        if (StringUtils.isNotBlank((CharSequence)schemeErrorMessage.toString())) {
            showMessage.append((CharSequence)schemeErrorMessage);
        }
        this.feedbackResult(totalCount, successCount, showMessage.toString());
    }

    private void feedbackResult(int totalCount, int successCount, String showMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("successCount", successCount);
        result.put("failureCount", totalCount - successCount);
        result.put("showMessage", showMessage);
        this.feedbackCustomdata(result);
    }

    public static DynamicObject[] queryQualityCheckSchemesByIds(List<Long> pkIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkIds)};
        return BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"id,name,status,enable", (QFilter[])qFilters);
    }

    private DynamicObject getCheckScheme(long checkSchemeID) {
        DynamicObject checkScheme = BusinessDataServiceHelper.loadSingle((Object)checkSchemeID, (String)"task_qualitycheckscheme");
        DynamicObjectCollection taskBillEntry = checkScheme.getDynamicObjectCollection("taskbillentry");
        if (taskBillEntry.size() < 1) {
            log.info("\u591a\u9009\u4e1a\u52a1\u5355\u636e\uff0c\u6267\u884c\u8be5\u8d28\u68c0\u65b9\u6848\u65f6\u5148\u4fdd\u5b58\uff0c\u517c\u5bb9\u65e7\u6570\u636e" + checkScheme.getPkValue());
            DynamicObject taskBill = checkScheme.getDynamicObject("taskbill");
            if (taskBill == null) {
                log.info("\u8be5\u8d28\u68c0\u65b9\u6848\u5f15\u7528\u7684\u4e1a\u52a1\u5355\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c" + checkScheme.getPkValue());
                return null;
            }
            DynamicObject mulTaskBill = taskBillEntry.addNew();
            String condition = checkScheme.getString("taskbillcondiontion");
            String conditionJson = checkScheme.getString("taskbillcondiontionjson");
            mulTaskBill.set("multaskbill", taskBill.getPkValue());
            mulTaskBill.set("scale", (Object)checkScheme.getString("percentage"));
            mulTaskBill.set("samplenum", (Object)checkScheme.getString("samplesize"));
            if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)conditionJson)) {
                Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionJson, Map.class);
                String taskFilterJson = (String)filterConditionMap.get("taskparamfiler");
                String billFilterJson = (String)filterConditionMap.get("billparamfiler");
                if (StringUtils.isEmpty((CharSequence)billFilterJson) && StringUtils.isEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    mulTaskBill.set("condition", (Object)condition);
                    checkScheme.set("taskbillcondiontion", null);
                    checkScheme.set("taskbillcondiontionjson", null);
                }
                if (StringUtils.isNotEmpty((CharSequence)billFilterJson) && StringUtils.isBlank((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    mulTaskBill.set("condition", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""));
                    checkScheme.set("taskbillcondiontionjson", null);
                    checkScheme.set("taskbillcondiontion", null);
                }
                if (StringUtils.isEmpty((CharSequence)billFilterJson) && StringUtils.isNotEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", null);
                    mulTaskBill.set("condition", null);
                    checkScheme.set("taskbillcondiontionjson", (Object)taskFilterJson);
                    checkScheme.set("taskbillcondiontion", (Object)condition.replaceAll("\\(", "").replaceAll("\\)", ""));
                }
                if (StringUtils.isNotEmpty((CharSequence)billFilterJson) && StringUtils.isNotEmpty((CharSequence)taskFilterJson)) {
                    mulTaskBill.set("conditionjson", (Object)billFilterJson);
                    checkScheme.set("taskbillcondiontionjson", (Object)taskFilterJson);
                    String and = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"QualityCheckSchemePlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    String or = ResManager.loadKDString((String)"\u6216\u8005", (String)"QualityCheckSchemePlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    String splitTextAnd = ")" + and + "(";
                    String splitTextOr = ")" + or + "(";
                    String splitTextAnd2 = "\\)" + and + "\\(";
                    String splitTextOr2 = "\\)" + or + "\\(";
                    if (condition.contains(splitTextAnd)) {
                        String billCondition = condition.split(splitTextAnd2)[0];
                        String taskCondition = condition.split(splitTextAnd2)[1];
                        mulTaskBill.set("condition", (Object)billCondition.replaceAll("\\(", ""));
                        checkScheme.set("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                    } else if (condition.contains(splitTextOr)) {
                        String billCondition = condition.split(splitTextOr2)[0];
                        String taskCondition = condition.split(splitTextOr2)[1];
                        mulTaskBill.set("condition", (Object)billCondition.replaceAll("\\(", ""));
                        checkScheme.set("taskbillcondiontion", (Object)taskCondition.replaceAll("\\)", ""));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkScheme});
        }
        return checkScheme;
    }
}

