/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.enums.TaskPauseResultEnum;
import kd.ssc.enums.TaskStateEnum;

public class TaskServiceHelper {
    private static final Log log = LogFactory.getLog(TaskServiceHelper.class);
    private static final String OP_PAUSE = "3";
    private static final String OP_CANCEL_PAUSE = "4";
    private static final String CODE_FAILED = "1";
    private static final String OPERATE_PAUSE = "pause";
    private static final String OPERATE_CANCELPAUSE = "cancelPause";

    public static Map<String, Object> updateTaskSuspendedStateByTaskId(Long taskId, String operate, String reason, List<Long> pendingOpinionList, Long operatorId) {
        return TaskServiceHelper.updateTaskSuspendedStateByTaskId(taskId, operate, reason, pendingOpinionList, operatorId, null);
    }

    public static Map<String, Object> updateTaskSuspendedStateByTaskId(Long taskId, String operate, String reason, List<Long> pendingOpinionList, Long operatorId, Set<Long> attIds) {
        boolean isQualityTask;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        DynamicObject task = null;
        try {
            task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"id,state,qualitysamplelibrary,pendingopinion,pendingopinions,apprevalmessage,approveop,operatorId,tasktypeid,billtype");
        }
        catch (Exception e) {
            log.error(taskId + "\u7684\u4efb\u52a1\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (task == null) {
            TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.TASK_NOT_FOUND);
            return resultMap;
        }
        String state = task.getString("state");
        boolean bl = isQualityTask = task.getDynamicObject("qualitysamplelibrary") != null;
        if (isQualityTask) {
            log.info(taskId + "\u4e3a\u8d28\u68c0\u4efb\u52a1");
            TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.TASK_NOT_FOUND);
            return resultMap;
        }
        if (OPERATE_PAUSE.equals(operate)) {
            if (CollectionUtils.isEmpty(pendingOpinionList) && StringUtils.isEmpty((String)reason)) {
                TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.NO_PAUSE_REASON);
                return resultMap;
            }
            if (TaskStateEnum.PAUSE.getValue().equals(state)) {
                log.info(taskId + "\u5df2\u7ecf\u662f\u6682\u6302\u72b6\u6001");
                TaskServiceHelper.buildResult(resultMap, Boolean.TRUE, TaskPauseResultEnum.ALREADY_TARGET_STATE);
                return resultMap;
            }
            if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
                TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.STATE_ERROR);
                return resultMap;
            }
            String apprevalMessage = "";
            StringBuilder nameSb = new StringBuilder();
            task.set("pendingopinion", (Object)reason);
            if (CollectionUtils.isNotEmpty(pendingOpinionList)) {
                QFilter filter = new QFilter("id", "in", pendingOpinionList);
                DynamicObject[] taskPendingDos = BusinessDataServiceHelper.load((String)"task_pendingreason", (String)"id, number, name, description", (QFilter[])new QFilter[]{filter});
                DynamicObjectCollection pendingClos = task.getDynamicObjectCollection("pendingopinions");
                if (taskPendingDos != null && taskPendingDos.length > 0) {
                    pendingClos.clear();
                    for (DynamicObject taskPendingDo : taskPendingDos) {
                        DynamicObject item = pendingClos.addNew();
                        item.set("fbasedataid", taskPendingDo.getPkValue());
                        nameSb.append(taskPendingDo.getString("name")).append(',');
                    }
                    if (nameSb.length() > 0) {
                        apprevalMessage = nameSb.substring(0, nameSb.length() - 1);
                    }
                }
                task.set("pendingopinions", (Object)pendingClos);
            }
            if (StringUtils.isNotEmpty((String)reason)) {
                apprevalMessage = apprevalMessage + ":" + reason;
            }
            task.set("apprevalmessage", (Object)apprevalMessage);
            task.set("state", (Object)TaskStateEnum.PAUSE.getValue());
            task.set("approveop", (Object)OP_PAUSE);
        } else if (OPERATE_CANCELPAUSE.equals(operate)) {
            if (!TaskStateEnum.PAUSE.getValue().equals(state)) {
                TaskServiceHelper.buildResult(resultMap, Boolean.TRUE, TaskPauseResultEnum.ALREADY_TARGET_STATE);
                return resultMap;
            }
            String originState = TaskServiceHelper.getOldJobState(taskId);
            task.set("state", (Object)originState);
            task.set("apprevalmessage", null);
            task.set("approveop", (Object)CODE_FAILED);
        } else {
            TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.UNKNOW_OPERATE);
            return resultMap;
        }
        if (operatorId != null && operatorId != 0L) {
            task.set("operatorId", (Object)operatorId);
        }
        try (TXHandle h = TX.requiresNew((String)"updateTask");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                String operation = OPERATE_PAUSE.equals(operate) ? OP_PAUSE : OP_CANCEL_PAUSE;
                TaskServiceHelper.insertStateChangeRecord(task, state, operation, attIds);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                h.markRollback();
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("code", CODE_FAILED);
                resultMap.put("message", String.format(ResManager.loadKDString((String)"\u6682\u6302\u6216\u53d6\u6d88\u6682\u6302\u5f02\u5e38\uff1a%s", (String)"TaskServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]), e));
                HashMap<String, Object> hashMap = resultMap;
                if (h != null) {
                    if (var11_12 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var11_12.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return hashMap;
            }
        }
        TaskServiceHelper.buildResult(resultMap, Boolean.TRUE, TaskPauseResultEnum.SUCCESS);
        return resultMap;
    }

    public static Map<String, Object> updateTaskSuspendedStateByBill(String billType, String billId, String operate, String reason) {
        String operation;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        HashMap<DynamicObject, String> taskOldStateMap = new HashMap<DynamicObject, String>(2);
        DynamicObject[] taskInfos = TaskServiceHelper.getTaskInfoByFilter(billType, billId);
        if (taskInfos == null || taskInfos.length == 0) {
            TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.TASK_NOT_FOUND);
            return resultMap;
        }
        if (OPERATE_PAUSE.equals(operate)) {
            if (StringUtils.isEmpty((String)reason)) {
                TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.NO_PAUSE_REASON);
                return resultMap;
            }
            for (DynamicObject dynamicObject : taskInfos) {
                String string = dynamicObject.getString("state");
                if (TaskStateEnum.PAUSE.getValue().equals(string)) {
                    log.info(dynamicObject.getLong("id") + "\u5df2\u7ecf\u662f\u6682\u6302\u72b6\u6001\u4e86");
                    continue;
                }
                if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(string) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(string)) continue;
                dynamicObject.set("apprevalmessage", (Object)reason);
                dynamicObject.set("pendingopinion", (Object)reason);
                dynamicObject.set("state", (Object)TaskStateEnum.PAUSE.getValue());
                dynamicObject.set("approveop", (Object)OP_PAUSE);
                taskOldStateMap.put(dynamicObject, string);
            }
        } else if (OPERATE_CANCELPAUSE.equals(operate)) {
            for (DynamicObject dynamicObject : taskInfos) {
                String string = dynamicObject.getString("state");
                if (!TaskStateEnum.PAUSE.getValue().equals(string)) continue;
                Long taskId = dynamicObject.getLong("id");
                String originState = TaskServiceHelper.getOldJobState(taskId);
                dynamicObject.set("state", (Object)originState);
                dynamicObject.set("apprevalmessage", null);
                dynamicObject.set("approveop", (Object)CODE_FAILED);
                taskOldStateMap.put(dynamicObject, originState);
            }
        } else {
            TaskServiceHelper.buildResult(resultMap, Boolean.FALSE, TaskPauseResultEnum.UNKNOW_OPERATE);
            return resultMap;
        }
        String string = operation = OPERATE_PAUSE.equals(operate) ? OP_PAUSE : OP_CANCEL_PAUSE;
        if (taskOldStateMap.size() > 0) {
            try (TXHandle h = TX.requiresNew((String)"batchUpdateTask");){
                try {
                    for (Map.Entry entry : taskOldStateMap.entrySet()) {
                        DynamicObject task = (DynamicObject)entry.getKey();
                        String state2 = (String)entry.getValue();
                        SaveServiceHelper.update((DynamicObject)task);
                        TaskServiceHelper.insertStateChangeRecord(task, state2, operation);
                    }
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                    h.markRollback();
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("code", CODE_FAILED);
                    resultMap.put("message", String.format(ResManager.loadKDString((String)"\u6682\u6302\u6216\u53d6\u6d88\u6682\u6302\u5f02\u5e38\uff1a%s", (String)"TaskServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]), exception));
                    HashMap<String, Object> hashMap = resultMap;
                    if (h != null) {
                        if (var9_11 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var9_11.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return hashMap;
                }
            }
        }
        TaskServiceHelper.buildResult(resultMap, Boolean.TRUE, TaskPauseResultEnum.SUCCESS);
        return resultMap;
    }

    public static void insertStateChangeRecord(DynamicObject task, String oldState, String operation) {
        TaskServiceHelper.insertStateChangeRecord(task, oldState, operation, null);
    }

    public static void insertStateChangeRecord(DynamicObject task, String oldState, String operation, Set<Long> attIds) {
        DynamicObject tscDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        tscDyo.set("operatorid", (Object)RequestContext.get().getCurrUserId());
        tscDyo.set("operation", (Object)operation);
        tscDyo.set("newjobstate", (Object)task.getString("state"));
        tscDyo.set("oldjobstate", (Object)oldState);
        tscDyo.set("changetime", (Object)new Date());
        if (OP_PAUSE.equals(operation)) {
            tscDyo.set("message", (Object)task.getString("apprevalMessage"));
        }
        tscDyo.set("jobid", task.get("id"));
        tscDyo.set("tasktype", (Object)task.getLong("tasktypeid.id"));
        tscDyo.set("billtype", (Object)task.getLong("billtype.id"));
        int operationNum = TaskServiceHelper.getOperationSize(task.getLong("id"));
        tscDyo.set("operationnum", (Object)(++operationNum));
        if (CollectionUtils.isNotEmpty(attIds)) {
            DynamicObjectCollection entries = tscDyo.getDynamicObjectCollection("entry");
            for (Long attId : attIds) {
                DynamicObject entryDyo = entries.addNew();
                entryDyo.set("attid", (Object)attId);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tscDyo});
    }

    private static int getOperationSize(long id) {
        QFilter filter = new QFilter("jobid", "=", (Object)id);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"task_statechange", (String)"id", (QFilter[])filter.toArray());
        return col.size();
    }

    public static String getOldJobState(Long taskId) {
        int operationnum;
        QFilter jobIdFilter = new QFilter("jobid", "=", (Object)taskId);
        QFilter opFil = new QFilter("operation", "!=", (Object)"26");
        DynamicObjectCollection stateCollection = QueryServiceHelper.query((String)"task_statechange", (String)"id,oldjobstate,operationnum", (QFilter[])new QFilter[]{jobIdFilter, opFil}, (String)"operationnum desc");
        String oldjobstate = (String)((DynamicObject)stateCollection.get(0)).get("oldjobstate");
        if (stateCollection.size() > 0 && (operationnum = ((Integer)((DynamicObject)stateCollection.get(0)).get("operationnum")).intValue()) == 0) {
            DynamicObjectCollection statebyChangeTime = QueryServiceHelper.query((String)"task_statechange", (String)"id,oldjobstate,operationnum", (QFilter[])new QFilter[]{jobIdFilter, opFil}, (String)"changetime desc");
            oldjobstate = (String)((DynamicObject)statebyChangeTime.get(0)).get("oldjobstate");
        }
        return oldjobstate;
    }

    private static DynamicObject[] getTaskInfoByFilter(String billType, String billId) {
        QFilter billTypeFilter = new QFilter("billtype.bindbill.number", "=", (Object)billType);
        QFilter billNoFilter = new QFilter("billid", "=", (Object)billId);
        QFilter notQuality = new QFilter("qualitysamplelibrary", "=", (Object)0);
        QFilter poolTypeFilter = new QFilter("pooltype", "=", (Object)CODE_FAILED);
        return BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid,billtype.id,state,qualitysamplelibrary,apprevalmessage,pendingopinion", (QFilter[])new QFilter[]{billTypeFilter, billNoFilter, notQuality, poolTypeFilter});
    }

    private static void buildResult(Map<String, Object> resultMap, Boolean result, TaskPauseResultEnum taskPauseResultEnum) {
        resultMap.put("success", result);
        resultMap.put("code", taskPauseResultEnum.getValue());
        resultMap.put("message", taskPauseResultEnum.getName());
    }
}

