/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.AppUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.workbill.WorkBillConfigDTO;
import kd.ssc.task.business.workbill.builder.AdvConApBuilder;
import kd.ssc.task.business.workbill.builder.FieldsetPanelApBuilder;
import kd.ssc.task.business.workbill.containercfg.AdvConApCfg;
import kd.ssc.task.business.workbill.containercfg.ContainerApCfg;
import kd.ssc.task.business.workbill.containercfg.FieldsetPanelApCfg;

public class BillFormModelBuilder {
    private static final Log log = LogFactory.getLog(BillFormModelBuilder.class);
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final String SSC_TASK_BILLFORMMODELBUILDER_SAVE = "ssc.task.billFormModelBuilder.save";
    private static final String SSC_TASK_BILLFORMMODELBUILDER_DELTABLE = "ssc.task.billFormModelBuilder.deltable";
    private static final String SSC_TASK_BILLFORMMODELBUILDER_DELMETADATA = "ssc.task.billFormModelBuilder.delmetadata";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    public static final String BIZUNIT_VALUE = "2O+0I8AANUD9";
    private static final String FORMID = "formid";
    private static final String FORMNAME = "formname";
    private static final String DUPLICATEENTRY = "Duplicate entry";
    private static final String SSC_TASK_BUSINESS = "ssc-task-business";
    private DesignerData designerData = new DesignerData();
    private WorkBillConfigDTO billConfig;

    public BillFormModelBuilder(WorkBillConfigDTO billConfig) {
        this.billConfig = billConfig;
    }

    public Map<String, Object> createBillFormModel() {
        Throwable throwable;
        TXHandle tx;
        Map<String, Object> metaDataMap;
        String formName;
        HashMap<String, Object> message;
        block20: {
            HashMap<String, Object> hashMap;
            block21: {
                block22: {
                    message = new HashMap<String, Object>(8);
                    formName = this.billConfig.getFormName().getLocaleValue_zh_CN();
                    metaDataMap = this.buildDesignFormMetaDataMap();
                    tx = TX.requiresNew((String)SSC_TASK_BILLFORMMODELBUILDER_SAVE);
                    throwable = null;
                    Map save = this.designerData.save(metaDataMap);
                    if (save.get(SUCCESS) == null || ((Boolean)save.get(SUCCESS)).booleanValue() || save.get(ERRORS) == null) break block20;
                    message.put(SUCCESS, Boolean.FALSE);
                    message.put(MESSAGE, ((ErrorInfo)((ArrayList)save.get(ERRORS)).get(0)).getError());
                    hashMap = message;
                    if (tx == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                tx.close();
            }
            return hashMap;
        }
        try {
            try {
                String formId = (String)metaDataMap.get("id");
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BillFormModelBuilder_0", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u52a8\u6001\u521b\u5efa\u5355\u636e\u3010%s\u3011\u5143\u6a21\u578b", (String)"BillFormModelBuilder_1", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formName));
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
                dObject.set(BIZAPP, (Object)this.billConfig.getBizAppId());
                dObject.set(BIZUNIT, (Object)BIZUNIT_VALUE);
                dObject.set("form", (Object)formId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BillFormModelBuilder_0", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"BillFormModelBuilder_2", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
                message.put(FORMID, formId);
                message.put(FORMNAME, formName);
                message.put(SUCCESS, Boolean.TRUE);
                message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f", (String)"BillFormModelBuilder_3", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
            }
            catch (NullPointerException exception) {
                log.error((Throwable)exception);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u5143\u6a21\u578b\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe", (String)"BillFormModelBuilder_4", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formName);
                if (msg.contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010%1$s\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a%2$s", (String)"BillFormModelBuilder_5", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), this.billConfig.getFormNumber(), msg);
                }
                message.put(MESSAGE, msg);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = e.getMessage();
                if (e.getMessage().contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u7801\u3010%1$s\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a%2$s", (String)"BillFormModelBuilder_5", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), this.billConfig.getFormNumber(), msg);
                }
                message.put(MESSAGE, msg);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return message;
    }

    private Map<String, Object> buildDesignFormMetaDataMap() {
        String appId = this.billConfig.getBizAppId();
        LocaleString formName = this.billConfig.getFormName();
        String formNumber = this.billConfig.getFormNumber();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)"2LYDMCNXHB+5", (MetaCategory)MetaCategory.Form);
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setParentId("2LYDMCNXHB+5");
        formMeta.setName(formName);
        formMeta.setKey(formNumber);
        formMeta.setModelType("BillFormModel");
        formMeta.setInheritPath(this.getInheritPath(formMeta));
        formMeta.setDevType("0");
        formMeta.setBizappId(appId);
        this.setInheritFlag(formMeta.getItems());
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        MainEntity mainEntity = entityMeta.getRootEntity();
        entityMeta.setId(formMeta.getId());
        entityMeta.setParentId("2LYDMCNXHB+5");
        entityMeta.setModelType("BillFormModel");
        mainEntity.setTemplate(false);
        ((BillEntity)mainEntity).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        entityMeta.setName(formName);
        entityMeta.setKey(formNumber);
        mainEntity.setKey(formNumber);
        mainEntity.setTableName(this.billConfig.getTableName());
        mainEntity.setdbRoute(this.billConfig.getDBRoute());
        entityMeta.setBizappId(appId);
        this.setInheritFlag(entityMeta.getItems());
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityMeta.getId());
        this.createMetaBuildContext(formMeta);
        List containerCfgLi = this.billConfig.getContainerCfgLi();
        this.createControl(formMeta, entityMeta, containerCfgLi);
        String currentIsv = ISVService.getISVInfo().getId();
        if (kd.bos.util.StringUtils.isEmpty((String)currentIsv)) {
            ErrorCode errCode = new ErrorCode("ssc.task.createBillModel", ResManager.loadKDString((String)"\u521b\u5efa\u5355\u636e\u5143\u6570\u636e\u6a21\u578b\u5931\u8d25\u3002", (String)"BillFormModelBuilder_6", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
            throw new KDException(errCode, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"BillFormModelBuilder_7", (String)SSC_TASK_BUSINESS, (Object[])new Object[0])});
        }
        entityMeta.setIsv(currentIsv);
        formMeta.setIsv(currentIsv);
        return formMeta.buildDesignMeta(RequestContext.get().getLang().name());
    }

    private String getInheritPath(FormMetadata formMeta) {
        String inheritPath = formMeta.getInheritPath();
        return kd.bos.util.StringUtils.isNotEmpty((String)inheritPath) ? inheritPath + ',' + "2LYDMCNXHB+5" : "2LYDMCNXHB+5";
    }

    private void setInheritFlag(List<? extends AbstractElement> els) {
        for (AbstractElement abstractElement : els) {
            abstractElement.setInherit(true);
        }
    }

    private void createMetaBuildContext(FormMetadata formMeta) {
        MetaBuildContext context = new MetaBuildContext();
        formMeta.setBuildContext(context);
    }

    private void createControl(FormMetadata formMeta, EntityMetadata entityMetadata, List<ContainerApCfg> containerCfgLi) {
        FieldsetPanelApBuilder fieldPanelApBuilder = new FieldsetPanelApBuilder(formMeta, entityMetadata);
        AdvConApBuilder advConApBuilder = new AdvConApBuilder(formMeta, entityMetadata);
        for (ContainerApCfg cfg : containerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.addControlAp((FieldsetPanelApCfg)cfg);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            advConApBuilder.addControlAp((AdvConApCfg)cfg);
        }
    }

    public Map<String, Object> updateBillFormModel() {
        String formNumber_;
        Map saveMsg = null;
        String formName = this.billConfig.getFormName().getLocaleValue_zh_CN();
        String formId = this.billConfig.getFormId();
        if (kd.bos.util.StringUtils.isEmpty((String)formId)) {
            saveMsg = this.createBillFormModel();
            log.warn("\u4fee\u6539\u5355\u636e\u3010" + formName + "\u3011\u5143\u6570\u636e\u5f02\u5e38\uff0c \u5355\u636e\u5143\u6570\u636e\u4e0d\u5b58\u5728\u91cd\u65b0\u521b\u5efa\u4e00\u4e2a");
            return saveMsg;
        }
        String formNumber = this.billConfig.getFormNumber();
        if (!StringUtils.equals((CharSequence)formNumber, (CharSequence)(formNumber_ = MetadataDao.getNumberById((String)formId)))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u3010%1$s\u3011\u5bf9\u5e94\u7684\u5355\u636e\u5143\u6570\u636e\u6a21\u578b\u3010%2$s\u3011\u6807\u8bc6\u5df2\u88ab\u7be1\u6539\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u5e73\u53f0\u624b\u52a8\u6539\u56de\uff1a%3$s", (String)"BillFormModelBuilder_11", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formNumber, formNumber_, formNumber));
        }
        String lang = RequestContext.get().getLang().name();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        List<String> templates = Arrays.asList(formMeta.getInheritPath().split(","));
        if (!templates.contains("2LYDMCNXHB+5")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7981\u6b62\u4fee\u6539\uff0c\u5143\u6570\u636e%1$s\u3010%2$s\u3011\u4e0d\u662f\u901a\u7528\u5de5\u5355\u6a21\u677f\u6d3e\u751f\u51fa\u6765\u7684", (String)"BillFormModelBuilder_10", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formName, formNumber));
        }
        Map oldMetaDataMap = formMeta.buildDesignMeta(lang);
        formMeta.setName(this.billConfig.getFormName());
        entityMeta.setName(this.billConfig.getFormName());
        this.deleteControl(formMeta, entityMeta, this.billConfig.getDelContainerCfgLi(), this.billConfig.getContainerCfgLi());
        this.updateControl(formMeta, entityMeta, this.billConfig.getContainerCfgLi());
        formMeta.bindEntityMetadata(entityMeta);
        Map metaDataMap = formMeta.buildDesignMeta(lang);
        saveMsg = this.designerData.save(metaDataMap, oldMetaDataMap);
        if (saveMsg.get(SUCCESS) != null && !((Boolean)saveMsg.get(SUCCESS)).booleanValue() && saveMsg.get(ERRORS) != null) {
            saveMsg.put(SUCCESS, Boolean.FALSE);
            saveMsg.put(MESSAGE, ((ErrorInfo)((ArrayList)saveMsg.get(ERRORS)).get(0)).getError());
            return saveMsg;
        }
        AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"BillFormModelBuilder_8", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u52a8\u6001\u4fee\u6539\u5355\u636e\u3010%s\u3011\u5143\u6a21\u578b", (String)"BillFormModelBuilder_9", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formName));
        return saveMsg;
    }

    private void updateControl(FormMetadata formMeta, EntityMetadata entityMetadata, List<ContainerApCfg> containerCfgLi) {
        FieldsetPanelApBuilder fieldPanelApBuilder = new FieldsetPanelApBuilder(formMeta, entityMetadata);
        AdvConApBuilder advConApBuilder = new AdvConApBuilder(formMeta, entityMetadata);
        for (ContainerApCfg cfg : containerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.updateControlAp((FieldsetPanelApCfg)cfg);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            advConApBuilder.updateControlAp((AdvConApCfg)cfg);
        }
    }

    private void deleteControl(FormMetadata formMeta, EntityMetadata entityMetadata, List<ContainerApCfg> delContainerCfgLi, List<ContainerApCfg> containerCfgLi) {
        HashSet<String> tables = new HashSet<String>(8);
        tables.add(this.billConfig.getTableName());
        boolean existsDelFields = false;
        for (ContainerApCfg cfg : containerCfgLi) {
            if (!CollectionUtils.isEmpty((Collection)cfg.getDelFieldCfgLi())) {
                existsDelFields = true;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            tables.add(((AdvConApCfg)cfg).getEntryTableName());
        }
        if (!existsDelFields && CollectionUtils.isEmpty(delContainerCfgLi)) {
            log.info("Nothing to delete. FormNumber = " + this.billConfig.getFormNumber());
            return;
        }
        delContainerCfgLi.forEach(p -> {
            if (p instanceof AdvConApCfg) {
                tables.add(((AdvConApCfg)p).getEntryTableName());
            }
        });
        if (this.existsBizData(tables)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u7981\u6b62\u5220\u9664\u5b57\u6bb5\u3002", (String)"BillFormModelBuilder_19", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
        }
        FieldsetPanelApBuilder fieldPanelApBuilder = new FieldsetPanelApBuilder(formMeta, entityMetadata);
        AdvConApBuilder advConApBuilder = new AdvConApBuilder(formMeta, entityMetadata);
        for (ContainerApCfg cfg : delContainerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.deleteControlAp((FieldsetPanelApCfg)cfg, true);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            advConApBuilder.deleteControlAp((AdvConApCfg)cfg, true);
        }
        for (ContainerApCfg cfg : containerCfgLi) {
            if (cfg instanceof FieldsetPanelApCfg) {
                fieldPanelApBuilder.deleteControlAp((FieldsetPanelApCfg)cfg, false);
                continue;
            }
            if (!(cfg instanceof AdvConApCfg)) continue;
            advConApBuilder.deleteControlAp((AdvConApCfg)cfg, false);
        }
    }

    private boolean existsBizData(Set<String> tables) {
        DBRoute dbRoute = DBRoute.of((String)this.billConfig.getDBRoute());
        String algoKey = this.getClass() + ".existBillBizData()";
        String queSql = "select 1 from %s";
        String dropSql = "drop table %s";
        ArrayList<String> needDropTables = new ArrayList<String>(tables.size());
        for (String tableName : tables) {
            if (!DB.exitsTable((DBRoute)dbRoute, (String)tableName)) continue;
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)String.format(queSql, tableName));){
                if (!ds.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
            needDropTables.add(tableName);
        }
        try (TXHandle tx = TX.requiresNew((String)SSC_TASK_BILLFORMMODELBUILDER_DELTABLE);){
            try {
                for (String delTableName : needDropTables) {
                    DB.execute((DBRoute)dbRoute, (String)String.format(dropSql, delTableName));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6570\u636e\u8868\u51fa\u9519\uff1aneedDropTables = " + ((Object)needDropTables).toString(), (Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
        return false;
    }

    public Map<String, Object> deleteBillFormModel() {
        Map<String, Object> delMsg = new HashMap<String, Object>(2);
        String formId = this.billConfig.getFormId();
        String formName = this.billConfig.getFormName().getLocaleValue();
        String formNumber = MetadataDao.getNumberById((String)formId);
        if (kd.bos.util.StringUtils.isEmpty((String)formId) || !MetadataDao.checkNumber((String)formNumber)) {
            log.warn("\u5355\u636e\u3010" + formName + "\u3011\u5143\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
            delMsg.put(SUCCESS, Boolean.TRUE);
            delMsg.put(MESSAGE, ResManager.loadKDString((String)"\u5355\u636e\u5143\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"BillFormModelBuilder_12", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
            return delMsg;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List<String> templates = Arrays.asList(formMeta.getInheritPath().split(","));
        if (!templates.contains("2LYDMCNXHB+5")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7981\u6b62\u5220\u9664\uff0c\u5143\u6570\u636e%1$s\u3010%2$s\u3011\u4e0d\u662f\u901a\u7528\u5de5\u5355\u6a21\u677f\u6d3e\u751f\u51fa\u6765\u7684", (String)"BillFormModelBuilder_13", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), formName, formNumber));
        }
        HashSet<String> tables = new HashSet<String>(8);
        tables.add(this.billConfig.getTableName());
        List containerCfgLi = this.billConfig.getContainerCfgLi();
        for (ContainerApCfg cfg : containerCfgLi) {
            if (!(cfg instanceof AdvConApCfg)) continue;
            tables.add(((AdvConApCfg)cfg).getEntryTableName());
        }
        if (this.existsBizData(tables)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u7981\u6b62\u5220\u9664\u5143\u6570\u636e\u6a21\u578b\u3002", (String)"BillFormModelBuilder_14", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
        }
        QFilter f1 = new QFilter(BIZUNIT, "=", (Object)BIZUNIT_VALUE);
        QFilter f2 = new QFilter("form", "=", (Object)formId);
        DynamicObject funcUnitDynObj = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"id", (QFilter[])new QFilter[]{f1, f2});
        DynamicObject recycleDynObj = DevportalUtil.createRecycleBinFormData((String)formId, (String)ResManager.loadKDString((String)"\u901a\u8fc7\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3->\u5de5\u5355\u7ba1\u7406\u5220\u9664\u8868\u5355\u5143\u6570\u636e", (String)"BillFormModelBuilder_17", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
        try (TXHandle h = TX.requiresNew((String)SSC_TASK_BILLFORMMODELBUILDER_DELMETADATA);){
            try {
                if (funcUnitDynObj != null) {
                    String pkId = funcUnitDynObj.getString("id");
                    Object[] pkIds = new String[]{pkId};
                    MainEntityType met = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_UNITRELFORM);
                    DeleteServiceHelper.delete((IDataEntityType)met, (Object[])pkIds);
                    AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BillFormModelBuilder_15", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"BillFormModelBuilder_16", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recycleDynObj});
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BillFormModelBuilder_15", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5c06\u5220\u9664\u7684\u8868\u5355\u5b58\u5165\u56de\u6536\u7ad9\uff01", (String)"BillFormModelBuilder_18", (String)SSC_TASK_BUSINESS, (Object[])new Object[0]));
                delMsg = MetadataDao.delFormMetadata((String)formId);
            }
            catch (Exception e) {
                h.markRollback();
                log.error("\u5220\u9664\u5355\u636e\u3010" + formName + "\u3011\u5143\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
        return delMsg;
    }
}

