/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.core;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;
import kd.sdk.fi.ssc.extpoint.approve.ITaskCancelPendService;
import kd.ssc.enums.Source;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.approveRebuild.MsgTypeEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.entity.PersonChangeTypeEnum;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.approveRebuild.helper.ArtiCheckPointRecordHelper;
import kd.ssc.task.approveRebuild.helper.BillOperationHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveFailureHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveSuccessHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveValidateHelper;
import kd.ssc.task.approveRebuild.helper.TaskCompleteHelper;
import kd.ssc.task.approveRebuild.helper.TaskQueryHelper;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.business.helper.WorkflowApproveRecordHelper;
import kd.ssc.task.business.task.TaskServiceHelper;
import kd.ssc.task.common.TaskApprevalUtil;
import kd.ssc.task.create.CreateParTaskByWorkFlow;
import kd.ssc.task.delete.service.impl.DeleteTaskServiceImpl;
import kd.ssc.task.formplugin.TaskModifyPriority;
import kd.ssc.task.formplugin.util.ArtiCheckPointUtil;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.helper.TaskQueryServiceHelper;
import kd.ssc.task.image.SscImageServiceHelper;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class CoreTaskApprove {
    private static final Log log = LogFactory.getLog(CoreTaskApprove.class);
    private static final String FORM_DHC_INQUIRYBILL = "dhc_inquirybill";

    public Map<String, Object> taskApproveSubmit(Map<String, Object> paramMap) {
        String msg;
        Map<String, Object> resultMap = new HashMap<String, Object>(8);
        String operation = (String)paramMap.get("operation");
        if (StringUtils.isEmpty((CharSequence)operation) && StringUtils.isNotEmpty((CharSequence)(msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5ba1\u6279\u64cd\u4f5c\u201d\u3002", (String)"CoreTaskApprove_10", (String)"ssc-task-formplugin", (Object[])new Object[0])))) {
            return TaskApproveFailureHelper.getFailureResult("SSC_1001", msg);
        }
        switch (operation) {
            case "1": {
                resultMap = this.taskApproveSubmitByPass(paramMap);
                break;
            }
            case "2": {
                resultMap = this.taskApproveSubmitByNoPass(paramMap);
                break;
            }
            case "3": {
                resultMap = this.taskApproveByPend(paramMap);
                break;
            }
            case "4": {
                resultMap = this.taskApproveByRescan(paramMap);
                break;
            }
        }
        return resultMap;
    }

    private void initParamMap(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = this.getTaskDo(taskId);
        paramMap.put("billId", taskDo.getString("billid"));
        paramMap.put("billNo", taskDo.getString("billnumber"));
        long billTypeId = taskDo.getLong("billtype.id");
        paramMap.put("billTypeId", billTypeId);
        paramMap.put("taskTypeId", taskDo.getLong("tasktypeid.id"));
        paramMap.put("billNumber", taskDo.getString("billtype.bindbill.number"));
        paramMap.put("erpNumber", TaskApproveHelper.getErpNumber(billTypeId));
        paramMap.put("assignId", taskDo.getString("assignid"));
        paramMap.put("personId", taskDo.getString("personid.id"));
        paramMap.put("state", taskDo.getString("state"));
        paramMap.put("pooltype", taskDo.getString("pooltype"));
        paramMap.put("source", taskDo.getString("source"));
        Long sscId = taskDo.getLong("sscid");
        paramMap.put("sscId", sscId);
        String sscType = DutyManageDataHelper.getSSCType((long)sscId);
        paramMap.put("sscType", sscType);
        String qualityJudge = taskDo.getString("tasktypeid.qualityjudge");
        paramMap.put("taskProperty", qualityJudge);
    }

    protected DynamicObject getTaskDo(Long taskId) {
        String entityName = "task_task";
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, tasktypeid.qualityjudge, personid.id, imagenumber,billtype, billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion, approveop, unpassreasondata, assignid, source";
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
    }

    public Map<String, Object> taskApproveSubmitByPass(Map<String, Object> paramMap) {
        this.initParamMap(paramMap);
        String billNumber = (String)paramMap.get("billNumber");
        String billId = (String)paramMap.get("billId");
        Long billTypeId = (Long)paramMap.get("billTypeId");
        Long taskTypeId = (Long)paramMap.get("taskTypeId");
        String erpNumber = (String)paramMap.get("erpNumber");
        boolean isKDCC = "KDCC".equalsIgnoreCase(erpNumber);
        String voucherMsg = TaskApproveValidateHelper.voucherStrongVerifyBySubmit(billTypeId, taskTypeId, billNumber, Long.parseLong(billId));
        if (isKDCC && StringUtils.isNotEmpty((CharSequence)voucherMsg)) {
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", voucherMsg);
        }
        return this.auditPass0(paramMap);
    }

    public Map<String, Object> taskApproveSubmitByNoPass(Map<String, Object> paramMap) {
        boolean isDelVoucher;
        this.initParamMap(paramMap);
        String billNumber = (String)paramMap.get("billNumber");
        String billId = (String)paramMap.get("billId");
        String decisionItem = (String)paramMap.get("decisionItem");
        String assignId = (String)paramMap.get("assignId");
        Long decisionId = (Long)paramMap.get("curDecisionItem");
        String nodeItemId = (String)paramMap.get("nodeItemId");
        Long billTypeId = (Long)paramMap.get("billTypeId");
        Long taskTypeId = (Long)paramMap.get("taskTypeId");
        if (!(decisionItem.equals("3") || !(isDelVoucher = this.isDelVoucher(billTypeId, taskTypeId)) && this.isNextSccNoteForReject(billId, assignId, decisionId, nodeItemId))) {
            String erpNumber = (String)paramMap.get("erpNumber");
            boolean isKDCC = "KDCC".equalsIgnoreCase(erpNumber);
            String voucherMsg = TaskApproveValidateHelper.voucherStrongVerifyByReturn(billNumber, Long.parseLong(billId));
            if (isKDCC && StringUtils.isNotEmpty((CharSequence)voucherMsg)) {
                return TaskApproveFailureHelper.getFailureResult("SSC_2001", voucherMsg);
            }
        }
        Map<String, Object> resultMap = new HashMap<String, Object>(8);
        switch (decisionItem) {
            case "2": {
                resultMap = this.nopass(paramMap);
                break;
            }
            case "3": {
                resultMap = this.processRet(paramMap);
                break;
            }
            case "4": {
                resultMap = this.returnboth(paramMap);
                break;
            }
        }
        return resultMap;
    }

    private boolean isDelVoucher(Long billTypeId, Long taskTypeId) {
        if (ObjectUtils.isEmpty((Object)billTypeId) || ObjectUtils.isEmpty((Object)taskTypeId)) {
            return true;
        }
        DynamicObject dynamicTaskBill = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)"task_taskbill");
        String createTaskModel = dynamicTaskBill.getString("createtaskmodel.id");
        boolean isNeedVoucher = dynamicTaskBill.getBoolean("isneedvoucher");
        if ("0".equals(createTaskModel) || !isNeedVoucher) {
            return true;
        }
        DynamicObjectCollection taskRuleBills = dynamicTaskBill.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)taskRuleBills)) {
            return true;
        }
        Long childPKid = taskRuleBills.stream().filter(data -> taskTypeId.equals(data.getLong("tasktype.id"))).map(data -> data.getLong("childpkid")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)childPKid)) {
            return true;
        }
        DynamicObject dynamicTaskCreateRule = BusinessDataServiceHelper.loadSingleFromCache((Object)childPKid, (String)"task_taskbill_child");
        if (ObjectUtils.isEmpty((Object)dynamicTaskCreateRule)) {
            return true;
        }
        return dynamicTaskCreateRule.getBoolean("isdelvoucher");
    }

    private boolean isNextSccNoteForReject(String billId, String assignId, Long decisionId, String nodeItemId) {
        boolean result;
        log.info("\u662f\u5426\u5171\u4eab\u8282\u70b9\u5165\u53c2\uff1abillId:{},workFlowId:{},decisionId:{},nodeItemId:{}", new Object[]{billId, assignId, decisionId, nodeItemId});
        if (StringUtils.isEmpty((CharSequence)assignId)) {
            return false;
        }
        Long workFlowId = Long.valueOf(assignId);
        WFDecisionOption wfDecisionOption = this.matchDecisionOption(workFlowId, decisionId);
        if (wfDecisionOption == null) {
            return false;
        }
        String auditType = wfDecisionOption.getAuditType();
        List rejectNodesModels = wfDecisionOption.getRejectOptions();
        switch (auditType) {
            case "approve": {
                result = true;
                break;
            }
            case "reject": {
                String nodeType = this.queryNextNoteTypeForReject(billId, rejectNodesModels, nodeItemId);
                result = nodeType.contains("SSCApprove");
                log.info("\u662f\u5426\u5171\u4eab\u8282\u70b9\uff0c\u9a73\u56de\u81f3\u8282\u70b9\u7c7b\u578b\uff1a{}", (Object)nodeType);
                break;
            }
            case "terminate": {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        log.info("\u662f\u5426\u5171\u4eab\u8282\u70b9\uff1a{}", (Object)result);
        return result;
    }

    private WFDecisionOption matchDecisionOption(Long workFlowId, Long decisionId) {
        DynamicObject dynamicObject;
        String decisionValue = "Reject";
        if (decisionId != null && decisionId != 0L && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)decisionId, (String)"task_decisionitem")) != null) {
            decisionValue = dynamicObject.getString("decisionvalue");
        }
        WorkflowServiceImpl workflowService = (WorkflowServiceImpl)ServiceFactory.getService((String)"WorkflowService");
        List approvalDecisionOptions = workflowService.getApprovalDecisionOptions(workFlowId);
        for (WFDecisionOption decisionOption : approvalDecisionOptions) {
            if (!decisionOption.getNumber().equals(decisionValue)) continue;
            return decisionOption;
        }
        return null;
    }

    private String queryNextNoteTypeForReject(String billId, List<WFRejectNodesModel> rejectNodesModels, String nodeItemId) {
        if (!CollectionUtils.isEmpty(rejectNodesModels)) {
            Map latestApprovalRecordMap = WorkflowApproveRecordHelper.getLatestApprovalRecordMap((String)billId);
            ApprovalRecordItem approvalRecordItem = latestApprovalRecordMap.containsKey(nodeItemId) ? (ApprovalRecordItem)latestApprovalRecordMap.get(nodeItemId) : (ApprovalRecordItem)latestApprovalRecordMap.get(rejectNodesModels.get(0).getItemId());
            return approvalRecordItem != null && approvalRecordItem.getNodeType() != null ? approvalRecordItem.getNodeType() : "";
        }
        List approvalRecordGroupList = WorkflowServiceHelper.getAllApprovalRecord((String)billId);
        Set waitGroupActivityIds = null;
        boolean start = false;
        for (int index = approvalRecordGroupList.size() - 1; index >= 0; --index) {
            IApprovalRecordGroup lastGroup;
            IApprovalRecordGroup curGroup = (IApprovalRecordGroup)approvalRecordGroupList.get(index);
            String decisionType = curGroup.getGroupDecisionType();
            List curGroupChildren = CollectionUtils.isEmpty((Collection)curGroup.getChildren()) ? Collections.emptyList() : curGroup.getChildren();
            Set curGroupActivityIds = curGroupChildren.stream().map(IApprovalRecordItem::getActivityId).collect(Collectors.toSet());
            if ("wait".equals(decisionType) && index - 1 >= 0) {
                lastGroup = (IApprovalRecordGroup)approvalRecordGroupList.get(index - 1);
                if ("approve".equals(lastGroup.getGroupDecisionType()) || "submit".equals(lastGroup.getGroupDecisionType())) {
                    IApprovalRecordItem approvalRecordItem = lastGroup.getChildren().stream().max(Comparator.comparing(IApprovalRecordItem::getTime)).orElseGet(ApprovalRecordItem::new);
                    return StringUtils.isNotEmpty((CharSequence)approvalRecordItem.getNodeType()) ? approvalRecordItem.getNodeType() : "";
                }
                start = true;
                waitGroupActivityIds = curGroupActivityIds;
                continue;
            }
            if (!start || CollectionUtils.isEmpty(waitGroupActivityIds) || !CollectionUtils.containsAny(waitGroupActivityIds, curGroupActivityIds) || index - 1 < 0 || !"approve".equals((lastGroup = (IApprovalRecordGroup)approvalRecordGroupList.get(index - 1)).getGroupDecisionType()) && !"submit".equals(lastGroup.getGroupDecisionType())) continue;
            IApprovalRecordItem approvalRecordItem = lastGroup.getChildren().stream().max(Comparator.comparing(IApprovalRecordItem::getTime)).orElseGet(ApprovalRecordItem::new);
            return StringUtils.isNotEmpty((CharSequence)approvalRecordItem.getNodeType()) ? approvalRecordItem.getNodeType() : "";
        }
        return "";
    }

    private Map<String, Object> auditPass0(Map<String, Object> paramMap) {
        return this.nextBillAudit(paramMap);
    }

    private Map<String, Object> nextBillAudit(Map<String, Object> paramMap) {
        String formName = (String)paramMap.get("billNumber");
        if (!FORM_DHC_INQUIRYBILL.equals(formName)) {
            paramMap.put("decisionItem", null);
        }
        return this.auditHandle(paramMap, "bar_pass");
    }

    private Map<String, Object> nopass(Map<String, Object> paramMap) {
        return this.nextBillNoPassHandle(paramMap);
    }

    private Map<String, Object> returnboth(Map<String, Object> paramMap) {
        String innerMsg;
        String opinion;
        String state = (String)paramMap.get("state");
        if (!(TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) || TaskStateEnum.RESCAN.getValue().equals(state) || TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u3001\u201c\u9000\u56de\u91cd\u626b\u201d\u3001\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u6253\u56de\uff08\u542b\u5f71\u50cf\uff09\u3002", (String)"CoreTaskApprove_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        boolean isCanRescan = true;
        String billId = (String)paramMap.get("billId");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billId);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (imageInfoInside == null) {
            log.info("\u65e0\u5f71\u50cf\u8bb0\u5f55, billId:" + billId);
            isCanRescan = false;
        }
        if (StringUtils.isEmpty((CharSequence)(opinion = (String)paramMap.get("opinion")))) {
            opinion = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"CoreTaskApprove_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)(innerMsg = (String)paramMap.get("innerMsg")))) {
            innerMsg = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"CoreTaskApprove_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        try {
            if (isCanRescan && !"2".equals(imageInfoInside.getImageState()) && !"4".equals(imageInfoInside.getImageState())) {
                log.info("\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf, billId:" + billId);
                isCanRescan = false;
            } else if (TaskStateEnum.RESCAN.getValue().equals(state)) {
                log.info("\u5355\u636e\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u9000\u56de\u91cd\u626b\u201d\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf, billId:" + billId);
                isCanRescan = false;
            }
            log.info("\u8c03\u7528\u9000\u56de\u91cd\u626b\u63a5\u53e3\u53c2\u6570, billId = {} , isCanRescan = {}", (Object)billId, (Object)isCanRescan);
            Long taskId = (Long)paramMap.get("taskId");
            Long billTypeId = (Long)paramMap.get("billTypeId");
            Long taskTypeId = (Long)paramMap.get("taskTypeId");
            if (isCanRescan) {
                String returnReason = (String)paramMap.get("withdrawal");
                SscImageServiceHelper.rescan((String)imageInfoInside.getImageNo(), (String)billId, (String)returnReason);
                this.insertStateChangeFUT(taskId, opinion, innerMsg, "5", billTypeId, taskTypeId);
                SscImageServiceUtil.updateAccountByImageNumber((String)imageInfoInside.getImageNo(), (String)"3");
                TaskApproveHelper.updateTaskMsg(taskId, opinion, innerMsg, "5");
            }
            return this.nextBillNoPassHandle(paramMap);
        }
        catch (Exception e) {
            log.error("\u6253\u56de\uff08\u542b\u5f71\u50cf\uff09\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u6253\u56de\uff08\u542b\u5f71\u50cf\uff09\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a%1$s\u3002", (String)"CoreTaskApprove_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)e));
            return TaskApproveFailureHelper.getFailureResult("SSC_1002", msg, MsgTypeEnum.ERROR);
        }
    }

    private Map<String, Object> processRet(Map<String, Object> paramMap) {
        Object[] keys;
        boolean retSucessFlag;
        block28: {
            DynamicObjectCollection allTaskCollection;
            Throwable throwable;
            TXHandle h;
            Long workFlowId;
            block25: {
                Map<String, Object> map;
                block26: {
                    block27: {
                        Long taskId = (Long)paramMap.get("taskId");
                        workFlowId = Long.valueOf((String)paramMap.get("assignId"));
                        String withdrawal = (String)paramMap.get("withdrawal");
                        String innerMsg = (String)paramMap.get("innerMsg");
                        ParTaskNodeServiceImpl parTaskNodeService = new ParTaskNodeServiceImpl();
                        long instId = parTaskNodeService.getInstIdByTaskId(taskId.longValue());
                        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
                        QFilter nodeStateFilter = new QFilter("state", "=", (Object)InstNodeEnum.PROCESSING.getValue());
                        DynamicObjectCollection taskList = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{instIdFilter, nodeStateFilter});
                        String opinion = (String)paramMap.get("opinion");
                        ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterRtnBack((Long)taskId, (String)opinion, paramMap);
                        List<Long> taskIds = this.getStartInstTaskId(instId);
                        if (CollectionUtils.isEmpty(taskIds)) {
                            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u5f00\u59cb\u8282\u70b9\u5931\u8d25\u3002", (String)"CoreTaskApprove_6", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
                        }
                        retSucessFlag = true;
                        keys = new Object[]{};
                        if (taskList.isEmpty()) break block28;
                        h = TX.required((String)(this.getClass().getName() + "processRet"));
                        throwable = null;
                        List withdrawalIdList = (List)paramMap.get("withdrawalIdList");
                        if (!CollectionUtils.isEmpty((Collection)withdrawalIdList)) {
                            this.saveUnpassReason(taskId, withdrawalIdList);
                        }
                        keys = TaskApproveFailureHelper.processCurTask(taskId, taskList, opinion, withdrawal, innerMsg);
                        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskinst");
                        dyo.set("id", (Object)instId);
                        dyo.set("ptendtime", (Object)new Date());
                        dyo.set("ptstatus", (Object)FlowInstEnum.REPULSE.getValue());
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
                        QFilter qFilter = new QFilter("sourcetaskid", "in", taskIds);
                        DynamicObjectCollection taskHistCollection = QueryServiceHelper.query((String)"task_taskhistory", (String)"tasktypeid,billtype,billid,sscid", (QFilter[])new QFilter[]{qFilter});
                        allTaskCollection = QueryServiceHelper.query((String)"task_task", (String)"tasktypeid,billtype,billid,sscid", (QFilter[])new QFilter[]{qFilter});
                        if (!CollectionUtils.isEmpty((Collection)taskHistCollection)) {
                            allTaskCollection.addAll((Collection)taskHistCollection);
                        }
                        if (!CollectionUtils.isEmpty((Collection)allTaskCollection)) break block25;
                        String msg = ResManager.loadKDString((String)"\u6839\u636e\u5f00\u59cb\u8282\u70b9\u83b7\u53d6\u5386\u53f2\u4efb\u52a1\u5931\u8d25\u3002", (String)"CoreTaskApprove_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                        map = TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
                        if (h == null) break block26;
                        if (throwable == null) break block27;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block26;
                    }
                    h.close();
                }
                return map;
            }
            try {
                try {
                    Long[] taskTypeIds = new Long[allTaskCollection.size()];
                    for (int i = 0; i < allTaskCollection.size(); ++i) {
                        taskTypeIds[i] = ((DynamicObject)allTaskCollection.get(i)).getLong("tasktypeid");
                    }
                    long billTypeID = ((DynamicObject)allTaskCollection.get(0)).getLong("billtype");
                    String billID = ((DynamicObject)allTaskCollection.get(0)).getString("billid");
                    new CreateParTaskByWorkFlow().publishInialMessage(billID, Long.valueOf(billTypeID), taskTypeIds, workFlowId.longValue());
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("kd.ssc.task.approveRebuild.core.CoreTaskApprove.processRet:\u9000\u56de\u5171\u4eab\u5ba1\u6838\u51fa\u9519", e);
                    retSucessFlag = false;
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (retSucessFlag) {
            Long hisTaskId = null;
            try {
                Object key;
                if (keys != null && keys.length > 0 && (key = keys[0]) instanceof DynamicObject) {
                    DynamicObject taskHis = (DynamicObject)key;
                    hisTaskId = taskHis.getLong("id");
                    TaskApprevalUtil.insertWFTask(taskHis);
                }
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u6d41\u7a0b\u4efb\u52a1\u5173\u7cfb\u8868\u5931\u8d25\uff1a{}" + e.getMessage());
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("hisTaskId", hisTaskId);
            return TaskApproveSuccessHelper.getSuccessResult(data);
        }
        String msg = ResManager.loadKDString((String)"\u9000\u56de\u5171\u4eab\u5ba1\u6838\u51fa\u9519\u3002", (String)"CoreTaskApprove_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        return TaskApproveFailureHelper.getFailureResult("SSC_1002", msg);
    }

    private Map<String, Object> nextBillNoPassHandle(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        List withdrawalIdList = (List)paramMap.get("withdrawalIdList");
        if (!CollectionUtils.isEmpty((Collection)withdrawalIdList)) {
            this.saveUnpassReason(taskId, withdrawalIdList);
        }
        return this.auditHandle(paramMap, "bd_nopass");
    }

    private void saveUnpassReason(long taskId, List<Long> pkList) {
        WithdrawalSelectorUtil utils = new WithdrawalSelectorUtil();
        utils.deleteTaskWithdrawalUnpassById(taskId);
        utils.saveTaskWithdrawalUnpass(pkList, taskId);
        utils.saveTaskUnpass(pkList, taskId);
    }

    private Map<String, Object> auditHandle(Map<String, Object> paramMap, String key) {
        Object curDecisionItem;
        List subScoreRuleList;
        List withdrawalIdList;
        HashMap<String, String> map = new HashMap<String, String>(32);
        map.put("sscId", String.valueOf(paramMap.get("sscId")));
        map.put("operation", (String)paramMap.get("operation"));
        Long billTypeId = (Long)paramMap.get("billTypeId");
        map.put("billtypeid", billTypeId.toString());
        map.put("billTypeKey", paramMap.get("billNumber").toString());
        map.put("billid", paramMap.get("billId").toString());
        map.put("taskID", paramMap.get("taskId").toString());
        map.put("opinion", paramMap.get("opinion").toString());
        Object withdrawal = paramMap.get("withdrawal");
        if (withdrawal != null) {
            map.put("withdrawal", withdrawal.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)(withdrawalIdList = (List)paramMap.get("withdrawalIdList")))) {
            map.put("withdrawalids", SerializationUtils.toJsonString((Object)withdrawalIdList));
        }
        if (!CollectionUtils.isEmpty((Collection)(subScoreRuleList = (List)paramMap.get("subScoreRuleList")))) {
            String subScoreRule = SerializationUtils.toJsonString((Object)subScoreRuleList);
            map.put("subscorerule", subScoreRule);
        }
        map.put("innermsg", paramMap.get("innerMsg").toString());
        map.put("erpNumber", paramMap.get("erpNumber").toString());
        map.put("personid", paramMap.get("personId").toString());
        Long operatorId = (Long)paramMap.get("operatorId");
        if (operatorId != null && operatorId != 0L) {
            map.put("operatorId", String.valueOf(operatorId));
        }
        map.put("state", paramMap.get("state").toString());
        map.put("tasktypeid", paramMap.get("taskTypeId").toString());
        Object decisionItem = paramMap.get("decisionItem");
        if (decisionItem != null) {
            map.put("decisionitem", (String)decisionItem);
        }
        if ((curDecisionItem = paramMap.get("curDecisionItem")) == null) {
            map.put("decisionitemid", "0");
        } else {
            map.put("decisionitemid", curDecisionItem.toString());
        }
        if (paramMap.get("nodeItemId") != null) {
            map.put("nodeItemId", paramMap.get("nodeItemId").toString());
        }
        map.put("origin", (String)paramMap.get("origin"));
        map.put("subPageId", (String)paramMap.get("subPageId"));
        map.put("appId", (String)paramMap.get("appId"));
        if (paramMap.get("attachment") != null) {
            map.put("attachment", JSONObject.toJSONString((Object)paramMap.get("attachment")));
        }
        if (paramMap.containsKey("ignoreWarn")) {
            map.put("ignoreWarn", (String)paramMap.get("ignoreWarn"));
        }
        DynamicObject billData = (DynamicObject)paramMap.get("billData");
        IFormView view = (IFormView)paramMap.get("view");
        IDataModel model = (IDataModel)paramMap.get("model");
        IFormView subView = (IFormView)paramMap.get("subView");
        return TaskApproveHelper.doApproveOperation(key, map, billData, view, model, subView);
    }

    private void insertStateChangeFUT(Long taskId, String rescanmsg, String innermsg, String operation, Long taskTypeId, Long billTypeId) {
        Timestamp changetime = new Timestamp(System.currentTimeMillis());
        long operatorid = Long.parseLong(RequestContext.get().getUserId());
        ORM orm = ORM.create();
        DynamicObject stateChangeobj = orm.newDynamicObject("task_statechange");
        stateChangeobj.set("innermsg", (Object)innermsg);
        stateChangeobj.set("message", (Object)rescanmsg);
        stateChangeobj.set("operatorid", (Object)operatorid);
        stateChangeobj.set("operation", (Object)operation);
        stateChangeobj.set("changetime", (Object)changetime);
        stateChangeobj.set("jobid", (Object)taskId);
        stateChangeobj.set("tasktype", (Object)taskTypeId);
        stateChangeobj.set("billtype", (Object)billTypeId);
        if ("5".equals(operation)) {
            stateChangeobj.set("oldjobstate", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
            stateChangeobj.set("newjobstate", (Object)TaskStateEnum.RESCAN.getValue());
        } else if ("20".equals(operation)) {
            stateChangeobj.set("oldjobstate", (Object)TaskStateEnum.RESCAN.getValue());
            stateChangeobj.set("newjobstate", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stateChangeobj});
    }

    private List<Long> getStartInstTaskId(Long insId) {
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("instantid", "=", (Object)insId);
        QFilter qFilter2 = new QFilter("parenttaskid", "=", (Object)0);
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        for (DynamicObject dyo : queryList) {
            if (dyo.get("taskid") == null) continue;
            taskIdList.add(dyo.getLong("taskid"));
        }
        return taskIdList;
    }

    public Map<String, Object> taskApproveByPend(Map<String, Object> paramMap) {
        Map<String, Object> resultMap;
        this.initParamMap(paramMap);
        Map<String, Object> failureResult = BillOperationHelper.doBillOperationResult(paramMap);
        if (failureResult != null) {
            return failureResult;
        }
        Long taskId = (Long)paramMap.get("taskId");
        String reason = (String)paramMap.get("reason");
        List pendingOpinionList = (List)paramMap.get("pendingOpinionList");
        Long operatorId = (Long)paramMap.get("operatorId");
        Map attMap = (Map)paramMap.get("attachment");
        Set attIds = attMap == null ? null : attMap.keySet();
        Map suspendedMap = TaskServiceHelper.updateTaskSuspendedStateByTaskId((Long)taskId, (String)"pause", (String)reason, (List)pendingOpinionList, (Long)operatorId, attIds);
        log.info("kd.ssc.task.approveRebuild.core.CoreTaskApprove.taskApproveByPend(),suspendedMap=" + JSONObject.toJSONString((Object)suspendedMap));
        Boolean success = (Boolean)suspendedMap.get("success");
        if (success != null && success.booleanValue()) {
            resultMap = TaskApproveSuccessHelper.getSuccessResult(null);
        } else {
            String message = (String)suspendedMap.get("message");
            resultMap = TaskApproveFailureHelper.getFailureResult("SSC_2001", message);
        }
        Long sscId = (Long)paramMap.get("sscId");
        SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.UPDATE, (Long)sscId, (Long)taskId);
        SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.PEND);
        return resultMap;
    }

    public Map<String, Object> taskApproveByRescan(Map<String, Object> paramMap) {
        String innerMsg;
        this.initParamMap(paramMap);
        String billId = (String)paramMap.get("billId");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billId);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (imageInfoInside == null) {
            String msg = ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\u6620\u5c04\u8bb0\u5f55", (String)"CoreTaskApprove_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        if (!"2".equals(imageInfoInside.getImageState()) && !"4".equals(imageInfoInside.getImageState())) {
            String msg = ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"CoreTaskApprove_12", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg, MsgTypeEnum.ERROR);
        }
        Map<String, Object> failureResult = BillOperationHelper.doBillOperationResult(paramMap);
        if (failureResult != null) {
            return failureResult;
        }
        String opinion = (String)paramMap.get("opinion");
        if (StringUtils.isEmpty((CharSequence)opinion)) {
            opinion = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"CoreTaskApprove_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)(innerMsg = (String)paramMap.get("innerMsg")))) {
            innerMsg = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"CoreTaskApprove_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        String rescanOpinion = (String)paramMap.get("rescanOpinion");
        try {
            log.info("\u8c03\u7528\u9000\u56de\u91cd\u626b\u63a5\u53e3\u53c2\u6570, billId:" + billId);
            Long taskId = (Long)paramMap.get("taskId");
            Long billTypeId = (Long)paramMap.get("billTypeId");
            Long taskTypeId = (Long)paramMap.get("taskTypeId");
            SscImageServiceHelper.rescan((String)imageInfoInside.getImageNo(), (String)billId, (String)rescanOpinion);
            this.insertStateChangeFUT(taskId, opinion, innerMsg, "5", billTypeId, taskTypeId);
            SscImageServiceUtil.updateAccountByImageNumber((String)imageInfoInside.getImageNo(), (String)"3");
            SscImageServiceUtil.updateImageScanIntoRescan((String)imageInfoInside.getImageNo());
        }
        catch (Exception e) {
            log.error("\u9000\u626b\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u9000\u626b\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a%1$s\u3002", (String)"CoreTaskApprove_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)e));
            return TaskApproveFailureHelper.getFailureResult("SSC_1002", msg, MsgTypeEnum.ERROR);
        }
        return TaskApproveSuccessHelper.getSuccessResult(null);
    }

    public Map<String, Object> taskApproveBySave(Map<String, Object> paramMap) {
        Map<String, Object> failureResult;
        this.initParamMap(paramMap);
        Long taskId = (Long)paramMap.get("taskId");
        Boolean billOpr = (Boolean)paramMap.get("billOpr");
        if ((billOpr == null || billOpr.booleanValue()) && (failureResult = BillOperationHelper.doBillOperationResult(paramMap)) != null) {
            return failureResult;
        }
        try {
            Map attMap;
            DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"sscid, pooltype,state,innermsg,completetime,bizdata_tag,apprevalmessage,billtype.id,tasktypeid.id,approveop,decisionitem,decisionitemnew,unpassreasonid,pendingopinion,pendingopinions,rescanopinion,unpassreasondesc,unpassreasondata,itemid", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
            if (paramMap.containsKey("opinion")) {
                String opinion = (String)paramMap.get("opinion");
                if (StringUtils.isNotEmpty((CharSequence)opinion) && opinion.length() > 2000) {
                    opinion = opinion.substring(0, 2000);
                }
                task.set("apprevalmessage", (Object)opinion);
            }
            if (paramMap.containsKey("innerMsg")) {
                String innerMsg = (String)paramMap.get("innerMsg");
                task.set("innermsg", (Object)innerMsg);
            }
            if (paramMap.containsKey("approveOp")) {
                String approveOp = (String)paramMap.get("approveOp");
                task.set("approveop", (Object)approveOp);
            }
            if (paramMap.containsKey("decisionItem")) {
                String decisionItem = (String)paramMap.get("decisionItem");
                task.set("decisionitem", (Object)decisionItem);
            }
            if (paramMap.containsKey("curDecisionItem")) {
                Long curDecisionItem = (Long)paramMap.get("curDecisionItem");
                task.set("decisionitemnew", (Object)curDecisionItem);
            }
            if (paramMap.containsKey("nodeItemId")) {
                String nodeItemId = (String)paramMap.get("nodeItemId");
                task.set("itemid", (Object)nodeItemId);
            }
            if (paramMap.containsKey("withdrawal")) {
                String withdrawal = (String)paramMap.get("withdrawal");
                task.set("unpassreasondesc", (Object)withdrawal);
            }
            if (paramMap.containsKey("withdrawalIdList")) {
                List withdrawalIdList = (List)paramMap.get("withdrawalIdList");
                if (CollectionUtils.isEmpty((Collection)withdrawalIdList)) {
                    task.set("unpassreasondata", (Object)"");
                } else {
                    task.set("unpassreasondata", (Object)SerializationUtils.toJsonString((Object)withdrawalIdList));
                }
            }
            if (paramMap.containsKey("pendingopinion")) {
                String pendingopinion = (String)paramMap.get("pendingopinion");
                task.set("pendingopinion", (Object)pendingopinion);
            }
            if (paramMap.containsKey("pendingOpinionList")) {
                List pendingOpinionList = (List)paramMap.get("pendingOpinionList");
                if (!CollectionUtils.isEmpty((Collection)pendingOpinionList)) {
                    QFilter filter = new QFilter("id", "in", (Object)pendingOpinionList);
                    DynamicObject[] taskPendingDos = BusinessDataServiceHelper.load((String)"task_pendingreason", (String)"id, number, name, description", (QFilter[])new QFilter[]{filter});
                    DynamicObjectCollection pendingClos = task.getDynamicObjectCollection("pendingopinions");
                    if (taskPendingDos != null && taskPendingDos.length > 0) {
                        pendingClos.clear();
                        for (DynamicObject taskPendingDo : taskPendingDos) {
                            DynamicObject item = pendingClos.addNew();
                            item.set("fbasedataid", taskPendingDo.getPkValue());
                        }
                    }
                    task.set("pendingopinions", (Object)pendingClos);
                } else {
                    task.set("pendingopinions", null);
                }
            }
            if (paramMap.containsKey("rescanOpinion")) {
                String rescanOpinion = (String)paramMap.get("rescanOpinion");
                task.set("rescanopinion", (Object)rescanOpinion);
            }
            Set attIds = (attMap = (Map)paramMap.get("attachment")) == null ? null : attMap.keySet();
            try (TXHandle h = TX.requiresNew((String)(CoreTaskApprove.class + ".taskApproveBySave()"));){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                    TaskServiceHelper.insertStateChangeRecord((DynamicObject)task, (String)task.getString("state"), (String)"26", attIds);
                }
                catch (Exception e) {
                    log.error(CoreTaskApprove.class + ".taskApproveBySave(): save DB exception");
                    h.markRollback();
                    throw e;
                }
            }
            Long sscId = task.getLong("sscid.id");
            SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.UPDATE, (Long)sscId, (Long)taskId);
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u4efb\u52a1\uff0c\u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            return TaskApproveFailureHelper.getFailureResult("SSC_1002", errorMsg, MsgTypeEnum.ERROR);
        }
        return TaskApproveSuccessHelper.getSuccessResult(null);
    }

    public Map<String, Object> saveArtiCheckPointInfo(Map<String, Object> paramMap) {
        try {
            Long taskId = (Long)paramMap.get("taskId");
            Boolean allPass = (Boolean)paramMap.get("allPass");
            Long hisTaskId = 0L;
            List recordList = (List)paramMap.get("recordList");
            DynamicObject taskDo = this.getTaskDo(taskId);
            if (taskDo == null) {
                String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, billtype.id";
                QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
                taskDo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
                hisTaskId = taskDo.getLong("id");
            }
            Long billTypeId = taskDo.getLong("billtype.id");
            Long taskTypeId = taskDo.getLong("tasktypeid.id");
            log.info("saveArtiCheckPointInfo taskId = {},hisTaskId = {},billTypeId = {},taskTypeId = {}", new Object[]{taskId, hisTaskId, billTypeId, taskTypeId});
            ArtiCheckPointRecordHelper artiCheckPointRecordHelper = new ArtiCheckPointRecordHelper();
            QFilter filter = new QFilter("taskid", "=", (Object)String.valueOf(taskId));
            DynamicObject[] articheckpointrecords = BusinessDataServiceHelper.load((String)"task_articheckpointrecord", (String)"id,taskid,articheckpoint.id,createtime", (QFilter[])new QFilter[]{filter});
            if (articheckpointrecords != null && articheckpointrecords.length > 0) {
                if (CollectionUtils.isEmpty((Collection)recordList)) {
                    artiCheckPointRecordHelper.saveRecord(hisTaskId, articheckpointrecords);
                } else {
                    artiCheckPointRecordHelper.saveRecordByUpdate(taskId, hisTaskId, filter, recordList);
                }
            } else if (CollectionUtils.isEmpty((Collection)recordList)) {
                DynamicObjectCollection artiCheckPoints = ArtiCheckPointUtil.getArtiCheckPointByBillTypeId(billTypeId, String.valueOf(taskTypeId), taskDo.get("billid"));
                if (artiCheckPoints == null) {
                    log.info("\u4e1a\u52a1\u5355\u636e-\u4eba\u5de5\u68c0\u67e5\u9879\u914d\u7f6e\uff0c\u4e3a\u7a7a\u65e0\u9700\u65b0\u589e\u4eba\u5de5\u68c0\u67e5\u9879\u8bb0\u5f55");
                } else {
                    artiCheckPointRecordHelper.saveRecordByConfig(taskId, hisTaskId, artiCheckPoints, allPass);
                }
            } else {
                artiCheckPointRecordHelper.saveRecordByUpdate(taskId, hisTaskId, filter, recordList);
            }
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u4efb\u52a1\uff0c\u4fdd\u5b58\u4eba\u5de5\u68c0\u67e5\u9879\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            return TaskApproveFailureHelper.getFailureResult("SSC_1002", errorMsg, MsgTypeEnum.ERROR);
        }
        return TaskApproveSuccessHelper.getSuccessResult(null);
    }

    public Map<String, Object> taskApproveByCancelPend(Map<String, Object> paramMap) {
        String success;
        this.initParamMap(paramMap);
        Long taskId = (Long)paramMap.get("taskId");
        PluginProxy pluginProxy = PluginProxy.create(null, ITaskCancelPendService.class, (String)"kd.ssc.task.approveRebuild.core.CoreTaskApprove.taskApproveByCancelPendExt");
        HashMap extResultMap = new HashMap(8);
        List extResultMapList = pluginProxy.callReplace(p -> p.beforeCancelPend(taskId, paramMap));
        if (!CollectionUtils.isEmpty((Collection)extResultMapList)) {
            for (Map map : extResultMapList) {
                if (CollectionUtils.isEmpty((Map)map)) continue;
                extResultMap.putAll(map);
            }
        }
        if (!CollectionUtils.isEmpty(extResultMap) && "false".equals(success = (String)extResultMap.get("success"))) {
            String errCode = (String)extResultMap.get("errCode");
            String msg = (String)extResultMap.get("msg");
            String msgType = (String)extResultMap.get("msgType");
            Map<String, Object> failureResult = TaskApproveFailureHelper.getFailureResult(errCode, msg);
            failureResult.put("msgType", msgType);
            return failureResult;
        }
        Map verifyResult = SscEventDistributor.cancelPendVerify((Long)taskId, paramMap);
        String success2 = (String)verifyResult.get("success");
        if ("false".equals(success2)) {
            return verifyResult;
        }
        Map<String, Object> failureResult = BillOperationHelper.doBillOperationResult(paramMap);
        if (failureResult != null) {
            return failureResult;
        }
        Map<String, Object> resultMap = this.doTaskCancelPend(paramMap, taskId);
        Long sscId = (Long)paramMap.get("sscId");
        SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.UPDATE, (Long)sscId, (Long)taskId);
        SscEventDistributor.personChangeNotify((Long)taskId, (PersonChangeTypeEnum)PersonChangeTypeEnum.CANCEL_PEND);
        pluginProxy.callReplace(p -> {
            p.afterCancelPend(taskId, paramMap, resultMap);
            return null;
        });
        return resultMap;
    }

    private Map<String, Object> doTaskCancelPend(Map<String, Object> paramMap, Long taskId) {
        Map<String, Object> resultMap;
        Long operatorId = (Long)paramMap.get("operatorId");
        Map suspendedMap = TaskServiceHelper.updateTaskSuspendedStateByTaskId((Long)taskId, (String)"cancelPause", null, null, (Long)operatorId);
        log.info("kd.ssc.task.approveRebuild.core.CoreTaskApprove.taskApproveByCancelPend(),suspendedMap=" + JSONObject.toJSONString((Object)suspendedMap));
        Boolean success = (Boolean)suspendedMap.get("success");
        if (success != null && success.booleanValue()) {
            resultMap = TaskApproveSuccessHelper.getSuccessResult(null);
        } else {
            String message = (String)suspendedMap.get("message");
            resultMap = TaskApproveFailureHelper.getFailureResult("SSC_2001", message);
        }
        return resultMap;
    }

    public Map<String, Object> taskApproveByComplete(Map<String, Object> paramMap) {
        this.initParamMap(paramMap);
        String msg = TaskApproveValidateHelper.checkTaskComplete(paramMap);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long taskId = (Long)paramMap.get("taskId");
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long operatorId = (Long)paramMap.get("operatorId");
        String source = (String)paramMap.get("source");
        DynamicObject taskHisDo = TaskCompleteHelper.completeSscTask(taskId, currentPersonId, operatorId);
        if (Integer.toString(Source.WorkFlow.getValue()).equals(source) || Integer.toString(Source.ParTask.getValue()).equals(source)) {
            String resultName = ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210", (String)"CoreTaskApprove_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String auditMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210", (String)"CoreTaskApprove_13", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            Long personId = taskHisDo.getLong("personid.id");
            TaskWorkFlowUtil.updateWfSscNodeInfoByTaskHis((DynamicObject)taskHisDo, (String)resultName, (String)auditMessage, (long)personId, (String)TaskPoolTypeEnum.COMPLETE.getValue());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        long hisTaskId = taskHisDo.getLong("id");
        data.put("hisTaskId", hisTaskId);
        return TaskApproveSuccessHelper.getSuccessResult(data);
    }

    public Map<String, Object> taskApproveByTerminate(Map<String, Object> paramMap) {
        this.initParamMap(paramMap);
        String msg = TaskApproveValidateHelper.checkTaskTerminate(paramMap);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long taskId = (Long)paramMap.get("taskId");
        Long operatorId = (Long)paramMap.get("operatorId");
        String source = (String)paramMap.get("source");
        DynamicObject taskHisDo = TaskCompleteHelper.terminateSscTask(taskId, operatorId);
        if (Integer.toString(Source.WorkFlow.getValue()).equals(source) || Integer.toString(Source.ParTask.getValue()).equals(source)) {
            String resultName = ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62", (String)"CoreTaskApprove_16", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String auditMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62", (String)"CoreTaskApprove_16", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            Long personId = taskHisDo.getLong("personid.id");
            TaskWorkFlowUtil.updateWfSscNodeInfoByTaskHis((DynamicObject)taskHisDo, (String)resultName, (String)auditMessage, (long)personId, (String)"7");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        long hisTaskId = taskHisDo.getLong("id");
        data.put("hisTaskId", hisTaskId);
        return TaskApproveSuccessHelper.getSuccessResult(data);
    }

    public Map<String, Object> taskQueryByBillId(Map<String, Object> paramMap) {
        DynamicObject[] taskHisDos;
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        Long billId = (Long)paramMap.get("billId");
        String entityNumber = (String)paramMap.get("entityNumber");
        DynamicObject[] taskDos = TaskQueryHelper.QueryTaskByBillId("task_task", String.valueOf(billId), entityNumber);
        if (taskDos != null && taskDos.length != 0) {
            taskList.addAll(Arrays.asList(taskDos));
        }
        if ((taskHisDos = TaskQueryHelper.QueryTaskByBillId("task_taskhistory", String.valueOf(billId), entityNumber)) != null && taskHisDos.length != 0) {
            taskList.addAll(Arrays.asList(taskHisDos));
        }
        ArrayList taskMapList = new ArrayList();
        if (!CollectionUtils.isEmpty(taskList)) {
            for (DynamicObject task : taskList) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                taskMap.put("taskId", task.getLong("id"));
                taskMap.put("sscId", task.getLong("sscid.id"));
                taskMap.put("billTypeId", task.getLong("billtype.id"));
                taskMap.put("taskTypeId", task.getLong("tasktypeid.id"));
                taskMap.put("taskProperty", task.getString("tasktypeid.qualityjudge"));
                taskMap.put("poolType", task.getString("pooltype"));
                taskMap.put("state", task.getString("state"));
                DynamicObject personid = (DynamicObject)task.get("personid");
                Long personId = personid != null ? Long.valueOf(personid.getLong("id")) : null;
                taskMap.put("personId", personId);
                taskMap.put("assignId", task.getString("assignid"));
                taskMapList.add(taskMap);
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("taskList", taskMapList);
        return TaskApproveSuccessHelper.getSuccessResult(data);
    }

    public Map<String, Object> taskDeleteByTaskId(Map<String, Object> paramMap) {
        this.initParamMap(paramMap);
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = this.getTaskDo(taskId);
        DeleteTaskServiceImpl deleteTaskService = new DeleteTaskServiceImpl();
        boolean success = deleteTaskService.deleteTaskAndInst(taskDo);
        if (success) {
            String source = (String)paramMap.get("source");
            if (Integer.toString(Source.WorkFlow.getValue()).equals(source) || Integer.toString(Source.ParTask.getValue()).equals(source)) {
                String resultName = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664", (String)"CoreTaskApprove_14", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                String auditMessage = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4eba\u5de5\u5220\u9664", (String)"CoreTaskApprove_15", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                Long personId = taskDo.getLong("personid.id");
                TaskWorkFlowUtil.updateWfMsgAfterTaskDelete((DynamicObject)taskDo, (String)resultName, (String)auditMessage, (long)personId, (int)1);
            }
        }
        return TaskApproveSuccessHelper.getSuccessResult(null);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> taskModifyPriorityByBatch(Map<String, Object> paramMap) {
        void var15_19;
        HashMap<String, Object> data;
        List taskIdList = (List)paramMap.get("taskIdList");
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long targetLevelId = (Long)paramMap.get("targetLevelId");
        DynamicObject targetLevelDo = QueryServiceHelper.queryOne((String)"task_tasklevel", (String)"priority", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)targetLevelId)});
        String adjustSource = (String)paramMap.get("adjustSource");
        List<Map<String, Object>> taskListInfo = TaskQueryServiceHelper.getMyTaskListInfoByPkIds(new HashSet<Long>(taskIdList));
        Map<Long, Map<String, Object>> finalData = CoreTaskApprove.getFinalDataMap(taskListInfo);
        ArrayList<Long> existIdList = new ArrayList<Long>(8);
        boolean success = true;
        ArrayList<Long> successIdList = new ArrayList<Long>(8);
        ArrayList<Map<String, Object>> stateChangeList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> msgMapList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Long, Map<String, Object>> entry : finalData.entrySet()) {
            Long taskId = entry.getKey();
            existIdList.add(taskId);
            Map<String, Object> detail = entry.getValue();
            String subject = (String)detail.get("subject");
            String state = (String)detail.get("state");
            Long qualitySampleLibrary = (Long)detail.get("qualitySampleLibrary");
            Set canSelectPriority = (Set)detail.get("canSelectPriority");
            String downAdjustStr = (String)detail.get("downAdjust");
            Integer currLevel = (Integer)detail.get("level");
            String msg = TaskApproveValidateHelper.checkTaskModifyPriority(state, qualitySampleLibrary, currLevel, canSelectPriority, targetLevelId, targetLevelDo, downAdjustStr, adjustSource);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                msg = String.format("%s\uff1a" + msg, subject);
                Map<String, Object> itemResultMap = TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
                success = false;
                this.addMsgMap(msgMapList, taskId, itemResultMap);
                continue;
            }
            successIdList.add(taskId);
            HashMap<String, Object> paraMap = new HashMap<String, Object>(4);
            paraMap.put("selectedRowId", taskId);
            paraMap.put("billTypeId", detail.get("billTypeId"));
            paraMap.put("taskTypeId", detail.get("taskTypeId"));
            stateChangeList.add(paraMap);
        }
        TaskModifyPriority taskModifyPriority = new TaskModifyPriority();
        taskModifyPriority.taskModifyPriority(successIdList, targetLevelId);
        taskModifyPriority.updateStateChange(stateChangeList, currentPersonId);
        for (Long taskId : taskIdList) {
            if (existIdList.contains(taskId)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            Map<String, Object> itemResultMap = TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
            success = false;
            this.addMsgMap(msgMapList, taskId, itemResultMap);
        }
        if (success) {
            data = new HashMap<String, Object>();
            data.put("successIdList", successIdList);
            Map<String, Object> map = TaskApproveSuccessHelper.getSuccessResult(data);
        } else {
            data = new HashMap();
            data.put("successIdList", successIdList);
            Map<String, Object> map = TaskApproveFailureHelper.getFailureResultByBatch(msgMapList, data);
        }
        return var15_19;
    }

    private static Map<Long, Map<String, Object>> getFinalDataMap(List<Map<String, Object>> taskListInfo) {
        HashMap<Long, Map<String, Object>> finalData = new HashMap<Long, Map<String, Object>>(10);
        if (!CollectionUtils.isEmpty(taskListInfo)) {
            for (Map<String, Object> map : taskListInfo) {
                Long taskId = (Long)map.get("taskId");
                Map detailMap = finalData.getOrDefault(taskId, new HashMap());
                detailMap.put("qualitySampleLibrary", map.get("qualitySampleLibrary"));
                detailMap.put("billTypeId", map.get("billTypeId"));
                detailMap.put("taskTypeId", map.get("taskTypeId"));
                detailMap.put("level", map.get("level"));
                detailMap.put("subject", map.get("subject"));
                detailMap.put("taskId", taskId);
                detailMap.put("state", map.get("state"));
                Set canSelectList = detailMap.getOrDefault("canSelectPriority", new HashSet());
                canSelectList.add((Long)map.get("priority"));
                detailMap.put("canSelectPriority", canSelectList);
                detailMap.put("downAdjust", map.get("downAdjust"));
                finalData.put(taskId, detailMap);
            }
        }
        return finalData;
    }

    private void addMsgMap(List<Map<String, Object>> msgMapList, Long taskId, Map<String, Object> itemResultMap) {
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("taskId", taskId);
        msgMap.put("errCode", itemResultMap.get("errCode"));
        msgMap.put("msg", itemResultMap.get("msg"));
        msgMap.put("msgType", itemResultMap.get("msgType"));
        msgMapList.add(msgMap);
    }
}

