/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.core;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.approveRebuild.core.CoreTaskApprove;
import kd.ssc.task.approveRebuild.helper.TaskApproveFailureHelper;
import kd.ssc.task.helper.MutexCacheHelper;

public class CoreTaskApproveSyncWrapper
extends CoreTaskApprove {
    private static final Log log = LogFactory.getLog(CoreTaskApproveSyncWrapper.class);
    private CoreTaskApprove coreTaskApprove;

    public CoreTaskApproveSyncWrapper() {
        this.coreTaskApprove = new CoreTaskApprove();
    }

    public CoreTaskApproveSyncWrapper(CoreTaskApprove coreTaskApprove) {
        this.coreTaskApprove = coreTaskApprove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> taskApproveSubmitByPass(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String state = taskDo.getString("state");
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u5ba1\u6279\u901a\u8fc7\u3002", (String)"CoreTaskApproveSyncWrapper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (!personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        boolean locked = this.getLock(taskId);
        if (!locked) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\u3002", (String)"CoreTaskApproveSyncWrapper_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_1003", msg);
        }
        try {
            Map<String, Object> map = this.coreTaskApprove.taskApproveSubmitByPass(paramMap);
            return map;
        }
        finally {
            this.releaseLock(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> taskApproveSubmitByNoPass(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String state = taskDo.getString("state");
        if (!(TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) || TaskStateEnum.TO_UPLOAD_IMAGE.getValue().equals(state) || TaskStateEnum.RESCAN.getValue().equals(state) || TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u3001\u201c\u5f85\u4e0a\u4f20\u5f71\u50cf\u201d\u3001\u201c\u9000\u56de\u91cd\u626b\u201d\u3001\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u5ba1\u6279\u4e0d\u901a\u8fc7\u3002", (String)"CoreTaskApproveSyncWrapper_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (personId != null && personId != 0L && !personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        boolean locked = this.getLock(taskId);
        if (!locked) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\u3002", (String)"CoreTaskApproveSyncWrapper_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_1003", msg);
        }
        try {
            Map<String, Object> map = this.coreTaskApprove.taskApproveSubmitByNoPass(paramMap);
            return map;
        }
        finally {
            this.releaseLock(taskId);
        }
    }

    @Override
    public Map<String, Object> taskApproveByPend(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String state = taskDo.getString("state");
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u6682\u6302\u3002", (String)"CoreTaskApproveSyncWrapper_6", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        return this.coreTaskApprove.taskApproveByPend(paramMap);
    }

    @Override
    public Map<String, Object> taskApproveByRescan(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String state = taskDo.getString("state");
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u9000\u626b\u3002", (String)"CoreTaskApproveSyncWrapper_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (!personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        return this.coreTaskApprove.taskApproveByRescan(paramMap);
    }

    @Override
    public Map<String, Object> taskApproveBySave(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        return this.coreTaskApprove.taskApproveBySave(paramMap);
    }

    @Override
    public Map<String, Object> saveArtiCheckPointInfo(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
            boolean hisTask = QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{idFilter});
            if (!hisTask) {
                String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
                return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
            }
        }
        return this.coreTaskApprove.saveArtiCheckPointInfo(paramMap);
    }

    @Override
    public Map<String, Object> taskApproveByCancelPend(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String state = taskDo.getString("state");
        if (!TaskStateEnum.PAUSE.getValue().equals(state)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u6302\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u53d6\u6d88\u6682\u6302\u3002", (String)"CoreTaskApproveSyncWrapper_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        return this.coreTaskApprove.taskApproveByCancelPend(paramMap);
    }

    @Override
    public Map<String, Object> taskApproveByComplete(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String poolType = taskDo.getString("pooltype");
        if (!TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType) && !TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u5904\u7406\u73af\u8282\u4e3a\u201c\u5f85\u5206\u914d\u201c\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u5b8c\u6210\u3002", (String)"CoreTaskApproveSyncWrapper_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (personId != 0L && !personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        return this.coreTaskApprove.taskApproveByComplete(paramMap);
    }

    @Override
    public Map<String, Object> taskApproveByTerminate(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        String poolType = taskDo.getString("pooltype");
        if (!TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u5904\u7406\u73af\u8282\u4e3a\u201c\u5904\u7406\u4e2d\u201d\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u7ec8\u6b62\u3002", (String)"CoreTaskApproveSyncWrapper_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2001", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (!personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        return this.coreTaskApprove.taskApproveByTerminate(paramMap);
    }

    @Override
    public Map<String, Object> taskDeleteByTaskId(Map<String, Object> paramMap) {
        Long taskId = (Long)paramMap.get("taskId");
        DynamicObject taskDo = super.getTaskDo(taskId);
        if (taskDo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a%1$s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CoreTaskApproveSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_2002", msg);
        }
        Long currentPersonId = (Long)paramMap.get("currentPersonId");
        Long personId = taskDo.getLong("personid.id");
        if (personId != 0L && !personId.equals(currentPersonId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u5904\u7406\u4eba\u4e0e\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4eba\u4e0d\u540c\u3002", (String)"CoreTaskApproveSyncWrapper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            return TaskApproveFailureHelper.getFailureResult("SSC_2003", msg);
        }
        return this.coreTaskApprove.taskDeleteByTaskId(paramMap);
    }

    private synchronized boolean getLock(long taskId) {
        if (MutexCacheHelper.containsMutexCache4Approve(taskId)) {
            return false;
        }
        MutexCacheHelper.putMutexCache4Approve(taskId);
        return true;
    }

    private void releaseLock(long taskId) {
        MutexCacheHelper.removeMutexCache4Approve(taskId);
    }
}

