/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ArtiCheckPointRecordHelper {
    private static final Log log = LogFactory.getLog(ArtiCheckPointRecordHelper.class);

    public void saveRecord(Long hisTaskId, DynamicObject[] articheckpointrecords) {
        log.info("ArtiCheckPointRecordHelper.saveRecord start");
        for (DynamicObject oldRecordDo : articheckpointrecords) {
            if (hisTaskId != null && hisTaskId != 0L) {
                oldRecordDo.set("taskid", (Object)hisTaskId);
            }
            oldRecordDo.set("createtime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])articheckpointrecords);
        log.info("ArtiCheckPointRecordHelper.saveRecord end");
    }

    public void saveRecordByUpdate(Long taskId, Long hisTaskId, QFilter deleteFilter, List<Map<String, Object>> recordList) {
        log.info("ArtiCheckPointRecordHelper.saveRecordByUpdate start");
        DeleteServiceHelper.delete((String)"task_articheckpointrecord", (QFilter[])new QFilter[]{deleteFilter});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(recordList.size());
        for (Map<String, Object> recordMap : recordList) {
            DynamicObject newRecordItem = new DynamicObject((DynamicObjectType)dt);
            if (hisTaskId != null && hisTaskId != 0L) {
                newRecordItem.set("taskid", (Object)hisTaskId);
            } else {
                newRecordItem.set("taskid", (Object)taskId);
            }
            newRecordItem.set("articheckpoint", recordMap.get("artiCheckPointId"));
            newRecordItem.set("createtime", (Object)new Date());
            newRecordItem.set("iscontented", recordMap.get("isContented"));
            newRecordList.add(newRecordItem);
        }
        SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[0]));
        log.info("ArtiCheckPointRecordHelper.saveRecordByUpdate end");
    }

    public void saveRecordByConfig(Long taskId, Long hisTaskId, DynamicObjectCollection artiCheckPoints, Boolean allPass) {
        log.info("ArtiCheckPointRecordHelper.saveRecordByConfig start");
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(artiCheckPoints.size());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
        for (DynamicObject artiCheckPoint : artiCheckPoints) {
            DynamicObject newRecordItem = new DynamicObject((DynamicObjectType)dt);
            if (hisTaskId != null && hisTaskId != 0L) {
                newRecordItem.set("taskid", (Object)hisTaskId);
            } else {
                newRecordItem.set("taskid", (Object)taskId);
            }
            newRecordItem.set("articheckpoint", (Object)artiCheckPoint.getLong("articheckpointid"));
            newRecordItem.set("createtime", (Object)new Date());
            if (allPass != null && allPass.booleanValue()) {
                newRecordItem.set("iscontented", (Object)Boolean.TRUE);
            } else {
                newRecordItem.set("iscontented", (Object)artiCheckPoint.getBoolean("articheckpointselected"));
            }
            newRecordList.add(newRecordItem);
        }
        SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[0]));
        log.info("ArtiCheckPointRecordHelper.saveRecordByConfig end");
    }
}

