/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.approveRebuild.helper.TaskApproveSuccessHelper;
import kd.ssc.task.common.workcalendar.CalRemainingTime;

public class TaskCompleteHelper {
    public static DynamicObject completeSscTask(Long taskId, Long currentPersonId, Long operatorId) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject taskDo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
            Long personId = taskDo.getLong("personid.id");
            String poolType = taskDo.getString("pooltype");
            String oldState = taskDo.getString("state");
            Long billTypeId = taskDo.getLong("billtype.id");
            Long taskTypeId = taskDo.getLong("tasktypeid.id");
            Date completeTime = new Date();
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
                personId = currentPersonId;
                taskDo.set("personid", (Object)personId);
                taskDo.set("receivetime", (Object)completeTime);
                taskDo.set("firstreceivetime", (Object)completeTime);
                taskDo.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDo});
            }
            CalRemainingTime cal = new CalRemainingTime();
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            taskIdList.add(taskId);
            cal.calRemainingTime(taskIdList, "5");
            taskDo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
            taskDo.set("state", (Object)TaskStateEnum.PROCESSED.getValue());
            taskDo.set("pooltype", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
            taskDo.set("operatorId", (Object)operatorId);
            taskDo.set("completetime", (Object)completeTime);
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("opinion", taskDo.getString("apprevalmessage"));
            map.put("innermsg", taskDo.getString("innermsg"));
            DynamicObject taskHisDo = TaskApproveSuccessHelper.insertDataToHistoryTask(taskId, taskDo, true, map);
            DynamicObject completeStateChange = TaskCompleteHelper.createStateChange(taskId, personId, "23", completeTime, oldState, TaskStateEnum.PROCESSED.getValue(), billTypeId, taskTypeId);
            long hisTaskId = taskHisDo.getLong("id");
            TaskApproveSuccessHelper.insertDataToHistoryState(taskId, hisTaskId, completeStateChange, true);
            TaskApproveSuccessHelper.insertEvaluateIntermediate(taskId, taskDo);
            DynamicObject dynamicObject = taskHisDo;
            return dynamicObject;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static DynamicObject terminateSscTask(Long taskId, Long operatorId) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject taskDo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
            Long personId = taskDo.getLong("personid.id");
            String oldState = taskDo.getString("state");
            Long billTypeId = taskDo.getLong("billtype.id");
            Long taskTypeId = taskDo.getLong("tasktypeid.id");
            Date completeTime = new Date();
            CalRemainingTime cal = new CalRemainingTime();
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            taskIdList.add(taskId);
            cal.calRemainingTime(taskIdList, "6");
            taskDo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
            taskDo.set("state", (Object)TaskStateEnum.TERMINATED.getValue());
            taskDo.set("pooltype", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
            taskDo.set("operatorId", (Object)operatorId);
            taskDo.set("completetime", (Object)completeTime);
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("opinion", taskDo.getString("apprevalmessage"));
            map.put("innermsg", taskDo.getString("innermsg"));
            DynamicObject taskHisDo = TaskApproveSuccessHelper.insertDataToHistoryTask(taskId, taskDo, true, map);
            DynamicObject completeStateChange = TaskCompleteHelper.createStateChange(taskId, personId, "24", completeTime, oldState, TaskStateEnum.TERMINATED.getValue(), billTypeId, taskTypeId);
            long hisTaskId = taskHisDo.getLong("id");
            TaskApproveSuccessHelper.insertDataToHistoryState(taskId, hisTaskId, completeStateChange, true);
            DynamicObject dynamicObject = taskHisDo;
            return dynamicObject;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static DynamicObject createStateChange(Long taskId, Long personId, String operation, Date changeTime, String oldState, String newState, Long billTypeId, Long taskTypeId) {
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject("task_statechange");
        obj.set("operation", (Object)operation);
        obj.set("newjobstate", (Object)newState);
        obj.set("oldjobstate", (Object)oldState);
        obj.set("changetime", (Object)changeTime);
        obj.set("operatorid", (Object)personId);
        obj.set("tasktype", (Object)taskTypeId);
        obj.set("billtype", (Object)billTypeId);
        obj.set("message", null);
        obj.set("innermsg", null);
        obj.set("jobid", (Object)taskId);
        return obj;
    }
}

