/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.backup;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.ssc.task.util.SSCBosUtil;

public class BackUpAttachmentReviewPlugin
extends AbstractFormPlugin {
    private boolean ENABLE = false;
    private static final String BTN_FILE_ANALYSIS = "fileanalysis";
    private static final String FLEX_FILE_ANALYSIS = "flex_fileanalysis";
    private static final String FGPTAS_AUDIT_SHOW = "fgptas_audit_show";
    private static final String GPTFAS_PARA_ENTITY_ID = "entityid";
    private static final String GPTFAS_PARA_ENTITY_OBJECT = "entityobject";
    private static final String CACHE_LOAD_AUDIT = "CACHE_LOAD_AUDIT";
    public static final String CACHE_ENABLE_REVIEW = "CACHE_ENABLE_REVIEW";
    private static final String CACHE_GPT_BILL_ID = "gpt.billId";
    private static final String CACHE_GPT_ENTITY_NUMBER = "gpt.entityNumber";
    private static final String CACHE_GPT_USER_ID = "gpt.userId";
    private static final String CACHE_NEED_BILL_AUDIT = "gpt.needBillAudit";
    private static final String PARA_ENTITY_ID = "entityid";
    private static final String PARA_ENTITY_OBJECT = "entityobject";
    private static final String PARA_STATUS_KEY = "statusKey";
    private static final Log log = LogFactory.getLog(BackUpAttachmentReviewPlugin.class);

    public void initialize() {
        this.initEnable();
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(this.ENABLE), new String[]{BTN_FILE_ANALYSIS, FLEX_FILE_ANALYSIS});
        this.getView().setEnable(Boolean.valueOf(this.ENABLE), new String[]{BTN_FILE_ANALYSIS, FLEX_FILE_ANALYSIS});
    }

    public void registerListener(EventObject e) {
        if (this.ENABLE) {
            this.addClickListeners(new String[]{BTN_FILE_ANALYSIS});
        }
    }

    public void afterBindData(EventObject e) {
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_FILE_ANALYSIS.equals(key)) {
            long currUserId = RequestContext.get().getCurrUserId();
            LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)currUserId, (Long)618L);
            if (!licenseCheckResult.getHasLicense().booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{key});
                evt.setCancel(true);
                this.getView().showErrorNotification(licenseCheckResult.getMsg());
                return;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{key});
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_FILE_ANALYSIS.equals(key) && !StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.getPageCache().get(CACHE_LOAD_AUDIT))) {
            this.showAttachmentAudit();
            this.getPageCache().put(CACHE_LOAD_AUDIT, "true");
        }
    }

    private void initEnable() {
        String enable = this.getPageCache().get(CACHE_ENABLE_REVIEW);
        if (StringUtils.isBlank((CharSequence)enable)) {
            boolean configExist;
            boolean isAttachmentReview = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)SSCBosUtil.getCtrlParam((String)"isAttachmentReview"));
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String formId = (String)fsp.getCustomParam("billtype");
            Object pkId = fsp.getCustomParam("billid");
            Map attachments = AttachmentServiceHelper.getAttachmentsForApi((String)formId, (Object)pkId);
            boolean attachmentExist = attachments.entrySet().stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue())));
            QFilter[] configFilters = new QFilter[]{new QFilter("entityobject", "=", (Object)formId)};
            try {
                configExist = QueryServiceHelper.exists((String)"fgptas_auditconfig", (QFilter[])configFilters);
            }
            catch (Exception e2) {
                log.error(String.format("\u5355\u636eid_%s\u67e5\u8be2%s\u5ba1\u6838\u65b9\u6848\u53d1\u751f\u672a\u77e5\u5f02\u5e38", pkId, formId), (Throwable)e2);
                configExist = false;
            }
            this.ENABLE = isAttachmentReview && attachmentExist && configExist;
            this.getPageCache().put(CACHE_ENABLE_REVIEW, this.ENABLE + "");
        } else {
            this.ENABLE = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)enable);
        }
    }

    private void showAttachmentAudit() {
        FormShowParameter fspShow = new FormShowParameter();
        fspShow.setFormId(FGPTAS_AUDIT_SHOW);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String formId = (String)fsp.getCustomParam("billtype");
        Object pkId = fsp.getCustomParam("billid");
        fspShow.setCustomParam("entityid", pkId);
        fspShow.setCustomParam("entityobject", (Object)formId);
        fspShow.getOpenStyle().setShowType(ShowType.InContainer);
        fspShow.getOpenStyle().setTargetKey(FLEX_FILE_ANALYSIS);
        this.getView().showForm(fspShow);
        HashMap<String, String> cache = new HashMap<String, String>(3);
        cache.put(CACHE_GPT_BILL_ID, pkId + "");
        cache.put(CACHE_GPT_ENTITY_NUMBER, formId);
        cache.put(CACHE_GPT_USER_ID, RequestContext.get().getCurrUserId() + "");
        cache.put(CACHE_NEED_BILL_AUDIT, "true");
        this.getPageCache().put(cache);
    }
}

