/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.backup;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.SubScoreRuleTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.approveRebuild.ApproveOriginEnum;
import kd.ssc.enums.approveRebuild.MsgTypeEnum;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.approveRebuild.TaskApproveService;
import kd.ssc.task.approveRebuild.helper.BillOperationHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveSuccessHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveValidateHelper;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.helper.TaskCreditHelper;
import kd.ssc.task.business.helper.WorkFlowCreditHelper;
import kd.ssc.task.business.helper.WorkflowApproveRecordHelper;
import kd.ssc.task.common.LogBuildUtil;
import kd.ssc.task.common.TaskApprevalPluginUtil;
import kd.ssc.task.common.TaskApprevalUtil;
import kd.ssc.task.common.VoucherBtnEnum;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.common.workcalendar.CalRemainingTime;
import kd.ssc.task.create.CreateParTaskByWorkFlow;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.TaskPauseOrCancel;
import kd.ssc.task.formplugin.util.ArtiCheckPointUtil;
import kd.ssc.task.formplugin.util.BillAttributeControlUtil;
import kd.ssc.task.formplugin.util.PendingSelectorUtil;
import kd.ssc.task.formplugin.util.RescanSelectorUtil;
import kd.ssc.task.formplugin.util.TaskApproveUtil;
import kd.ssc.task.formplugin.util.ViewFlowchartUtil;
import kd.ssc.task.formplugin.util.VoucherUtil;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.helper.MutexCacheHelper;
import kd.ssc.task.image.SscImageServiceHelper;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.workcalendar.pojo.RemainingTimeInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BackUpTaskApproveFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(BackUpTaskApproveFormPlugin.class);
    private static final String OPERATIONKEY_PASS = "bar_pass";
    private static final String OPERATIONKEY_NOPASS = "bd_nopass";
    private static final String OPERATIONKEY_REBACK = "bar_repulse_mytask";
    private static final String FORM_APPROVALDECISIONITEMRELATION = "task_approvaldecisionitem";
    private static final String FORM_APPROVALPENDING = "task_approvalpending";
    private static final String FORM_APPROVALRESCAN = "task_approvalrescan";
    private static final String FORM_DHC_INQUIRYBILL = "dhc_inquirybill";
    private static final String CACHE_SSC_DECISION_ID = "ssc_decisionitem_id";
    private static final String CBK_CHOSE_OPINION = "chooseOpinion";
    private static final String SELECTBREAKRULE = "selectbreakrule";
    private static final String TASK_QUALITY_DOCHECK = "task_quality_docheck";
    private static final String TASK_QUALITY_DORECTITY = "task_quality_dorectify";
    private static final String TASK_QUALITY_DOREVIEW = "task_quality_doreview";
    private static final String FIELD_ISMUSTINPUT = "isMustInput";
    private static final String IS_MUSTINPUT = "0";
    private static final String IS_NOT_MUSTINPUT = "1";
    private static final String DECISION_REJECTION = "decisionrejection";
    private static final String LABEL_FOLD_OP = "foldapproveop";
    private static final String LABEL_UNFOLD_OP = "unfoldapproveop";

    public void registerListener(EventObject evt) {
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(Collections.singletonList(taskId));
        List<Long> relationIds = TaskApprevalPluginUtil.getDecisionItemId(OPERATIONKEY_NOPASS, Collections.singletonList(taskId));
        BasedataEdit curDecisionItem = (BasedataEdit)this.getControl("curdecisionitem");
        curDecisionItem.addBeforeF7SelectListener(event -> {
            if (!CollectionUtils.isEmpty((Collection)relationIds)) {
                QFilter idFilter = new QFilter("id", "in", (Object)relationIds);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_decisionitem", (Long)((Long)((List)billInfo.get("sscid")).get(0)));
                event.addCustomQFilter(idFilter.and(baseDataFilter));
            }
        });
        String poolTypeMyTask = (String)this.getView().getFormShowParameter().getCustomParam("pooltype-mytask");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)poolTypeMyTask) && !"2".equals(poolTypeMyTask)) {
            AbstractGrid taskBill = (AbstractGrid)this.getView().getControl("entryentity");
            taskBill.addRowClickListener((RowClickEventListener)this);
        }
        BasedataEdit pendingopinions = (BasedataEdit)this.getControl("pendingopinions");
        pendingopinions.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        pendingopinions.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addClickListeners(new String[]{LABEL_FOLD_OP, LABEL_UNFOLD_OP});
    }

    public void initialize() {
        ControlTypes.register(ApprovalRecord.class);
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        TextEdit opinionField = (TextEdit)this.getControl("opinion");
        opinionField.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"save", "submit", "submitandnext", "cancelpending", "cancelrescan", "nexttask", "rescanopinion", "approvalrecordtabpage", "pauserecordpanel", "withdrawal", DECISION_REJECTION, "collapsevector", "expandvector"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        String isload = this.getPageCache().get("SSC_FORM_ISLOAD");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)isload) || "true".equals(isload)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaskApprevalPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String taskId = this.getPageCache().get("taskid");
        QFilter qFilter = new QFilter("sourcetaskid", "=", (Object)NumberUtils.toLong((String)taskId, (long)-1L));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"state", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null && TaskStateEnum.CANCEL.getValue().equals(dynamicObject.getString("state"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u88ab\u66f4\u65b0\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u6b63\u5728\u5c1d\u8bd5\u7684\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210\u3002", (String)"TaskApprevalPlugin_47", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("opinion".equals(fieldKey)) {
            this.showOpinionF7Form();
        } else if ("rescanopinion".equals(fieldKey)) {
            this.openRescanDialog();
        } else if ("withdrawal".equals(fieldKey)) {
            this.openWithDrawalDialog();
        } else if ("nexttask".equals(fieldKey)) {
            this.doNextTask();
        } else if ("save".equals(fieldKey)) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "TaskApprevalPlugin_57", "ssc-task-formplugin");
            MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u4efb\u52a1\u201c\u4fdd\u5b58\u201d\u64cd\u4f5c\u3002", "TaskApprevalPlugin_56", "ssc-task-formplugin");
            this.addOperationLog("save", opName, opDes);
            boolean success = this.doSave(true);
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskApproveFormPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("submit".equals(fieldKey)) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u63d0\u4ea4", "TaskApprevalPlugin_59", "ssc-task-formplugin");
            MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u4efb\u52a1\u63d0\u4ea4\u64cd\u4f5c\u3002", "TaskApprevalPlugin_58", "ssc-task-formplugin");
            this.addOperationLog("submit", opName, opDes);
            if (this.isEmbedBill()) {
                this.doSubmit(false);
            } else {
                this.doSubmitNew(false);
            }
        } else if ("submitandnext".equals(fieldKey)) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761", "TaskApprevalPlugin_61", "ssc-task-formplugin");
            MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761\u64cd\u4f5c\u3002", "TaskApprevalPlugin_60", "ssc-task-formplugin");
            this.addOperationLog("submitAndNext", opName, opDes);
            if (this.isEmbedBill()) {
                this.doSubmit(true);
            } else {
                this.doSubmitNew(true);
            }
        } else if ("cancelpending".equals(fieldKey)) {
            this.cancelPause();
        } else if ("cancelrescan".equals(fieldKey)) {
            this.cancelRescan();
        } else if (DECISION_REJECTION.equals(fieldKey)) {
            this.openDecisionRejectionDialog();
        } else if (LABEL_FOLD_OP.equals(fieldKey)) {
            this.unfoldOperation(false);
        } else if (LABEL_UNFOLD_OP.equals(fieldKey)) {
            this.unfoldOperation(true);
        } else if ("collapsevector".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"collapsevector", "entryentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
        } else if ("expandvector".equalsIgnoreCase(fieldKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"collapsevector", "entryentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
        }
    }

    private void doSaveNew() {
    }

    private void addOperationLog(String opKey, MultiLangEnumBridge opName, MultiLangEnumBridge opDes) {
        String approveFormId = TaskApprevalHelper.getApproveFormId();
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), null, approveFormId, opKey, opName, opDes, new String[0]);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }

    private void openWithDrawalDialog() {
        IFormView view = this.getView();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("task_withdrawal");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.setHasRight(true);
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setLookUp(true);
        para.setShowTitle(false);
        String taskid = this.getPageCache().get("taskid");
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(Collections.singletonList(Long.valueOf(taskid)));
        List<Long> billTypeList = billInfo.get("billtype");
        List<Long> taskTypeList = billInfo.get("tasktypeid");
        if (billTypeList == null || billTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u6b64\u4efb\u52a1\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"TaskApprevalPlugin_44", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskTypeList == null || taskTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u3002\u672a\u67e5\u8be2\u5230\u6b64\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u3002", (String)"TaskApprevalPlugin_45", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        WithdrawalSelectorUtil withdrawalSelector = new WithdrawalSelectorUtil();
        Set<Long> idSet = withdrawalSelector.getWithdrawalIdBybilltypeAndTasktype(billTypeList.get(0), taskTypeList.get(0));
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", idSet));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_withdrawal", (Long)billInfo.get("sscid").get(0));
        QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        filter.setFilter(baseDataFilter);
        filter.setFilter(enableFil);
        para.setListFilterParameter(filter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reWithdrawal"));
        String withdrawal = this.getPageCache().get("withdrawal");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)withdrawal)) {
            para.setSelectedRows(((ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawal, Long.class)).toArray());
        }
        view.showForm((FormShowParameter)para);
    }

    private void openRescanDialog() {
        IFormView view = this.getView();
        ListShowParameter para = new ListShowParameter();
        para.setFormId(FORM_APPROVALRESCAN);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.getOpenStyle().setTargetKey("tabap");
        para.setHasRight(true);
        String taskid = this.getPageCache().get("taskid");
        ArrayList<Long> taskIds = new ArrayList<Long>(1);
        taskIds.add(Long.valueOf(taskid));
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        List<Long> billTypeList = billInfo.get("billtype");
        List<Long> taskTypeList = billInfo.get("tasktypeid");
        if (billTypeList == null || billTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u80fd\u6253\u5f00\u201c\u9000\u626b\u539f\u56e0\u5217\u8868\u201d\u3002\u9519\u8bef\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u6b64\u4efb\u52a1\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"TaskApprevalPlugin_53", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskTypeList == null || taskTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u9000\u626b\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u6b64\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u3002", (String)"TaskApprevalPlugin_54", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        RescanSelectorUtil rescanSelector = new RescanSelectorUtil();
        Set<Long> idSet = rescanSelector.getRescanIdBybilltypeAndTasktype(billTypeList.get(0), taskTypeList.get(0));
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", idSet));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_rescanreason", (Long)billInfo.get("sscid").get(0));
        filter.setFilter(baseDataFilter);
        para.setListFilterParameter(filter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reRescan"));
        String withdrawal = this.getPageCache().get("rescan");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)withdrawal)) {
            para.setSelectedRows(((ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawal, Long.class)).toArray());
        }
        view.showForm((FormShowParameter)para);
    }

    private void doNextTask() {
        String taskId = this.getPageCache().get("taskid");
        String poolType = this.getPageCache().get("pooltype");
        String poolTask = this.getPageCache().get("pooltype-mytask");
        DynamicObject curtask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        if (curtask == null) {
            QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
            curtask = BusinessDataServiceHelper.loadSingleFromCache((String)"task_taskhistory", (QFilter[])new QFilter[]{idFilter});
        }
        TaskApprevalHelper.getNextTask(curtask, this.getView(), poolType, poolTask, null);
    }

    public void doSubmit(boolean isNext) {
        this.getView().getPageCache().put("isSave", "false");
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        Long billtypeid = 0L;
        Long tasktypeid = 0L;
        String billnumber = "";
        String billid = "";
        String billNo = null;
        if (customParams != null) {
            billtypeid = (Long)customParams.get("billtypeid");
            tasktypeid = (Long)customParams.get("tasktypeid");
            billnumber = (String)customParams.get("billnumber");
            billid = (String)customParams.get("billid");
            billNo = VoucherUtil.getTaskBillNo(billid);
        }
        this.getPageCache().put("isNext", isNext ? "true" : "false");
        IDataModel model = this.getModel();
        String operation = (String)model.getValue("operationgroupfield");
        this.getPageCache().put("operation", operation);
        String decisionitem = (String)model.getValue("decisionitem");
        boolean isSuccess = false;
        this.getPageCache().put("decisionitem", decisionitem);
        boolean isKDCC = "KDCC".equalsIgnoreCase(this.getErpNumberAndCacheBindNum());
        if (!this.checkMustRecord(operation)) {
            return;
        }
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            if (isKDCC && !VoucherUtil.voucherVerifyBySubmit(billtypeid, tasktypeid, billnumber, Long.parseLong(billid), view, "submited")) {
                return;
            }
            this.auditPass0();
        } else if ("2".equals(operation)) {
            if (!decisionitem.equals("3") && isKDCC && !VoucherUtil.voucherVerifyByReturn(billnumber, Long.parseLong(billid), view, "nopass", billNo)) {
                return;
            }
            switch (decisionitem) {
                case "1": {
                    this.nopass();
                    break;
                }
                case "2": {
                    this.nopass();
                    break;
                }
                case "3": {
                    isSuccess = this.processRet();
                    break;
                }
                case "4": {
                    isSuccess = this.returnboth();
                    break;
                }
            }
        } else if ("3".equals(operation)) {
            isSuccess = this.pendBillData();
        } else if ("4".equals(operation)) {
            isSuccess = this.rescan();
        }
        String hasDecision = this.getPageCache().get("hasDecision");
        if (isNext && isSuccess && this.getView().getPageCache().get("submitResult") == null && hasDecision == null) {
            String taskId = this.getPageCache().get("taskid");
            String poolType = this.getPageCache().get("pooltype");
            String poolTask = this.getPageCache().get("pooltype-mytask");
            DynamicObject curtask = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(taskId), (String)"task_task");
            if (curtask == null) {
                QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)Long.valueOf(taskId));
                curtask = BusinessDataServiceHelper.loadSingleFromCache((String)"task_taskhistory", (QFilter[])new QFilter[]{idFilter});
            }
            String sourcePageId = view.getPageCache().get("sourcePageId");
            TaskApprevalHelper.getNextTask(curtask, this.getView(), poolType, poolTask, sourcePageId);
        }
    }

    private void doSubmitNew(boolean isNext) {
        IPageCache pageCache = this.getView().getPageCache();
        IDataModel model = this.getModel();
        String operation = (String)model.getValue("operationgroupfield");
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            String billid;
            String billnumber;
            Long tasktypeid;
            Map customParams;
            Long billtypeid;
            String voucherMsg;
            if (!ArtiCheckPointUtil.isArtiCheckPointSelected(this.getView(), model)) {
                return;
            }
            boolean isKDCC = "KDCC".equalsIgnoreCase(this.getErpNumberAndCacheBindNum());
            if (isKDCC && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(voucherMsg = TaskApproveValidateHelper.voucherWeakVerifyBySubmit(billtypeid = (Long)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("billtypeid"), tasktypeid = (Long)customParams.get("tasktypeid"), billnumber = (String)customParams.get("billnumber"), Long.parseLong(billid = (String)customParams.get("billid")))))) {
                ConfirmCallBackListener call = new ConfirmCallBackListener("submited");
                this.getPageCache().put("submitIsNext", String.valueOf(isNext));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), voucherMsg), MessageBoxOptions.None, call);
                return;
            }
        } else if ("2".equals(operation)) {
            Long curDecisionItem = (Long)model.getValue("curdecisionitem_id");
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)IS_MUSTINPUT, (CharSequence)pageCache.get(FIELD_ISMUSTINPUT)) && curDecisionItem == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51b3\u7b56\u9879\u201d\u3002", (String)"TaskApproveFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String withdrawal = (String)model.getValue("withdrawal");
            if (withdrawal != null) {
                withdrawal = withdrawal.replaceAll(" +", "").replaceAll("\n", "");
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)withdrawal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u6279\u9000\u539f\u56e0\u201d\u3002", (String)"TaskApproveFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.taskApproveSubmit(isNext);
    }

    private void taskApproveSubmit(boolean isNext) {
        TaskApproveService TaskApproveService2;
        Map<String, Object> resultMap;
        String success;
        String metadatatType;
        IDataModel model = this.getModel();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Long taskId = this.getCacheTaskIDLong();
        String operation = (String)model.getValue("operationgroupfield");
        String decisionItem = (String)model.getValue("decisionitem");
        Long curDecisionItem = (Long)model.getValue("curdecisionitem_id");
        String opinion = (String)model.getValue("opinion");
        String withdrawal = (String)model.getValue("withdrawal");
        String withdrawalId = this.getPageCache().get("withdrawal");
        String innerMsg = (String)this.getModel().getValue("innermsg");
        String nodeItemId = this.getPageCache().get("nodeItemId");
        DynamicObjectCollection pendingopinions = (DynamicObjectCollection)this.getModel().getValue("pendingopinions");
        List pendingOpinionList = pendingopinions.stream().map(p -> p.getDynamicObject("fbasedataid")).map(p -> (Long)p.getPkValue()).collect(Collectors.toList());
        String pendingopinion = (String)this.getModel().getValue("pendingopinion");
        String rescanOpinion = (String)this.getModel().getValue("rescanopinion");
        paramMap.put("taskId", taskId);
        paramMap.put("operation", operation);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("decisionItem", decisionItem);
        paramMap.put("curDecisionItem", curDecisionItem);
        paramMap.put("opinion", opinion);
        paramMap.put("withdrawal", withdrawal);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)withdrawalId)) {
            ArrayList withdrawalIdList = (ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawalId, Long.class);
            paramMap.put("withdrawalIdList", withdrawalIdList);
        }
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            DynamicObjectCollection breakRules = (DynamicObjectCollection)this.getModel().getValue("selectsubscorerule");
            ArrayList<Long> breaskRuleIds = new ArrayList<Long>();
            for (DynamicObject dynObj : breakRules) {
                breaskRuleIds.add(dynObj.getLong("fbasedataid_id"));
            }
            if (!CollectionUtils.isEmpty(breaskRuleIds)) {
                paramMap.put("subScoreRuleList", breaskRuleIds);
            }
        }
        paramMap.put("innerMsg", innerMsg);
        paramMap.put("nodeItemId", nodeItemId);
        paramMap.put("reason", pendingopinion);
        paramMap.put("pendingOpinionList", pendingOpinionList);
        paramMap.put("rescanOpinion", rescanOpinion);
        paramMap.put("origin", ApproveOriginEnum.FORM.getValue());
        IFormView subView = this.getSubViewByPageCachePgID();
        String subPageId = subView.getPageId();
        String appId = subView.getServiceAppId(subPageId);
        paramMap.put("subPageId", subPageId);
        paramMap.put("appId", appId);
        DynamicObject billData = this.getSubViewBilldata();
        if (IS_NOT_MUSTINPUT.equals(operation) || "2".equals(operation)) {
            paramMap.put("billData", billData);
            paramMap.put("view", this.getView());
            paramMap.put("model", this.getModel());
            paramMap.put("subView", subView);
        }
        if (FORM_DHC_INQUIRYBILL.equals(metadatatType = this.getPageCache().get("metadatatType"))) {
            String questionReply = billData.getString("questionreply");
            paramMap.put("questionReply", questionReply);
        }
        if ("false".equals(success = (String)(resultMap = (TaskApproveService2 = new TaskApproveService()).taskApproveSubmit(paramMap)).get("success"))) {
            boolean hasShow = this.showBillOpResult(subView, resultMap);
            if (!hasShow) {
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showErrorNotification(msg);
                } else if (MsgTypeEnum.POP.getValue().equals(msgType)) {
                    String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519", (String)"TaskApproveFormPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(errorInfo, msg, MessageTypes.Default);
                }
            }
        } else if ("true".equals(success)) {
            if (IS_NOT_MUSTINPUT.equals(operation) || "2".equals(operation)) {
                this.afterApproveSuccess(taskId, operation);
            } else if ("3".equals(operation)) {
                this.afterApproveSuccessByOtherOpr(taskId, operation);
            } else if ("4".equals(operation)) {
                if (opinion.isEmpty()) {
                    opinion = rescanOpinion;
                }
                this.afterApproveSuccessByOtherOpr(taskId, operation);
                TaskApproveHelper.updateTaskMsg(taskId, opinion, innerMsg, "5");
            }
            if (isNext) {
                IFormView view = this.getView();
                try {
                    TaskApprevalUtil.switchNextTask(view);
                }
                catch (Exception e) {
                    log.error("\u4efb\u52a1\u5ba1\u6279\u5b8c\u6210\uff0c\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761\u62a5\u9519", (Throwable)e);
                    view.close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object newValue = changeData.getNewValue();
        IPageCache pageCache = this.getPageCache();
        String metadatatType = pageCache.get("metadatatType");
        String taskId = pageCache.get("taskid");
        List<Long> relationIds = TaskApprevalPluginUtil.getDecisionItemId(OPERATIONKEY_NOPASS, Collections.singletonList(Long.parseLong(taskId)));
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"operationgroupfield", (CharSequence)name)) {
            this.setApproveInfoVisible(this.getView(), this.getModel(), true, relationIds);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"decisionitem", (CharSequence)name)) {
            boolean flag = !CollectionUtils.isEmpty(relationIds) && (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"2", (CharSequence)((String)newValue)) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"4", (CharSequence)((String)newValue)));
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"curdecisionitem"});
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{DECISION_REJECTION});
            pageCache.put(FIELD_ISMUSTINPUT, flag ? IS_MUSTINPUT : IS_NOT_MUSTINPUT);
            if (flag) {
                FieldEdit edit = (FieldEdit)this.getControl("curdecisionitem");
                edit.setMustInput(true);
            } else {
                this.getModel().setValue("curdecisionitem", (Object)"");
                this.getModel().setValue(DECISION_REJECTION, (Object)"");
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"opinion", (CharSequence)name) && FORM_DHC_INQUIRYBILL.equals(metadatatType)) {
            pageCache.put("apprevalmessage_success", newValue.toString());
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"curdecisionitem", (CharSequence)name)) {
            if (newValue != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{DECISION_REJECTION});
                this.setDecisionRejectionDefault(taskId);
            }
        } else if ("checkboxfield".equals(name)) {
            this.getView().getPageCache().put("checkPass", "true");
            this.checkBoxFieldChanged((Boolean)newValue);
        } else if ("checkboxall".equalsIgnoreCase(name)) {
            int rowCnt = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (int i = 0; i < rowCnt; ++i) {
                this.getModel().setValue("checkboxfield", newValue, i);
            }
            this.getModel().endInit();
            this.getView().updateView("checkpointpanelap");
        }
        if (FORM_DHC_INQUIRYBILL.equals(metadatatType)) {
            this.initViewOfDhcInquirybill();
        }
    }

    private void checkBoxFieldChanged(Boolean checkBox) {
        this.getModel().beginInit();
        if (checkBox.booleanValue()) {
            int rowCnt = this.getModel().getEntryRowCount("entryentity");
            boolean checkAll = true;
            for (int i = 0; i < rowCnt; ++i) {
                if (((Boolean)this.getModel().getValue("checkboxfield", i)).booleanValue()) continue;
                checkAll = false;
                break;
            }
            this.getModel().setValue("checkboxall", (Object)checkAll);
        } else {
            this.getModel().setValue("checkboxall", (Object)Boolean.FALSE);
        }
        this.getModel().endInit();
        this.getView().updateView("checkpointpanelap");
    }

    private void showOpinionF7Form() {
        Long sscid;
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("task_appropinions");
        para.setFormId("bos_templatetreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        QFilter qFilter = null;
        FormShowParameter thisPara = this.getView().getFormShowParameter();
        Long taskid = Long.valueOf(thisPara.getCustomParam("taskid").toString());
        DynamicObject taskObj = QueryServiceHelper.queryOne((String)"task_task", (String)"sscid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskid)});
        String operation = (String)this.getModel().getValue("operationgroupfield");
        String approvalOperation = IS_MUSTINPUT;
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"2", (CharSequence)operation)) {
            approvalOperation = IS_NOT_MUSTINPUT;
        }
        QFilter defaultSelectedFilter = new QFilter("isdisplay", "=", (Object)true).and("approvaloperation", "=", (Object)approvalOperation);
        QFilter commonFilter = new QFilter("isdisplay", "=", (Object)false);
        String sscId = "";
        if (taskObj != null && (sscid = Long.valueOf(taskObj.getLong("sscid"))) > 0L) {
            sscId = String.valueOf(sscid);
            qFilter = new QFilter("sscid", "=", (Object)sscid);
            qFilter.and(new QFilter("isleaf", "=", (Object)IS_NOT_MUSTINPUT));
            qFilter.and(commonFilter.or(defaultSelectedFilter));
        }
        ListFilterParameter listFilter = new ListFilterParameter();
        if (qFilter != null) {
            listFilter.setFilter(qFilter);
        } else {
            listFilter.setFilter(new QFilter("sscid", "=", (Object)"-1"));
        }
        para.setListFilterParameter(listFilter);
        if ("false".equals(TaskParamHelper.getTaskParamByName((String)"enableOpinionMultiSelect"))) {
            para.setMultiSelect(false);
        } else {
            para.setMultiSelect(true);
        }
        para.setHasRight(true);
        para.setCustomParam("sscId", (Object)sscId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CBK_CHOSE_OPINION);
        para.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)para);
    }

    public void itemClick(ItemClickEvent evt) {
        String isload = this.getPageCache().get("SSC_FORM_ISLOAD");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)isload) || "true".equals(isload)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaskApprevalPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String taskId = this.getPageCache().get("taskid");
        QFilter qFilter = new QFilter("sourcetaskid", "=", (Object)NumberUtils.toLong((String)taskId, (long)-1L));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"state", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null && dynamicObject.getString("state").equals(TaskStateEnum.CANCEL.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u88ab\u66f4\u65b0\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u6b63\u5728\u5c1d\u8bd5\u7684\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210\u3002", (String)"TaskApprevalPlugin_47", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String key = evt.getItemKey();
        if ("close".equals(key)) {
            return;
        }
        if (!this.autoPressMsgCheck(key)) {
            return;
        }
        if ("bar_image".equals(key)) {
            this.viewphoto();
        } else if ("viewflowchart".equals(key)) {
            this.viewflowchart();
        } else if (key.contains("billbar")) {
            this.doBillOpetator(key);
        } else if ("fixdata".equals(key)) {
            this.fixData();
            LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u4fee\u590d\u6570\u636e", (String)"TaskApproveFormPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), (String)("taskId=" + taskId));
        } else if ("btncirculation".equals(key)) {
            this.showCirculationPage();
        } else if ("circulatelog".equals(key)) {
            this.showCirculateLog();
        }
    }

    private void showCirculateLog() {
        String taskId = this.getPageCache().get("assignId");
        FormShowParameter para = WorkflowTCDataPluginUtil.getCirculateLogParameter((Long)Long.valueOf(taskId));
        para.setFormId("task_taskcirculationlog");
        this.getView().showForm(para);
    }

    private void doBillOpetator(String key) {
        try {
            String billKey = this.getPageCache().get(key + "_key");
            String billOpetator = this.getPageCache().get(key + "_number");
            String billToolbar = this.getPageCache().get(key + "_toolbar");
            String subViewPageID = this.getPageCache().get("pageID");
            FormView view = (FormView)this.getView();
            String subAppID = view.getServiceAppId(subViewPageID);
            String requestParams = String.format("[{\"key\":\"%s\",\"methodName\":\"itemClick\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]", billToolbar, billKey, billOpetator);
            log.info("requestParams:" + requestParams);
            Object resultObject = DispatchServiceHelper.invokeBOSService((String)subAppID, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{subViewPageID, requestParams});
            if (resultObject == null) {
                log.error("kd.ssc.task.formplugin.TaskApprevalPlugin#doBillOpetator: result is blank, key=" + key);
                return;
            }
            String result = resultObject.toString();
            log.info("result:" + result);
            List list = (List)SerializationUtils.fromJsonString((String)result, List.class);
            HashMap<String, Object> arg = new HashMap<String, Object>(2);
            arg.put("pageId", subViewPageID);
            arg.put("actions", list);
            view.getClientProxy().addAction("sendDynamicFormAction", arg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskApproveFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void nopass() {
        String taskId = this.getPageCache().get("taskid");
        List<Long> taskIds = Collections.singletonList(Long.valueOf(taskId));
        List<Long> relationList = TaskApprevalPluginUtil.getDecisionItemId(OPERATIONKEY_NOPASS, taskIds);
        if (relationList != null && relationList.size() > 0) {
            this.processDecisionItemData(OPERATIONKEY_NOPASS, false);
            this.getPageCache().put("hasDecision", "true");
        } else {
            this.getPageCache().put("hasDecision", null);
            ArrayList withdrawals = (ArrayList)SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("withdrawal"), Long.class);
            if (this.isEmbedBill()) {
                this.embedBillNoPassHandle(withdrawals);
            } else {
                this.nextBillNoPassHandle(0L, withdrawals);
            }
        }
    }

    private boolean checkMustRecord(String operation) {
        IPageCache pageCache = this.getPageCache();
        String opinion = (String)this.getModel().getValue("opinion");
        Object pendingopinions = this.getModel().getValue("pendingopinions");
        String rescanopinion = (String)this.getModel().getValue("rescanopinion");
        long curDecisionItem = this.getModel().getDataEntity().getLong("curdecisionitem_id");
        String withdrawal = this.getPageCache().get("withdrawal");
        opinion = opinion.replaceAll(" +", "").replaceAll("\n", "");
        rescanopinion = rescanopinion.replaceAll(" +", "").replaceAll("\n", "");
        if (withdrawal != null) {
            withdrawal = withdrawal.replaceAll(" +", "").replaceAll("\n", "");
        }
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            if (!this.isDhcInquirybill() && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)opinion)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5ba1\u6279\u610f\u89c1\u3002", (String)"TaskApprevalPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if ("2".equals(operation)) {
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)opinion)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5ba1\u6279\u610f\u89c1\u3002", (String)"TaskApprevalPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)IS_MUSTINPUT, (CharSequence)pageCache.get(FIELD_ISMUSTINPUT)) && curDecisionItem == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51b3\u7b56\u9879\u201d\u3002", (String)"TaskApproveFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)withdrawal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u6279\u9000\u539f\u56e0\u201d\u3002", (String)"TaskApproveFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if ("3".equals(operation)) {
            if (pendingopinions == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u6682\u6302\u539f\u56e0\u201d\u3002", (String)"TaskApproveFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if ("4".equals(operation) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)rescanopinion)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u9000\u626b\u539f\u56e0\u201d\u3002", (String)"TaskApproveFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean processRet() {
        String userId;
        String taskId = this.getPageCache().get("taskid");
        if (taskId == null) {
            return false;
        }
        QFilter idQfilter = new QFilter("id", "=", (Object)Long.valueOf(taskId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_task", (String)"state,personid,assignid", (QFilter[])new QFilter[]{idQfilter});
        HashSet<String> normalSet = new HashSet<String>(Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()));
        if (!normalSet.contains(dynamicObject.getString("state"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u88ab\u66f4\u65b0\uff0c\u6b63\u5728\u5c1d\u8bd5\u7684\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210\u3002", (String)"TaskApprevalPlugin_49", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        String personId = dynamicObject.getString("personid");
        if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)personId, (CharSequence)(userId = RequestContext.get().getUserId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u5df2\u88ab\u66f4\u65b0\uff0c\u6b63\u5728\u5c1d\u8bd5\u7684\u64cd\u4f5c\u65e0\u6cd5\u5b8c\u6210\u3002", (String)"TaskApprevalPlugin_49", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        long workFlowId = dynamicObject.getLong("assignid");
        ParTaskNodeServiceImpl parTaskNodeService = new ParTaskNodeServiceImpl();
        long instId = parTaskNodeService.getInstIdByTaskId(Long.parseLong(taskId));
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
        QFilter nodeStateFilter = new QFilter("state", "=", (Object)InstNodeEnum.PROCESSING.getValue());
        DynamicObjectCollection taskList = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{instIdFilter, nodeStateFilter});
        try {
            String auditMsg = "";
            Object opinion = this.getModel().getValue("opinion");
            if (opinion instanceof String) {
                auditMsg = (String)opinion;
            }
            ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterRtnBack((Long)Long.valueOf(taskId), (String)auditMsg);
        }
        catch (NumberFormatException e) {
            log.error("TaskApprevalPlugin.processRet: \u9000\u56de\u5171\u4eab -> \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        List<Long> taskIds = this.getStartInstTaskId(instId);
        if (CollectionUtils.isEmpty(taskIds)) {
            return false;
        }
        boolean retSucessFlag = true;
        Object[] keys = new Object[]{};
        if (!taskList.isEmpty()) {
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "processRet"));){
                try {
                    ArrayList withdrawals = (ArrayList)SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("withdrawal"), Long.class);
                    this.saveUnpassReason(withdrawals);
                    keys = this.processCurTask(taskId, taskList);
                    DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskinst");
                    dyo.set("id", (Object)instId);
                    dyo.set("ptendtime", (Object)new Date());
                    dyo.set("ptstatus", (Object)FlowInstEnum.REPULSE.getValue());
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
                    QFilter qFilter = new QFilter("sourcetaskid", "in", taskIds);
                    DynamicObjectCollection taskHistCollection = QueryServiceHelper.query((String)"task_taskhistory", (String)"tasktypeid,billtype,billid,sscid", (QFilter[])new QFilter[]{qFilter});
                    DynamicObjectCollection allTaskCollection = QueryServiceHelper.query((String)"task_task", (String)"tasktypeid,billtype,billid,sscid", (QFilter[])new QFilter[]{qFilter});
                    if (!CollectionUtils.isEmpty((Collection)taskHistCollection)) {
                        allTaskCollection.addAll((Collection)taskHistCollection);
                    }
                    if (CollectionUtils.isEmpty((Collection)allTaskCollection)) {
                        throw new Exception(ResManager.loadKDString((String)"\u901a\u8fc7\u5f00\u59cb\u8282\u70b9\u83b7\u53d6\u5386\u53f2\u4efb\u52a1\u5931\u8d25\u3002", (String)"TaskApproveFormPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                    Long[] taskTypeIds = new Long[allTaskCollection.size()];
                    for (int i = 0; i < allTaskCollection.size(); ++i) {
                        taskTypeIds[i] = ((DynamicObject)allTaskCollection.get(i)).getLong("tasktypeid");
                    }
                    long billTypeID = ((DynamicObject)allTaskCollection.get(0)).getLong("billtype");
                    String billID = ((DynamicObject)allTaskCollection.get(0)).getString("billid");
                    new CreateParTaskByWorkFlow().publishInialMessage(billID, Long.valueOf(billTypeID), taskTypeIds, workFlowId);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("kd.ssc.task.formplugin.TaskApprevalPlugin.processRet:\u9000\u56de\u5171\u4eab\u5ba1\u6838\u51fa\u9519", e);
                    boolean bl = retSucessFlag = false;
                    if (h != null) {
                        if (var19_20 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var19_20.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
        }
        if (retSucessFlag) {
            try {
                Object key;
                if (keys != null && keys.length > 0 && (key = keys[0]) instanceof DynamicObject) {
                    DynamicObject taskHis = (DynamicObject)key;
                    TaskApprevalUtil.insertWFTask(taskHis);
                }
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u6d41\u7a0b\u4efb\u52a1\u5173\u7cfb\u8868\u5931\u8d25\uff1a{}" + e.getMessage());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"TaskApprevalPlugin_48", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        return true;
    }

    public List<Long> getStartInstTaskId(Long insId) {
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("instantid", "=", (Object)insId);
        QFilter qFilter2 = new QFilter("parenttaskid", "=", (Object)0);
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        for (DynamicObject dyo : queryList) {
            if (dyo.get("taskid") == null) continue;
            taskIdList.add(dyo.getLong("taskid"));
        }
        return taskIdList;
    }

    private Object[] processCurTask(String taskId, DynamicObjectCollection taskList) {
        HashSet<Object> pkList = new HashSet<Object>();
        Object[] keys = new Object[]{};
        for (DynamicObject task : taskList) {
            Object taskIdTmp = task.get("taskid");
            if (taskIdTmp == null || pkList.contains(taskIdTmp) || !(taskIdTmp instanceof Long)) continue;
            pkList.add(taskIdTmp);
            if (!taskId.equals(taskIdTmp.toString())) continue;
            keys = this.insertTaskHistoryAndStateChangeHis((Long)taskIdTmp, Integer.parseInt(TaskStateEnum.AUDIT_NOTPASSED.getValue()));
        }
        QFilter qFilter = new QFilter("id", "in", pkList);
        DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{qFilter});
        return keys;
    }

    private boolean auditPass0() {
        if (!ArtiCheckPointUtil.isArtiCheckPointSelected(this.getView(), this.getModel())) {
            return false;
        }
        this.getPageCache().put("decisionitem", null);
        if (this.isEmbedBill()) {
            this.embedBillAudit();
        } else {
            this.nextBillAudit();
        }
        return true;
    }

    private void cancelPause() {
        boolean hasShow;
        Map resultMap;
        String success;
        String state = this.getSelectRowDataState();
        List<String> pauseStates = Arrays.asList(TaskStateEnum.PAUSE.getValue(), TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
        if (!pauseStates.contains(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u6302\u201d\u72b6\u6001\u7684\u4efb\u52a1\u53ef\u53d6\u6d88\u6682\u6302\u3002", (String)"TaskApprevalPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        long taskId = this.getCacheTaskIDLong();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("origin", ApproveOriginEnum.FORM.getValue());
        IFormView subView = this.getSubViewByPageCachePgID();
        if (subView != null) {
            String subPageId = subView.getPageId();
            String appId = subView.getServiceAppId(subPageId);
            paramMap.put("subPageId", subPageId);
            paramMap.put("appId", appId);
        }
        if ("true".equals(success = (String)(resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveByCancelPend", (Object[])new Object[]{paramMap})).get("success"))) {
            List<IApprovalRecordGroup> approvalRecordGroups = TaskApproveUtil.setPauseRecord(taskId, false);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("isPC", "true");
            ((ApprovalRecord)this.getControl("pauserecordap")).setParameters(params);
            ((ApprovalRecord)this.getControl("pauserecordap")).setArData(approvalRecordGroups);
            TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, this.getModel(), "3");
            this.getModel().setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"MytaskListPlugin_48", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("state", TaskStateEnum.TO_BE_AUDIT.getValue());
            this.setApproveInfoVisible(this.getPageCache().get("state"), this.getPageCache().get("pooltype"), this.getView(), this.getModel(), true);
            List<String> allShow = Arrays.asList(VoucherBtnEnum.PREVIEW_VOUCHER.getValue(), VoucherBtnEnum.CHECK_VOUCHER.getValue(), VoucherBtnEnum.SAVE_VOUCHER.getValue(), VoucherBtnEnum.DELETE_VOUCHER.getValue());
            this.getView().setEnable(Boolean.TRUE, allShow.toArray(new String[0]));
            this.getView().updateView("flexpanelap");
        } else if ("false".equals(success) && !(hasShow = this.showBillOpResult(subView, resultMap))) {
            String msg = (String)resultMap.get("msg");
            String msgType = (String)resultMap.get("msgType");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                this.getView().showTipNotification(msg);
            } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void saveApproveop() {
        QFilter toDisfilter = new QFilter("id", "=", (Object)Long.parseLong(this.getPageCache().get("taskid")));
        DynamicObject taskObjs = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"approveop", (QFilter[])new QFilter[]{toDisfilter});
        taskObjs.set("approveop", this.getModel().getValue("operationgroupfield"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObjs});
    }

    private void cancelRescan() {
        Long taskId = this.getCacheTaskIDLong();
        String state = this.getSelectRowDataState();
        if (!TaskStateEnum.RESCAN.getValue().equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u9000\u626b\u72b6\u6001\u7684\u4efb\u52a1\u53ef\u53d6\u6d88\u9000\u626b\u3002", (String)"TaskApprevalPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String billid = this.getPageCache().get("billID");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billid);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (imageInfoInside == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\u6620\u5c04\u8bb0\u5f55\u3002", (String)"TaskApprevalPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean billOprSuccess = this.billOprByBeforeTask("6");
        if (!billOprSuccess) {
            return;
        }
        String opinion = " ";
        String innermsg = (String)this.getModel().getValue("innermsg");
        try {
            String imageNumber = imageInfoInside.getImageNo();
            log.info("\u8c03\u7528\u53d6\u6d88\u9000\u626b\u63a5\u53e3\u53c2\u6570--imagenumber\uff1a" + imageNumber + "\tbillid:" + billid);
            SscImageServiceHelper.cancelrescan((String)imageNumber, (String)billid, (String)"20");
            this.insertStateChange(opinion, null, "20");
            SscImageServiceUtil.updateAccountByImageNumber((String)imageNumber, (String)"2");
            this.updateTaskMsg(opinion, innermsg, "20");
            TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, this.getModel(), "6");
            this.getModel().setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
            this.saveApproveop();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u626b\u6210\u529f", (String)"TaskApprevalPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("state", TaskStateEnum.TO_BE_AUDIT.getValue());
            this.setApproveInfoVisible(this.getPageCache().get("state"), this.getPageCache().get("pooltype"), this.getView(), this.getModel(), true);
            List<String> allShow = Arrays.asList(VoucherBtnEnum.PREVIEW_VOUCHER.getValue(), VoucherBtnEnum.CHECK_VOUCHER.getValue(), VoucherBtnEnum.SAVE_VOUCHER.getValue(), VoucherBtnEnum.DELETE_VOUCHER.getValue());
            this.getView().setEnable(Boolean.TRUE, allShow.toArray(new String[0]));
            this.getView().updateView("flexpanelap");
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u9000\u626b\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u626b\u51fa\u9519\uff1a%s", (String)"TaskApprevalPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private boolean rescan() {
        String state = this.getSelectRowDataState();
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u9000\u626b\u3002", (String)"TaskApprevalPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        String billid = this.getPageCache().get("billID");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billid);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (imageInfoInside == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\u6620\u5c04\u8bb0\u5f55\u3002", (String)"TaskApprevalPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        String opinion = (String)this.getModel().getValue("opinion");
        String innermsg = (String)this.getModel().getValue("innermsg");
        String rescanOpinion = (String)this.getModel().getValue("rescanopinion");
        if (opinion.isEmpty()) {
            opinion = rescanOpinion;
        }
        try {
            if (!"2".equals(imageInfoInside.getImageState()) && !"4".equals(imageInfoInside.getImageState())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"TaskApprevalPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean billOprSuccess = this.billOprByBeforeTask("4");
            if (!billOprSuccess) {
                return false;
            }
            log.info("\u8c03\u7528\u9000\u56de\u91cd\u626b\u63a5\u53e3\u53c2\u6570\uff1a\tbillid:" + billid);
            SscImageServiceHelper.rescan((String)imageInfoInside.getImageNo(), (String)billid, (String)rescanOpinion);
            this.insertStateChange(rescanOpinion, null, "5");
            SscImageServiceUtil.updateAccountByImageNumber((String)imageInfoInside.getImageNo(), (String)"3");
            SscImageServiceUtil.updateImageScanIntoRescan((String)imageInfoInside.getImageNo());
            this.doSave(false);
            this.updateTaskMsg(opinion, innermsg, "5");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b\u6210\u529f", (String)"TaskApprevalPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        catch (Exception e) {
            log.error("\u9000\u626b\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9000\u626b\u51fa\u9519\u3002\u51fa\u9519\u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"TaskApprevalPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)e)));
            return false;
        }
        return true;
    }

    private boolean returnboth() {
        String state = this.getSelectRowDataState();
        boolean isCanRescan = true;
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u9000\u626b\u3002", (String)"TaskApprevalPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        String billid = this.getPageCache().get("billID");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billid);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (imageInfoInside == null) {
            log.info("\u65e0\u5f71\u50cf\u8bb0\u5f55" + billid);
            isCanRescan = false;
        }
        String opinion = (String)this.getModel().getValue("opinion");
        String innermsg = (String)this.getModel().getValue("innermsg");
        if (opinion.isEmpty()) {
            opinion = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"TaskApprevalPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        if (innermsg.isEmpty()) {
            innermsg = ResManager.loadKDString((String)"\u9000\u56de\u91cd\u626b", (String)"TaskApprevalPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        }
        try {
            if (isCanRescan && !"2".equals(imageInfoInside.getImageState()) && !"4".equals(imageInfoInside.getImageState())) {
                log.info("\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf" + billid);
                isCanRescan = false;
            }
            log.info("\u8c03\u7528\u9000\u56de\u91cd\u626b\u63a5\u53e3\u53c2\u6570:" + billid);
            String taskId = this.getPageCache().get("taskid");
            List<Long> taskIds = Collections.singletonList(Long.valueOf(taskId));
            List<Long> relationList = TaskApprevalPluginUtil.getDecisionItemId(OPERATIONKEY_REBACK, taskIds);
            ArtiCheckPointUtil.saveArtiCheckPointInfo(null, this.getPageCache().get("taskid"), this.getModel(), null, false, null, null);
            if (relationList == null || relationList.size() == 0) {
                this.getPageCache().put("hasDecision", null);
                if (isCanRescan) {
                    String returnReason = (String)this.getModel().getValue("withdrawal");
                    SscImageServiceHelper.rescan((String)imageInfoInside.getImageNo(), (String)billid, (String)returnReason);
                    this.insertStateChange(opinion, innermsg, "5");
                    SscImageServiceUtil.updateAccountByImageNumber((String)imageInfoInside.getImageNo(), (String)"3");
                    this.updateTaskMsg(opinion, innermsg, "5");
                }
                ArrayList withdrawals = (ArrayList)SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("withdrawal"), Long.class);
                if (this.isEmbedBill()) {
                    this.embedBillNoPassHandle(withdrawals);
                } else {
                    this.nextBillNoPassHandle(0L, withdrawals);
                }
            } else {
                this.processDecisionItemData(OPERATIONKEY_NOPASS, isCanRescan);
                this.getPageCache().put("hasDecision", "true");
            }
        }
        catch (Exception e) {
            log.error("\u9000\u626b\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9000\u626b\u51fa\u9519\u3002\u51fa\u9519\u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"TaskApprevalPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)e)));
            return false;
        }
        return true;
    }

    private void processDecisionItemData(String operationKey, boolean isCanRescan) {
        String billid = this.getPageCache().get("billID");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billid);
        ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        long itemId = this.getModel().getDataEntity().getLong("curdecisionitem_id");
        String opinion = (String)this.getModel().getValue("opinion");
        String innermsg = (String)this.getModel().getValue("innermsg");
        String decisionitem = this.getPageCache().get("decisionitem");
        String returnReason = (String)this.getModel().getValue("withdrawal");
        ArrayList withdrawals = (ArrayList)SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("withdrawal"), Long.class);
        this.getPageCache().put(CACHE_SSC_DECISION_ID, String.valueOf(itemId));
        if (OPERATIONKEY_NOPASS.equalsIgnoreCase(operationKey)) {
            if ("4".equals(decisionitem) && isCanRescan) {
                try {
                    if (imageInfoInside == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\u6620\u5c04\u8bb0\u5f55\u3002", (String)"TaskApprevalPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String imageNumber = imageInfoInside.getImageNo();
                    SscImageServiceHelper.rescan((String)imageNumber, (String)billid, (String)returnReason);
                    this.insertStateChange(opinion, innermsg, "5");
                    SscImageServiceUtil.updateAccountByImageNumber((String)imageNumber, (String)"3");
                    this.updateTaskMsg(opinion, innermsg, "5");
                }
                catch (Exception e) {
                    log.error("\u9000\u626b\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9000\u626b\u51fa\u9519\u3002\u51fa\u9519\u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"TaskApprevalPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)e)));
                    return;
                }
            }
            if (this.isEmbedBill()) {
                this.embedBillNoPassHandle(withdrawals);
            } else {
                this.nextBillNoPassHandle(itemId, withdrawals);
            }
        }
    }

    private boolean pendBillData() {
        List<Long> selectedRowIds = this.getSelectedRowIDs();
        String state = this.getSelectRowDataState();
        if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u6682\u6302\u3002", (String)"TaskApprevalPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().getPageCache().put("submitResult", "false");
            return false;
        }
        boolean billOprSuccess = this.billOprByBeforeTask("3");
        if (!billOprSuccess) {
            return false;
        }
        this.processPauseOrCancel(selectedRowIds, true);
        this.doSave(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"MytaskListPlugin_49", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().close();
        return true;
    }

    private List<Long> getSelectedRowIDs() {
        ArrayList<Long> selectedRowIds = new ArrayList<Long>();
        long taskId = this.getCacheTaskIDLong();
        selectedRowIds.add(taskId);
        return selectedRowIds;
    }

    private long getCacheTaskIDLong() {
        String taskID = this.getPageCache().get("taskid");
        return Long.parseLong(taskID);
    }

    private String getSelectRowDataState() {
        long taskId = this.getCacheTaskIDLong();
        DynamicObject curTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"id,billtype,oprt,billid,pooltype,state,subject,tasktypeid,personid");
        String state = curTask.getString("state");
        return state;
    }

    private void fixData() {
        if (this.isEmbedBill()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5d4c\u5165\u5355\u636e\u6682\u4e0d\u652f\u6301\u4fee\u590d\u6570\u636e\u3002", (String)"TaskApproveFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView subView = this.getSubViewByPageCachePgID();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billtypeid", this.getPageCache().get("billtypeid"));
        map.put("billTypeKey", this.getPageCache().get("metadatatType"));
        map.put("billid", this.getPageCache().get("billID"));
        map.put("taskID", this.getPageCache().get("taskid"));
        map.put("opinion", (String)this.getModel().getValue("opinion"));
        map.put("fixdata", "true");
        map.put("erpNumber", this.getErpNumberAndCacheBindNum());
        String personid = this.getPageCache().get("personid") == null ? (String)this.getView().getFormShowParameter().getCustomParam("state") : this.getPageCache().get("personid");
        map.put("personid", personid);
        map.put("state", (String)this.getView().getFormShowParameter().getCustomParam("state"));
        map.put("tasktypeid", this.getView().getFormShowParameter().getCustomParam("tasktypeid").toString());
        DynamicObject billData = this.getSubViewBilldata();
        TaskApprevalUtil.updateStateAndRecord(OPERATIONKEY_PASS, billData, map, this.getView(), this.getModel(), subView);
    }

    private void showCirculationPage() {
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("taskid", Long.parseLong(this.getPageCache().get("assignId")));
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("task_taskcirculation");
        para.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u4f20\u9605", (String)"TaskCirculationPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        para.setCustomParams(customParams);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showCirculationPage"));
        this.getView().showForm(para);
    }

    private boolean autoPressMsgCheck(String key) {
        String opinion;
        if ("bar_pass,bd_nopass,bar_repulse,bar_pending,bar_return,bar_returnboth".indexOf(key) > -1 && ((opinion = (String)this.getModel().getValue("opinion")) == null || opinion.trim().length() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5ba1\u6279\u610f\u89c1\u3002", (String)"TaskApprevalPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean doSave(boolean billOpr) {
        Long taskId = this.getCacheTaskIDLong();
        if (this.isEmbedBill()) {
            this.embedBillSave();
        } else {
            boolean saveSuccess = this.notEmbedBillSave(billOpr);
            if (!saveSuccess) {
                return false;
            }
        }
        Map<String, Object> resultMap = TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, this.getModel(), null);
        String success = (String)resultMap.get("success");
        if ("false".equals(success)) {
            String msg = (String)resultMap.get("msg");
            String msgType = (String)resultMap.get("msgType");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                this.getView().showTipNotification(msg);
            } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                this.getView().showErrorNotification(msg);
            }
            return false;
        }
        return true;
    }

    private void embedBillSave() {
        IFrame frame = (IFrame)this.getControl("iframeap");
        IFrameMessage msg = new IFrameMessage("kdcc_bill_save", "*", (Object)this.getView().getPageId());
        frame.postMessage(msg);
    }

    private boolean notEmbedBillSave(boolean billOpr) {
        long taskId = Long.parseLong(this.getPageCache().get("taskid"));
        String opinion = (String)this.getModel().getValue("opinion");
        String approveOp = (String)this.getModel().getValue("operationgroupfield");
        if (IS_NOT_MUSTINPUT.equals(approveOp)) {
            this.getPageCache().put("apprevalmessage_success", opinion);
        } else if ("2".equals(approveOp)) {
            this.getPageCache().put("apprevalmessage_fail", opinion);
        }
        String innerMsg = (String)this.getModel().getValue("innermsg");
        String decisionItem = (String)this.getModel().getValue("decisionitem");
        Long curDecisionItem = (Long)this.getModel().getValue("curdecisionitem_id");
        String nodeItemId = this.getPageCache().get("nodeItemId");
        String withdrawal = (String)this.getModel().getValue("withdrawal");
        String withdrawalId = this.getPageCache().get("withdrawal");
        List withdrawalIdList = new ArrayList();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)withdrawalId)) {
            withdrawalIdList = SerializationUtils.fromJsonStringToList((String)withdrawalId, Long.class);
        }
        DynamicObjectCollection pendingopinions = (DynamicObjectCollection)this.getModel().getValue("pendingopinions");
        List pendingOpinionList = pendingopinions.stream().map(p -> p.getDynamicObject("fbasedataid")).map(p -> (Long)p.getPkValue()).collect(Collectors.toList());
        String pendingopinion = (String)this.getModel().getValue("pendingopinion");
        String rescanOpinion = (String)this.getModel().getValue("rescanopinion");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        if (!"3".equals(approveOp)) {
            paramMap.put("opinion", opinion);
        }
        paramMap.put("innerMsg", innerMsg);
        paramMap.put("approveOp", approveOp);
        paramMap.put("decisionItem", decisionItem);
        paramMap.put("curDecisionItem", curDecisionItem);
        paramMap.put("nodeItemId", nodeItemId);
        paramMap.put("withdrawal", withdrawal);
        paramMap.put("pendingopinion", pendingopinion);
        paramMap.put("pendingOpinionList", pendingOpinionList);
        paramMap.put("rescanOpinion", rescanOpinion);
        paramMap.put("withdrawalIdList", withdrawalIdList);
        paramMap.put("origin", ApproveOriginEnum.FORM.getValue());
        IFormView subView = this.getSubViewByPageCachePgID();
        String subPageId = subView.getPageId();
        String appId = subView.getServiceAppId(subPageId);
        paramMap.put("subPageId", subPageId);
        paramMap.put("appId", appId);
        paramMap.put("billOpr", billOpr);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveBySave", (Object[])new Object[]{paramMap});
        String success = (String)resultMap.get("success");
        if ("false".equals(success)) {
            boolean hasShow = this.showBillOpResult(subView, resultMap);
            if (!hasShow) {
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showErrorNotification(msg);
                }
            }
            return false;
        }
        return true;
    }

    private IFormView getSubViewByPageCachePgID() {
        IFormView subView = this.getView().getViewNoPlugin(this.getPageCache().get("pageID"));
        return subView;
    }

    private DynamicObject getSubViewBilldata() {
        IFormView subView = this.getSubViewByPageCachePgID();
        if (subView != null) {
            return subView.getModel().getDataEntity(true);
        }
        log.info("\u5171\u4eab\u5ba1\u6279\u754c\u9762\u83b7\u53d6\u5b50\u9875\u9762\u4e3anull\uff0c\u7f13\u5b58\u7684pageID\u4e3a\uff1a" + this.getPageCache().get("pageID"));
        ErrorCode code = new ErrorCode("500", ResManager.loadKDString((String)"\u5355\u636e\u89c6\u56fe\u6a21\u578b\u672a\u52a0\u8f7d\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"TaskApproveFormPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        throw new KDBizException(code, new Object[0]);
    }

    private void viewflowchart() {
        if (this.isEmbedBill()) {
            this.openEmbBillFlowChart();
        } else {
            this.openNoEmbBillFlowChart();
        }
    }

    private void openEmbBillFlowChart() {
        String url = this.getEmbWFCharUrl();
        this.openUrlByNewWindow(url);
    }

    private void openUrlByNewWindow(String url) {
        IFormView parentView = this.getView();
        IFormView subView = this.getSubViewByPageCachePgID();
        if (parentView == null) {
            subView.openUrl(url);
        } else {
            parentView.openUrl(url);
        }
    }

    private String getEmbWFCharUrl() {
        String pooltype = (String)this.getView().getFormShowParameter().getCustomParam("pooltype");
        if (pooltype == null) {
            pooltype = (String)this.getView().getFormShowParameter().getCustomParam("pooltype-mytask");
        }
        boolean isHis = false;
        if (TaskPoolTypeEnum.COMPLETE.getValue().equalsIgnoreCase(pooltype)) {
            isHis = true;
        }
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)this.getErpNumberAndCacheBindNum());
        log.info("kd.ssc.task.formplugin.TaskApprevalPlugin.getEmbWFCharUrl taskID:" + this.getCacheTaskIDLong() + ";isHis:" + isHis);
        String url = taskFacade.getEmbedWFUrl(Long.valueOf(this.getCacheTaskIDLong()), isHis);
        log.info("kd.ssc.task.formplugin.TaskApprevalPlugin.getEmbWFCharUrl end");
        return url;
    }

    private void openNoEmbBillFlowChart() {
        DynamicObject billData = this.getSubViewBilldata();
        IFormView subView = this.getSubViewByPageCachePgID();
        if (this.getErpNumberAndCacheBindNum().equalsIgnoreCase("EAS")) {
            ViewFlowchartUtil.viewFlowchart(log, subView, this.getPageCache().get("billID"), this.getView());
        } else {
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)billData.get("id"));
        }
    }

    private boolean isEmbedBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isembed = formShowParameter.getCustomParam("isembed") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("isembed");
        return isembed;
    }

    private void processPauseOrCancel(List<Long> selectedRowIds, boolean isPending) {
        TaskPauseOrCancel taskPauseOrCancel = new TaskPauseOrCancel();
        HashMap<String, Object> extendMap = new HashMap<String, Object>();
        if (isPending) {
            extendMap.put("message", this.getModel().getValue("pendingopinion"));
        }
        extendMap.put("innermsg", this.getModel().getValue("innermsg"));
        taskPauseOrCancel.changeTaskState(selectedRowIds, extendMap, isPending);
    }

    public String getErpNumberAndCacheBindNum() {
        String erpNumber = this.getPageCache().get("erpNumber");
        if (this.getPageCache().get("erpNumber") != null) {
            return erpNumber;
        }
        String billtypeidStr = this.getPageCache().get("billtypeid");
        long billtypeid = Long.parseLong(billtypeidStr);
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number,bindbill.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        erpNumber = (String)billType.get("externalerp.number");
        String bindbillNumber = (String)billType.get("bindbill.number");
        this.getPageCache().put("erpNumber", erpNumber.toLowerCase());
        this.getPageCache().put("bindbillNumber", bindbillNumber);
        return erpNumber.toLowerCase();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getPageCache().get("billID") == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String billID = (String)formShowParameter.getCustomParam("billid");
            String imageNumber = (String)formShowParameter.getCustomParam("imageNumber");
            String metadatatType = (String)formShowParameter.getCustomParam("billnumber");
            String billNumber = (String)formShowParameter.getCustomParam("sourcebillnumber");
            String bindform = (String)formShowParameter.getCustomParam("bindform");
            String approveop = (String)formShowParameter.getCustomParam("approveop");
            if (bindform == null) {
                bindform = metadatatType;
            }
            Long tasktypeid = (Long)formShowParameter.getCustomParam("tasktypeid");
            Long taskid = (Long)formShowParameter.getCustomParam("taskid");
            String bizdata = (String)formShowParameter.getCustomParam("bizdata");
            Long billTypeId = (Long)formShowParameter.getCustomParam("billtypeid");
            boolean isembed = formShowParameter.getCustomParam("isembed") == null ? false : (Boolean)formShowParameter.getCustomParam("isembed");
            String state = (String)formShowParameter.getCustomParam("state");
            String pooltype = (String)formShowParameter.getCustomParam("pooltype");
            String pooltype_mytask = (String)formShowParameter.getCustomParam("pooltype-mytask");
            String sscid = formShowParameter.getCustomParam("sscid") + "";
            String unpassreasondata = (String)formShowParameter.getCustomParam("unpassreasondata");
            String sourcePageId = (String)formShowParameter.getCustomParam("sourcePageId");
            this.getPageCache().put("state", state);
            this.getPageCache().put("billID", billID);
            this.getPageCache().put("metadatatType", metadatatType);
            this.getPageCache().put("bindform", bindform);
            this.getPageCache().put("taskid", taskid.toString());
            this.getPageCache().put("billtypeid", billTypeId.toString());
            this.getPageCache().put("tasktypeid", tasktypeid.toString());
            this.getPageCache().put("imageNumber", imageNumber);
            this.getPageCache().put("sscid", sscid);
            this.getPageCache().put("pooltype", pooltype);
            this.getPageCache().put("pooltype-mytask", pooltype_mytask);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)unpassreasondata)) {
                this.getPageCache().put("withdrawal", unpassreasondata);
            }
            this.getPageCache().put("pending", unpassreasondata);
            this.getPageCache().put("rescan", unpassreasondata);
            this.getPageCache().put("sourcePageId", sourcePageId);
            this.setEmbedViewVisible();
            this.setAuditButtonVisble(formShowParameter, state, pooltype);
            this.setApproveopVisibleAndEnable(approveop, formShowParameter, state, pooltype, taskid);
            this.setBillToolbar(billTypeId, tasktypeid);
            boolean flag = this.openBillView(billID, bindform, taskid, bizdata, state, pooltype, pooltype_mytask, isembed, billNumber);
            this.setApprovalHandleMsg(formShowParameter);
            this.setAuditRecord(taskid, billTypeId);
            if (FORM_DHC_INQUIRYBILL.equals(metadatatType)) {
                this.initViewOfDhcInquirybill();
            }
            this.setArtiCheckPoint(taskid, billTypeId, pooltype, tasktypeid, billID);
            if (!flag) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)taskid);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_task", (String)"sscid", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject == null) {
                dynamicObject = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"sscid", (QFilter[])new QFilter[]{qFilter});
            }
            if (dynamicObject == null) {
                return;
            }
            String billType = (String)formShowParameter.getCustomParam("billtype");
            Long sscId = dynamicObject.getLong("sscid");
            this.autoOpenImage(billID, billType, sscId, billTypeId, formShowParameter.getCustomParam("from") == null);
            if (IS_NOT_MUSTINPUT.equals(pooltype_mytask)) {
                MutexCacheHelper.putMutexCache(String.valueOf(RequestContext.get().getCurrUserId()), taskid.toString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.unfoldOperation(false);
    }

    private void setApproveopVisibleAndEnable(String approveop, FormShowParameter formShowParameter, String state, String pooltype, Long taskid) {
        boolean isFromMytask = false;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((CharSequence)formShowParameter.getCustomParam("pooltype-mytask")))) {
            isFromMytask = true;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.setApproveInfo(formShowParameter, model);
        this.setOpVisible(approveop, state, pooltype, view, model);
        this.setApproveInfoVisible(state, pooltype, view, model, isFromMytask);
    }

    private void setDecisionItem(boolean processRet) {
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("decisionitem");
        List comboItems = comboProp.getComboItems();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long billTypeId = (Long)showParameter.getCustomParam("billtypeid");
        boolean displayImage = SscImageServiceUtil.imageDisplayCtrlById((Long)billTypeId);
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            LocaleString name = comboItem.getName();
            boolean itemVisible = comboItem.isItemVisible();
            if ("5".equals(value) || "6".equals(value) || "3".equals(value) && !processRet || "4".equals(value) && !displayImage || !itemVisible) continue;
            ComboItem citem = new ComboItem();
            citem.setValue(value);
            citem.setCaption(name);
            list.add(citem);
        }
        ComboEdit com = (ComboEdit)this.getControl("decisionitem");
        com.setComboItems(list);
        String decisionItemVal = (String)this.getModel().getValue("decisionitem");
        if ("4".equals(decisionItemVal) && !displayImage) {
            this.getModel().setValue("decisionitem", (Object)"2");
        }
    }

    private void setApproveInfo(FormShowParameter formShowParameter, IDataModel model) {
        Object decisionitem = formShowParameter.getCustomParam("decisionitem");
        Object approveop = formShowParameter.getCustomParam("approveop");
        Object pendingopinion = formShowParameter.getCustomParam("pendingopinion");
        List pendingopinions = (List)formShowParameter.getCustomParam("pendingopinions");
        Object rescanopinion = formShowParameter.getCustomParam("rescanopinion");
        Object unpassreasondesc = formShowParameter.getCustomParam("unpassreasondesc");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)approveop)) {
            model.setValue("operationgroupfield", approveop);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)decisionitem)) {
            model.setValue("decisionitem", decisionitem);
            if ("2".equals(decisionitem) || "4".equals(decisionitem)) {
                String entityName = "task_task";
                if (this.isHisTask()) {
                    entityName = "task_taskhistory";
                }
                DynamicObject taskDynObj = BusinessDataServiceHelper.loadSingleFromCache((Object)formShowParameter.getCustomParam("taskid"), (String)entityName, (String)"decisionitemnew.id,assignid,billid,itemid");
                model.setValue("curdecisionitem", (Object)taskDynObj.getLong("decisionitemnew.id"));
                this.loadHisDecisionRejection(taskDynObj);
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)unpassreasondesc)) {
            model.setValue("withdrawal", unpassreasondesc);
        }
        model.setValue("pendingopinion", pendingopinion);
        if (pendingopinions != null && !pendingopinions.isEmpty()) {
            Object[] fbasedataids = pendingopinions.stream().map(p -> (Map)p.get("fbasedataid")).map(p -> p.get("id")).toArray();
            model.setValue("pendingopinions", (Object)fbasedataids);
        }
        model.setValue("rescanopinion", rescanopinion);
    }

    private void loadHisDecisionRejection(DynamicObject taskDynObj) {
        Long workFlowId = taskDynObj.getLong("assignid");
        Long decisionId = taskDynObj.getLong("decisionitemnew.id");
        if (decisionId == 0L) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)decisionId, (String)"task_decisionitem", (String)"id,decisionvalue");
        String decisionValue = dynamicObject.getString("decisionvalue");
        String billId = taskDynObj.getString("billid");
        String itemId = taskDynObj.getString("itemid");
        List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)decisionValue);
        if (!CollectionUtils.isEmpty((Collection)rejectNodeList)) {
            for (WFRejectNodesModel wfRejectNodesModel : rejectNodeList) {
                if (itemId == null || !itemId.equals(wfRejectNodesModel.getItemId())) continue;
                this.initDecisionRejection(itemId, billId, wfRejectNodesModel);
                break;
            }
        } else {
            this.initDecisionRejection(itemId, billId, null);
        }
    }

    private void setApproveInfoVisible(String state, String pooltype, IFormView view, IDataModel model, boolean isFromMytask) {
        this.setApproveInfoVisible(view, model, isFromMytask, null);
    }

    private void setApproveInfoVisible(IFormView view, IDataModel model, boolean isFromMytask, List<Long> relationIds) {
        String state = view.getPageCache().get("state");
        String poolType = view.getPageCache().get("pooltype");
        if (!isFromMytask || TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            view.setVisible(Boolean.FALSE, new String[]{"buttongroup"});
            view.setEnable(Boolean.FALSE, new String[]{"operation", "flexpanelap20", "nexttask"});
        }
        String operation = (String)model.getValue("operationgroupfield");
        if (TaskStateEnum.RESCAN.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation", "opinion", "decisionitem", "withdrawal", "innermsg", "pendingopinion", "pendingopinions", "rescanopinion", SELECTBREAKRULE, "selectsubscorerule", "save", "submit", "submitandnext", "cancelpending", "checkpointpanelap", "curdecisionitem", DECISION_REJECTION});
            view.setEnable(Boolean.FALSE, new String[]{"rescanopinion"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"checkboxfield"});
            view.setVisible(Boolean.TRUE, new String[]{"rescanopinion"});
            view.setVisible(Boolean.valueOf(isFromMytask), new String[]{"cancelrescan"});
        } else if (TaskStateEnum.PAUSE.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation", "opinion", "decisionitem", "withdrawal", "innermsg", "rescanopinion", SELECTBREAKRULE, "selectsubscorerule", "save", "submit", "submitandnext", "cancelrescan", "checkpointpanelap", "curdecisionitem", DECISION_REJECTION});
            view.setEnable(Boolean.FALSE, new String[]{"pendingopinion", "pendingopinions"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"checkboxfield"});
            view.setVisible(Boolean.TRUE, new String[]{"pendingopinion", "cancelpending", "pendingopinions"});
        } else if (IS_NOT_MUSTINPUT.equals(operation)) {
            boolean isCompletMyTask;
            model.setValue("opinion", (Object)this.getPageCache().get("apprevalmessage_success"));
            view.setVisible(Boolean.FALSE, new String[]{"decisionitem", "withdrawal", "pendingopinion", "pendingopinions", "rescanopinion", "cancelpending", "cancelrescan", "curdecisionitem", DECISION_REJECTION});
            view.setVisible(Boolean.TRUE, new String[]{"opinion", "innermsg", "save", "submit", "submitandnext", "operation", "checkpointpanelap"});
            view.setEnable(Boolean.TRUE, -1, new String[]{"checkboxfield"});
            if (this.getPageCache().get("hide-checkpointpanelap") != null) {
                view.setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
            }
            view.setEnable(Boolean.TRUE, new String[]{"rescanopinion", "pendingopinion", "pendingopinions"});
            this.setSubScoreRuleVisiable(view);
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String poolType_Mytask = (String)showParam.getCustomParam("pooltype-mytask");
            boolean isQualityTask = TASK_QUALITY_DOCHECK.equals(showParam.getFormId()) || TASK_QUALITY_DORECTITY.equals(showParam.getFormId()) || TASK_QUALITY_DOREVIEW.equals(showParam.getFormId());
            boolean bl = isCompletMyTask = kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)poolType_Mytask) && "2".equals(poolType_Mytask);
            if (!isQualityTask && !isCompletMyTask || this.isDhcInquirybill()) {
                view.setVisible(Boolean.FALSE, new String[]{SELECTBREAKRULE});
            }
            this.setDefaultOpinion(true);
        } else if ("2".equals(operation)) {
            boolean con1;
            model.setValue("opinion", (Object)this.getPageCache().get("apprevalmessage_fail"));
            view.setVisible(Boolean.FALSE, new String[]{"pendingopinion", "pendingopinions", "rescanopinion", SELECTBREAKRULE, "selectsubscorerule", "cancelpending", "cancelrescan"});
            view.setVisible(Boolean.TRUE, new String[]{"opinion", "decisionitem", "withdrawal", "innermsg", "save", "submit", "submitandnext", "checkpointpanelap"});
            if (this.getPageCache().get("hide-checkpointpanelap") != null) {
                view.setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
            }
            this.setDefaultOpinion(false);
            String taskId = this.getPageCache().get("taskid");
            boolean isShowDecisionItem = false;
            String decisionItem = model.getValue("decisionitem").toString();
            boolean bl = con1 = kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"2", (CharSequence)decisionItem) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"4", (CharSequence)decisionItem);
            if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
                isShowDecisionItem = con1 && model.getValue("curdecisionitem") != null;
            } else if (con1) {
                if (CollectionUtils.isEmpty(relationIds)) {
                    relationIds = TaskApprevalPluginUtil.getDecisionItemId(OPERATIONKEY_NOPASS, Collections.singletonList(Long.parseLong(taskId)));
                }
                isShowDecisionItem = !CollectionUtils.isEmpty(relationIds);
            }
            this.getView().setVisible(Boolean.valueOf(isShowDecisionItem), new String[]{"curdecisionitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{DECISION_REJECTION});
            if (model.getValue("curdecisionitem") != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{DECISION_REJECTION});
            }
            this.getPageCache().put(FIELD_ISMUSTINPUT, isShowDecisionItem ? IS_MUSTINPUT : IS_NOT_MUSTINPUT);
            if (isShowDecisionItem) {
                FieldEdit edit = (FieldEdit)this.getControl("curdecisionitem");
                edit.setMustInput(true);
            }
        } else if ("3".equals(operation)) {
            view.setVisible(Boolean.FALSE, new String[]{"opinion", "decisionitem", "withdrawal", "innermsg", "rescanopinion", SELECTBREAKRULE, "selectsubscorerule", "cancelpending", "cancelrescan", "curdecisionitem", DECISION_REJECTION});
            view.setVisible(Boolean.TRUE, new String[]{"pendingopinion", "pendingopinions", "save", "submit", "submitandnext"});
        } else if ("4".equals(operation)) {
            view.setVisible(Boolean.FALSE, new String[]{"opinion", "decisionitem", "withdrawal", "innermsg", "pendingopinion", "pendingopinions", SELECTBREAKRULE, "selectsubscorerule", "cancelpending", "cancelrescan", "curdecisionitem", DECISION_REJECTION});
            view.setVisible(Boolean.TRUE, new String[]{"rescanopinion", "save", "submit", "submitandnext"});
        }
    }

    private void setSubScoreRuleVisiable(IFormView view) {
        Boolean openCreditControl;
        boolean isHisTask = this.isHisTask();
        long taskId = this.getCacheTaskIDLong();
        if (isHisTask) {
            openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByHisTask((long)taskId);
        } else {
            DynamicObject taskInfo = TaskCreditHelper.getTaskInfo((long)taskId);
            openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByTaskId((DynamicObject)taskInfo);
        }
        if (openCreditControl == null || openCreditControl.booleanValue()) {
            boolean relatedSubScoreRule = this.billRelatedSubScoreRule();
            view.setVisible(Boolean.valueOf(relatedSubScoreRule), new String[]{"selectsubscorerule"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"selectsubscorerule"});
        }
    }

    private void setOpVisible(String operation, String state, String pooltype, IFormView view, IDataModel model) {
        if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state)) {
            model.setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
        } else if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
            model.setValue("operationgroupfield", (Object)"2");
        } else if (IS_NOT_MUSTINPUT.equals(operation)) {
            model.setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
        } else if ("2".equals(operation)) {
            model.setValue("operationgroupfield", (Object)"2");
        } else if ("3".equals(operation)) {
            model.setValue("operationgroupfield", (Object)"3");
        } else if ("4".equals(operation)) {
            model.setValue("operationgroupfield", (Object)"4");
        } else if (TaskStateEnum.RESCAN.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation"});
        } else if (TaskStateEnum.PAUSE.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation"});
        }
    }

    private void setBillToolbar(Long billTypeId, Long tasktypeid) {
        Map map;
        String circulate;
        DynamicObject dynamicObject;
        Map<String, Map<String, Object>> needShowButtonAps = BillAttributeControlUtil.getNeedShowButtonAps(billTypeId, tasktypeid);
        int needShowButtonSize = needShowButtonAps.size();
        for (int i = needShowButtonSize + 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + i});
        }
        boolean displayImage = SscImageServiceUtil.imageDisplayCtrlById((Long)billTypeId);
        if (!displayImage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_image"});
        }
        int index = 1;
        for (Map.Entry<String, Map<String, Object>> entry : needShowButtonAps.entrySet()) {
            String key = entry.getKey();
            if (this.isDhcInquirybill()) {
                if (this.isHisTask()) {
                    if ("addknowledge".equals(key)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + index});
                        ++index;
                        continue;
                    }
                } else {
                    if ("viewknowledge".equals(key)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + index});
                        ++index;
                        continue;
                    }
                    if (this.isFromAdmin() && "addknowledge".equals(key)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"billbar" + index});
                    }
                }
            }
            Map<String, Object> value = entry.getValue();
            String[] ctrlapnames = value.get("ctrlapname").toString().split("\\.");
            String[] ctrlapnumbers = value.get("ctrlapnumber").toString().split("\\.");
            HashMap<String, LocaleString> map2 = new HashMap<String, LocaleString>();
            DynamicObject[] pageCache = this.getPageCache();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(ctrlapnames[ctrlapnames.length - 1]);
            map2.put("text", localeString);
            this.getView().updateControlMetadata("billbar" + index, map2);
            pageCache.put("billbar" + index + "_key", key);
            pageCache.put("billbar" + index + "_number", value.get("opkey") == null ? "" : value.get("opkey").toString());
            pageCache.put("billbar" + index + "_toolbar", ctrlapnumbers[0]);
            if (++index <= 10) continue;
            break;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get("taskid")));
        String entityName = null;
        if (this.isHisTask()) {
            dynamicObject = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"assignid", (QFilter[])new QFilter[]{qFilter});
            entityName = "task_taskhistory";
        } else {
            dynamicObject = QueryServiceHelper.queryOne((String)"task_task", (String)"assignid", (QFilter[])new QFilter[]{qFilter});
            entityName = "task_task";
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)((String)dynamicObject.get("assignid")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
            return;
        }
        Long assignId = Long.valueOf((String)dynamicObject.get("assignid"));
        this.getPageCache().put("assignId", assignId.toString());
        TaskInfo task = WorkflowServiceHelper.findTaskById((Long)assignId);
        if (task != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)task.getControl()) && !Boolean.parseBoolean(circulate = (String)(map = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class)).get("circulate"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
        }
        if (task == null && entityName.equals("task_taskhistory")) {
            DynamicObject[] control = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"control", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignId)});
            circulate = null;
            for (DynamicObject controlValue : control) {
                circulate = (String)controlValue.get("control");
            }
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)circulate)) {
                String circulateResult = "false";
                String regex = "\"circulate\":\"(.*?)\"";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(circulate);
                if (matcher.find()) {
                    circulateResult = matcher.group(1);
                }
                if (circulateResult.equals("false")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
            }
        }
    }

    private void setArtiCheckPoint(Long taskid, Long billTypeId, String pooltype, Long tasktypeid, Object billId) {
        QFilter filter = new QFilter("taskid", "=", (Object)String.valueOf(taskid));
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"articheckpoint as articheckpointid,articheckpoint.name as articheckpointname,iscontented as articheckpointselected", (QFilter[])new QFilter[]{filter});
        if (articheckpointrecords == null || articheckpointrecords.size() == 0) {
            if (TaskPoolTypeEnum.COMPLETE.getValue().equals(pooltype)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
                return;
            }
            articheckpointrecords = ArtiCheckPointUtil.getArtiCheckPointByBillTypeId(billTypeId, String.valueOf(tasktypeid), billId);
            if (articheckpointrecords == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
                this.getPageCache().put("hide-checkpointpanelap", "true");
                return;
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < articheckpointrecords.size(); ++i) {
            DynamicObject articheckpointrecord = (DynamicObject)articheckpointrecords.get(i);
            vs.set("articheckpointid", (Object)articheckpointrecord.getString("articheckpointid"), i);
            vs.set("checkboxfield", (Object)articheckpointrecord.getString("articheckpointselected"), i);
            vs.set("articheckpointname", (Object)articheckpointrecord.getString("articheckpointname"), i);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.checkBoxFieldChanged(true);
    }

    private void setEmbedViewVisible() {
        if (!this.isEmbedBill()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"iframeap"});
        }
    }

    private boolean openBillView(String billID, String bindform, Long taskid, String bizdata, String state, String pooltype, String pooltype_mytask, boolean isembed, String billNumber) {
        if (isembed) {
            this.openEmbedView(billID);
            return true;
        }
        return this.openNextBillView(billID, bindform, taskid, bizdata, state, pooltype, pooltype_mytask, billNumber);
    }

    private void openEmbedView(String billID) {
        this.getPageCache().put("SSC_FORM_ISLOAD", "false");
        String taskID = this.getPageCache().get("taskid");
        boolean isHis = this.isHisTask();
        String extUrl = this.getExtUrl(billID, taskID, isHis);
        IFrame frame = (IFrame)this.getControl("iframeap");
        frame.setSrc(extUrl);
    }

    private String getExtUrl(String billID, String taskID, boolean isHis) {
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)this.getErpNumberAndCacheBindNum());
        log.info("kd.ssc.task.formplugin.TaskApprevalPlugin.getExtUrl getEmbedViewUrl billID : " + billID + "; taskID: " + taskID + "; isHis:" + isHis);
        String extUrl = taskFacade.getEmbedViewUrl(billID, taskID, isHis);
        log.info("kd.ssc.task.formplugin.TaskApprevalPlugin.getExtUrl getEmbedViewUrl end");
        return extUrl;
    }

    private DynamicObject getExtparam() {
        String taskID = this.getPageCache().get("taskid");
        boolean isHis = this.isHisTask();
        return this.getExtParamByTKID(taskID, isHis);
    }

    public DynamicObject getExtParamByTKID(String taskID, boolean isHis) {
        String extParamEntityName = "task_ext_param";
        if (isHis) {
            extParamEntityName = "taskhis_ext_param";
        }
        QFilter extParamFilter = new QFilter("taskid", "=", (Object)Long.valueOf(taskID));
        DynamicObject[] extParamArrays = BusinessDataServiceHelper.load((String)extParamEntityName, (String)"extparam_tag,isstoredindb", (QFilter[])new QFilter[]{extParamFilter});
        if (extParamArrays.length < 1) {
            return null;
        }
        DynamicObject extParam = extParamArrays[0];
        return extParam;
    }

    private boolean openNextBillView(String billID, String bindform, Long taskid, String bizdata, String state, String pooltype, String pooltype_mytask, String billNumber) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u5355\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u548c\u63d0\u5355\u4eba\u5904\u7406\u3002", (String)"MytaskListPlugin_59", (String)"ssc-task-formplugin", (Object[])new Object[]{billNumber}));
            return false;
        }
        if ("KDCC".equalsIgnoreCase(this.getErpNumberAndCacheBindNum())) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(billID));
            boolean exists = QueryServiceHelper.exists((String)this.getPageCache().get("metadatatType"), (QFilter[])new QFilter[]{idFilter});
            if (!exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u5355\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u548c\u63d0\u5355\u4eba\u5904\u7406\u3002", (String)"MytaskListPlugin_59", (String)"ssc-task-formplugin", (Object[])new Object[]{billNumber}));
                return false;
            }
        }
        BillShowParameter parameter = new BillShowParameter();
        if (bizdata != null && !this.isExtBillStoreInDB(taskid)) {
            parameter.getCustomParams().put("bizdata", bizdata);
        }
        parameter.setPkId((Object)billID);
        parameter.setFormId(bindform);
        parameter.getOpenStyle().setTargetKey("billcontainer");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (pooltype_mytask == null) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setBillStatus(BillOperationStatus.SUBMIT);
        }
        parameter.setCustomParam("taskID", (Object)taskid.toString());
        parameter.setCustomParam("billID", (Object)billID);
        parameter.setCustomParam("sscId", (Object)this.getPageCache().get("sscid"));
        parameter.setCustomParam("pooltype", (Object)pooltype);
        parameter.setCustomParam("pooltype-mytask", (Object)pooltype_mytask);
        parameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        boolean isLock = this.isOperLocked(state, pooltype);
        if (isLock) {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
        }
        parameter.setHasRight(true);
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillFormShowCustomerPlugin");
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillAttributeControlFormPlugin");
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.SscSaveValidatorPlugin");
        this.getPageCache().put("SSC_FORM_ISLOAD", "true");
        this.getView().showForm((FormShowParameter)parameter);
        this.getPageCache().put("pageID", parameter.getPageId());
        return true;
    }

    private boolean isExtBillStoreInDB(Long taskid) {
        if (this.getErpNumberAndCacheBindNum().equalsIgnoreCase("kdcc")) {
            return false;
        }
        DynamicObject extParam = this.getExtparam();
        if (extParam == null) {
            return false;
        }
        return extParam.getBoolean("isstoredindb");
    }

    private void setAuditButtonVisble(FormShowParameter formShowParameter, String state, String pooltype) {
        String taskid;
        QFilter qFilter;
        DynamicObject dynamicObject;
        boolean isLock;
        Object valueoffrom = formShowParameter.getCustomParam("from");
        Object taskTypeid = formShowParameter.getCustomParam("tasktypeid");
        Object billTypeId = formShowParameter.getCustomParam("billtypeid");
        if (!"admin".equals(valueoffrom) || !TaskPoolTypeEnum.PROCESSING.getValue().equals(pooltype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fixdata"});
        }
        if (valueoffrom != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"genvoucher"});
        }
        if (isLock = this.isOperLocked(state, pooltype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"nexttask", OPERATIONKEY_PASS, OPERATIONKEY_NOPASS, "bar_repulse", "bar_rescan", "bar_cancelrescan", "bar_pending", "bar_cancelpause", "opinion", "innermsg", "save", "genvoucher", "bar_return", "bar_returnboth"});
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)"task_task", (String)"source", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)NumberUtils.toLong((String)(taskid = formShowParameter.getCustomParam("taskid") + ""), (long)-1L))})) == null) {
            return;
        }
        Object source = dynamicObject.get("source");
        HashSet<String> notParSet = new HashSet<String>(Arrays.asList(IS_NOT_MUSTINPUT, "2"));
        boolean processRet = true;
        if (null != source && notParSet.contains(source.toString())) {
            processRet = false;
        } else if (null != source && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)source.toString(), (CharSequence)"5")) {
            String entityName = "task_taskbill";
            String selectFields = "id,entryentity.childpkid as childpkid";
            QFilter billTypeFilter = new QFilter("id", "=", billTypeId);
            QFilter taskTypeFilter = new QFilter("entryentity.tasktype", "=", taskTypeid);
            DynamicObject dynObjCol = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{billTypeFilter, taskTypeFilter});
            if (dynObjCol == null) {
                return;
            }
            Long childpkid = dynObjCol.getLong("childpkid");
            QFilter filter = new QFilter("id", "=", (Object)childpkid);
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"task_taskbill_child", (String)"taskoriginal", (QFilter[])new QFilter[]{filter});
            if (dyo == null) {
                return;
            }
            Object taskoriginal = dyo.get("taskoriginal");
            if (null != taskoriginal && !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)taskoriginal.toString(), (CharSequence)"2")) {
                processRet = false;
            }
        }
        this.setDecisionItem(processRet);
    }

    private void setApprovalHandleMsg(FormShowParameter formShowParameter) {
        String apprevalmessage = (String)formShowParameter.getCustomParam("apprevalmessage");
        String operation = (String)this.getModel().getValue("operationgroupfield");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)apprevalmessage)) {
            String taskId = this.getPageCache().get("taskid");
            if (IS_NOT_MUSTINPUT.equals(operation)) {
                apprevalmessage = TaskApprevalPluginUtil.processDefaultOpinion(Long.parseLong(taskId), true);
            } else if ("2".equals(operation)) {
                apprevalmessage = TaskApprevalPluginUtil.processDefaultOpinion(Long.parseLong(taskId), false);
            }
        }
        String innermsg = (String)formShowParameter.getCustomParam("innermsg");
        IDataModel dataModel = this.getModel();
        dataModel.setValue("opinion", (Object)apprevalmessage);
        dataModel.setValue("innermsg", (Object)innermsg);
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            this.getPageCache().put("apprevalmessage_success", apprevalmessage);
        } else if ("2".equals(operation)) {
            this.getPageCache().put("apprevalmessage_fail", apprevalmessage);
        }
    }

    private void setAuditRecord(Long taskid, Long billTypeId) {
        boolean isHist = this.isHisTask();
        FormShowParameter parameEdit = TaskApproveUtil.setAuditRecord(taskid, billTypeId, isHist);
        this.getView().showForm(parameEdit);
        List<IApprovalRecordGroup> approvalRecordGroups = TaskApproveUtil.setPauseRecord(taskid, isHist);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("isPC", "true");
        ((ApprovalRecord)this.getControl("pauserecordap")).setParameters(params);
        ((ApprovalRecord)this.getControl("pauserecordap")).setArData(approvalRecordGroups);
    }

    private boolean isHisTask() {
        Object sourcetaskid = this.getView().getFormShowParameter().getCustomParam("sourcetaskid");
        boolean isHist = sourcetaskid != null && Long.parseLong(sourcetaskid.toString()) > 0L;
        return isHist;
    }

    private boolean isOperLocked(String state, String pooltype) {
        boolean isLock = false;
        if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state) || TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
            isLock = true;
        }
        return isLock;
    }

    private void viewphoto() {
        if (this.isEmbedBill()) {
            this.embedViewPhoto();
        } else {
            this.notembedViewPhoto();
        }
    }

    private void embedViewPhoto() {
        this.viewPhotoBase();
    }

    private void notembedViewPhoto() {
        this.viewPhotoBase();
    }

    private void viewPhotoBase() {
        String imageNumber = this.getPageCache().get("imageNumber");
        String billId = this.getPageCache().get("billID");
        String billtype = this.getPageCache().get("metadatatType");
        Object valueoffrom = this.getView().getFormShowParameter().getCustomParam("from");
        String state = this.getPageCache().get("state");
        String pooltype = this.getPageCache().get("pooltype");
        String pooltype_mytask = this.getPageCache().get("pooltype-mytask");
        if (pooltype == null) {
            pooltype = pooltype_mytask;
        }
        String isEdit = valueoffrom != null ? IS_MUSTINPUT : (state != null && pooltype != null && (state.equals(IS_NOT_MUSTINPUT) || state.equals("7")) && pooltype.equals(IS_NOT_MUSTINPUT) ? IS_NOT_MUSTINPUT : IS_MUSTINPUT);
        SscImageServiceHelper.viewphoto((String)imageNumber, (String)billId, (String)billtype, (IFormView)this.getView(), (String)isEdit);
    }

    public void entryRowClick(RowClickEvent arg0) {
        if (arg0.getSource() instanceof CardEntry && ((CardEntry)arg0.getSource()).getKey().equals("entryentity")) {
            int row = arg0.getRow();
            IPageCache pageCache = this.getView().getPageCache();
            if (!"true".equals(pageCache.get("checkPass"))) {
                IDataModel model = this.getModel();
                Boolean checkboxfieldValue = (Boolean)model.getValue("checkboxfield", row);
                model.beginInit();
                model.setValue("checkboxfield", (Object)(checkboxfieldValue == false ? 1 : 0), row);
                model.endInit();
                this.getView().updateView("entryentity");
                this.checkBoxFieldChanged(checkboxfieldValue == false);
            }
            pageCache.remove("checkPass");
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (CBK_CHOSE_OPINION.equals(closedCallBackEvent.getActionId())) {
            Object rtnData = closedCallBackEvent.getReturnData();
            if (rtnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection rtnCollection = (ListSelectedRowCollection)rtnData;
                String opinion = this.getOpinions(rtnCollection);
                this.getModel().setValue("opinion", (Object)opinion);
                String operation = (String)this.getModel().getValue("operationgroupfield");
                if (IS_NOT_MUSTINPUT.equals(operation)) {
                    this.getPageCache().put("apprevalmessage_success", opinion);
                } else if ("2".equals(operation)) {
                    this.getPageCache().put("apprevalmessage_fail", opinion);
                }
            }
        } else if ("reWithdrawal".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            String withdrawal;
            List<Long> withdrawalids;
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Object returnData2 = closedCallBackEvent.getReturnData();
            WithdrawalSelectorUtil withdrawalSelectorUtil = new WithdrawalSelectorUtil();
            if (returnData2 instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection withdrawalidList = (ListSelectedRowCollection)returnData2;
                withdrawalids = withdrawalidList.stream().map(value -> (Long)value.getPrimaryKeyValue()).collect(Collectors.toList());
                withdrawal = withdrawalSelectorUtil.transformWithdrawal(withdrawalids);
            } else {
                Map ret = (Map)returnData2;
                withdrawalids = (List<Long>)ret.get("withdrawalids");
                withdrawal = withdrawalSelectorUtil.transformWithdrawal(withdrawalids);
            }
            this.getModel().setValue("withdrawal", (Object)withdrawal);
            this.getPageCache().put("withdrawal", SerializationUtils.toJsonString(withdrawalids));
        } else if ("reRescan".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Map ret = (Map)closedCallBackEvent.getReturnData();
            List rescanids = (List)ret.get("rescanids");
            RescanSelectorUtil rescanSelectorUtil = new RescanSelectorUtil();
            String rescan = rescanSelectorUtil.transformRescan(rescanids);
            this.getModel().setValue("rescanopinion", (Object)rescan);
            this.getPageCache().put("rescanopinion", SerializationUtils.toJsonString((Object)rescanids));
        } else if ("reDecisionRejection".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            String jsonString = (String)closedCallBackEvent.getReturnData();
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)jsonString)) {
                Map returnDataMap = (Map)JSON.parseObject((String)jsonString, Map.class);
                String nodeItemId = (String)returnDataMap.get("nodeItemId");
                String nodeShowName = (String)returnDataMap.get("nodeShowName");
                this.getPageCache().put("nodeItemId", nodeItemId);
                this.getModel().setValue(DECISION_REJECTION, (Object)nodeShowName);
            }
        } else if ("showCirculationPage".equalsIgnoreCase(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u4f20\u9605\u81f3%s\u540d\u8054\u7cfb\u4eba\u3002", (String)"TaskCirculationPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), returnData));
        }
    }

    private String getOpinions(ListSelectedRowCollection rtnCollection) {
        Object opinionTmp;
        StringBuilder opinionBuilder = new StringBuilder();
        ArrayList<Long> pkidList = new ArrayList<Long>(rtnCollection.size());
        for (ListSelectedRow row : rtnCollection) {
            Object pkValue = row.getPrimaryKeyValue();
            if (!(pkValue instanceof Long)) continue;
            pkidList.add((Long)pkValue);
        }
        String selectField = "opinions";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkidList)};
        DynamicObjectCollection opinionCollection = QueryServiceHelper.query((String)"task_appropinions", (String)selectField, (QFilter[])qFilters);
        int opSize = opinionCollection.size();
        if (opSize > 1) {
            int i = 1;
            for (DynamicObject dyo : opinionCollection) {
                Object opinionTmp2 = dyo.get("opinions");
                if (!(opinionTmp2 instanceof String)) continue;
                opinionBuilder.append(i).append(". ");
                opinionBuilder.append((String)opinionTmp2);
                if (i < opSize) {
                    opinionBuilder.append('\n');
                }
                ++i;
            }
        } else if (opSize == 1 && (opinionTmp = ((DynamicObject)opinionCollection.get(0)).get("opinions")) instanceof String) {
            opinionBuilder.append((String)opinionTmp);
        }
        return opinionBuilder.toString();
    }

    public void embedBillNoPassHandle(List<Long> withdrawalids) {
        this.saveUnpassReason(withdrawalids);
        this.embedBillNoPass();
    }

    public void nextBillNoPassHandle(long decisionItemId, List<Long> withdrawalids) {
        this.getPageCache().put(CACHE_SSC_DECISION_ID, String.valueOf(decisionItemId));
        this.saveUnpassReason(withdrawalids);
        DynamicObject billData = this.getSubViewBilldata();
        this.auditHandle(OPERATIONKEY_NOPASS, billData);
    }

    private void saveUnpassReason(List<Long> pkList) {
        WithdrawalSelectorUtil utils = new WithdrawalSelectorUtil();
        long taskid = Long.parseLong(this.getPageCache().get("taskid"));
        utils.deleteTaskWithdrawalUnpassById(taskid);
        utils.saveTaskWithdrawalUnpass(pkList, taskid);
        utils.saveTaskUnpass(pkList, taskid);
    }

    private String getBindBillById() {
        return this.getPageCache().get("bindbillNumber");
    }

    private void updateTaskMsg(String opinion, String msg, String operation) {
        Long taskid = Long.valueOf(this.getPageCache().get("taskid"));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)"task_task", (String)"id,state,apprevalmessage,innerMsg");
        if (operation.equals("5")) {
            obj.set("state", (Object)TaskStateEnum.RESCAN.getValue());
        } else {
            obj.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        obj.set("innerMsg", (Object)msg);
        obj.set("apprevalmessage", (Object)opinion);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private void insertStateChange(String rescanmsg, String innermsg, String operation) {
        Long taskid = Long.valueOf(this.getPageCache().get("taskid"));
        this.insertStateChangeFUT(rescanmsg, innermsg, operation, taskid);
    }

    public void insertStateChangeFUT(String rescanmsg, String innermsg, String operation, Long taskid) {
        DynamicObject curTask = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)"task_task", (String)"id,billtype,oprt,billid,pooltype,state,subject,tasktypeid,personid");
        long billtypeid = curTask.getLong("billtype");
        long tasktypeid = curTask.getLong("tasktypeid");
        Timestamp changetime = new Timestamp(System.currentTimeMillis());
        long operatorid = Long.parseLong(RequestContext.get().getUserId());
        ORM orm = ORM.create();
        DynamicObject stateChangeobj = orm.newDynamicObject("task_statechange");
        stateChangeobj.set("innermsg", (Object)innermsg);
        stateChangeobj.set("message", (Object)rescanmsg);
        stateChangeobj.set("operatorid", (Object)operatorid);
        stateChangeobj.set("operation", (Object)operation);
        stateChangeobj.set("changetime", (Object)changetime);
        stateChangeobj.set("jobid", (Object)taskid);
        stateChangeobj.set("tasktype", (Object)tasktypeid);
        stateChangeobj.set("billtype", (Object)billtypeid);
        if ("5".equals(operation)) {
            stateChangeobj.set("oldjobstate", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
            stateChangeobj.set("newjobstate", (Object)TaskStateEnum.RESCAN.getValue());
        } else if ("20".equals(operation)) {
            stateChangeobj.set("oldjobstate", (Object)TaskStateEnum.RESCAN.getValue());
            stateChangeobj.set("newjobstate", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        orm.insert(stateChangeobj);
    }

    public void customEvent(CustomEventArgs e) {
        List<String> keys = Arrays.asList("attachment_custom_ctrl", "customcontrolap");
        for (String key : keys) {
            if (!key.equalsIgnoreCase(e.getKey())) continue;
            return;
        }
        try {
            if (!kd.bos.dataentity.utils.StringUtils.isEmail((String)e.getEventArgs())) {
                String operKey;
                Map extParamMap = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), LinkedHashMap.class);
                String string = operKey = extParamMap.get("content") == null ? null : extParamMap.get("content").toString();
                if ("kdcc-audit".equalsIgnoreCase(operKey)) {
                    this.embedBillAuditSscHandle();
                } else if ("kdcc-nopass".equalsIgnoreCase(operKey)) {
                    this.embedBillNoPassHandle();
                } else if ("kdcc-repulse".equalsIgnoreCase(operKey)) {
                    this.embedBillNoPassHandle();
                }
            }
        }
        catch (Exception ex) {
            log.error("kd.ssc.task.formplugin.TaskApproveFormPlugin.customEvent", (Throwable)ex);
        }
    }

    private void embedBillNoPassHandle() {
        this.auditHandle(OPERATIONKEY_NOPASS, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent m) {
        super.confirmCallBack(m);
        String callBackId = m.getCallBackId();
        if ("passReminder".equals(callBackId)) {
            if (m.getResult() == MessageBoxResult.Yes) {
                if (this.isEmbedBill()) {
                    this.embedBillAudit();
                } else {
                    this.nextBillAudit();
                }
            }
        } else if ("submited".equals(callBackId)) {
            if (this.isEmbedBill()) {
                this.auditPass0();
            } else {
                String submitIsNext = this.getPageCache().get("submitIsNext");
                boolean isNext = Boolean.parseBoolean(submitIsNext);
                this.taskApproveSubmit(isNext);
            }
        } else if ("nopass".equals(callBackId)) {
            String decisionitem = (String)this.getModel().getValue("decisionitem");
            boolean isSuccess = false;
            switch (decisionitem) {
                case "1": {
                    this.nopass();
                    break;
                }
                case "2": {
                    this.nopass();
                    break;
                }
                case "3": {
                    isSuccess = this.processRet();
                    break;
                }
                case "4": {
                    isSuccess = this.returnboth();
                    break;
                }
            }
            String hasDecision = this.getPageCache().get("hasDecision");
            boolean isNext = Boolean.parseBoolean(this.getPageCache().get("isNext"));
            if (isNext && isSuccess && this.getView().getPageCache().get("submitResult") == null && hasDecision == null) {
                String taskId = this.getPageCache().get("taskid");
                String poolType = this.getPageCache().get("pooltype");
                String poolTask = this.getPageCache().get("pooltype-mytask");
                DynamicObject curtask = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(taskId), (String)"task_task");
                if (curtask == null) {
                    QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)Long.valueOf(taskId));
                    curtask = BusinessDataServiceHelper.loadSingleFromCache((String)"task_taskhistory", (QFilter[])new QFilter[]{idFilter});
                }
                String sourcePageId = this.getView().getPageCache().get("sourcePageId");
                TaskApprevalHelper.getNextTask(curtask, this.getView(), poolType, poolTask, sourcePageId);
            }
        }
    }

    private void embedBillAudit() {
        this.postEmbedBillMsg("kdcc_bill_audit");
    }

    private void postEmbedBillMsg(String msgKey) {
        IFrame frame = (IFrame)this.getControl("iframeap");
        IFrameMessage msg = new IFrameMessage(msgKey, "*", (Object)this.getView().getPageId());
        frame.postMessage(msg);
    }

    private void embedBillNoPass() {
        this.postEmbedBillMsg("kdcc_bill_nopass");
    }

    private void embedBillAuditSscHandle() {
        this.auditHandle(OPERATIONKEY_PASS, null);
    }

    private void nextBillAudit() {
        DynamicObject billData = this.getSubViewByPageCachePgID().getModel().getDataEntity(true);
        String formName = billData.getDataEntityType().getName();
        if (FORM_DHC_INQUIRYBILL.equals(formName)) {
            String questionReply = billData.getString("questionreply");
            if (StringUtils.isBlank((CharSequence)questionReply)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u9898\u56de\u590d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskApproveFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String decisionItem = (String)this.getModel().getValue("decisionitem");
            this.getPageCache().put("decisionitem", decisionItem);
        }
        this.auditHandle(OPERATIONKEY_PASS, billData);
    }

    private void auditHandle(String key, DynamicObject billData) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean flag = false;
        map.put("billtypeid", this.getPageCache().get("billtypeid"));
        map.put("billTypeKey", this.getPageCache().get("metadatatType"));
        map.put("billid", this.getPageCache().get("billID"));
        map.put("taskID", this.getPageCache().get("taskid"));
        map.put("opinion", (String)this.getModel().getValue("opinion"));
        map.put("withdrawal", (String)this.getModel().getValue("withdrawal"));
        map.put("innermsg", (String)this.getModel().getValue("innermsg"));
        map.put("isEmbed", this.isEmbedBill() + "");
        map.put("erpNumber", this.getErpNumberAndCacheBindNum());
        map.put("personid", this.getPageCache().get("personid"));
        map.put("state", (String)this.getView().getFormShowParameter().getCustomParam("state"));
        map.put("tasktypeid", this.getView().getFormShowParameter().getCustomParam("tasktypeid").toString());
        map.put("decisionitem", this.getPageCache().get("decisionitem"));
        map.put("decisionitemid", this.getPageCache().get(CACHE_SSC_DECISION_ID));
        map.put("itemId", this.getPageCache().get("nodeItemId"));
        this.putCreditSubScoreParams(key, map);
        IFormView subView = this.getSubViewByPageCachePgID();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("task_approval_spilt1".equals(formId)) {
            flag = true;
        }
        TaskApprevalUtil.doApproveOperation(key, billData, map, this.getView(), this.getModel(), subView, flag);
    }

    private void putCreditSubScoreParams(String key, Map<String, String> map) {
        switch (key) {
            case "bar_pass": {
                DynamicObjectCollection breakRules = (DynamicObjectCollection)this.getModel().getValue("selectsubscorerule");
                ArrayList<Long> breaskRuleIds = new ArrayList<Long>();
                for (DynamicObject dynObj : breakRules) {
                    breaskRuleIds.add(dynObj.getLong("fbasedataid_id"));
                }
                if (breaskRuleIds.size() <= 0) break;
                map.put("subscorerule", SerializationUtils.toJsonString(breaskRuleIds));
                break;
            }
            case "bd_nopass": {
                map.put("withdrawalids", this.getPageCache().get("withdrawal"));
                break;
            }
        }
    }

    private Object[] insertTaskHistoryAndStateChangeHis(long taskId, int state) {
        DynamicObject[] hisTasks;
        Object[] result;
        QFilter fiterTaskId = new QFilter("id", "=", (Object)taskId);
        String selectFields = "id,billno,resttime,billnumber,orgid,usergroup,costwaittime,billtype,tasktypeid,sscid,creator,subject,state,innermsg,apprevalmessage,taskcreatetime,imageuploadtime,receivetime,completetime,personid,tasklevelid,imageok,flagmsg,autoprocess,pooltype,expirestate,bizdata_tag,billid,billlongid,procinstid,coefficient,unpassreasondesc,qualitysamplelibrary,qualitystate,orignalperson,reformperson,qualityresult,qualitychecktime\uff0csysbillid,multistate,level,extenderp,source,auditor,assignid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,sourcetaskid,autoprocessforcheck,decisionitem,pendingopinion,rescanopinion,firstreceivetime,pausewaittime";
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{fiterTaskId});
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"task_taskhistory");
        historyTask.set("sourcetaskid", (Object)taskId);
        historyTask.set("state", (Object)state);
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("innermsg", this.getModel().getValue("innermsg"));
        String opinion = this.getModel().getValue("opinion").toString();
        historyTask.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
        historyTask.set("decisionitem", (Object)"3");
        historyTask.set("unpassreasondesc", this.getModel().getValue("withdrawal"));
        historyTask.set("receivetime", taskData.get("receivetime"));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("completetime", (Object)new Date());
        historyTask.set("personid", taskData.get("personid"));
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", (Object)2);
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("bizdata_tag", taskData.get("bizdata_tag"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("iscalculated", (Object)IS_MUSTINPUT);
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        historyTask.set("workgroup", (Object)DataHelper.getWorkgroupId((Long)taskData.getLong("usergroup_id")));
        CalRemainingTime cal = new CalRemainingTime();
        RemainingTimeInfo remainingTimeInfo = cal.calCompletedTimeNoDB(Collections.singletonList(taskId)).get(taskId);
        if (remainingTimeInfo != null) {
            historyTask.set("costwaittime", (Object)remainingTimeInfo.getCostWorkTime());
            historyTask.set("resttime", (Object)remainingTimeInfo.getReminderTime());
            historyTask.set("waittime", (Object)remainingTimeInfo.getWaitTime());
            historyTask.set("expirestate", (Object)remainingTimeInfo.getExpireState());
            historyTask.set("firstcostwaittime", (Object)remainingTimeInfo.getFirstCostWorkTime());
            historyTask.set("pausewaittime", (Object)remainingTimeInfo.getPauseWaitTimes());
        }
        if ((result = SaveServiceHelper.save((DynamicObject[])(hisTasks = new DynamicObject[]{historyTask}))).length > 0) {
            DynamicObject stateChange = TaskApprevalUtil.createStateChange4ReturnSsc(taskData, historyTask);
            TaskApprevalUtil.insertDataToHistoryState(taskData.getLong("id"), ((DynamicObject)result[0]).getLong("id"), stateChange, true);
        }
        return result;
    }

    private String getBillNo() {
        String entityName = "task_task";
        if (this.isHisTask()) {
            entityName = "task_taskhistory";
        }
        long taskId = this.getCacheTaskIDLong();
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDyo = QueryServiceHelper.queryOne((String)entityName, (String)"billtype.bindbill.number", (QFilter[])new QFilter[]{idFilter});
        if (taskDyo != null) {
            return taskDyo.getString("billtype.bindbill.number");
        }
        return "";
    }

    private boolean billRelatedSubScoreRule() {
        String billNum = this.getBillNo();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billNum)) {
            return false;
        }
        List subScoreRuleIds = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getSubScoreRuleIdsByBillNumAndType", (Object[])new Object[]{billNum, SubScoreRuleTypeEnum.DEFECT_PASS.getValue()});
        return subScoreRuleIds != null && subScoreRuleIds.size() != 0;
    }

    private void initViewOfDhcInquirybill() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IFormView subView = this.getSubViewByPageCachePgID();
        subView.setEnable(Boolean.TRUE, new String[]{"questionreply"});
        this.inquiryOperationVisible();
        view.setVisible(Boolean.FALSE, new String[]{"selectsubscorerule", "opinion"});
        model.setValue("opinion", (Object)"");
        FieldEdit opinionEdit = (FieldEdit)this.getControl("opinion");
        opinionEdit.setMustInput(false);
        String operation = (String)model.getValue("operationgroupfield");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operation) || "2".equals(operation) || "4".equals(operation)) {
            model.setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
            operation = IS_NOT_MUSTINPUT;
        }
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            this.setDecisionItemOfDhcInquirybill();
            view.setVisible(Boolean.TRUE, new String[]{"decisionitem"});
            view.setVisible(Boolean.FALSE, new String[]{"withdrawal"});
        }
    }

    private void setDecisionItemOfDhcInquirybill() {
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("decisionitem");
        List comboItems = comboProp.getComboItems();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            LocaleString name = comboItem.getName();
            if (!"5".equals(value) && !"6".equals(value)) continue;
            ComboItem citem = new ComboItem();
            citem.setValue(value);
            citem.setCaption(name);
            list.add(citem);
        }
        ComboEdit com = (ComboEdit)this.getControl("decisionitem");
        com.setComboItems(list);
        com.setMustInput(true);
        String decisionItemVal = (String)this.getModel().getValue("decisionitem");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)decisionItemVal) || !decisionItemVal.equals("5") && !decisionItemVal.equals("6")) {
            this.getModel().setValue("decisionitem", (Object)"5");
        }
    }

    private boolean isDhcInquirybill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billNumber = (String)formShowParameter.getCustomParam("billnumber");
        return FORM_DHC_INQUIRYBILL.equals(billNumber);
    }

    private boolean isFromAdmin() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object valueoffrom = formShowParameter.getCustomParam("from");
        return "admin".equals(valueoffrom);
    }

    private void setDefaultOpinion(boolean isPassed) {
        String taskId = this.getPageCache().get("taskid");
        String approvalMessage = TaskApprevalPluginUtil.processDefaultOpinion(Long.parseLong(taskId), isPassed);
        Object opinion = this.getModel().getValue("opinion");
        if (ObjectUtils.isEmpty((Object)opinion)) {
            this.getModel().setValue("opinion", (Object)approvalMessage);
        }
    }

    private void openDecisionRejectionDialog() {
        String taskId = this.getPageCache().get("taskid");
        String decisionValue = this.getDecisionValue();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("task_decisionrejection");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reDecisionRejection"));
        para.setCustomParam("taskId", (Object)taskId);
        para.setCustomParam("decisionValue", (Object)decisionValue);
        para.setCustomParam("nodeItemId", (Object)this.getPageCache().get("nodeItemId"));
        this.getView().showForm(para);
    }

    private String getDecisionValue() {
        String decisionValue = null;
        DynamicObject curDecisionItem = (DynamicObject)this.getModel().getValue("curdecisionitem");
        if (curDecisionItem != null) {
            Long decisionId = (Long)this.getModel().getValue("curdecisionitem_id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)decisionId, (String)"task_decisionitem", (String)"id,decisionvalue");
            decisionValue = dynamicObject.getString("decisionvalue");
        }
        return decisionValue;
    }

    private void setDecisionRejectionDefault(String taskId) {
        String decisionValue;
        DynamicObject taskDynObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"billid,assignid,itemid");
        String billId = taskDynObj.getString("billid");
        Long workFlowId = taskDynObj.getLong("assignid");
        List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)(decisionValue = this.getDecisionValue()));
        if (!CollectionUtils.isEmpty((Collection)rejectNodeList)) {
            WFRejectNodesModel wfRejectNodesModel = (WFRejectNodesModel)rejectNodeList.get(0);
            this.initDecisionRejection(wfRejectNodesModel.getItemId(), billId, wfRejectNodesModel);
        } else {
            this.getModel().setValue(DECISION_REJECTION, (Object)"");
            this.getPageCache().put("nodeItemId", null);
        }
    }

    private void initDecisionRejection(String itemId, String billId, WFRejectNodesModel wfRejectNodesModel) {
        Map latestApprovalRecordMap = WorkflowApproveRecordHelper.getLatestApprovalRecordMap((String)billId);
        ApprovalRecordItem approvalRecordItem = (ApprovalRecordItem)latestApprovalRecordMap.get(itemId);
        if (approvalRecordItem != null) {
            String decisionRejection = approvalRecordItem.getActivityName() + "-" + approvalRecordItem.getAssignee();
            this.getModel().setValue(DECISION_REJECTION, (Object)decisionRejection);
            this.getPageCache().put("nodeItemId", approvalRecordItem.getActivityId());
        } else if (wfRejectNodesModel != null && wfRejectNodesModel.getName() != null) {
            this.getModel().setValue(DECISION_REJECTION, (Object)wfRejectNodesModel.getName());
            this.getPageCache().put("nodeItemId", itemId);
        } else {
            this.getModel().setValue(DECISION_REJECTION, (Object)"");
            this.getPageCache().put("nodeItemId", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (IS_NOT_MUSTINPUT.equals(this.getPageCache().get("pooltype-mytask"))) {
            boolean contains = MutexCacheHelper.containsMutexCache(this.getPageCache().get("taskid"));
            MutexCacheHelper.removeMutexCache(this.getPageCache().get("taskid"));
        }
    }

    private void unfoldOperation(boolean unfold) {
        this.getView().setVisible(Boolean.valueOf(unfold), new String[]{"op_pending", "op_rescan"});
        this.getView().setVisible(Boolean.valueOf(unfold), new String[]{LABEL_FOLD_OP});
        this.getView().setVisible(Boolean.valueOf(!unfold), new String[]{LABEL_UNFOLD_OP});
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long billTypeId = (Long)showParameter.getCustomParam("billtypeid");
        boolean displayImage = SscImageServiceUtil.imageDisplayCtrlById((Long)billTypeId);
        if (!displayImage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"op_rescan"});
        }
        if (this.isDhcInquirybill()) {
            this.inquiryOperationVisible();
        }
    }

    private void inquiryOperationVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"op_nopass", "op_rescan"});
    }

    private void afterApproveSuccess(Long taskId, String operation) {
        DynamicObject taskHistoryDo = TaskApproveSuccessHelper.getTaskHistoryDo(taskId);
        TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, this.getModel(), operation);
        HashMap<String, String> creditMap = this.putCreditSubScoreParams(operation);
        String operationKey = "";
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            operationKey = OPERATIONKEY_PASS;
        } else if ("2".equals(operation)) {
            operationKey = OPERATIONKEY_NOPASS;
        }
        TaskApproveHelper.creditSetWfVariable(operationKey, creditMap, taskId);
        TaskApproveSuccessHelper.creditSubScore(operation, taskHistoryDo, creditMap);
    }

    private void afterApproveSuccessByOtherOpr(Long taskId, String operation) {
        this.notEmbedBillSave(false);
        TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, this.getModel(), operation);
    }

    private HashMap<String, String> putCreditSubScoreParams(String operation) {
        HashMap<String, String> creditMap = new HashMap<String, String>();
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            DynamicObjectCollection breakRules = (DynamicObjectCollection)this.getModel().getValue("selectsubscorerule");
            ArrayList<Long> breaskRuleIds = new ArrayList<Long>();
            for (DynamicObject dynObj : breakRules) {
                breaskRuleIds.add(dynObj.getLong("fbasedataid_id"));
            }
            if (breaskRuleIds.size() > 0) {
                creditMap.put("subscorerule", SerializationUtils.toJsonString(breaskRuleIds));
            }
        } else if ("2".equals(operation)) {
            creditMap.put("withdrawalids", this.getPageCache().get("withdrawal"));
        }
        return creditMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        switch (name = property.getName()) {
            case "pendingopinions": {
                PendingSelectorUtil pendingSelector = new PendingSelectorUtil();
                Set<Long> idSet = pendingSelector.getPendingIdBybilltypeAndTasktype();
                String taskid = this.getPageCache().get("taskid");
                Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(Collections.singletonList(Long.valueOf(taskid)));
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_pendingreason", (Long)billInfo.get("sscid").get(0));
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", idSet));
                beforeF7SelectEvent.addCustomQFilter(baseDataFilter);
                QFilter hiddenFilter = new QFilter("hidden", "=", (Object)IS_MUSTINPUT);
                beforeF7SelectEvent.addCustomQFilter(hiddenFilter);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }

    private boolean billOprByBeforeTask(String operation) {
        String erpNumber = this.getErpNumberAndCacheBindNum();
        if ("KDCC".equalsIgnoreCase(erpNumber)) {
            boolean hasShow;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("origin", ApproveOriginEnum.FORM.getValue());
            IFormView subView = this.getSubViewByPageCachePgID();
            String subPageId = subView.getPageId();
            String appId = subView.getServiceAppId(subPageId);
            map.put("subPageId", subPageId);
            map.put("appId", appId);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long taskBillId = (Long)customParams.get("billtypeid");
            Long taskTypeId = (Long)customParams.get("tasktypeid");
            Map<String, Object> billOpResultMap = BillOperationHelper.saveKDCCBillData(map, taskBillId, taskTypeId, operation);
            Map<String, Object> failureResult = BillOperationHelper.tranServiceResultMap(billOpResultMap);
            if (failureResult != null && (hasShow = this.showBillOpResult(subView, failureResult))) {
                return false;
            }
        }
        return true;
    }

    private void autoOpenImage(String billId, String billType, Long sscId, Long taskTypeId, boolean fromMyTask) {
        if (!fromMyTask) {
            return;
        }
        boolean autoOpenImageSwitch = TeamLeaderApi.getBooleanParam("autoopenimage", sscId, false);
        log.info(sscId + "\u81ea\u52a8\u6253\u5f00\u53cc\u5c4f\u5f71\u50cf\u53c2\u6570\u503c\u4e3a\uff1a" + autoOpenImageSwitch);
        if (autoOpenImageSwitch) {
            boolean taskBillOpenImage = false;
            DynamicObject taskBillDyn = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"isuseimage", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskTypeId)});
            if (taskBillDyn != null) {
                taskBillOpenImage = taskBillDyn.getBoolean("isuseimage");
            }
            if (taskBillOpenImage) {
                try {
                    SscImageServiceHelper.autoOpenImage((String)billId, (IFormView)this.getView(), (String)billType);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
        }
    }

    private boolean showBillOpResult(IFormView subView, Map<String, Object> resultMap) {
        boolean hasShow = false;
        if (subView == null) {
            return hasShow;
        }
        OperationResult opResult = (OperationResult)resultMap.get("billOpResult");
        if (opResult != null && !opResult.isSuccess()) {
            boolean billActionResult = false;
            List actionResult = (List)resultMap.get("billActionResult");
            if (!CollectionUtils.isEmpty((Collection)actionResult)) {
                for (Object actionResultObj : actionResult) {
                    if (!(actionResultObj instanceof Map) || !"ShowNotificationMsg".equals(((Map)actionResultObj).get("a"))) continue;
                    billActionResult = true;
                    break;
                }
                if (billActionResult) {
                    HashMap<String, Object> arg = new HashMap<String, Object>(3);
                    arg.put("pageId", subView.getPageId());
                    arg.put("actions", actionResult);
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg);
                    hasShow = true;
                }
            }
            if (!billActionResult) {
                subView.showOperationResult(opResult);
                this.getView().sendFormAction(subView);
                hasShow = true;
            }
        }
        return hasShow;
    }
}

