/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.savevalidator;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaskApproveSaveValidatorPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskApproveSaveValidatorPlugin.class);
    private static final String PREFIX = "ssc_er_bill_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save", "submit", "submitandnext"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject billdata;
        super.beforeClick(evt);
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        List<String> btnList = Arrays.asList("save", "submit", "submitandnext");
        if (btnList.contains(ctrlKey) && (billdata = this.getSubViewBilldata()) != null) {
            this.saveValidator(this.getPageCache(), billdata);
        }
    }

    private DynamicObject getSubViewBilldata() {
        String pageID = this.getPageCache().get("pageID");
        DynamicObject billData = null;
        if (StringUtils.isNotEmpty((CharSequence)pageID)) {
            IFormView subView = this.getView().getViewNoPlugin(pageID);
            billData = subView.getModel().getDataEntity(true);
        } else {
            log.info("subPageID is empty");
        }
        return billData;
    }

    private void saveValidator(IPageCache pageCache, DynamicObject dataEntity) {
        String billEntityName = dataEntity.getDataEntityType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        HashSet<String> erBillEntitySet = new HashSet<String>(Arrays.asList("er_tripreimbursebill", "er_dailyreimbursebill", "er_publicreimbursebill", "er_dailyloanbill"));
        if (!erBillEntitySet.contains(billEntityName) && !this.isInheritErBill(erBillEntitySet, entityType)) {
            log.info("saveValidator() end. billEntityName = " + billEntityName);
            return;
        }
        String resultStr = this.validateEntryRowCount(pageCache, dataEntity);
        if (StringUtils.isNotBlank((CharSequence)resultStr)) {
            DynamicObject sourceDataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)billEntityName);
            log.warn("\u5f00\u59cb\u6253\u5370\u5355\u636e\u5b9e\u4f53\u539f\u59cb\u6570\u636e\uff08\u6765\u6e90DB\uff09");
            this.printLog(sourceDataEntity);
            log.warn("\u5355\u636e\u5b9e\u4f53\u539f\u59cb\u6570\u636e\u6253\u5370\u7ed3\u675f");
            log.warn("\u5f00\u59cb\u6253\u5370\u5f53\u524d\u5355\u636e\u5b9e\u4f53\u6570\u636e");
            this.printLog(dataEntity);
            log.warn("\u5f53\u524d\u5355\u636e\u5b9e\u4f53\u6570\u636e\u6253\u5370\u7ed3\u675f");
            throw new KDBizException(resultStr);
        }
    }

    private boolean isInheritErBill(Set<String> erBillEntityList, MainEntityType entityType) {
        String[] inheritEntities = entityType.getInheritPath().split(",");
        int len = inheritEntities.length;
        for (int i = 0; i < len; ++i) {
            String inheritEntityNum = MetadataDao.getEntityNumberById((String)inheritEntities[i]);
            if (!erBillEntityList.contains(inheritEntityNum)) continue;
            return true;
        }
        return false;
    }

    private String validateEntryRowCount(IPageCache pageCache, DynamicObject dataEntity) {
        StringBuilder sb = new StringBuilder();
        List collectionProperties = dataEntity.getDynamicObjectType().getProperties().getCollectionProperties(true);
        for (ICollectionProperty collProperty : collectionProperties) {
            if (!(collProperty instanceof EntryProp)) continue;
            String entryName = collProperty.getName();
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryName);
            int nowRowCount = entry.size();
            String cacheRowCount = pageCache.get(PREFIX + entryName);
            if (!StringUtils.isNotBlank((CharSequence)cacheRowCount) || Integer.parseInt(cacheRowCount) <= 0 || nowRowCount != 0) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff08%2$s\uff09\u7684\u521d\u59cb\u884c\u6570\uff1a%1$d\uff0c\u5f53\u524d\u884c\u6570\uff1a%2$d\u3002", (String)"TaskApproveSaveValidatorPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), collProperty.getDisplayName(), entryName, cacheRowCount, nowRowCount));
        }
        if (sb.length() > 0) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u5206\u5f55\u6570\u636e\u884c\u6821\u9a8c\u5931\u8d25\uff1a\u201c%s\u201d\u3002", (String)"TaskApproveSaveValidatorPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), sb);
        }
        return null;
    }

    private void printLog(DynamicObject billData) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        option.setDataEntityBinder(new IDataEntityBinder(){

            public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                if (prop instanceof DynamicLocaleProperty) {
                    return true;
                }
                if (prop instanceof MulBasedataProp) {
                    return true;
                }
                return super.isSerializProperty(prop, option);
            }
        });
        String strBillData = DataEntitySerializer.serializerToString((Object)billData, (DataEntitySerializerOption)option);
        int len = strBillData.length();
        int times = len / 10000;
        for (int i = 0; i <= times; ++i) {
            int end = (i + 1) * 10000;
            log.warn(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u65e5\u5fd7\uff1a %2$s", (String)"TaskApproveSaveValidatorPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), i + 1, strBillData.substring(i * 10000, end > len ? len : end)));
        }
    }
}

