/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.smartscheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.ssc.smartApproval.util.TaskDataUploadHelper;
import kd.ssc.task.common.smartscheme.TaskAIPredictDTO;
import kd.ssc.task.common.smartscheme.TaskAITrainDTO;
import kd.ssc.task.common.smartscheme.TrainDataUtil;
import kd.ssc.task.formplugin.util.IntelligentDataUtil;
import kd.ssc.task.util.SSCBosUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class SmartQualityCheckPredict {
    private static final Log log = LogFactory.getLog(SmartQualityCheckPredict.class);
    private static final String predictUrl = "/quality_detect/predict";
    private static final String correlationUrl = "/quality_detect/correlation";
    private static final String initUrl = "/quality_detect/init";
    private static final String infoUrl = "/quality_detect/information";
    private static final String trainUrl = "/quality_detect/pushdata";

    public static String getUrlSetting() {
        String url = ConfigurationUtil.getString((String)"ai.quality_detect_service.url");
        log.info("\u667a\u80fd\u8d28\u68c0\uff1aMC\u914d\u7f6eURL\uff1a" + url);
        if (StringUtils.isEmpty((CharSequence)url)) {
            Object params = SSCBosUtil.getSscSettingInfo((String)"smartqualitycheckurl", (boolean)false);
            String string = url = params != null ? params.toString() : null;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u667a\u80fd\u8d28\u68c0\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a");
            return null;
        }
        return url;
    }

    public static String predict(List<Long> taskIds, String[] billTypeNumbers) throws Exception {
        log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\uff0c\u4efb\u52a1\u3010" + SerializationUtils.toJsonString(taskIds) + "\u3011");
        try {
            DataSet datas = IntelligentDataUtil.getData(taskIds, billTypeNumbers);
            if (datas != null) {
                HashMap<String, TaskAIPredictDTO> body = new HashMap<String, TaskAIPredictDTO>();
                for (Row row : datas) {
                    TaskAIPredictDTO taskAIPredictDTO = TaskAIPredictDTO.builder().id(row.get("taskid") == null ? "" : row.getString("taskid")).user(row.get("usergroupname") == null ? "" : row.getString("usergroupname")).project(row.get("items") == null ? "" : row.getString("items")).task_type(row.get("tasktype") == null ? "" : row.getString("tasktype")).sum(row.get("totalmoney") == null ? new BigDecimal("0") : row.getBigDecimal("totalmoney")).nums(row.get("detailscount") == null ? 0 : row.getInteger("detailscount")).if_return(row.get("ispendingrepulserecord") != null && row.getInteger("ispendingrepulserecord") != 0 ? "true" : "false").record_num(row.get("billnumber") == null ? "" : row.getString("billnumber")).if_exemption(row.get("isverifybill") == null ? "false" : "true").create_month(row.get("createmonth") == null ? 0 : row.getInteger("createmonth")).credit_score(row.get("creditvalue") == null ? "" : row.getString("creditvalue")).extract_num(row.get("creatortaskhiscount") == null ? 0 : row.getInteger("creatortaskhiscount")).share_num(row.get("auditortaskhiscount") == null ? 0 : row.getInteger("auditortaskhiscount")).accuracy(row.get("completetotal") == null || row.get("total") == null ? new BigDecimal("0") : row.getBigDecimal("completetotal").divide(row.getBigDecimal("total"), 2)).record_type(row.get("billtypename") == null ? "" : row.getString("billtypename")).organization(row.get("orgpatternname") == null ? "" : row.getString("orgpatternname")).job(row.get("position") == null ? "" : row.getString("position")).department(row.get("dptname") == null ? "" : row.getString("dptname")).build();
                    body.put(row.getString("taskid"), taskAIPredictDTO);
                }
                log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\uff0c\u4efb\u52a1\u3010" + SerializationUtils.toJsonString(body) + "\u3011");
                String urlSetting = SmartQualityCheckPredict.getUrlSetting();
                if (StringUtils.isNotBlank((CharSequence)urlSetting)) {
                    return TaskDataUploadHelper.executePostWithHeader((String)(urlSetting + predictUrl), (String)SerializationUtils.toJsonString(body));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\uff0c\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return null;
    }

    public static void getQualityDetectInformation() throws Exception {
        String urlSetting = SmartQualityCheckPredict.getUrlSetting();
        if (StringUtils.isBlank((CharSequence)urlSetting)) {
            return;
        }
        try {
            JSONObject resultJson;
            String code;
            String ret = TaskDataUploadHelper.executePostWithHeader((String)(urlSetting + infoUrl), (String)"");
            log.info("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u4fe1\u606f\u8fed\u4ee3\u8fd0\u7b97\u4fe1\u606f " + ret);
            if (StringUtils.isNotBlank((CharSequence)ret) && StringUtils.isNotBlank((CharSequence)(code = (resultJson = JSONObject.parseObject((String)ret)).getString("code"))) && StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                JSONArray result = resultJson.getJSONArray("result");
                if (CollectionUtils.isEmpty((Collection)result)) {
                    return;
                }
                JSONObject info = result.getJSONObject(0);
                String serviceName = info.getString("service_name");
                String modelName = info.getString("model_name");
                String usedTimes = info.getString("used_times");
                String accuracy = info.getString("accuracy");
                String recall = info.getString("recall");
                String fScore = info.getString("f1_score");
                String lastTrainTime = info.getString("last_train_time");
                String trainData = info.getString("train_data");
                Integer version = info.getInteger("version");
                if (version == 0) {
                    return;
                }
                QFilter statusQf = new QFilter("status", "=", (Object)"0");
                QFilter datatypeQf = new QFilter("datatype", "=", (Object)"1");
                QFilter versionQf = new QFilter("version", "=", (Object)version);
                DynamicObject[] modelInitRecords = BusinessDataServiceHelper.load((String)"task_modelinitrecord", (String)"id,usedTimes,accuracy,recall,fScore,lastTrainTime,trainData,version", (QFilter[])new QFilter[]{statusQf, datatypeQf, versionQf});
                if (modelInitRecords.length >= 1) {
                    DynamicObject updateVal = modelInitRecords[0];
                    updateVal.set("usedTimes", (Object)usedTimes);
                    updateVal.set("accuracy", (Object)accuracy);
                    updateVal.set("recall", (Object)recall);
                    updateVal.set("fScore", (Object)fScore);
                    updateVal.set("lastTrainTime", (Object)lastTrainTime);
                    updateVal.set("trainData", (Object)trainData);
                    updateVal.set("version", (Object)version);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateVal});
                    return;
                }
                DynamicObject saveVal = BusinessDataServiceHelper.newDynamicObject((String)"task_modelinitrecord");
                saveVal.set("serviceName", (Object)serviceName);
                saveVal.set("modelName", (Object)modelName);
                saveVal.set("usedTimes", (Object)usedTimes);
                saveVal.set("accuracy", (Object)accuracy);
                saveVal.set("recall", (Object)recall);
                saveVal.set("fScore", (Object)fScore);
                saveVal.set("lastTrainTime", (Object)lastTrainTime);
                saveVal.set("trainData", (Object)trainData);
                saveVal.set("version", (Object)version);
                saveVal.set("status", (Object)0);
                saveVal.set("datatype", (Object)1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveVal});
            }
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u4fe1\u606f\u8fed\u4ee3\u8fd0\u7b97\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    public static boolean initQualityDetect(List<String> paramchoice) {
        String urlSetting = SmartQualityCheckPredict.getUrlSetting();
        log.info("\u667a\u80fd\u8d28\u68c0\uff1a\u521d\u59cb\u5316\u63a5\u53e3\u542f\u52a8\uff0curl:" + urlSetting + initUrl);
        if (StringUtils.isBlank((CharSequence)urlSetting)) {
            return false;
        }
        JSONObject data = new JSONObject();
        String pre = "feature_name_";
        int i = 1;
        for (String choiceItem : paramchoice) {
            data.put(pre + i, (Object)choiceItem);
            ++i;
        }
        JSONObject body = new JSONObject();
        body.put("choice", (Object)data);
        try {
            String ret = TaskDataUploadHelper.executePostWithHeader((String)(urlSetting + initUrl), (String)body.toJSONString());
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                JSONObject resultJson = JSONObject.parseObject((String)ret);
                String code = resultJson.getString("code");
                if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                    log.info("\u667a\u80fd\u8d28\u68c0\uff1a\u521d\u59cb\u5316\u63a5\u53e3\u8fd4\u56de " + ret);
                    return true;
                }
                log.info("\u667a\u80fd\u8d28\u68c0\uff1a\u521d\u59cb\u5316\u63a5\u53e3\u8fd4\u56de\u62a5\u9519 " + ret);
            }
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u521d\u59cb\u5316\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public static String correlationUrl() {
        try {
            String urlSetting = SmartQualityCheckPredict.getUrlSetting();
            if (StringUtils.isNotBlank((CharSequence)urlSetting)) {
                return TaskDataUploadHelper.executePostWithHeader((String)(urlSetting + correlationUrl), (String)"");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u667a\u80fd\u8d28\u68c0\u6a21\u578b\u76f8\u5173\u6027\uff0c\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static boolean train(String tenantId) throws Exception {
        String urlSetting = SmartQualityCheckPredict.getUrlSetting();
        if (StringUtils.isBlank((CharSequence)urlSetting)) {
            return false;
        }
        try {
            List<TaskAITrainDTO> datas = TrainDataUtil.getData();
            if (CollectionUtils.isEmpty(datas)) {
                log.info("\u667a\u80fd\u8d28\u68c0:\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u6570\u4e3a0");
                return false;
            }
            HashMap<String, List<TaskAITrainDTO>> body = new HashMap<String, List<TaskAITrainDTO>>(2);
            body.put("datas", datas);
            log.info("\u667a\u80fd\u8d28\u68c0:\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\uff0c\u3010" + SerializationUtils.toJsonString(body) + "\u3011");
            String result = SmartQualityCheckPredict.executePostTrain(urlSetting + trainUrl, SerializationUtils.toJsonString(body));
            if (result != null) {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (resultJson.get((Object)"code").equals(0)) {
                    log.info("\u667a\u80fd\u8d28\u68c0:\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u6210\u529f");
                    return true;
                }
                log.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u5931\u8d25,\u63a5\u53e3\u672a\u8fd4\u56de\u9884\u671f\u7ed3\u679c" + resultJson.toJSONString());
            } else {
                log.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u5931\u8d25,\u63a5\u53e3\u672a\u8fd4\u56de\u9884\u671f\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u5931\u8d25" + e.getMessage());
            throw e;
        }
        log.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\u5931\u8d25");
        return false;
    }

    private static String executePostTrain(String url, String body) throws Exception {
        HttpPost post = new HttpPost(url);
        try {
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(5000).build()).build();
            post.setHeader("traceId", RequestContext.get().getTraceId());
            post.setHeader("accountId", RequestContext.get().getAccountId());
            post.setHeader("tenantId", RequestContext.get().getTenantId());
            post.setHeader("Content-Type", "application/json;charset=utf8");
            StringEntity entity = new StringEntity(body, "UTF-8");
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            if (response != null && response.getEntity() != null) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                return string;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }
}

