/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.smartscheme;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.util.TaskDateUtil;

public class SmartQualitySchemeCheck {
    private static Log log = LogFactory.getLog(SmartQualitySchemeCheck.class);
    private static final String selectEntityFields = "id,billid,billnumber,sysbillid,bizdata_tag,subject,billtype,orgid,sscid,tasktypeid,innermsg,apprevalmessage,tasklevelid,imageok,flagmsg,imageuploadtime,coefficient,multistate,resttime,level,extenderp,source,auditor,assignid,procinstid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,costwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,unpassreasondesc,iscalculated,qualityresult,creator,personid,autoprocess,sourcetaskid,predictvalue,predictlevel,billlongid";
    private static final int RUNPAGESIZE = 5000;
    private static Random rand;

    public static int executeQualityCheckTask(DynamicObject checkScheme, DynamicObject[] entities) {
        log.info(String.format("\u667a\u80fd\u8d28\u68c0\u62bd\u68c0\u5f00\u59cb\uff0c\u8d28\u68c0\u65b9\u6848\u3010%s\u3011\uff0c\u6267\u884c\u65f6\u95f4\uff1a%s", checkScheme.getPkValue(), new Date().getTime()));
        int executeSum = 0;
        Object taskBill = checkScheme.get("taskbill");
        Object taskType = checkScheme.get("tasktype");
        Object selectedOrg = checkScheme.get("selectedorg");
        if (taskBill == null || taskType == null || selectedOrg == null) {
            return executeSum;
        }
        QFilter filterPreTask = SmartQualitySchemeCheck.getPreTaskFilter(checkScheme);
        int samplingMethod = checkScheme.getInt("samplingmethod");
        ORM orm = ORM.create();
        if (1 == samplingMethod) {
            int taskCount;
            int sampleSize = checkScheme.getInt("samplesize");
            sampleSize = sampleSize > (taskCount = orm.queryDataSet("executeQualityCheckTask.getCount", "task_taskhistory", "id", filterPreTask.toArray()).count("id", false)) ? taskCount : sampleSize;
            executeSum = SmartQualitySchemeCheck.createQualityCheckTask(checkScheme, entities, filterPreTask, orm, sampleSize);
        } else if (0 == samplingMethod) {
            DataSet groupDS = orm.queryDataSet("executeQualityCheckTask.getCount", "task_taskhistory", "billtype,tasktypeid", filterPreTask.toArray(), null).groupBy(new String[]{"billtype", "tasktypeid"}).count("num").finish();
            for (Row groupRow : groupDS) {
                Object bilTypeId = groupRow.get("billtype");
                Object taskTypeId = groupRow.get("tasktypeid");
                QFilter filter = new QFilter("billtype", "=", bilTypeId).and(new QFilter("tasktypeid", "=", taskTypeId));
                filter.and(filterPreTask);
                int percentage = checkScheme.getInt("percentage");
                int count = groupRow.getInteger("num") * percentage / 100;
                executeSum += SmartQualitySchemeCheck.createQualityCheckTask(checkScheme, entities, filter, orm, count);
            }
        }
        return executeSum;
    }

    private static int createQualityCheckTask(DynamicObject checkScheme, DynamicObject[] entities, QFilter filterPreTask, ORM orm, int needCount) {
        if (needCount <= 0) {
            return 0;
        }
        int pageNum = 0;
        int start = 0;
        int executeSum = 0;
        DataSet taskDs = orm.queryDataSet("excuteQualityCheckTask", "task_taskhistory", selectEntityFields, new QFilter[]{filterPreTask}, "predictvalue desc", start, needCount <= 5000 ? needCount : 5000);
        while (taskDs != null && taskDs.hasNext()) {
            executeSum += QualityCheckSchemeUtil.createQualityCheckTask(entities, checkScheme, (List<DynamicObject>)ORMUtil.toDynamicObjectCollection((DataSet)taskDs, (String)"task_taskhistory"));
            QualityCheckSchemeUtil.handleDispatcherTask(checkScheme, entities);
            if ((needCount -= 5000) > 0) {
                start = 5000 * ++pageNum;
                int temp = needCount <= 5000 ? needCount : 5000;
                taskDs = orm.queryDataSet("excuteQualityCheckTask", "task_taskhistory", selectEntityFields, filterPreTask.toArray(), "predictvalue desc", start, temp);
                continue;
            }
            taskDs.close();
        }
        return executeSum;
    }

    private static QFilter getPreTaskFilter(DynamicObject checkScheme) {
        Object sscId = checkScheme.getDynamicObject("ssccenter").getPkValue();
        Object taskBill = checkScheme.get("taskbill");
        Object taskType = checkScheme.get("tasktype");
        List selectedOrgs = ((DynamicObjectCollection)checkScheme.get("selectedorg")).stream().map(org -> org.get("fbasedataid_id")).collect(Collectors.toList());
        String timeRangeType = checkScheme.getString("timeframe");
        Date startDate = checkScheme.getDate("startdate");
        Date endDate = checkScheme.getDate("enddate");
        Map times = TaskDateUtil.getQueryTimeParams((String)timeRangeType, (Date)startDate, (Date)endDate);
        String isAutoProcess = checkScheme.getString("isautoprocess");
        boolean isRepeatSample = checkScheme.getBoolean("isrepeatsample");
        QFilter filter = new QFilter("pooltype", "=", (Object)"2");
        filter.and(new QFilter("qualitysamplelibrary", "=", (Object)0));
        filter.and(new QFilter("state", "=", (Object)TaskStateEnum.AUDIT_PASSED.getValue()));
        filter.and(new QFilter("orgid", "in", selectedOrgs));
        filter.and(new QFilter("sscid", "=", sscId));
        DynamicObjectCollection taskBills = (DynamicObjectCollection)taskBill;
        DynamicObjectCollection taskTypes = (DynamicObjectCollection)taskType;
        List taskBillIds = taskBills.stream().map(item -> item.get("fbasedataid_id")).collect(Collectors.toList());
        List taskTypeIds = taskTypes.stream().map(item -> item.get("fbasedataid_id")).collect(Collectors.toList());
        filter.and(new QFilter("billtype", "in", taskBillIds));
        filter.and(new QFilter("tasktypeid", "in", taskTypeIds));
        if ("0".equals(isAutoProcess) || "1".equals(isAutoProcess)) {
            filter.and(new QFilter("autoprocess", "=", (Object)isAutoProcess));
        }
        Object pkValue = checkScheme.getPkValue();
        Set<Object> extractedTaskIds = SmartQualitySchemeCheck.getExtractedTaskByOtherSchemes(isRepeatSample ? pkValue : null, sscId);
        if (extractedTaskIds != null && extractedTaskIds.size() > 0) {
            QFilter filterExistHistoryTaskId = new QFilter("id", "not in", extractedTaskIds);
            filter.and(filterExistHistoryTaskId);
        }
        if (times != null && !times.isEmpty()) {
            QFilter filterCompleteTimeBegin = QFilter.of((String)"completetime >= ? AND completetime <= ?", (Object[])new Object[]{times.get("startdate"), times.get("enddate")});
            filter.and(filterCompleteTimeBegin);
        }
        return filter;
    }

    private static Set<Object> getExtractedTaskByOtherSchemes(Object checkSchemeId, Object sscId) {
        Set<Object> extractedTaskIds = new HashSet<Object>(16);
        QFilter[] filters = checkSchemeId != null ? new QFilter("checkscheme", "=", checkSchemeId).toArray() : null;
        List sampleLibraries = QueryServiceHelper.queryPrimaryKeys((String)"task_qualitysamplelibrary", (QFilter[])filters, null, (int)-1);
        if (sampleLibraries != null && !sampleLibraries.isEmpty()) {
            QFilter filter = new QFilter("qualitysamplelibrary", "in", (Object)sampleLibraries);
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_task", (String)"id,sourcetaskid", (QFilter[])new QFilter[]{filter});
            extractedTaskIds = tasks.stream().map(task -> task.get("sourcetaskid")).collect(Collectors.toSet());
            DynamicObjectCollection historyTasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,sourcetaskid", (QFilter[])new QFilter[]{filter});
            extractedTaskIds.addAll(historyTasks.stream().map(task -> task.get("sourcetaskid")).collect(Collectors.toSet()));
        }
        return extractedTaskIds;
    }

    static {
        try {
            rand = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            rand = new SecureRandom();
        }
    }
}

