/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;

public class WorkCalendarUtils {
    private static Log logger = LogFactory.getLog(WorkCalendarUtils.class);

    public static List<ComboItem> setShareCenter(String entityName, String appId) {
        QFilter qFilter;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)OrgViewTypeEnum.IS_SCC.getViewType(), (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            qFilter = new QFilter(OrgViewTypeEnum.IS_SCC.getFieldKey(), "=", (Object)"1");
        } else {
            List orgIDs = hasPermOrgs.getHasPermOrgs();
            qFilter = new QFilter("id", "in", (Object)orgIDs);
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return WorkCalendarUtils.getComboItems(orgs);
    }

    public static List<ComboItem> setGroup(Object orgid, Long userId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(orgid + ""));
        boolean isSysAdminAndAllRight = TeamLeaderApi.isAdminRole(String.valueOf(orgid), userId, "HXLFBW8ZGNH");
        if (!isSysAdminAndAllRight) {
            qFilter.and("entryentity.userfield", "=", (Object)userId);
            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(orgid))) {
                qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter, enableFilter});
        return WorkCalendarUtils.getComboItems(groups);
    }

    public static boolean isExistCalendar(String currentOrg, int year) {
        Date dateTo;
        Date dateFrom;
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateFrom = SDF.parse(year + "-01-01");
            dateTo = SDF.parse(year + "-12-31");
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + e);
            return false;
        }
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(currentOrg));
        filters.and(new QFilter("dateentry.date", ">=", (Object)dateFrom));
        filters.and(new QFilter("dateentry.date", "<=", (Object)dateTo));
        return QueryServiceHelper.exists((String)"ssc_workcalendarsetting", (QFilter[])new QFilter[]{filters});
    }

    private static List<ComboItem> getComboItems(DynamicObject[] items) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        for (DynamicObject item : items) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item.get("name") + ""));
            citem.setValue(item.get("id") + "");
            list.add(citem);
        }
        return list;
    }

    public static List<Map<String, String>> parseWorkCalendarData(DynamicObjectCollection workCalendars) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        HashMap datas = new HashMap(16);
        for (DynamicObject calendar : workCalendars) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("workDate", SDF.format(calendar.get("dateentry.date")));
            String dateType = calendar.getString("dateentry.datetype");
            if (dateType.equals(SscDateType.HALFWORKDATEAM.getValue()) || dateType.equals(SscDateType.HALFWORKDATEPM.getValue())) {
                data.put("dateType", SscDateType.HALFWORKDATE.getValue());
            } else {
                data.put("dateType", calendar.getString("dateentry.datetype"));
            }
            datas.put(SDF.format(calendar.get("dateentry.date")), data);
        }
        return new ArrayList<Map<String, String>>(datas.values());
    }

    public static void setSingleDaySetOfUser(DynamicObjectCollection timeDatas, String date, String userGroup, String uid, IDataModel model) {
        ArrayList<DynamicObject> validDatas = new ArrayList<DynamicObject>(16);
        for (DynamicObject obj : timeDatas) {
            if (!SscLevelType.EMPLOYEE.getValue().equals(obj.getString("dateentry.level")) || !uid.equals(obj.getString("dateentry.user"))) continue;
            validDatas.add(obj);
        }
        if (validDatas != null && validDatas.size() > 0) {
            WorkCalendarUtils.initDateTime(validDatas, model);
        }
    }

    public static Map<String, List<String>> getSingleDaySetOfUser(String orgId, String groupId, Date nowDate, String uid) {
        long userId = Long.parseLong(uid);
        HashMap<String, List<String>> timeMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection timeDatas = SscWorkCalendarApi.getData(orgId, groupId, nowDate, Collections.singletonList(userId));
        if (timeDatas == null | timeDatas.isEmpty()) {
            return timeMap;
        }
        ArrayList<DynamicObject> validDatas = new ArrayList<DynamicObject>(16);
        for (DynamicObject obj : timeDatas) {
            if (!SscLevelType.EMPLOYEE.getValue().equals(obj.getString("dateentry.level")) || !uid.equals(obj.getString("dateentry.user"))) continue;
            validDatas.add(obj);
        }
        if (validDatas.isEmpty()) {
            return timeMap;
        }
        for (DynamicObject obj : validDatas) {
            if (SscTimeType.OFFTIME.getValue().equals(obj.getString("dateentry.timeentry.timetype"))) {
                String offTimeStart = obj.getString("dateentry.timeentry.begintimeam");
                String offTimeEnd = obj.getString("dateentry.timeentry.endtimeam");
                timeMap.computeIfAbsent(SscTimeType.OFFTIME.getValue(), p -> new ArrayList()).add(StringUtils.join((Object[])new String[]{offTimeStart, "-", offTimeEnd}));
                continue;
            }
            if (!SscTimeType.OVERTIME.getValue().equals(obj.getString("dateentry.timeentry.timetype"))) continue;
            String overTimeStart = obj.getString("dateentry.timeentry.begintimeam");
            String overTimeEnd = obj.getString("dateentry.timeentry.endtimeam");
            timeMap.computeIfAbsent(SscTimeType.OVERTIME.getValue(), p -> new ArrayList()).add(StringUtils.join((Object[])new String[]{overTimeStart, "-", overTimeEnd}));
        }
        return timeMap;
    }

    private static void initDateTime(List<DynamicObject> validDatas, IDataModel model) {
        WorkCalendarUtils.cleanEntryEntity(model);
        for (DynamicObject obj : validDatas) {
            if (SscTimeType.OFFTIME.getValue().equals(obj.getString("dateentry.timeentry.timetype"))) {
                int offRowIndex = model.createNewEntryRow("offtimeentryentity");
                model.setValue("offtimestart", (Object)SscWorkCalendarUtil.getTimeShow(obj.getString("dateentry.timeentry.begintimeam")), offRowIndex);
                model.setValue("offtimeend", (Object)SscWorkCalendarUtil.getTimeShow(obj.getString("dateentry.timeentry.endtimeam")), offRowIndex);
                continue;
            }
            if (!SscTimeType.OVERTIME.getValue().equals(obj.getString("dateentry.timeentry.timetype"))) continue;
            int overRowIndex = model.createNewEntryRow("overtimeentryentity");
            model.setValue("overtimestart", (Object)SscWorkCalendarUtil.getTimeShow(obj.getString("dateentry.timeentry.begintimeam")), overRowIndex);
            model.setValue("overtimeend", (Object)SscWorkCalendarUtil.getTimeShow(obj.getString("dateentry.timeentry.endtimeam")), overRowIndex);
        }
    }

    public static void cleanEntryEntity(IDataModel model) {
        model.deleteEntryData("overtimeentryentity");
        model.deleteEntryData("offtimeentryentity");
    }
}

