/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.util.RecordExceptionUtil;

public class ApplyCreditLevel {
    private DynamicObject[] unDisTaskcol = null;
    private Map<Long, String> userCreditLevelMap = new HashMap<Long, String>(2);
    private static final Log log = LogFactory.getLog(ApplyCreditLevel.class);
    private boolean printLog;

    public ApplyCreditLevel(DynamicObject[] unDisTaskcol) {
        this.unDisTaskcol = unDisTaskcol;
    }

    public void prepareData() {
        if (this.unDisTaskcol == null) {
            this.logInfo("unDisTaskCol is null");
            return;
        }
        HashSet<Long> userIdSet = new HashSet<Long>(32);
        for (DynamicObject task : this.unDisTaskcol) {
            userIdSet.add(task.getLong("creator.id"));
        }
        if (userIdSet.isEmpty()) {
            return;
        }
        this.userCreditLevelMap = this.buildUserCredMap(userIdSet);
    }

    private Map<Long, String> buildUserCredMap(Set<Long> userIdSet) {
        DynamicObject[] creditFiles;
        HashMap<Long, String> userCreditLevelMap = new HashMap<Long, String>(2);
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "!=", (Object)Character.valueOf('D')), new QFilter("user", "in", userIdSet)};
        for (DynamicObject creditFilte : creditFiles = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)"user.id,creditlevel.name", (QFilter[])qFilters)) {
            userCreditLevelMap.put(creditFilte.getLong("user.id"), creditFilte.getString("creditlevel.name"));
        }
        return userCreditLevelMap;
    }

    public boolean match(DynamicObject task, String applyCreditFilter) {
        boolean matchresult = false;
        if (StringUtils.isEmpty((String)applyCreditFilter)) {
            this.logInfo("applyCreditFilter is null, creditLevel Match Success");
            matchresult = true;
        } else {
            Map filters = (Map)SerializationUtils.fromJsonString((String)applyCreditFilter, HashMap.class);
            Object filterRow = filters.get("filterRow");
            if (filterRow == null || ((List)filterRow).size() == 0) {
                this.logInfo("filterRow is null, creditLevel Match Success");
                matchresult = true;
            } else {
                String creLevelName = this.userCreditLevelMap.get(task.getLong("creator.id"));
                this.logInfo("applyCreditFilter:" + applyCreditFilter + ";");
                this.logInfo("user CreLevelName :" + creLevelName + ";");
                if (StringUtils.isEmpty((String)creLevelName)) {
                    this.logInfo("user creLevelName not found, credit match failed");
                    return matchresult;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("applycreditlevel.name", creLevelName);
                String creFormula = this.getCreExpFormular(applyCreditFilter);
                Object result = "false";
                try {
                    result = FormulaEngine.execExcelFormula((String)creFormula, map);
                }
                catch (FormulaException e) {
                    log.error("\u4efb\u52a1\u5206\u914d\u89c4\u5219\u89e3\u6790\u5931\u8d25:" + creFormula, (Throwable)e);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("task_id", task.get("id"));
                    param.put("task_subject", task.get("subject"));
                    RecordExceptionUtil.saveRecordExcept((String)"ssc", (String)"kd.ssc.task.dis.ApplyCreditLevel.match()", param, (String)("task allot rule prase failed: " + creFormula), (String)ExceptionUtil.getStackTrace((Throwable)e));
                }
                if ("true".equals(result.toString())) {
                    this.logInfo("creditLevel match success");
                    matchresult = true;
                } else {
                    this.logInfo("creditLevel match failed");
                }
            }
        }
        return matchresult;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    private String getCreExpFormular(String applyCreditFilter) {
        String creditFilterJson = applyCreditFilter;
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)creditFilterJson, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_disrulef7creditlevel");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
        filterBuilder.buildFilter(false);
        FilterObject filterObject = filterBuilder.getFilterObject();
        if (filterObject == null) {
            return "1 = 2";
        }
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        String[] filterScript = scriptBuilder.buildFilterScript(filterObject);
        return filterScript[0];
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }
}

