/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.formula.TaskFormulaEngine;
import kd.ssc.task.util.TaskOwningSysUtil;

public class BillCusFilter {
    private Map<Long, DynamicObject> billTypeMap = new HashMap<Long, DynamicObject>();
    private static final Log log = LogFactory.getLog(BillCusFilter.class);
    private boolean printLog;

    public void prepareData() {
        this.billTypeMap = this.buildTypeMap();
    }

    public void prepareData4GivenSSC(Long sscId) {
        this.billTypeMap = this.buildTypeMap(sscId);
    }

    public boolean match(DynamicObject task, String filterrulejson, Long ruleId) {
        long taskId = task.getLong("id");
        String billId = task.getString("billid");
        String logKeyInfo = taskId + ":" + billId + ":" + ruleId;
        if (StringUtils.isEmpty((String)filterrulejson) || filterrulejson.startsWith("{\"filterRow\":[]")) {
            this.logInfo("filterRuleJson is null; taskbill filter match success" + logKeyInfo);
            return true;
        }
        String fastMatch = TaskParamHelper.getTaskParamByName((String)"fastMatch");
        boolean matched = false;
        long billType = task.getLong("billtype.id");
        String metaNum = this.billTypeMap.get(billType).getString("bindbill.number");
        String erpNumber = this.billTypeMap.get(billType).getString("externalerp.number");
        if ("true".equals(fastMatch)) {
            this.logInfo("fastMatch" + logKeyInfo);
            matched = TaskFormulaEngine.fastMatchByEngine((String)billId, (String)filterrulejson, (String)metaNum, (String)erpNumber);
        } else {
            matched = this.matchBill(task, filterrulejson, metaNum, erpNumber);
        }
        if (matched) {
            this.logInfo("match success" + logKeyInfo);
        } else {
            this.logInfo("match failed" + logKeyInfo);
        }
        return matched;
    }

    private boolean matchBill(DynamicObject task, String filterrulejson, String metaNum, String erpNumber) {
        DynamicObject[] billIDAfterFilDyObj;
        String billId = task.getString("billid");
        QFilter idFilters = TaskOwningSysUtil.getBillIdQFilter((String)erpNumber, (String)billId);
        QFilter billFilter = BillCusFilter.getBillFilter(metaNum, filterrulejson);
        if (billFilter != null) {
            idFilters.and(billFilter);
        }
        return (billIDAfterFilDyObj = BusinessDataServiceHelper.load((String)metaNum, (String)"id", (QFilter[])idFilters.toArray())) != null && billIDAfterFilDyObj.length > 0;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    public static QFilter getBillFilter(String metaNum, String filterrulejson) {
        QFilter billruleFilter = null;
        if (!StringUtils.isBlank((String)filterrulejson)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filterrulejson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)metaNum);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
            filterBuilder.buildFilter(false);
            FilterObject filterObject = filterBuilder.getFilterObject();
            billruleFilter = filterObject.getQFilter();
        }
        return billruleFilter;
    }

    private Map<Long, DynamicObject> buildTypeMap() {
        DynamicObject[] billTypeDyObjs = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"bindbill.number,allowanyapplier,externalerp.number", null);
        return Arrays.stream(billTypeDyObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    private Map<Long, DynamicObject> buildTypeMap(Long sscId) {
        if (sscId == null || sscId <= 0L) {
            return this.buildTypeMap();
        }
        QFilter qFilter = new QFilter("ssccenter", "=", (Object)sscId);
        DynamicObject[] billTypeDyObjs = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"bindbill.number,allowanyapplier,externalerp.number", (QFilter[])qFilter.toArray());
        return Arrays.stream(billTypeDyObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public boolean isAllowAnyApplier(Long billTypeId) {
        return this.billTypeMap.get(billTypeId).getBoolean("allowanyapplier");
    }
}

