/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.business.helper.CreditServiceHelper;
import kd.ssc.task.business.service.credit.CreditDelayService;
import kd.ssc.task.common.distime.TaskPredictDisTimeUtil;
import kd.ssc.task.common.workcalendar.CalWorkDateUtil;
import kd.ssc.task.formplugin.pojo.workcalendar.DailyWorkPeriod;
import kd.ssc.task.workcalendar.pojo.SimpleJob;

public class CreditDelayDis
implements CreditDelayService {
    private static final Log log = LogFactory.getLog(CreditDelayDis.class);
    private DynamicObject[] unDisTaskcol = new DynamicObject[0];
    private QFilter taskBaseFilter = null;
    private Set<Long> delayTasks = new HashSet<Long>(8);
    private boolean printLog;

    public void setUnDisTaskCol(DynamicObject[] unDisTaskcol) {
        this.unDisTaskcol = unDisTaskcol;
    }

    public void setTaskBaseFilter(QFilter taskBaseFilter) {
        this.taskBaseFilter = taskBaseFilter;
    }

    public void prepareData() {
        int length = this.unDisTaskcol.length;
        if (this.taskBaseFilter == null || length == 0) {
            this.logInfo("taskBaseFilter is null or unDisTaskColLength is empty");
            return;
        }
        HashSet<Long> taskIds = new HashSet<Long>(length);
        HashMap<Long, String> billIdMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> creatorIdMap = new HashMap<Long, Long>(16);
        HashMap<String, Set<String>> billTypeMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject task : this.unDisTaskcol) {
            boolean isExtSystemTask;
            boolean isQualityTask = task.getLong("qualitysamplelibrary.id") != 0L;
            boolean bl = isExtSystemTask = !StringUtils.equals((CharSequence)task.getString("billtype.externalerp.number"), (CharSequence)"KDCC");
            if (isQualityTask || isExtSystemTask) continue;
            taskIds.add(task.getLong("id"));
            billIdMap.put(task.getLong("id"), task.getString("billid"));
            creatorIdMap.put(task.getLong("id"), task.getLong("creator.id"));
            Set billIdSet = billTypeMap.computeIfAbsent(task.getString("billtype.bindbill.number"), key -> new HashSet(16));
            billIdSet.add(task.getString("billid"));
        }
        if (taskIds.isEmpty()) {
            return;
        }
        Map<Long, Long> allAppObjIdMap = this.getBillCreditAppObj(billTypeMap);
        this.updateAppObjUserId(billIdMap, creatorIdMap, allAppObjIdMap);
        this.delayTasks = this.buildDelayTasksNew(taskIds, creatorIdMap);
    }

    private void updateAppObjUserId(Map<Long, String> billIdMap, Map<Long, Long> creatorIdMap, Map<Long, Long> allAppObjIdMap) {
        for (Long taskId : creatorIdMap.keySet()) {
            long billIdL;
            String billId = billIdMap.get(taskId);
            try {
                billIdL = Long.parseLong(billId);
            }
            catch (NumberFormatException e) {
                log.error("transfer billId error,only support long type billId:" + billId);
                continue;
            }
            Long appObjUserId = allAppObjIdMap.get(billIdL);
            if (appObjUserId == null || appObjUserId == -1L) continue;
            creatorIdMap.put(taskId, appObjUserId);
        }
    }

    private Map<Long, Long> getBillCreditAppObj(Map<String, Set<String>> billTypeMap) {
        Map creditAppObjMap = CreditServiceHelper.queryAllEnableCreditAppObj();
        HashMap<Long, Long> allAppObjIdMap = new HashMap<Long, Long>();
        for (Map.Entry<String, Set<String>> entry : billTypeMap.entrySet()) {
            String appObj = (String)creditAppObjMap.get(entry.getKey());
            if (!StringUtils.isNotEmpty((CharSequence)appObj)) continue;
            Set<String> billIds = entry.getValue();
            Map appObjIdMap = CreditServiceHelper.batchQueryAppObjIds((String)entry.getKey(), billIds, (String)appObj);
            allAppObjIdMap.putAll(appObjIdMap);
        }
        return allAppObjIdMap;
    }

    private Set<Long> buildDelayTasksNew(Set<Long> taskIds, Map<Long, Long> userIdMap) {
        HashSet<Long> delayTasks = new HashSet<Long>(16);
        String algoKey = CreditDelayDis.class + ".buildCreditFilter()";
        String selFields_0 = "id,sscid,billtype,creator,taskcreatetime,imageuploadtime";
        String selFields_1 = "user,creditlevel";
        String selFields_2 = "creditlevel,billtype.FBasedataId billtype,waittime,timeunit";
        QFilter taskIdFil = new QFilter("id", "in", taskIds);
        QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter userIdFil = new QFilter("user", "in", userIdMap.values());
        QFilter statusFil = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        DataSet userIdDataSet = this.buildUserIdDataSet(userIdMap);
        try (DataSet disTask = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)"task_task", (String)selFields_0, (QFilter[])new QFilter[]{taskIdFil}, (String)"taskcreatetime asc");
             DataSet creditFiles = QueryServiceHelper.queryDataSet((String)(algoKey + "_2"), (String)"task_creditfiles", (String)selFields_1, (QFilter[])new QFilter[]{userIdFil, statusFil}, null);
             DataSet creditApp = QueryServiceHelper.queryDataSet((String)(algoKey + "_3"), (String)"task_creditappwaittime", (String)selFields_2, (QFilter[])new QFilter[]{enableFil}, null);
             DataSet appObjDataSet = disTask.leftJoin(userIdDataSet).on("id", "taskid").select(new String[]{"id", "sscid", "billtype", "taskcreatetime", "imageuploadtime"}, new String[]{"userid"}).finish();
             DataSet dataSet = appObjDataSet.leftJoin(creditFiles).on("userid", "user").select(new String[]{"id", "sscid", "billtype", "taskcreatetime", "imageuploadtime"}, new String[]{"creditlevel", "user"}).finish().filter("creditlevel is not null");
             DataSet prepareDataSet = dataSet.leftJoin(creditApp).on("creditlevel", "creditlevel").on("billtype", "billtype").select(new String[]{"id", "sscid", "billtype", "user", "taskcreatetime", "imageuploadtime", "creditlevel"}, new String[]{"waittime", "timeunit"}).finish().filter("waittime > 0");){
            userIdDataSet.close();
            Date now = new Date();
            Date minCreateTime = null;
            HashMap<Long, CalWorkDateUtil> workDates = new HashMap<Long, CalWorkDateUtil>(4);
            HashMap<Long, Date> predictDisTimeMap = new HashMap<Long, Date>(16);
            block64: for (Row row : prepareDataSet) {
                int waitMin;
                CalWorkDateUtil workDate;
                Date createTime = row.getDate("taskcreatetime");
                long sscId = row.getLong("sscid");
                String unit = row.getString("timeunit");
                BigDecimal waitTime = row.getBigDecimal("waittime");
                if (minCreateTime == null) {
                    minCreateTime = createTime;
                }
                Date imaUplTime = row.getDate("imageuploadtime");
                Date toDoDisTime = createTime;
                if (imaUplTime != null && imaUplTime.after(createTime)) {
                    toDoDisTime = imaUplTime;
                }
                if ((workDate = (CalWorkDateUtil)workDates.get(sscId)) == null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(now);
                    calendar.add(1, 1);
                    workDate = CalWorkDateUtil.getInstance(sscId, minCreateTime, calendar.getTime(), "ssc");
                    workDates.put(sscId, workDate);
                }
                List<DailyWorkPeriod> dailyWorkPeriods = workDate.getDailyWorkPeriods(new SimpleJob(sscId));
                switch (unit) {
                    case "2": {
                        waitMin = waitTime.intValue();
                        break;
                    }
                    case "4": {
                        waitMin = waitTime.multiply(BigDecimal.valueOf(60L)).intValue();
                        break;
                    }
                    case "6": {
                        waitMin = workDate.getWorkMinutesOfSomeDay(dailyWorkPeriods, createTime, waitTime.intValue());
                        break;
                    }
                    default: {
                        continue block64;
                    }
                }
                long workTime = workDate.calWorkTime(new SimpleJob(sscId), createTime, now);
                if (workTime < (long)waitMin) {
                    delayTasks.add(row.getLong("id"));
                }
                Date predictDisTime = workDate.getNextWorkTime(dailyWorkPeriods, toDoDisTime, waitMin);
                predictDisTimeMap.put(row.getLong("id"), predictDisTime);
                if (predictDisTimeMap.size() != 1000) continue;
                TaskPredictDisTimeUtil.setPredictDisTime(predictDisTimeMap);
                predictDisTimeMap.clear();
            }
            if (predictDisTimeMap.size() > 0) {
                TaskPredictDisTimeUtil.setPredictDisTime(predictDisTimeMap);
            }
        }
        return delayTasks;
    }

    private DataSet buildUserIdDataSet(Map<Long, Long> userIdMap) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("taskid", (DataType)DateType.LongType), new Field("userid", (DataType)DateType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> entry : userIdMap.entrySet()) {
            dataSetBuilder.append(new Object[]{entry.getKey(), entry.getValue()});
        }
        return dataSetBuilder.build();
    }

    private List<QFilter> getCreditFilesFilters(QFilter taskBaseFilter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String algoKey = CreditDelayDis.class + ".getCreditFilesFilters()";
        HashSet<Long> userIds = new HashSet<Long>(8);
        QFilter userFil = null;
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_task", (String)"creator", (QFilter[])new QFilter[]{taskBaseFilter}, null);){
            for (Row row : dSet) {
                userIds.add(row.getLong("creator"));
                if (userIds.size() != 1000) continue;
                QFilter tempFil = new QFilter("user", "in", userIds);
                userFil = userFil == null ? tempFil : userFil.or(tempFil);
                userIds = new HashSet(8);
            }
        }
        if (userIds.size() > 0) {
            QFilter tempFil = new QFilter("user", "in", userIds);
            userFil = userFil == null ? tempFil : userFil.or(tempFil);
            qFilters.add(userFil);
        }
        return qFilters;
    }

    public boolean match(DynamicObject task) {
        boolean isQulityTask;
        boolean matchResult = false;
        long taskId = task.getLong("id");
        boolean bl = isQulityTask = task.getLong("qualitysamplelibrary.id") > 0L;
        if (isQulityTask) {
            matchResult = true;
            this.logInfo("qualityTask allot not consider credit");
        } else {
            matchResult = !this.delayTasks.contains(taskId);
            this.logInfo(matchResult ? "not need delay allot\uff1ataskId = " + taskId : "credit delay allot\uff1ataskId = " + taskId);
        }
        return matchResult;
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }
}

