/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.dis.ApplyCreditLevel;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.BillTypeCusFilterPojo;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.OrgSetUserGroupPojo;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.RobortRepulseRule;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.service.distask.WorkLoadService;

public class CusDisRule {
    private static final Log log = LogFactory.getLog(CusDisRule.class);
    private List<CusDisrulePojo> cusDisRuleList = new ArrayList<CusDisrulePojo>();
    private static final String TASK_DISRULEMETA = "task_disrule";
    private ApplyCreditLevel applyCreditLevel = null;
    private BillCusFilter billCusFilter = null;
    private WorkLoadService workLoad = null;
    private RobortRepulseRule robortRepulseRule = null;
    private QulityJob qulityJob = null;
    private long matchPerson = -1L;
    private long matchGroup = -1L;
    private boolean printLog;

    public void prepareData() {
        this.buildCusDisruleList();
    }

    public CusDisRule(ApplyCreditLevel applyCreditLevel, BillCusFilter billCusFilter, WorkLoadService workLoad, RobortRepulseRule RobortRepulseRule2, QulityJob qulityJob) {
        this.applyCreditLevel = applyCreditLevel;
        this.billCusFilter = billCusFilter;
        this.workLoad = workLoad;
        this.robortRepulseRule = RobortRepulseRule2;
        this.qulityJob = qulityJob;
    }

    private void buildCusDisruleList() {
        DynamicObject[] disrules;
        for (DynamicObject disrule : disrules = this.getDisRules()) {
            CusDisrulePojo cusDisrulePojo = new CusDisrulePojo();
            Long id = disrule.getLong("id");
            String number = disrule.getString("number");
            long sscid = disrule.getLong("ssccenter.id");
            long taskType = disrule.getLong("tasktype.id");
            int priority = disrule.getInt("priority");
            ArrayList<BillTypeCusFilterPojo> billTypeCusFilterList = new ArrayList<BillTypeCusFilterPojo>();
            ArrayList<OrgSetUserGroupPojo> orgSetUserGroupPojoList = new ArrayList<OrgSetUserGroupPojo>();
            DynamicObjectCollection entryBillTypeColls = disrule.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryGroupOrgcolls = disrule.getDynamicObjectCollection("entryentity1");
            for (DynamicObject entryBillType : entryBillTypeColls) {
                Long billType = entryBillType.getLong("billtype.id");
                String filterrulejson = entryBillType.getString("filterrulejson_tag");
                String applycreditleveljoson = entryBillType.getString("applycreditleveljoson_tag");
                String billSys = entryBillType.getString("billtype.externalerp.number");
                BillTypeCusFilterPojo billTypeCusFilterPojo = new BillTypeCusFilterPojo();
                billTypeCusFilterPojo.setBillType(billType);
                billTypeCusFilterPojo.setFilterrulejson(filterrulejson);
                billTypeCusFilterPojo.setApplycreditleveljoson(applycreditleveljoson);
                billTypeCusFilterPojo.setBillSys(billSys);
                billTypeCusFilterList.add(billTypeCusFilterPojo);
            }
            for (DynamicObject entryGroupOrg : entryGroupOrgcolls) {
                Set<Long> orgSet = this.buildOrgIDSet(entryGroupOrg);
                long group = entryGroupOrg.getLong("usergroup.id");
                boolean groupEnable = entryGroupOrg.getBoolean("usergroup.enable");
                OrgSetUserGroupPojo orgSetUserGroupPojo = new OrgSetUserGroupPojo();
                orgSetUserGroupPojo.setGroup(group);
                orgSetUserGroupPojo.setOrgSet(orgSet);
                orgSetUserGroupPojo.setEnable(groupEnable);
                orgSetUserGroupPojoList.add(orgSetUserGroupPojo);
            }
            cusDisrulePojo.setId(id);
            cusDisrulePojo.setNumber(number);
            cusDisrulePojo.setPriority(priority);
            cusDisrulePojo.setSscId(sscid);
            cusDisrulePojo.setTaskTypeId(taskType);
            cusDisrulePojo.setBillTypeCusFilterList(billTypeCusFilterList);
            cusDisrulePojo.setOrgSetUserGroupPojoList(orgSetUserGroupPojoList);
            this.cusDisRuleList.add(cusDisrulePojo);
        }
    }

    private void removeMatchPerson() {
        this.matchPerson = -1L;
    }

    private void removeMatchGroup() {
        this.matchGroup = -1L;
    }

    public Long getMatchPerson() {
        long toGegMatchPerson = this.matchPerson;
        this.removeMatchPerson();
        return toGegMatchPerson;
    }

    public Long getMatchGroup() {
        long toGegMatchGroup = this.matchGroup;
        this.removeMatchGroup();
        return toGegMatchGroup;
    }

    public int match(DynamicObject task) {
        this.matchPerson = -1L;
        this.matchGroup = -1L;
        Long firstGroup = 0L;
        String billnumber = task.getString("billnumber");
        String pooltype = task.getString("pooltype");
        for (CusDisrulePojo cusDisrulePojo : this.cusDisRuleList) {
            boolean allowAnyApplier;
            long group = -1L;
            this.logInfo("customDisRule.number:" + cusDisrulePojo.getNumber() + ";");
            this.logInfo("waitAllotTaskSscId: " + task.getLong("sscid.id") + ";allotRuleSscId: " + cusDisrulePojo.getSscId() + ";");
            if (Long.compare(task.getLong("sscid.id"), cusDisrulePojo.getSscId()) != 0) {
                this.logInfo("ssc different, match failed");
                continue;
            }
            this.logInfo("same sscId");
            long taskType = task.getLong("tasktypeid.id");
            if (this.qulityJob.isAutoAdtQJb(task)) {
                this.logInfo("qualityTask, originTask is autoApproveTask");
                long hisTaskType = this.qulityJob.getQjobSourceType(task);
                if (hisTaskType > -1L) {
                    this.logInfo("qualityScheme is originTask, originTaskType: " + taskType + ";originBillTaskType:" + hisTaskType + ";");
                    taskType = hisTaskType;
                }
            }
            this.logInfo("waitAllotTaskType:" + taskType + ";allotRuleTaskType:" + cusDisrulePojo.getTaskTypeId() + ";");
            if (Long.compare(taskType, cusDisrulePojo.getTaskTypeId()) != 0) {
                this.logInfo("taskType different, match failed");
                continue;
            }
            this.logInfo("sameTaskType");
            if (!this.billTypeCusFilterMatch(task, cusDisrulePojo)) continue;
            List<OrgSetUserGroupPojo> orgSetUserGroupPojoList = cusDisrulePojo.getOrgSetUserGroupPojoList();
            for (OrgSetUserGroupPojo orgSetUserGroupPojo : orgSetUserGroupPojoList) {
                long taskOrg = task.getLong("orgid.id");
                this.logInfo("currentTaskOrg: " + taskOrg);
                if (orgSetUserGroupPojo.getOrgSet().contains(taskOrg) && orgSetUserGroupPojo.isEnable()) {
                    this.logInfo("orgMatchSuccess: " + taskOrg);
                    group = orgSetUserGroupPojo.getGroup();
                    this.logInfo("matchUserGroup is: " + group + ";");
                    continue;
                }
                this.logInfo("org match failed or matched userGroup disable");
            }
            if (group == -1L) {
                this.logInfo("group is -1,group match failed");
                continue;
            }
            if (group != -1L && this.robortRepulseRule.isRobortGroup(group) && this.robortRepulseRule.match(task)) {
                this.logInfo("currentTask is robot autoApprove and reject, currentMatch robotGroup, change to nextGroup");
                continue;
            }
            if (group != -1L && this.robortRepulseRule.isRobortGroup(group) && this.qulityJob.isAutoAdtQJb(task)) {
                this.logInfo("currentTask is autoApproveQualityTask, can not allot to robotGroup, change to nextGroup");
                continue;
            }
            if (firstGroup == 0L) {
                firstGroup = group;
                if ("3".equals(pooltype)) {
                    this.matchGroup = firstGroup;
                    return 3;
                }
                if (this.robortRepulseRule.isRobortGroup(firstGroup) && !this.robortRepulseRule.isRobotsDistriOnDuty(firstGroup)) {
                    this.matchPerson = this.robortRepulseRule.getOneRobort(firstGroup);
                    this.matchGroup = firstGroup;
                    return 3;
                }
            }
            this.workLoad.deletePerson(group, task);
            if (task.getLong("qualitysamplelibrary.id") == 0L && !(allowAnyApplier = this.billCusFilter.isAllowAnyApplier(task.getLong("billtype.id")))) {
                this.workLoad.deleteApplier(group, task.getLong("creator.id"));
            }
            WorkerStatusPojo qTaskSourcePerson = null;
            if (task.getLong("qualitysamplelibrary.id") > 0L) {
                qTaskSourcePerson = this.workLoad.deleteQTaskSPerson(group, this.qulityJob.getQjobSourcePerson(task));
            }
            long person = this.workLoad.getMatchPerson(group, billnumber);
            if (task.getLong("qualitysamplelibrary.id") > 0L && qTaskSourcePerson != null) {
                this.workLoad.addQTaskSPerson(group, qTaskSourcePerson);
            }
            this.workLoad.addPerson(group);
            if (person == -1L) continue;
            this.matchPerson = person;
            this.matchGroup = group;
            this.logInfo(billnumber + "matchSuccess, userGroup: " + this.matchGroup + ",userId: " + this.matchPerson);
            return 3;
        }
        if (firstGroup == 0L) {
            this.logInfo(billnumber + "matched group is empty");
            return 1;
        }
        this.matchGroup = firstGroup;
        this.logInfo(billnumber + "match userGroup success: " + this.matchGroup + ",but user not on work or task maxed");
        return 2;
    }

    private boolean billTypeCusFilterMatch(DynamicObject task, CusDisrulePojo cusDisrulePojo) {
        boolean result = false;
        if (cusDisrulePojo == null) {
            this.logInfo("customDisRule is null, match failed");
            return result;
        }
        if (task == null) {
            this.logInfo("task is null, match failed");
            return result;
        }
        List<BillTypeCusFilterPojo> billTypeCusFilterPojoList = cusDisrulePojo.getBillTypeCusFilterList();
        for (BillTypeCusFilterPojo billTypeCusFilterPojo : billTypeCusFilterPojoList) {
            this.logInfo("waitDis taskBill: " + task.getLong("billtype.id") + ";disRule taskBill: " + billTypeCusFilterPojo.getBillType() + ";");
            if (Long.compare(task.getLong("billtype.id"), billTypeCusFilterPojo.getBillType()) != 0) {
                this.logInfo("taskBill Entry match Failed");
                continue;
            }
            this.logInfo("taskBill match Success");
            if (!this.applyCreditLevel.match(task, billTypeCusFilterPojo.getApplycreditleveljoson()) || !this.billCusFilter.match(task, billTypeCusFilterPojo.getFilterrulejson(), cusDisrulePojo.getId())) continue;
            result = true;
            this.logInfo("taskBill, customConditionEntry match success");
            break;
        }
        return result;
    }

    private Set<Long> buildOrgIDSet(DynamicObject entryGroupOrg) {
        DynamicObjectCollection orgColls = entryGroupOrg.getDynamicObjectCollection("orgrange");
        HashSet<Long> orgIDSet = new HashSet<Long>();
        for (DynamicObject dyobj : orgColls) {
            orgIDSet.add(dyobj.getLong("FBasedataId_id"));
        }
        return orgIDSet;
    }

    private DynamicObject[] getDisRules() {
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        DynamicObject[] taskDisRules = BusinessDataServiceHelper.load((String)TASK_DISRULEMETA, (String)"id,number,entryentity.id,ssccenter,entryentity1.id,tasktype,priority,entryentity.billtype,entryentity.billtype.externalerp.number,entryentity.filterrulejson_tag,entryentity.filterrulejson,entryentity.applycreditleveljoson_tag,entryentity.applycreditleveljoson,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{disruleEnbaleQFilter}, (String)"priority");
        return taskDisRules;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public List<CusDisrulePojo> getCusDisRuleList() {
        return this.cusDisRuleList;
    }

    public void setCusDisRuleList(List<CusDisrulePojo> cusDisRuleList) {
        this.cusDisRuleList = cusDisRuleList;
    }
}

